/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.fox.sys.BFoxScheme;
import com.tridium.fox.sys.BFoxsScheme;
import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BStationSurrogate
extends BAppSurrogate {
    public static final Property foxPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property foxsPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property httpPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property httpsPort = BStationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property foxOrd = BStationSurrogate.newProperty((int)3, (BValue)BOrd.DEFAULT, null);
    public static final Property foxsOrd = BStationSurrogate.newProperty((int)3, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BStationSurrogate;

    public String getStationName() {
        return this.getAppName();
    }

    public void setStationName(String string) {
        this.setAppName(string);
    }

    public BStationStatus getStationStatus() {
        return this.getAppStatus();
    }

    public void setStationStatus(BStationStatus bStationStatus) {
        this.setAppStatus(bStationStatus);
    }

    public int getFoxPort() {
        return this.getInt(foxPort);
    }

    public void setFoxPort(int n) {
        this.setInt(foxPort, n, null);
    }

    public int getFoxsPort() {
        return this.getInt(foxsPort);
    }

    public void setFoxsPort(int n) {
        this.setInt(foxsPort, n, null);
    }

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int n) {
        this.setInt(httpPort, n, null);
    }

    public int getHttpsPort() {
        return this.getInt(httpsPort);
    }

    public void setHttpsPort(int n) {
        this.setInt(httpsPort, n, null);
    }

    public BOrd getFoxOrd() {
        return (BOrd)this.get(foxOrd);
    }

    public void setFoxOrd(BOrd bOrd) {
        this.set(foxOrd, (BValue)bOrd, null);
    }

    public BOrd getFoxsOrd() {
        return (BOrd)this.get(foxsOrd);
    }

    public void setFoxsOrd(BOrd bOrd) {
        this.set(foxsOrd, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BStationSurrogate make(BDaemonSession bDaemonSession, String string) throws Exception {
        BStationSurrogate bStationSurrogate = new BStationSurrogate(bDaemonSession);
        bStationSurrogate.setAppName(string);
        bStationSurrogate.poll();
        return bStationSurrogate;
    }

    public static BStationSurrogate[] makeAll(BDaemonSession bDaemonSession) throws Exception {
        return (BStationSurrogate[])BStationSurrogate.makeAll(TYPE, bDaemonSession);
    }

    public static boolean isAnyStationRunning(BDaemonSession bDaemonSession) throws Exception {
        return BStationSurrogate.isAnyAppRunning(TYPE, bDaemonSession);
    }

    public void updateFields(XElem xElem) {
        int n;
        StringBuffer stringBuffer;
        super.updateFields(xElem);
        XElem xElem2 = xElem.elem("foxport");
        if (xElem2 != null) {
            this.setFoxPort(xElem2.geti("value"));
            if (this.getFoxPort() == -1) {
                this.setFoxOrd(BOrd.DEFAULT);
            } else if (this.session.getTunnelAuthorities() == null) {
                this.setFoxOrd(BOrd.make((BOrd)this.session.getHost().getNavOrd(), (OrdQuery)BFoxScheme.INSTANCE.parse(xElem2.get("value"))));
            } else {
                stringBuffer = new StringBuffer();
                n = 0;
                while (n < this.session.getTunnelAuthorities().length) {
                    stringBuffer.append('/').append(this.session.getTunnelAuthorities()[n]);
                    ++n;
                }
                stringBuffer.append(':').append(xElem2.get("value"));
                this.setFoxOrd(BOrd.make((BOrd)this.session.getHost().getNavOrd(), (OrdQuery)BFoxScheme.INSTANCE.parse(stringBuffer.toString())));
            }
        } else {
            this.setFoxPort(-1);
            this.setFoxOrd(BOrd.DEFAULT);
        }
        xElem2 = xElem.elem("foxsport");
        if (xElem2 != null) {
            this.setFoxsPort(xElem2.geti("value"));
            if (this.getFoxsPort() == -1) {
                this.setFoxsOrd(BOrd.DEFAULT);
            } else if (this.session.getTunnelAuthorities() == null) {
                this.setFoxsOrd(BOrd.make((BOrd)this.session.getHost().getNavOrd(), (OrdQuery)BFoxsScheme.INSTANCE.parse(xElem2.get("value"))));
            } else {
                stringBuffer = new StringBuffer();
                n = 0;
                while (n < this.session.getTunnelAuthorities().length) {
                    stringBuffer.append('/').append(this.session.getTunnelAuthorities()[n]);
                    ++n;
                }
                stringBuffer.append(':').append(xElem2.get("value"));
                this.setFoxsOrd(BOrd.make((BOrd)this.session.getHost().getNavOrd(), (OrdQuery)BFoxsScheme.INSTANCE.parse(stringBuffer.toString())));
            }
        } else {
            this.setFoxsPort(-1);
            this.setFoxsOrd(BOrd.DEFAULT);
        }
        xElem2 = xElem.elem("httpport");
        if (xElem2 != null) {
            this.setHttpPort(xElem2.geti("value"));
        } else {
            this.setHttpPort(-1);
        }
        xElem2 = xElem.elem("httpsport");
        if (xElem2 != null) {
            this.setHttpsPort(xElem2.geti("value"));
        } else {
            this.setHttpsPort(-1);
        }
    }

    public InputStream getStationOutput() throws ConnectException, AuthenticationException {
        return this.getAppOutput(true, false);
    }

    public InputStream getStationOutput(boolean bl) throws ConnectException, AuthenticationException {
        return this.getAppOutput(bl, false);
    }

    public InputStream getStationOutput(boolean bl, boolean bl2) throws ConnectException, AuthenticationException {
        return this.getAppOutput(bl, bl2);
    }

    public void dumpThreads() throws ConnectException, AuthenticationException {
        this.getDaemonSession().sendMessage(new ThreadDumpMessage(this.getAppName()));
    }

    public void startStationAsync() throws ConnectException, AuthenticationException {
        this.startAppAsync();
    }

    public void startStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        this.startApp(iCancelHint, daemonSessionTaskListener);
    }

    public static BStationSurrogate[] stopAllStations(BDaemonSession bDaemonSession, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        return (BStationSurrogate[])BStationSurrogate.stopAllApps(bDaemonSession, TYPE, BStationSurrogate.makeAll(bDaemonSession), iCancelHint, daemonSessionTaskListener);
    }

    public static BStationSurrogate[] stopAllStations(BDaemonSession bDaemonSession, BStationSurrogate[] bStationSurrogateArray, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        return (BStationSurrogate[])BStationSurrogate.stopAllApps(bDaemonSession, TYPE, bStationSurrogateArray, iCancelHint, daemonSessionTaskListener);
    }

    public static void saveStation(BDaemonSession bDaemonSession, String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(bDaemonSession, string).saveStation(iCancelHint, daemonSessionTaskListener);
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static void saveStationAsync(BDaemonSession bDaemonSession, String string) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(bDaemonSession, string).saveStationAsync();
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void syncStationModulesAsync() throws ConnectException, AuthenticationException {
        try {
            this.getDaemonSession().sendMessage(new SyncStationModulesMessage(this.getStationName()));
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void saveStationAsync() throws ConnectException, AuthenticationException {
        try {
            this.getDaemonSession().sendMessage(new SaveStationMessage(this.getStationName()));
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void saveStation(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.saveStation(iCancelHint, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        CancelableDaemonSessionTask cancelableDaemonSessionTask;
        block14: {
            if (this.getAppStatus() != BStationStatus.running) {
                return;
            }
            cancelableDaemonSessionTask = null;
            try {
                try {
                    if (daemonSessionTaskListener != null) {
                        cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "StationSurrogate.saving.title", "StationSurrogate.saving.message", new Object[]{this.getAppName()}, iCancelHint);
                        cancelableDaemonSessionTask.setCancelLabel(lex.getText("StationSurrogate.saving.cancel"));
                        daemonSessionTaskListener.taskStarted(cancelableDaemonSessionTask);
                    }
                    JobResult jobResult = this.getJobResult(this.getAppName());
                    log.trace("saveStation initial jobResult = " + jobResult);
                    long l = jobResult == null ? 0L : jobResult.millis;
                    this.saveStationAsync();
                    jobResult = this.getJobResult(this.getAppName());
                    while (true) {
                        block15: {
                            if (!BStationSurrogate.newCompletedJob(jobResult, l) && !BStationSurrogate.isCanceled(cancelableDaemonSessionTask)) break block15;
                            if (jobResult != null && jobResult.state != BJobState.success && !BStationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                                throw new BajaRuntimeException("Station save failed: " + jobResult.state);
                            }
                            break;
                        }
                        Thread.sleep(1000L);
                        jobResult = this.getJobResult(this.getAppName());
                        log.trace("saveStation jobResult = " + jobResult);
                    }
                }
                catch (ConnectException connectException) {
                    throw connectException;
                }
                catch (AuthenticationException authenticationException) {
                    throw authenticationException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
                throw throwable;
            }
            {
                Object var5_12 = null;
                if (daemonSessionTaskListener == null || cancelableDaemonSessionTask == null) break block14;
                daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
            }
        }
        if (BStationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
            throw new ICancelHint.CanceledException();
        }
    }

    public static void stopStation(BDaemonSession bDaemonSession, String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(bDaemonSession, string).stopApp(iCancelHint, daemonSessionTaskListener);
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static void stopStationAsync(BDaemonSession bDaemonSession, String string) throws ConnectException, AuthenticationException {
        try {
            BStationSurrogate.make(bDaemonSession, string).stopAppAsync();
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void stopStationAsync() throws ConnectException, AuthenticationException {
        this.stopAppAsync();
    }

    public void stopStation(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.stopApp(iCancelHint);
    }

    public void stopStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.stopApp(iCancelHint, daemonSessionTaskListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        if (!this.isAppStopped()) {
            CancelableDaemonSessionTask cancelableDaemonSessionTask = null;
            try {
                block16: {
                    try {
                        if (this.getAppStatus() == BStationStatus.stopping) break block16;
                        if (daemonSessionTaskListener != null) {
                            cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "StationSurrogate.stopping.title", "StationSurrogate.stopping.message", new Object[]{this.getAppName()}, iCancelHint);
                            cancelableDaemonSessionTask.setCancelLabel(lex.getText("AppSurrogate.stopping.cancel"));
                            daemonSessionTaskListener.taskStarted(cancelableDaemonSessionTask);
                        }
                        JobResult jobResult = this.getJobResult(this.getAppName());
                        log.trace("stopStation initial jobResult = " + jobResult);
                        long l = jobResult == null ? 0L : jobResult.millis;
                        this.stopAppAsync();
                        jobResult = this.getJobResult(this.getAppName());
                        this.poll();
                        while (true) {
                            if (this.isAppStopped() || BStationSurrogate.newCompletedJob(jobResult, l) || BStationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                                if (!this.isAppStopped() && jobResult != null && jobResult.state != BJobState.success && !BStationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                                    throw new BajaRuntimeException("Station save failed: " + jobResult.state);
                                }
                                break;
                            }
                            Thread.sleep(1000L);
                            this.poll();
                            jobResult = this.getJobResult(this.getAppName());
                            log.trace("stopStation jobResult = " + jobResult);
                        }
                    }
                    catch (ConnectException connectException) {
                        throw connectException;
                    }
                    catch (AuthenticationException authenticationException) {
                        throw authenticationException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new BajaRuntimeException((Throwable)exception);
                    }
                }
                Object var5_12 = null;
                if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
                throw throwable;
            }
            if (BStationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public void restartStationAsync() throws ConnectException, AuthenticationException {
        this.restartAppAsync();
    }

    public void restartStationAsync(boolean bl) throws ConnectException, AuthenticationException {
        this.restartAppAsync(bl);
    }

    public void deleteStation(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.deleteApp(iCancelHint, null);
    }

    public void deleteStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.deleteApp(iCancelHint, daemonSessionTaskListener);
    }

    public void deleteApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        super.deleteApp(iCancelHint, daemonSessionTaskListener);
        DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeDelete(new FilePath("!stations/" + this.getAppName()), this.getDaemonSession().getFileSpace()), iCancelHint, daemonSessionTaskListener);
    }

    public void killStationAsync() throws ConnectException, AuthenticationException {
        this.killAppAsync();
    }

    public void killStation(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.killApp(iCancelHint, daemonSessionTaskListener);
    }

    public void makeStationCopy(BDirectory bDirectory, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this.getDaemonSession().getFileSpace(), new FilePath("!stations/" + this.getAppName()), true, false, false, new StoreCache());
        bDaemonDirectoryStore.copyToLocalHost(bDirectory.getFilePath(), daemonSessionTaskListener);
    }

    public boolean isStationRunning() {
        return this.isAppRunning();
    }

    public boolean isStationStopped() {
        return this.isAppStopped();
    }

    public static boolean newCompletedJob(JobResult jobResult, long l) {
        if (jobResult == null) {
            return false;
        }
        if (jobResult.state.isComplete()) {
            boolean bl = false;
            if (jobResult.millis > l) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    private final JobResult getJobResult(String string) throws Exception {
        XElem xElem = XParser.make((InputStream)this.session.getInputStream(new QueryRequestStateMessage("baja:StationSaveJob@" + string))).parse();
        if (xElem.name().equals("request") && xElem.get("state", null) != null) {
            return new JobResult(xElem.get("state", null));
        }
        log.trace("getJobResult returns null for station " + this.getAppName());
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BStationSurrogate() {
        throw new UnsupportedOperationException();
    }

    public BStationSurrogate(BDaemonSession bDaemonSession) {
        super(bDaemonSession);
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$BStationSurrogate;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BStationSurrogate = BStationSurrogate.class("[Lcom.tridium.platform.daemon.BStationSurrogate;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    private static class ThreadDumpMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("station");

        public String getMessageString() {
            return this.path.toString();
        }

        public ThreadDumpMessage(String string) {
            this.path.append("?action=threads&station=").append(HttpUtil.encodeUrl((String)string));
        }
    }

    private static class SyncStationModulesMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("station?action=tell&");

        public String getMessageString() {
            return this.path.toString();
        }

        public SyncStationModulesMessage(String string) {
            this.path.append("station=").append(HttpUtil.encodeUrl((String)string));
            this.path.append("&message=syncmodules");
        }
    }

    private static class SaveStationMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("station?action=tell&");

        public String getMessageString() {
            return this.path.toString();
        }

        public SaveStationMessage(String string) {
            this.path.append("station=").append(HttpUtil.encodeUrl((String)string));
            this.path.append("&message=save");
            this.path.append(HttpUtil.encodeUrl((String)(" baja:StationSaveJob@" + string)));
        }
    }

    private static class JobResult {
        public BJobState state;
        public long millis;

        public String toString() {
            return "JobResult(" + this.state.toString() + ',' + this.millis + ')';
        }

        public JobResult(String string) {
            log.trace("JobResult parse=" + string);
            int n = string.indexOf(64);
            if (n < 0) {
                this.state = BJobState.make((String)string);
                this.millis = this.state == BJobState.unknown ? 0L : Clock.millis();
            } else {
                this.state = BJobState.make((String)string.substring(0, n));
                this.millis = Long.parseLong(string.substring(n + 1));
            }
        }
    }

    private static class QueryRequestStateMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("requeststate");

        public String getMessageString() {
            return this.path.toString();
        }

        public QueryRequestStateMessage(String string) {
            this.path.append("?requestid=").append(HttpUtil.encodeUrl((String)string));
        }
    }
}

