/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.Authenticator;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BR2StationSurrogate
extends BAppSurrogate {
    public static final Property httpPort = BR2StationSurrogate.newProperty((int)3, (int)-1, null);
    public static final Property dbFormat = BR2StationSurrogate.newProperty((int)3, (String)"n/a", null);
    public static final Type TYPE;
    protected static final BIcon connectedIcon;
    protected static final BIcon disconnectedIcon;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BR2StationSurrogate;

    public String getR2StationName() {
        return this.getAppName();
    }

    public void setR2StationName(String string) {
        this.setAppName(string);
    }

    public BStationStatus getR2StationStatus() {
        return this.getAppStatus();
    }

    public void setR2StationStatus(BStationStatus bStationStatus) {
        this.setAppStatus(bStationStatus);
    }

    public int getHttpPort() {
        return this.getInt(httpPort);
    }

    public void setHttpPort(int n) {
        this.setInt(httpPort, n, null);
    }

    public String getDbFormat() {
        return this.getString(dbFormat);
    }

    public void setDbFormat(String string) {
        this.setString(dbFormat, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BR2StationSurrogate make(BDaemonSession bDaemonSession, String string) throws Exception {
        BR2StationSurrogate bR2StationSurrogate = new BR2StationSurrogate(bDaemonSession);
        bR2StationSurrogate.setAppName(string);
        bR2StationSurrogate.poll();
        return bR2StationSurrogate;
    }

    public static BR2StationSurrogate[] makeAll(BDaemonSession bDaemonSession) throws Exception {
        return (BR2StationSurrogate[])BR2StationSurrogate.makeAll(TYPE, bDaemonSession);
    }

    public static boolean isAnyR2StationRunning(BDaemonSession bDaemonSession) throws Exception {
        return BR2StationSurrogate.isAnyAppRunning(TYPE, bDaemonSession);
    }

    public void updateFields(XElem xElem) {
        super.updateFields(xElem);
        XElem xElem2 = xElem.elem("httpport");
        if (xElem2 != null) {
            this.setHttpPort(xElem2.geti("value"));
        }
        if ((xElem2 = xElem.elem("dbtype")) != null) {
            this.setDbFormat(xElem2.get("value"));
        }
    }

    public InputStream getR2StationOutput() throws ConnectException, AuthenticationException {
        return this.getAppOutput(true, false);
    }

    public InputStream getR2StationOutput(boolean bl) throws ConnectException, AuthenticationException {
        return this.getAppOutput(bl, false);
    }

    public InputStream getR2StationOutput(boolean bl, boolean bl2) throws ConnectException, AuthenticationException {
        return this.getAppOutput(bl, bl2);
    }

    public BIcon getIcon() {
        return this.isAppRunning() ? connectedIcon : disconnectedIcon;
    }

    public void dumpThreads() throws ConnectException, AuthenticationException {
        this.getDaemonSession().sendMessage(new ThreadDumpMessage(this.getAppName()));
    }

    public boolean isR2StationRunning() {
        return this.isAppRunning();
    }

    public boolean isR2StationStopped() {
        return this.isAppStopped();
    }

    public void startR2StationAsync() throws ConnectException, AuthenticationException {
        this.startAppAsync();
    }

    public void startR2Station(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        this.startApp(iCancelHint, daemonSessionTaskListener);
    }

    public static BR2StationSurrogate[] stopAllR2Stations(BDaemonSession bDaemonSession, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        return (BR2StationSurrogate[])BR2StationSurrogate.stopAllApps(bDaemonSession, TYPE, BR2StationSurrogate.makeAll(bDaemonSession), iCancelHint, daemonSessionTaskListener);
    }

    public static BR2StationSurrogate[] stopAllR2Stations(BDaemonSession bDaemonSession, BR2StationSurrogate[] bR2StationSurrogateArray, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        return (BR2StationSurrogate[])BR2StationSurrogate.stopAllApps(bDaemonSession, TYPE, bR2StationSurrogateArray, iCancelHint, daemonSessionTaskListener);
    }

    public void saveStation(BUsernameAndPassword bUsernameAndPassword) throws ConnectException, AuthenticationException {
        boolean bl;
        long l;
        long l2;
        HttpConnection httpConnection;
        BR2StationSurrogate bR2StationSurrogate;
        block22: {
            if (this.getAppStatus() != BStationStatus.running) {
                return;
            }
            bR2StationSurrogate = this;
            String string = bR2StationSurrogate.getDbFormat();
            int n = bR2StationSurrogate.getHttpPort();
            String string2 = bR2StationSurrogate.getDaemonSession().getRemoteAddressString();
            String string3 = bR2StationSurrogate.getAppName();
            String string4 = "/prism/backupLocal?format=" + string;
            BIpHost bIpHost = new BIpHost(string2);
            httpConnection = null;
            Authenticator authenticator = null;
            boolean bl2 = false;
            l2 = -1;
            l = -1;
            try {
                XElem xElem = XParser.make((InputStream)this.getDaemonSession().getInputStream(new GetDirectoryMessage(new FilePath("/niagara/niagaraR2/rel/stations/" + this.getAppName()), false, true, false, bR2StationSurrogate.getDaemonSession().getFileSpace()))).parse();
                XElem[] xElemArray = xElem.elems("file");
                XElem xElem2 = null;
                int n2 = 0;
                while (n2 < xElemArray.length) {
                    if (xElemArray[n2].get("name").equalsIgnoreCase("config.sns")) {
                        xElem2 = xElemArray[n2];
                        break;
                    }
                    ++n2;
                }
                if (xElem2 != null) {
                    BDaemonFileStore bDaemonFileStore = new BDaemonFileStore(bR2StationSurrogate.getDaemonSession().getFileSpace(), new FilePath("/niagara/niagaraR2/rel/stations/" + this.getAppName() + "/config.sns"), xElem2);
                    l2 = bDaemonFileStore.getCrc();
                    l = bDaemonFileStore.getLastModified().getMillis();
                }
            }
            catch (Exception exception) {}
            bl = false;
            while (true) {
                try {
                    int n3 = 0;
                    if (httpConnection == null) {
                        httpConnection = new HttpConnection((BHost)bIpHost, n, string4);
                        n3 = httpConnection.connect();
                    } else {
                        bl2 = authenticator == null ? false : authenticator.setAuthorization(httpConnection, string4);
                        n3 = httpConnection.newRequest(string4);
                    }
                    if (n3 != 401) break;
                    this.readFully(httpConnection);
                    if (bl2) {
                        throw new AuthenticationException(this.getLexicon().getText("R2StationSurrogate.command.saveStation.invalidCredentials"));
                    }
                    authenticator = Authenticator.make(authenticator, (BHost)bIpHost, n, string3, httpConnection);
                    authenticator.setCredentials((BICredentials)bUsernameAndPassword);
                }
                catch (IOException iOException) {
                    break block22;
                }
            }
            bl = true;
        }
        if (httpConnection != null) {
            httpConnection.close();
            httpConnection = null;
        }
        if (bl) {
            long l3 = -1;
            long l4 = -1;
            boolean bl3 = true;
            do {
                if (!bl3) {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Exception exception) {}
                }
                try {
                    XElem xElem = XParser.make((InputStream)this.getDaemonSession().getInputStream(new GetDirectoryMessage(new FilePath("/niagara/niagaraR2/rel/stations/" + this.getAppName()), false, true, false, bR2StationSurrogate.getDaemonSession().getFileSpace()))).parse();
                    XElem[] xElemArray = xElem.elems("file");
                    XElem xElem3 = null;
                    int n = 0;
                    while (n < xElemArray.length) {
                        if (xElemArray[n].get("name").equalsIgnoreCase("config.sns")) {
                            xElem3 = xElemArray[n];
                            break;
                        }
                        ++n;
                    }
                    if (xElem3 == null) continue;
                    BDaemonFileStore bDaemonFileStore = new BDaemonFileStore(bR2StationSurrogate.getDaemonSession().getFileSpace(), new FilePath("/niagara/niagaraR2/rel/stations/" + this.getAppName() + "/config.sns"), xElem3);
                    l3 = bDaemonFileStore.getCrc();
                    l4 = bDaemonFileStore.getLastModified().getMillis();
                }
                catch (Exception exception) {
                    break;
                }
            } while (l2 == l3 && l == l4);
        }
    }

    public static void stopR2Station(BDaemonSession bDaemonSession, String string, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        try {
            BR2StationSurrogate.make(bDaemonSession, string).stopApp(iCancelHint, daemonSessionTaskListener);
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static void stopR2StationAsync(BDaemonSession bDaemonSession, String string) throws ConnectException, AuthenticationException {
        try {
            BR2StationSurrogate.make(bDaemonSession, string).stopAppAsync();
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void stopR2StationAsync() throws ConnectException, AuthenticationException {
        this.stopAppAsync();
    }

    public void stopR2Station(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.stopApp(iCancelHint);
    }

    public void stopR2Station(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.stopApp(iCancelHint, daemonSessionTaskListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        if (!this.isAppStopped()) {
            CancelableDaemonSessionTask cancelableDaemonSessionTask = null;
            try {
                block16: {
                    try {
                        if (this.getAppStatus() == BStationStatus.stopping) break block16;
                        if (daemonSessionTaskListener != null) {
                            cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "R2StationSurrogate.stopping.title", "R2StationSurrogate.stopping.message", new Object[]{this.getAppName()}, iCancelHint);
                            cancelableDaemonSessionTask.setCancelLabel(lex.getText("AppSurrogate.stopping.cancel"));
                            daemonSessionTaskListener.taskStarted(cancelableDaemonSessionTask);
                        }
                        this.stopAppAsync();
                        this.poll();
                        while (true) {
                            if (this.isAppStopped() || BR2StationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                                if (!this.isAppStopped() && !BR2StationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                                    throw new BajaRuntimeException("R2Station stop failed");
                                }
                                break;
                            }
                            Thread.sleep(1000L);
                            this.poll();
                        }
                    }
                    catch (ConnectException connectException) {
                        throw connectException;
                    }
                    catch (AuthenticationException authenticationException) {
                        throw authenticationException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new BajaRuntimeException((Throwable)exception);
                    }
                }
                Object var5_10 = null;
                if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
                throw throwable;
            }
            if (BR2StationSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public void restartR2StationAsync() throws ConnectException, AuthenticationException {
        this.restartAppAsync();
    }

    public void restartR2StationAsync(boolean bl) throws ConnectException, AuthenticationException {
        this.restartAppAsync(bl);
    }

    public void killR2StationAsync() throws ConnectException, AuthenticationException {
        this.killAppAsync();
    }

    public void killR2Station(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.killApp(iCancelHint, daemonSessionTaskListener);
    }

    public void makeR2StationCopy(BDirectory bDirectory, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this.getDaemonSession().getFileSpace(), new FilePath("!niagaraR2/rel/stations/" + this.getAppName()), true, false, false, new StoreCache());
        bDaemonDirectoryStore.copyToLocalHost(bDirectory.getFilePath(), daemonSessionTaskListener);
    }

    public void deleteR2Station(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.deleteApp(iCancelHint, null);
    }

    public void deleteR2Station(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.deleteApp(iCancelHint, daemonSessionTaskListener);
    }

    public void deleteApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        super.deleteApp(iCancelHint, daemonSessionTaskListener);
        DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeDelete(new FilePath("!niagaraR2/rel/stations/" + this.getAppName()), this.getDaemonSession().getFileSpace()), iCancelHint, daemonSessionTaskListener);
    }

    private final String readFully(HttpConnection httpConnection) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpConnection.getInputStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BR2StationSurrogate() {
        throw new UnsupportedOperationException();
    }

    public BR2StationSurrogate(BDaemonSession bDaemonSession) {
        super(bDaemonSession);
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$BR2StationSurrogate;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BR2StationSurrogate = BR2StationSurrogate.class("[Lcom.tridium.platform.daemon.BR2StationSurrogate;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        connectedIcon = BIcon.std((String)"r2/station.png");
        disconnectedIcon = BIcon.std((String)"r2/stationDisconnected.png");
    }

    private static class ThreadDumpMessage
    extends XmlResponseMessage {
        private StringBuffer path = new StringBuffer("r2station");

        public String getMessageString() {
            return this.path.toString();
        }

        public ThreadDumpMessage(String string) {
            this.path.append("?action=threads&r2station=").append(HttpUtil.encodeUrl((String)string));
        }
    }
}

