/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BR2StationSurrogate;
import com.tridium.platform.daemon.BSedonaSurrogate;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.ConsoleInputStream;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteAppMessage;
import com.tridium.platform.daemon.message.GetAppListMessage;
import com.tridium.platform.daemon.message.UpdateAppMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAppSurrogate
extends BComponent {
    public static final int PORT_UNKNOWN = -1;
    public static final Property isAutoStart = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    public static final Property isAutoRestart = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    public static final Property appStatus = BAppSurrogate.newProperty((int)3, (BValue)BStationStatus.unknown, null);
    public static final Property appName = BAppSurrogate.newProperty((int)3, (String)"", null);
    public static final Property isDisabled = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    public static final Property isDirty = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    public static final Property isAcceptingMessages = BAppSurrogate.newProperty((int)3, (boolean)false, null);
    public static final Property logBufferSize = BAppSurrogate.newProperty((int)3, (int)Short.MAX_VALUE, null);
    public static final Property logBufferFileSize = BAppSurrogate.newProperty((int)3, (int)Short.MAX_VALUE, null);
    public static final Type TYPE;
    protected static final BIcon connectedIcon;
    protected static final BIcon disconnectedIcon;
    public static final int STREAM_TIMEOUT_MILLIS = 500;
    protected static final Lexicon lex;
    protected static final Log log;
    protected BDaemonSession session;
    static /* synthetic */ Class class$com$tridium$platform$daemon$BAppSurrogate;

    public boolean getIsAutoStart() {
        return this.getBoolean(isAutoStart);
    }

    public void setIsAutoStart(boolean bl) {
        this.setBoolean(isAutoStart, bl, null);
    }

    public boolean getIsAutoRestart() {
        return this.getBoolean(isAutoRestart);
    }

    public void setIsAutoRestart(boolean bl) {
        this.setBoolean(isAutoRestart, bl, null);
    }

    public BStationStatus getAppStatus() {
        return (BStationStatus)this.get(appStatus);
    }

    public void setAppStatus(BStationStatus bStationStatus) {
        this.set(appStatus, (BValue)bStationStatus, null);
    }

    public String getAppName() {
        return this.getString(appName);
    }

    public void setAppName(String string) {
        this.setString(appName, string, null);
    }

    public boolean getIsDisabled() {
        return this.getBoolean(isDisabled);
    }

    public void setIsDisabled(boolean bl) {
        this.setBoolean(isDisabled, bl, null);
    }

    public boolean getIsDirty() {
        return this.getBoolean(isDirty);
    }

    public void setIsDirty(boolean bl) {
        this.setBoolean(isDirty, bl, null);
    }

    public boolean getIsAcceptingMessages() {
        return this.getBoolean(isAcceptingMessages);
    }

    public void setIsAcceptingMessages(boolean bl) {
        this.setBoolean(isAcceptingMessages, bl, null);
    }

    public int getLogBufferSize() {
        return this.getInt(logBufferSize);
    }

    public void setLogBufferSize(int n) {
        this.setInt(logBufferSize, n, null);
    }

    public int getLogBufferFileSize() {
        return this.getInt(logBufferFileSize);
    }

    public void setLogBufferFileSize(int n) {
        this.setInt(logBufferFileSize, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    protected static Map getAppElementMap(BDaemonSession bDaemonSession) throws Exception {
        if (bDaemonSession.getHostProperties().supportsServlet("applist")) {
            XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream(new GetAppListMessage())).parse();
            HashMap hashMap = new HashMap();
            XElem[] xElemArray = xElem.elems("app");
            int n = 0;
            while (n < xElemArray.length) {
                String string = xElemArray[n].get("type");
                Type type = BAppSurrogate.getAppType(string);
                TreeMap<String, XElem> treeMap = new TreeMap<String, XElem>();
                hashMap.put(type, treeMap);
                XElem[] xElemArray2 = xElemArray[n].elems(string);
                int n2 = 0;
                while (n2 < xElemArray2.length) {
                    treeMap.put(xElemArray2[n2].get("name"), xElemArray2[n2]);
                    ++n2;
                }
                ++n;
            }
            return hashMap;
        }
        XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream(new GetAppListMessage("station"))).parse();
        HashMap hashMap = new HashMap();
        TreeMap<String, XElem> treeMap = new TreeMap<String, XElem>();
        hashMap.put(BStationSurrogate.TYPE, treeMap);
        XElem[] xElemArray = xElem.elems("station");
        int n = 0;
        while (n < xElemArray.length) {
            treeMap.put(xElemArray[n].get("name"), xElemArray[n]);
            ++n;
        }
        return hashMap;
    }

    protected static Map getAppElementMap(Type type, BDaemonSession bDaemonSession) throws Exception {
        TreeMap treeMap = (TreeMap)BAppSurrogate.getAppElementMap(bDaemonSession).get(type);
        if (treeMap == null) {
            treeMap = new TreeMap();
        }
        return treeMap;
    }

    public void poll() throws Exception {
        XElem xElem = (XElem)BAppSurrogate.getAppElementMap(this.getType(), this.getDaemonSession()).get(this.getAppName());
        if (xElem != null) {
            this.updateFields(xElem);
        }
    }

    public boolean isRestartEnabled() {
        return this.getDaemonSession().getHostProperties().getAllowStationRestart();
    }

    public void updateFields(XElem xElem) {
        this.setAppName(xElem.get("name"));
        XElem xElem2 = xElem.elem("isdisabled");
        if (xElem2 != null) {
            this.setIsDisabled(xElem2.getb("value"));
        }
        if ((xElem2 = xElem.elem("isautostart")) != null) {
            this.setIsAutoStart(xElem2.getb("value"));
        }
        if ((xElem2 = xElem.elem("isautorestart")) != null) {
            this.setIsAutoRestart(xElem2.getb("value"));
        }
        if ((xElem2 = xElem.elem("isdirty")) != null) {
            this.setIsDirty(xElem2.getb("value"));
        }
        if ((xElem2 = xElem.elem("isacceptingmessages")) != null) {
            this.setIsAcceptingMessages(xElem2.getb("value"));
        }
        if ((xElem2 = xElem.elem("status")) != null) {
            this.setAppStatus(BStationStatus.make(xElem2.geti("value")));
        }
        if ((xElem2 = xElem.elem("logbuffersize")) != null) {
            this.setLogBufferSize(xElem2.geti("value"));
        }
        if ((xElem2 = xElem.elem("logbufferfilesize")) != null) {
            this.setLogBufferFileSize(xElem2.geti("value"));
        }
    }

    public InputStream getAppOutput() throws ConnectException, AuthenticationException {
        return this.getAppOutput(true, false);
    }

    public InputStream getAppOutput(boolean bl) throws ConnectException, AuthenticationException {
        return this.getAppOutput(bl, false);
    }

    public InputStream getAppOutput(boolean bl, boolean bl2) throws ConnectException, AuthenticationException {
        return ConsoleInputStream.make(this.getDaemonSession().getInputStream((DaemonMessage)new GetAppOutputMessage(this.getAppTypeString(), this.getAppName(), bl, bl2), 500));
    }

    public void updateLogBufferSize(int n, int n2) throws ConnectException, AuthenticationException {
        if (this.getDaemonSession().sendMessage(new UpdateLogBufferSizeMessage(this.getAppTypeString(), this.getAppName(), n, n2, true))) {
            this.setLogBufferSize(n);
            this.setLogBufferFileSize(n2);
        }
    }

    public void updateSettings(boolean bl, boolean bl2) throws ConnectException, AuthenticationException {
        this.getDaemonSession().sendMessage(new UpdateAppMessage(this.getAppTypeString(), this.getAppName(), this.getIsDisabled(), bl, bl2, true));
    }

    public void checkStart() {
        if (!(this.isAppRunning() || this.isRestartEnabled() || this.getAppStatus() != BStationStatus.halted && this.getAppStatus() != BStationStatus.failed)) {
            throw new LocalizableRuntimeException("platform", "AppSurrogate.error.startHaltedApp");
        }
    }

    public void startAppAsync() throws ConnectException, AuthenticationException {
        this.checkStart();
        if (!this.isAppRunning()) {
            this.setAppStatus(BStationStatus.starting);
            this.getDaemonSession().sendMessage(new StartAppMessage(this.getAppTypeString(), this.getAppName()));
        }
    }

    public void startApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        this.checkStart();
        CancelableDaemonSessionTask cancelableDaemonSessionTask = null;
        OutputWatcher outputWatcher = null;
        if (daemonSessionTaskListener != null) {
            cancelableDaemonSessionTask = this.isAppRunning() ? new CancelableDaemonSessionTask(lex, "AppSurrogate.waiting.title", "AppSurrogate.waiting.message", new Object[]{this.getAppName()}, iCancelHint) : new CancelableDaemonSessionTask(lex, "AppSurrogate.starting.title", "AppSurrogate.starting.message", new Object[]{this.getAppName()}, iCancelHint);
            iCancelHint = cancelableDaemonSessionTask;
        }
        try {
            outputWatcher = new OutputWatcher(this.getAppOutput(true, true), cancelableDaemonSessionTask, daemonSessionTaskListener);
            outputWatcher.start();
            if (daemonSessionTaskListener != null) {
                daemonSessionTaskListener.taskStarted(cancelableDaemonSessionTask);
            }
            this.startAppAsync();
            while (true) {
                if (BAppSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                    throw new ICancelHint.CanceledException();
                }
                this.poll();
                if (this.getAppStatus() == BStationStatus.running) {
                    Object var6_5 = null;
                    if (daemonSessionTaskListener != null) {
                        if (outputWatcher != null) {
                            outputWatcher.stopWatcher();
                        }
                        daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                    }
                    return;
                }
                if (this.getAppStatus() == BStationStatus.failed) {
                    throw new Exception("Application failed to start");
                }
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            block11: {
                Object var6_6 = null;
                if (daemonSessionTaskListener == null) break block11;
                if (outputWatcher != null) {
                    outputWatcher.stopWatcher();
                }
                daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
            }
            throw throwable;
        }
    }

    public void stopAppAsync() throws ConnectException, AuthenticationException {
        try {
            this.setAppStatus(BStationStatus.stopping);
            this.getDaemonSession().sendMessage(new StopAppMessage(this.getAppTypeString(), this.getAppName()));
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static BAppSurrogate[] stopAllApps(BDaemonSession bDaemonSession, Type type, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        try {
            return BAppSurrogate.stopAllApps(bDaemonSession, type, BAppSurrogate.makeAll(type, bDaemonSession), iCancelHint, daemonSessionTaskListener);
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public String getAppTypeString() {
        return BAppSurrogate.getAppTypeString(this.getType());
    }

    public static String getAppTypeString(Type type) {
        if (type == BSedonaSurrogate.TYPE) {
            return "sedona";
        }
        if (type == BStationSurrogate.TYPE) {
            return "station";
        }
        if (type == BR2StationSurrogate.TYPE) {
            return "r2station";
        }
        throw new IllegalArgumentException();
    }

    public static Type getAppType(String string) {
        if (string.equals("station")) {
            return BStationSurrogate.TYPE;
        }
        if (string.equals("sedona")) {
            return BSedonaSurrogate.TYPE;
        }
        if (string.equals("r2station")) {
            return BR2StationSurrogate.TYPE;
        }
        throw new IllegalArgumentException("invalid element for BAppSurrogate.make");
    }

    public static BAppSurrogate make(XElem xElem, BDaemonSession bDaemonSession) throws Exception {
        BAppSurrogate bAppSurrogate = null;
        if (xElem.name().equals("station")) {
            bAppSurrogate = new BStationSurrogate(bDaemonSession);
        } else if (xElem.name().equals("sedona")) {
            bAppSurrogate = new BSedonaSurrogate(bDaemonSession);
        } else if (xElem.name().equals("r2station")) {
            bAppSurrogate = new BR2StationSurrogate(bDaemonSession);
        } else {
            throw new IllegalArgumentException("invalid element for BAppSurrogate.make");
        }
        ((BAppSurrogate)bAppSurrogate).updateFields(xElem);
        return bAppSurrogate;
    }

    public static BAppSurrogate[] makeAll(Type type, BDaemonSession bDaemonSession) throws Exception {
        if (type == null) {
            Class clazz = class$com$tridium$platform$daemon$BAppSurrogate;
            if (clazz == null) {
                clazz = class$com$tridium$platform$daemon$BAppSurrogate = BAppSurrogate.class("[Lcom.tridium.platform.daemon.BAppSurrogate;", false);
            }
            Array array = new Array(clazz);
            Map map = BAppSurrogate.getAppElementMap(bDaemonSession);
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((Map)iterator.next()).values().iterator();
                while (iterator2.hasNext()) {
                    array.add((Object)BAppSurrogate.make((XElem)iterator2.next(), bDaemonSession));
                }
            }
            return (BAppSurrogate[])array.trim();
        }
        Map map = BAppSurrogate.getAppElementMap(type, bDaemonSession);
        if (map == null) {
            System.out.println("apps for " + type + " is null!");
        }
        BAppSurrogate[] bAppSurrogateArray = (BAppSurrogate[])java.lang.reflect.Array.newInstance(type.getTypeClass(), map.size());
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            bAppSurrogateArray[n] = BAppSurrogate.make((XElem)iterator.next(), bDaemonSession);
            ++n;
        }
        return bAppSurrogateArray;
    }

    public static boolean isAnyAppRunning(Type type, BDaemonSession bDaemonSession) throws Exception {
        BAppSurrogate[] bAppSurrogateArray = BAppSurrogate.makeAll(type, bDaemonSession);
        int n = 0;
        while (n < bAppSurrogateArray.length) {
            if (bAppSurrogateArray[n].isAppRunning()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static XElem getAppElem(BDaemonSession bDaemonSession, BAppSurrogate bAppSurrogate) throws Exception {
        Map map = BAppSurrogate.getAppElementMap(bAppSurrogate.getType(), bDaemonSession);
        return (XElem)map.get(bAppSurrogate.getAppName());
    }

    /*
     * Exception decompiling
     */
    public static BAppSurrogate[] stopAllApps(BDaemonSession var0, Type var1_1, BAppSurrogate[] var2_2, ICancelHint var3_3, DaemonSessionTaskListener var4_4) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [10 : 410->413)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stopApp(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.stopApp(iCancelHint, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        block14: {
            CancelableDaemonSessionTask cancelableDaemonSessionTask;
            block13: {
                if (this.isAppStopped()) break block14;
                cancelableDaemonSessionTask = null;
                try {
                    try {
                        if (this.getAppStatus() != BStationStatus.stopping) {
                            if (daemonSessionTaskListener != null) {
                                cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "AppSurrogate.stopping.title", "AppSurrogate.stopping.message", new Object[]{this.getAppName()}, iCancelHint);
                                cancelableDaemonSessionTask.setCancelLabel(lex.getText("AppSurrogate.stopping.cancel"));
                                daemonSessionTaskListener.taskStarted(cancelableDaemonSessionTask);
                            }
                            this.stopAppAsync();
                            this.poll();
                            while (!this.isAppStopped() && !BAppSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                                Thread.sleep(1000L);
                                this.poll();
                            }
                        }
                    }
                    catch (ConnectException connectException) {
                        throw connectException;
                    }
                    catch (AuthenticationException authenticationException) {
                        throw authenticationException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new BajaRuntimeException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                        daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                    }
                    throw throwable;
                }
                {
                    Object var5_10 = null;
                    if (daemonSessionTaskListener == null || cancelableDaemonSessionTask == null) break block13;
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
            }
            if (BAppSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public void restartAppAsync() throws ConnectException, AuthenticationException {
        if (!this.isRestartEnabled()) {
            throw new LocalizableRuntimeException("platform", "AppSurrogate.error.restartNotPermitted");
        }
        this.restartAppAsync(false);
    }

    public void restartAppAsync(boolean bl) throws ConnectException, AuthenticationException {
        if (!this.isRestartEnabled()) {
            throw new LocalizableRuntimeException("platform", "AppSurrogate.error.restartNotPermitted");
        }
        this.setAppStatus(BStationStatus.stopping);
        this.getDaemonSession().sendMessage(new RestartAppMessage(this.getAppTypeString(), this.getAppName(), bl));
    }

    public void deleteApp(ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        this.deleteApp(iCancelHint, null);
    }

    public void deleteApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.stopApp(iCancelHint, daemonSessionTaskListener);
        this.getDaemonSession().sendMessage(new DeleteAppMessage(this.getAppTypeString(), this.getAppName()));
    }

    public void killAppAsync() throws ConnectException, AuthenticationException {
        this.setAppStatus(BStationStatus.stopping);
        this.getDaemonSession().sendMessage(new KillAppMessage(this.getAppTypeString(), this.getAppName()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void killApp(ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        block13: {
            CancelableDaemonSessionTask cancelableDaemonSessionTask;
            block12: {
                if (this.isAppStopped()) break block13;
                cancelableDaemonSessionTask = null;
                try {
                    try {
                        if (daemonSessionTaskListener != null) {
                            cancelableDaemonSessionTask = new CancelableDaemonSessionTask(lex, "AppSurrogate.killing.title", "AppSurrogate.killing.message", new Object[]{this.getAppName()}, iCancelHint);
                            daemonSessionTaskListener.taskStarted(cancelableDaemonSessionTask);
                        }
                        this.killAppAsync();
                        this.poll();
                        while (!this.isAppStopped() && !BAppSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                            Thread.sleep(1000L);
                            this.poll();
                        }
                    }
                    catch (ConnectException connectException) {
                        throw connectException;
                    }
                    catch (AuthenticationException authenticationException) {
                        throw authenticationException;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new BajaRuntimeException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (daemonSessionTaskListener != null && cancelableDaemonSessionTask != null) {
                        daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                    }
                    throw throwable;
                }
                {
                    Object var5_10 = null;
                    if (daemonSessionTaskListener == null || cancelableDaemonSessionTask == null) break block12;
                    daemonSessionTaskListener.taskFinished(cancelableDaemonSessionTask);
                }
            }
            if (BAppSurrogate.isCanceled(cancelableDaemonSessionTask)) {
                throw new ICancelHint.CanceledException();
            }
        }
    }

    public boolean isAppRunning() {
        boolean bl = false;
        if (this.getAppStatus() == BStationStatus.running || this.getAppStatus() == BStationStatus.starting) {
            bl = true;
        }
        return bl;
    }

    public boolean isAppStopped() {
        boolean bl = false;
        if (this.getAppStatus() == BStationStatus.idle || this.getAppStatus() == BStationStatus.halted || this.getAppStatus() == BStationStatus.failed) {
            bl = true;
        }
        return bl;
    }

    protected static boolean isCanceled(CancelableDaemonSessionTask cancelableDaemonSessionTask) {
        boolean bl = false;
        if (cancelableDaemonSessionTask != null) {
            bl = cancelableDaemonSessionTask.isCanceled();
        }
        return bl;
    }

    public String toString(Context context) {
        return lex.getText("AppSurrogate." + this.getAppTypeString() + ".display", new Object[]{this.getAppName()});
    }

    public BIcon getIcon() {
        return this.isAppRunning() ? connectedIcon : disconnectedIcon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAppSurrogate() {
        throw new UnsupportedOperationException();
    }

    public BAppSurrogate(BDaemonSession bDaemonSession) {
        this.session = bDaemonSession;
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$BAppSurrogate;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$BAppSurrogate = BAppSurrogate.class("[Lcom.tridium.platform.daemon.BAppSurrogate;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        connectedIcon = BIcon.std((String)"database.png");
        disconnectedIcon = BIcon.std((String)"databaseDisconnected.png");
        lex = Lexicon.make((String)"platform");
        log = Log.getLog((String)"platform.appSurrogate");
    }

    protected static class GetAppOutputMessage
    extends DaemonMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public GetAppOutputMessage(String string, String string2, boolean bl, boolean bl2) {
            this.path = new StringBuffer(string);
            this.path.append("?action=getoutput");
            this.path.append("&").append(string).append("=").append(HttpUtil.encodeUrl((String)string2));
            this.path.append("&follow=").append(String.valueOf(bl));
            this.path.append("&updatesonly=").append(String.valueOf(bl2));
        }
    }

    protected static class UpdateLogBufferSizeMessage
    extends XmlResponseMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public UpdateLogBufferSizeMessage(String string, String string2, int n, int n2, boolean bl) {
            this.path = new StringBuffer(string);
            this.path.append("?action=update");
            this.path.append("&").append(string).append("=").append(HttpUtil.encodeUrl((String)string2));
            this.path.append("&logbuffersize=").append(n);
            this.path.append("&logbufferfilesize=").append(n2);
            if (bl) {
                this.path.append("&save=true");
            }
        }
    }

    protected static class StartAppMessage
    extends XmlResponseMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public StartAppMessage(String string, String string2) {
            this.path = new StringBuffer(string);
            this.path.append("?action=start");
            this.path.append("&").append(string).append("=").append(HttpUtil.encodeUrl((String)string2));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected static class OutputWatcher
    extends Thread {
        private InputStream in;
        private CancelableDaemonSessionTask task;
        private DaemonSessionTaskListener listener;
        private boolean stopped;
        private StringBuffer buf;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.listener == null) {
                return;
            }
            this.stopped = false;
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                try {
                    this.checkCanceled();
                    while (!this.stopped) {
                        try {
                            n = this.in.read(byArray, 0, 1024);
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new IOException();
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            this.checkCanceled();
                            continue;
                        }
                        this.checkCanceled();
                        if (this.stopped) continue;
                        if (n >= 0) {
                            this.append(new String(byArray, 0, n));
                            continue;
                        }
                        this.stopWatcher(false);
                    }
                }
                catch (EOFException eOFException) {
                    String string = "\n" + lex.getText("InputStreamPane.eof");
                    this.append(string.getBytes(), 0, string.length());
                }
                catch (IOException iOException) {
                    if (!this.stopped) {
                        iOException.printStackTrace(System.out);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.stopWatcher(false);
                throw throwable;
            }
            {
                Object var4_10 = null;
                this.stopWatcher(false);
                return;
            }
        }

        public void append(Throwable throwable) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
            this.append(byteArrayOutputStream.toString());
        }

        public void append(byte[] byArray, int n, int n2) {
            this.append(new String(byArray, n, n2));
        }

        public synchronized void append(String string) {
            this.buf.append(string);
            int n = -1;
            while ((n = this.indexOf(this.buf, '\n')) >= 0) {
                this.task.setMessage(this.buf.substring(0, n));
                this.listener.taskUpdated(this.task);
                this.buf.delete(0, n + 1);
            }
        }

        private final synchronized int indexOf(StringBuffer stringBuffer, char c) {
            int n = stringBuffer.length();
            int n2 = 0;
            while (n2 < n) {
                if (stringBuffer.charAt(n2) == c) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public void stopWatcher() {
            this.stopWatcher(true);
        }

        public void stopWatcher(boolean bl) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            try {
                this.in.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                try {
                    this.join();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private final void checkCanceled() {
            if (this.task != null && this.task.isCanceled()) {
                this.stopWatcher(false);
            }
        }

        private final /* synthetic */ void this() {
            this.stopped = true;
            this.buf = new StringBuffer();
        }

        public OutputWatcher(InputStream inputStream, CancelableDaemonSessionTask cancelableDaemonSessionTask, DaemonSessionTaskListener daemonSessionTaskListener) {
            super("AppSurrogate:OutputWatcher");
            this.this();
            this.in = inputStream;
            this.task = cancelableDaemonSessionTask;
            this.listener = daemonSessionTaskListener;
        }
    }

    protected static class StopAppMessage
    extends XmlResponseMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public StopAppMessage(String string, String string2) {
            this.path = new StringBuffer(string);
            this.path.append("?action=stop");
            this.path.append("&").append(string).append("=").append(HttpUtil.encodeUrl((String)string2));
            this.path.append("&restartOverride=").append(2);
        }
    }

    protected static class RestartAppMessage
    extends XmlResponseMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public RestartAppMessage(String string, String string2, boolean bl) {
            this.path = new StringBuffer(string);
            if (bl) {
                this.path.append("?action=kill");
            } else {
                this.path.append("?action=stop");
            }
            this.path.append("&").append(string).append("=").append(HttpUtil.encodeUrl((String)string2));
            this.path.append("&restartOverride=").append(1);
        }
    }

    protected static class KillAppMessage
    extends XmlResponseMessage {
        private StringBuffer path;

        public String getMessageString() {
            return this.path.toString();
        }

        public KillAppMessage(String string, String string2) {
            this(string, string2, false);
        }

        public KillAppMessage(String string, String string2, boolean bl) {
            this.path = new StringBuffer(string);
            this.path.append("?action=kill");
            this.path.append("&").append(string).append("=").append(HttpUtil.encodeUrl((String)string2));
            this.path.append("&restartOverride=").append(2);
            this.path.append("&block=").append(String.valueOf(bl));
        }
    }
}

