/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.KeyMaterial;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SimpleKeyRing;
import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.util.CommandLineArguments;
import com.tridium.util.ComponentTreeCursor;
import java.io.File;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMakeStationPortableCommand
extends BAbstractPlatformCommand {
    public static final BMakeStationPortableCommand INSTANCE = new BMakeStationPortableCommand();
    public static final Type TYPE;
    private static final Log log;
    private KeyRing kr;
    private boolean errors;
    static /* synthetic */ Class class$com$tridium$platform$command$BMakeStationPortableCommand;

    public Type getType() {
        return TYPE;
    }

    public void usage() {
        BMakeStationPortableCommand.println("");
        BMakeStationPortableCommand.println("usage:");
        BMakeStationPortableCommand.println("  plat makeportable <flags> <sourceStationDir> [target] [securityDir]");
        BMakeStationPortableCommand.println("parameters:");
        BMakeStationPortableCommand.println("  sourceStationDir   the station directory to convert");
        BMakeStationPortableCommand.println("  target             the name of the target station. Defaults to the name of the source station.");
        BMakeStationPortableCommand.println("  securityDir        the security directory of the source station. Defaults to <sourceStationDir>/../../security");
        BMakeStationPortableCommand.println("optional flags:");
        BMakeStationPortableCommand.println("  -o                 overwrite existing destStationDir");
        BMakeStationPortableCommand.println("  -locale:<x>        set the default locale (en_US)");
        BMakeStationPortableCommand.println("  -@<option>         pass option to Java VM");
        BMakeStationPortableCommand.println("  -buildreg          force rebuild of the registry");
        BMakeStationPortableCommand.println("");
    }

    public int invoke(CommandLineArguments commandLineArguments) {
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        if (commandLineArguments.parameters.length < 1) {
            this.usage();
            return 2;
        }
        String string = commandLineArguments.parameters[0];
        File file = new File(string);
        String string2 = commandLineArguments.parameters.length > 1 ? commandLineArguments.parameters[1] : file.getName();
        File file2 = new File(Sys.getBajaHome(), "stations" + File.separator + string2);
        File file3 = commandLineArguments.parameters.length > 2 ? new File(commandLineArguments.parameters[2]) : new File(file.getParentFile().getParentFile(), "security");
        File file4 = new File(file3, ".km");
        File file5 = new File(file3, ".kr");
        if (!file.isDirectory()) {
            log.error("Source directory " + file.getAbsolutePath() + " is not a directory or does not exist.");
            return 2;
        }
        if (!file3.isDirectory()) {
            log.error("Security directory " + file3.getAbsolutePath() + " is not a directory or does not exist.");
            return 2;
        }
        if (!file4.isFile()) {
            log.error("Key material file " + file4.getAbsolutePath() + " does not exist.");
            return 2;
        }
        if (!file5.isFile()) {
            log.error("Key ring file " + file5.getAbsolutePath() + " does not exist.");
            return 2;
        }
        try {
            LegacyKeyMaterial legacyKeyMaterial = new LegacyKeyMaterial(file4);
            this.kr = new SimpleKeyRing(file3, ".kr", (KeyMaterial)legacyKeyMaterial);
        }
        catch (Exception exception) {
            log.error("Could not get key ring: " + exception);
            return 1;
        }
        if (commandLineArguments.hasOption("o")) {
            try {
                FileUtil.delete((File)file2);
            }
            catch (Exception exception) {
                log.error("Could not overwrite existing destination directory: " + exception);
                return 1;
            }
        } else if (file2.exists()) {
            log.error("Destination directory " + file2.getAbsolutePath() + " already exists. Rerun with '-o' to overwrite.");
            return 2;
        }
        log.message("Copying station directory " + file.getAbsolutePath() + " to " + file2.getAbsolutePath());
        try {
            FileUtil.copyDir((File)file, (File)file2);
        }
        catch (Exception exception) {
            log.warning("Could not copy source station: " + exception);
            return 1;
        }
        this.convertBogs(file2);
        if (this.errors) {
            log.message("Done with errors.");
            return 3;
        }
        log.message("Done.");
        return 0;
    }

    public void convertBogs(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.convertBogs(fileArray[n]);
                } else if (fileArray[n].getName().endsWith(".bog")) {
                    this.convertBog(fileArray[n]);
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convertBog(File file) {
        Property[] propertyArray;
        log.message("Converting bog " + file.getAbsolutePath());
        BBogFile bBogFile = new BBogFile((BIFileStore)new BLocalFileStore((BFileSpace)BFileSystem.INSTANCE, BFileSystem.INSTANCE.localFileToPath(file), file));
        BComponentSpace bComponentSpace = (BComponentSpace)bBogFile.open();
        BComponent bComponent = bComponentSpace.getRootComponent();
        ComponentTreeCursor componentTreeCursor = new ComponentTreeCursor(bComponent, null);
        while (componentTreeCursor.nextComponent()) {
            BComponent bComponent2 = (BComponent)componentTreeCursor.get();
            propertyArray = bComponent2.getPropertiesArray();
            int n = 0;
            while (n < propertyArray.length) {
                BPassword bPassword;
                String string;
                BValue bValue = bComponent2.get(propertyArray[n]);
                if (bValue instanceof BPassword && (!bValue.equals((Object)propertyArray[n].getDefaultValue()) || propertyArray[n].isDynamic()) && (string = (bPassword = (BPassword)bValue).getPasswordEncoder().getEncodingType()).equals("aes256/text")) {
                    String string2 = bPassword.getPasswordEncoder().getEncodedValue();
                    int n2 = string2.indexOf(":");
                    String string3 = string2.substring(0, n2);
                    String string4 = string2.substring(n2 + 1);
                    try {
                        String string5 = Aes256PasswordManager.getManager((KeyRing)this.kr).decrypt(string4, string3);
                        BPassword bPassword2 = BPassword.make((String)string5);
                        bComponent2.set(propertyArray[n], (BValue)bPassword2);
                        log.trace("Converted password " + bComponent2.getSlotPathOrd() + '/' + propertyArray[n].getName());
                    }
                    catch (Exception exception) {
                        log.warning("Could not convert password " + bComponent2.getSlotPathOrd() + '/' + propertyArray[n].getName() + ": " + exception);
                        this.errors = true;
                    }
                }
                ++n;
            }
        }
        try {
            try {
                bBogFile.save();
            }
            catch (Exception exception) {
                log.warning("Could not save bog " + file.getAbsolutePath() + ": " + exception);
                this.errors = true;
            }
            propertyArray = null;
        }
        catch (Throwable throwable) {
            propertyArray = null;
            bBogFile.close();
            throw throwable;
        }
        bBogFile.close();
    }

    public String getCommandName() {
        return "makeportable";
    }

    public String getCommandDescription() {
        return "Convert station to use portable encoding for reversible passwords.";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.errors = false;
    }

    public BMakeStationPortableCommand() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platform$command$BMakeStationPortableCommand;
        if (clazz == null) {
            clazz = class$com$tridium$platform$command$BMakeStationPortableCommand = BMakeStationPortableCommand.class("[Lcom.tridium.platform.command.BMakeStationPortableCommand;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"makeportable");
    }

    private static class LegacyKeyMaterial
    extends KeyMaterial {
        File kmFile;

        /*
         * Exception decompiling
         */
        public byte[] getKeyMaterial() throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 117->120)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setKeyMaterial(byte[] byArray) throws Exception {
            throw new UnsupportedOperationException();
        }

        private LegacyKeyMaterial(File file) {
            this.kmFile = file;
        }
    }
}

