/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.command;

import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import java.net.ConnectException;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDaemonSessionCommand
extends BAbstractPlatformCommand
implements DaemonSessionTaskListener {
    public static final Type TYPE;
    private String lastTaskMessage;
    static /* synthetic */ Class class$com$tridium$platform$command$BDaemonSessionCommand;

    public Type getType() {
        return TYPE;
    }

    /*
     * Loose catch block
     */
    protected BDaemonSession getSession(CommandLineArguments commandLineArguments) throws ConnectException {
        BHost bHost = this.getHost(commandLineArguments);
        if (bHost == null) {
            return null;
        }
        int n = this.getPort(commandLineArguments);
        BDaemonSession bDaemonSession = BDaemonSession.make(bHost, n);
        BUsernameAndPassword bUsernameAndPassword = this.getCredentials(bDaemonSession, commandLineArguments);
        bDaemonSession.setCredentials((BICredentials)bUsernameAndPassword);
        while (true) {
            try {
                bDaemonSession.connect();
                return bDaemonSession;
            }
            catch (ConnectException connectException) {
                throw connectException;
            }
            catch (AuthenticationException authenticationException) {
                if (commandLineArguments.hasOption("noinput")) {
                    throw authenticationException;
                }
                BDaemonSessionCommand.println("Authentication failed");
                bUsernameAndPassword = this.getCredentials(bDaemonSession, null);
                bDaemonSession.setCredentials((BICredentials)bUsernameAndPassword);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            break;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected BHost getHost(CommandLineArguments commandLineArguments) {
        String string = commandLineArguments.getOption("h");
        return string == null ? null : (BHost)BOrd.make((String)string).get();
    }

    public int getPort(CommandLineArguments commandLineArguments) {
        return commandLineArguments.getIntOption("p", 3011);
    }

    public BUsernameAndPassword getCredentials(BDaemonSession bDaemonSession, CommandLineArguments commandLineArguments) throws ConnectException {
        String string;
        String string2 = commandLineArguments == null ? null : commandLineArguments.getOption("usr");
        String string3 = string = commandLineArguments == null ? null : commandLineArguments.getOption("pwd");
        if (!(string2 != null || commandLineArguments != null && commandLineArguments.hasOption("noinput"))) {
            string2 = this.promptString("User: ");
        }
        if (!(string != null || commandLineArguments != null && commandLineArguments.hasOption("noinput"))) {
            string = this.promptPasswordString("Password:  ");
        }
        if (string2 == null || string == null) {
            return null;
        }
        BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bDaemonSession.makeCredentials();
        bUsernameAndPassword.setUsername(string2);
        bUsernameAndPassword.setPassword(BPassword.make((String)string));
        return bUsernameAndPassword;
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (!daemonSessionTask.getMessage().equals(this.lastTaskMessage)) {
            System.out.println(daemonSessionTask.getMessage());
            this.lastTaskMessage = daemonSessionTask.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        this.taskStarted(daemonSessionTask);
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
    }

    public boolean isCancelEnabled() {
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastTaskMessage = null;
    }

    public BDaemonSessionCommand() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platform$command$BDaemonSessionCommand;
        if (clazz == null) {
            clazz = class$com$tridium$platform$command$BDaemonSessionCommand = BDaemonSessionCommand.class("[Lcom.tridium.platform.command.BDaemonSessionCommand;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

