/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.archive;

import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.ZipArchiveReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;

public class ZipArchive
implements FileArchive {
    public static Log log = Log.getLog((String)"platform.zipArchive");
    String archiveName;
    String archivePath;
    private File archiveFile;
    private File workingFile;
    private ZipOutputStream out;
    int maxBackups;

    public void writeFile(File file, String string) {
        try {
            int n;
            if (!file.exists()) {
                log.warning(file + " does not exist!");
                return;
            }
            if (file.isDirectory()) {
                throw new IllegalArgumentException("File is directory: " + file);
            }
            if ((string = string.replace('\\', '/')).charAt(0) == '/') {
                string = string.substring(1);
            }
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setSize(file.length());
            zipEntry.setTime(file.lastModified());
            try {
                this.out.putNextEntry(zipEntry);
            }
            catch (ZipException zipException) {
                log.warning("Archive " + this.archiveName + " unable to put zip entry ", (Throwable)zipException);
                return;
            }
            log.trace("Adding " + string);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                this.out.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            this.out.closeEntry();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
            log.trace("renaming archive file to backup " + this.archiveFile);
            FileUtil.renameToBackup((File)this.archiveFile, (int)this.maxBackups);
            log.trace("renaming working file to backup " + this.archiveFile);
            this.workingFile.renameTo(this.archiveFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void unzip(String string, String string2, String string3) throws IOException {
        Object object;
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdir();
        } else if (!file.isDirectory()) {
            throw new IllegalArgumentException("destDir <" + file + "> is not a directory");
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            FileUtil.delete((File)fileArray[n]);
            ++n;
        }
        File file2 = new File(string, string2);
        if (!file2.exists()) {
            object = new File(string, string2 + ".working");
            if (((File)object).exists()) {
                ((File)object).renameTo(file2);
            } else {
                return;
            }
        }
        object = new ZipArchiveReader(file2, false);
        ((ZipArchiveReader)object).extractAll(file);
    }

    public ZipArchive(String string, String string2, int n) {
        try {
            this.archivePath = string;
            this.archiveName = string2;
            this.archiveFile = new File(string, string2);
            this.workingFile = new File(this.archiveFile + ".working");
            this.maxBackups = n;
            if (this.archiveFile.isDirectory()) {
                throw new IllegalArgumentException("File is directory: " + this.archiveFile);
            }
            this.out = new ZipOutputStream(new FileOutputStream(this.workingFile));
            this.out.setMethod(8);
            String string3 = string2.substring(0, string2.indexOf(46));
            File[] fileArray = FileUtil.getBackups((File)new File(string), (String)string3);
            if (fileArray != null && fileArray.length != 0) {
                int n2 = fileArray.length - 1;
                while (n2 > n) {
                    log.trace("Deleting " + fileArray[n2]);
                    fileArray[n2].delete();
                    --n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

