/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.platform.BPlatform;
import com.tridium.platform.IPlatformLibrary;

abstract class NativePlatformLibrary
implements IPlatformLibrary {
    public static boolean nativesLoaded = false;
    public static boolean errorPrinted = false;
    private static Object NATIVE_FS_MONITOR = new Object();

    public static synchronized boolean load() {
        block3: {
            if (!nativesLoaded) {
                try {
                    System.loadLibrary("platform");
                    nativesLoaded = true;
                    errorPrinted = false;
                }
                catch (Throwable throwable) {
                    if (errorPrinted) break block3;
                    BPlatform.log.error("Cannot load native platform library");
                    errorPrinted = true;
                }
            }
        }
        return nativesLoaded;
    }

    public String getLastErrorMessage() {
        return NativePlatformLibrary.getLastErrorMessage0();
    }

    public void log(int n, String string) {
        NativePlatformLibrary.log0(n, string);
    }

    public int setSystemTime(long l) {
        return NativePlatformLibrary.setSystemTime0(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAllFileSystemNames() {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.getAllFileSystemNames0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFreeBytes(String string) {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.getFreeBytes0(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTotalBytes(String string) {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.getTotalBytes0(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getBlockSize(String string) {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.getBlockSize0(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxFileCount(String string) {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.getMaxFileCount0(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCurrentFileCount(String string) {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.getCurrentFileCount0(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFlash(String string) {
        Object object = NATIVE_FS_MONITOR;
        synchronized (object) {
            return NativePlatformLibrary.isFlash0(string);
        }
    }

    public long getTotalPhysicalMemoryBytes() {
        return NativePlatformLibrary.getTotalPhysicalMemoryBytes0();
    }

    public long getFreePhysicalMemoryBytes() {
        return NativePlatformLibrary.getFreePhysicalMemoryBytes0();
    }

    public int getCurrentCPUUtilization() {
        return NativePlatformLibrary.getCurrentCPUUtilization0();
    }

    public int getOverallCPUUtilization() {
        return NativePlatformLibrary.getOverallCPUUtilization0();
    }

    public int getNumberCPUs() {
        return NativePlatformLibrary.getNumberCPUs0();
    }

    public void updateWatchdog(String string, int n, int n2, int n3) {
        NativePlatformLibrary.updateWatchdog0(string, n, n2, n3);
    }

    public long getProcessId() {
        return NativePlatformLibrary.getProcessId0();
    }

    private static final native String getLastErrorMessage0();

    private static final native void log0(int var0, String var1);

    private static final native int setSystemTime0(long var0);

    private static final native String[] getAllFileSystemNames0();

    private static final native long getFreeBytes0(String var0);

    private static final native long getTotalBytes0(String var0);

    private static final native int getBlockSize0(String var0);

    private static final native long getMaxFileCount0(String var0);

    private static final native long getCurrentFileCount0(String var0);

    private static final native boolean isFlash0(String var0);

    private static final native long getTotalPhysicalMemoryBytes0();

    private static final native long getFreePhysicalMemoryBytes0();

    private static final native int getCurrentCPUUtilization0();

    private static final native int getOverallCPUUtilization0();

    private static final native int getNumberCPUs0();

    private static final native void updateWatchdog0(String var0, int var1, int var2, int var3);

    private static final native long getProcessId0();

    NativePlatformLibrary() {
    }
}

