/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.net.HttpUtil;
import com.tridium.nre.security.fips.EntrustProviderManager;
import com.tridium.nre.util.JavaTimeUtil;
import com.tridium.platform.BEngineWatchdogPolicy;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BStationRenameCleanupJob;
import com.tridium.platform.IPlatformLibrary;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.NullFileArchive;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.fox.BTimeChannel;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.station.Station;
import com.tridium.timezone.TzJarUtil;
import com.tridium.timezone.TzXmlDecoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.platform.RemoteStation;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BStationNameValidator;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSystemPlatformService
extends BPlatformService
implements BIAlarmablePlatformService {
    public static final Property javaVmName = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property javaVmVendor = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property javaVmVersion = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property osArch = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property osName = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property osVersion = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property hostId = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property model = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property niagaraVersion = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Property locale = BSystemPlatformService.newProperty((int)3, (String)"", (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth"}, (BIDataValue[])new BInteger[]{BInteger.make((int)2), BInteger.make((int)8)}));
    public static final Property stationName = BSystemPlatformService.newProperty((int)3, (String)"system", null);
    public static final Property systemTime = BSystemPlatformService.newProperty((int)3, (BValue)Clock.time((int)1000), null);
    public static final Property timeZone = BSystemPlatformService.newProperty((int)3, (BValue)BTimeZone.DEFAULT, null);
    public static final Property currentCpuUsage = BSystemPlatformService.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property overallCpuUsage = BSystemPlatformService.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property numCpus = BSystemPlatformService.newProperty((int)3, (int)1, null);
    public static final Property totalPhysicalMemory = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    public static final Property freePhysicalMemory = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    public static final Property filesystemAttributes = BSystemPlatformService.newProperty((int)3, (BValue)new BVector(), null);
    public static final Property isStation = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    public static final Property engineWatchdogPolicy = BSystemPlatformService.newProperty((int)1, (BValue)BEngineWatchdogPolicy.terminate, null);
    public static final Property engineWatchdogTimeout = BSystemPlatformService.newProperty((int)1, (BValue)BRelTime.MINUTE, (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.make((long)0L), BBoolean.FALSE}));
    public static final Property isStationAutoSaveEnabled = BSystemPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property stationAutoSaveFrequency = BSystemPlatformService.newProperty((int)1, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.makeMinutes((int)1), BBoolean.FALSE}));
    public static final Property stationSaveBackupCount = BSystemPlatformService.newProperty((int)1, (int)3, null);
    public static final Property timezoneDayModeSupport = BSystemPlatformService.newProperty((int)3, (BValue)BDstSupportLevel.none, null);
    public static final Property localDaemonAccess = BSystemPlatformService.newProperty((int)3, (BValue)BDaemonAccessLevel.none, null);
    public static final Property localDaemonPort = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    public static final Property localDaemonSslPort = BSystemPlatformService.newProperty((int)3, (int)-1, null);
    public static final Property stationSaveAlarmSupport = BSystemPlatformService.newProperty((int)0, (BValue)BSystemPlatformService.initStationSaveAlarmSupport(), null);
    public static final Property stationSaveAlarmProxy = BSystemPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property bajaHome = BSystemPlatformService.newProperty((int)6, (String)"unknown", null);
    public static final Property allowStationRestart = BSystemPlatformService.newProperty((int)3, (boolean)false, null);
    public static final Property fipsStatus = BSystemPlatformService.newProperty((int)3, (String)"", null);
    public static final Action getFilesystemForPath = BSystemPlatformService.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action getAllTimeZones = BSystemPlatformService.newAction((int)4, null);
    public static final Action reboot = BSystemPlatformService.newAction((int)4, null);
    public static final Action requestGarbageCollection = BSystemPlatformService.newAction((int)0, null);
    public static final Action sendThreadDumpToConsole = BSystemPlatformService.newAction((int)0, null);
    public static final Action restartStation = BSystemPlatformService.newAction((int)128, null);
    public static final Action renameAndRestartStation = BSystemPlatformService.newAction((int)132, (BValue)BString.make((String)"newStationName"), (BFacets)BFacets.make((String)"validator", (String)"baja:StationNameValidator"));
    public static final Type TYPE;
    private static final BIcon icon;
    private static final BTypeSpec STATION_OUTPUT_SERVLET;
    private static final String ALARM_TYPE_STATION_SAVE = "station save failure";
    private BStation station;
    private BVector allTimeZones;
    private boolean allowTimeUpdate;
    private boolean timeUpdated;
    private boolean timeZoneUpdated;
    private boolean localeUpdated;
    private boolean allowLocaleUpdate;
    private SaveListener saveListener;
    private volatile boolean stationSaveListenerActive;
    static /* synthetic */ Class class$com$tridium$platform$BSystemPlatformService;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public String getJavaVmName() {
        return this.getString(javaVmName);
    }

    public void setJavaVmName(String string) {
        this.setString(javaVmName, string, null);
    }

    public String getJavaVmVendor() {
        return this.getString(javaVmVendor);
    }

    public void setJavaVmVendor(String string) {
        this.setString(javaVmVendor, string, null);
    }

    public String getJavaVmVersion() {
        return this.getString(javaVmVersion);
    }

    public void setJavaVmVersion(String string) {
        this.setString(javaVmVersion, string, null);
    }

    public String getOsArch() {
        return this.getString(osArch);
    }

    public void setOsArch(String string) {
        this.setString(osArch, string, null);
    }

    public String getOsName() {
        return this.getString(osName);
    }

    public void setOsName(String string) {
        this.setString(osName, string, null);
    }

    public String getOsVersion() {
        return this.getString(osVersion);
    }

    public void setOsVersion(String string) {
        this.setString(osVersion, string, null);
    }

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String string) {
        this.setString(hostId, string, null);
    }

    public String getModel() {
        return this.getString(model);
    }

    public void setModel(String string) {
        this.setString(model, string, null);
    }

    public String getNiagaraVersion() {
        return this.getString(niagaraVersion);
    }

    public void setNiagaraVersion(String string) {
        this.setString(niagaraVersion, string, null);
    }

    public String getLocale() {
        return this.getString(locale);
    }

    public void setLocale(String string) {
        this.setString(locale, string, null);
    }

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String string) {
        this.setString(stationName, string, null);
    }

    public BAbsTime getSystemTime() {
        return (BAbsTime)this.get(systemTime);
    }

    public void setSystemTime(BAbsTime bAbsTime) {
        this.set(systemTime, (BValue)bAbsTime, null);
    }

    public BTimeZone getTimeZone() {
        return (BTimeZone)this.get(timeZone);
    }

    public void setTimeZone(BTimeZone bTimeZone) {
        this.set(timeZone, (BValue)bTimeZone, null);
    }

    public int getCurrentCpuUsage() {
        return this.getInt(currentCpuUsage);
    }

    public void setCurrentCpuUsage(int n) {
        this.setInt(currentCpuUsage, n, null);
    }

    public int getOverallCpuUsage() {
        return this.getInt(overallCpuUsage);
    }

    public void setOverallCpuUsage(int n) {
        this.setInt(overallCpuUsage, n, null);
    }

    public int getNumCpus() {
        return this.getInt(numCpus);
    }

    public void setNumCpus(int n) {
        this.setInt(numCpus, n, null);
    }

    public int getTotalPhysicalMemory() {
        return this.getInt(totalPhysicalMemory);
    }

    public void setTotalPhysicalMemory(int n) {
        this.setInt(totalPhysicalMemory, n, null);
    }

    public int getFreePhysicalMemory() {
        return this.getInt(freePhysicalMemory);
    }

    public void setFreePhysicalMemory(int n) {
        this.setInt(freePhysicalMemory, n, null);
    }

    public BVector getFilesystemAttributes() {
        return (BVector)this.get(filesystemAttributes);
    }

    public void setFilesystemAttributes(BVector bVector) {
        this.set(filesystemAttributes, (BValue)bVector, null);
    }

    public boolean getIsStation() {
        return this.getBoolean(isStation);
    }

    public void setIsStation(boolean bl) {
        this.setBoolean(isStation, bl, null);
    }

    public BEngineWatchdogPolicy getEngineWatchdogPolicy() {
        return (BEngineWatchdogPolicy)this.get(engineWatchdogPolicy);
    }

    public void setEngineWatchdogPolicy(BEngineWatchdogPolicy bEngineWatchdogPolicy) {
        this.set(engineWatchdogPolicy, (BValue)bEngineWatchdogPolicy, null);
    }

    public BRelTime getEngineWatchdogTimeout() {
        return (BRelTime)this.get(engineWatchdogTimeout);
    }

    public void setEngineWatchdogTimeout(BRelTime bRelTime) {
        this.set(engineWatchdogTimeout, (BValue)bRelTime, null);
    }

    public boolean getIsStationAutoSaveEnabled() {
        return this.getBoolean(isStationAutoSaveEnabled);
    }

    public void setIsStationAutoSaveEnabled(boolean bl) {
        this.setBoolean(isStationAutoSaveEnabled, bl, null);
    }

    public BRelTime getStationAutoSaveFrequency() {
        return (BRelTime)this.get(stationAutoSaveFrequency);
    }

    public void setStationAutoSaveFrequency(BRelTime bRelTime) {
        this.set(stationAutoSaveFrequency, (BValue)bRelTime, null);
    }

    public int getStationSaveBackupCount() {
        return this.getInt(stationSaveBackupCount);
    }

    public void setStationSaveBackupCount(int n) {
        this.setInt(stationSaveBackupCount, n, null);
    }

    public BDstSupportLevel getTimezoneDayModeSupport() {
        return (BDstSupportLevel)this.get(timezoneDayModeSupport);
    }

    public void setTimezoneDayModeSupport(BDstSupportLevel bDstSupportLevel) {
        this.set(timezoneDayModeSupport, (BValue)bDstSupportLevel, null);
    }

    public BDaemonAccessLevel getLocalDaemonAccess() {
        return (BDaemonAccessLevel)this.get(localDaemonAccess);
    }

    public void setLocalDaemonAccess(BDaemonAccessLevel bDaemonAccessLevel) {
        this.set(localDaemonAccess, (BValue)bDaemonAccessLevel, null);
    }

    public int getLocalDaemonPort() {
        return this.getInt(localDaemonPort);
    }

    public void setLocalDaemonPort(int n) {
        this.setInt(localDaemonPort, n, null);
    }

    public int getLocalDaemonSslPort() {
        return this.getInt(localDaemonSslPort);
    }

    public void setLocalDaemonSslPort(int n) {
        this.setInt(localDaemonSslPort, n, null);
    }

    public BPlatformAlarmSupport getStationSaveAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(stationSaveAlarmSupport);
    }

    public void setStationSaveAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(stationSaveAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getStationSaveAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(stationSaveAlarmProxy);
    }

    public void setStationSaveAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(stationSaveAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public String getBajaHome() {
        return this.getString(bajaHome);
    }

    public void setBajaHome(String string) {
        this.setString(bajaHome, string, null);
    }

    public boolean getAllowStationRestart() {
        return this.getBoolean(allowStationRestart);
    }

    public void setAllowStationRestart(boolean bl) {
        this.setBoolean(allowStationRestart, bl, null);
    }

    public String getFipsStatus() {
        return this.getString(fipsStatus);
    }

    public void setFipsStatus(String string) {
        this.setString(fipsStatus, string, null);
    }

    public BString getFilesystemForPath(BString bString) {
        return (BString)this.invoke(getFilesystemForPath, (BValue)bString, null);
    }

    public BVector getAllTimeZones() {
        return (BVector)this.invoke(getAllTimeZones, null, null);
    }

    public void reboot() {
        this.invoke(reboot, null, null);
    }

    public void requestGarbageCollection() {
        this.invoke(requestGarbageCollection, null, null);
    }

    public void sendThreadDumpToConsole() {
        this.invoke(sendThreadDumpToConsole, null, null);
    }

    public void restartStation() {
        this.invoke(restartStation, null, null);
    }

    public void renameAndRestartStation(BString bString) {
        this.invoke(renameAndRestartStation, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.setJavaVmName(System.getProperty("java.vm.name"));
        this.setJavaVmVendor(System.getProperty("java.vm.vendor"));
        this.setJavaVmVersion(System.getProperty("java.vm.version"));
        this.setOsArch(System.getProperty("os.arch"));
        this.setOsName(System.getProperty("os.name"));
        this.setOsVersion(System.getProperty("os.version"));
        this.setHostId(Nre.getHostId());
        this.setModel(Nre.getHostModel());
        this.setBajaHome(Sys.getBajaHome().getAbsolutePath());
        this.setNiagaraVersion(Sys.loadModule((String)"baja").getVendorVersion().toString());
        BFoxChannelRegistry bFoxChannelRegistry = BFoxChannelRegistry.getPrototype();
        if (bFoxChannelRegistry.get("time") == null) {
            bFoxChannelRegistry.add("time", (BValue)new BTimeChannel());
        }
    }

    public void serviceStopped() throws Exception {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        BFoxChannelRegistry bFoxChannelRegistry = BFoxChannelRegistry.getPrototype();
        if (bFoxChannelRegistry.get("time") != null) {
            bFoxChannelRegistry.remove("time");
        }
    }

    public void doStationStarted(BStation bStation) {
        this.station = bStation;
        this.setIsStation(true);
        this.setStationName(this.station.getStationName());
        new StationStartupWorker().start();
    }

    public boolean isChildLegal(BComponent bComponent) {
        return bComponent.getType().getTypeSpec().equals((Object)STATION_OUTPUT_SERVLET);
    }

    public boolean isOnLocalHost() {
        return Nre.getHostId().equals(this.getHostId());
    }

    public boolean isValidPlatform() {
        return false;
    }

    public int getSlotFlags() {
        return 0;
    }

    public void loadPlatformServiceProperties() {
        BTimeZone bTimeZone;
        super.loadPlatformServiceProperties();
        this.getStationSaveAlarmProxy().setAlarmSupport(this.getStationSaveAlarmSupport());
        LocalSessionUtil.getLocalSession();
        this.allowTimeUpdate = false;
        this.setSystemTime(Clock.time((int)1000));
        this.setTimeZone(BTimeZone.getLocal());
        try {
            BTimeZone bTimeZone2 = this.getPlatformTimeZone();
            bTimeZone = this.getTimeZone();
            if (bTimeZone2 == null) {
                bTimeZone2 = BTimeZone.UTC;
            }
            if (bTimeZone == null) {
                bTimeZone = BTimeZone.UTC;
            }
            if (!TimeZoneUtil.isEquivalent(bTimeZone2, bTimeZone)) {
                BPlatform.log.warning("OS Time zone '" + bTimeZone2 + "' is not the same as the station time zone '" + bTimeZone + '\'');
            }
        }
        catch (Exception exception) {
            BPlatform.log.warning("error checking platform time zone", (Throwable)exception);
        }
        this.allowTimeUpdate = true;
        this.allowLocaleUpdate = false;
        this.setLocale(Locale.getDefault().toString());
        this.allowLocaleUpdate = true;
        boolean bl = false;
        try {
            Sys.getLicenseManager().checkFeature("Tridium", "fips140-2");
            bl = true;
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {}
        bTimeZone = new EntrustProviderManager();
        boolean bl2 = bTimeZone.verifyProviders();
        if (bl && bl2) {
            this.setFipsStatus(this.getLexicon().getText("labels.system.fipsEnabled"));
        }
        if (bl && !bl2) {
            this.setFipsStatus(this.getLexicon().getText("labels.system.fipsLicensedNotInstalled"));
        } else if (!bl && bl2) {
            this.setFipsStatus(this.getLexicon().getText("labels.system.fipsInstalledNotLicensed"));
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.allowTimeUpdate && this.platformServicePropertiesLoaded) {
            if (property == systemTime) {
                this.timeUpdated = true;
            }
            if (property == timeZone) {
                this.timeZoneUpdated = true;
            }
        }
        if (this.allowLocaleUpdate && this.platformServicePropertiesLoaded && property == locale) {
            this.localeUpdated = true;
        }
    }

    protected boolean startPollTimerOnSubscribe() {
        return true;
    }

    public BRelTime getPollFrequency() {
        return BRelTime.makeSeconds((int)5);
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(context);
        if (!this.timeUpdated) {
            this.allowTimeUpdate = false;
            this.setSystemTime(Clock.time((int)1000));
            this.allowTimeUpdate = true;
        }
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        this.checkPropertiesLoaded();
        if (this.localeUpdated) {
            if (!this.setBajaLocaleId(this.getLocale())) {
                if (this.stationSaveListenerActive) {
                    BPlatform.log.warning("Failed to setBajaLocaleId(" + this.getLocale() + ") during station save");
                } else {
                    throw new BajaRuntimeException("Failed to setBajaLocaleId(" + this.getLocale() + ')');
                }
            }
            this.localeUpdated = false;
        }
        if (this.timeZoneUpdated || this.timeUpdated) {
            BTimeZone bTimeZone = this.getTimeZone();
            if (!this.setBajaTimeZoneId(bTimeZone.getId())) {
                if (this.stationSaveListenerActive) {
                    BPlatform.log.warning("Failed to setBajaTimeZoneId(" + bTimeZone.getId() + ") during station save");
                } else {
                    throw new BajaRuntimeException("Failed to setBajaTimeZoneId(" + bTimeZone.getId() + ')');
                }
            }
            if (this.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
                BDaemonSession bDaemonSession;
                DstRule dstRule;
                long l = this.getSystemTime().getMillis();
                if (!TimeZoneUtil.isSupported(l, bTimeZone, this.getTimezoneDayModeSupport())) {
                    BPlatform.log.warning("Time zone '" + bTimeZone + "' is not supported by the operating system, using UTC as the OS time zone");
                    bTimeZone = BTimeZone.UTC;
                }
                int n = bTimeZone.getUtcOffset(l) / 60000;
                int n2 = bTimeZone.getDaylightAdjustment(l) / 60000;
                DstRule dstRule2 = DstRule.getWallTimeRule((DstRule)bTimeZone.getDaylightStartRule(l), (int)0, (BTimeZone)bTimeZone);
                if (dstRule2 != null && (dstRule2.getDayMode() == 1 || dstRule2.getDayMode() == 2) && this.getTimezoneDayModeSupport().getOrdinal() != 3) {
                    dstRule2 = DstRule.asWeekdayRule((DstRule)dstRule2);
                }
                int n3 = -1;
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                int n8 = -1;
                int n9 = -1;
                if (dstRule2 != null) {
                    if (dstRule2.getTime() != null) {
                        n3 = dstRule2.getTime().getHour();
                        n4 = dstRule2.getTime().getMinute();
                    }
                    if (dstRule2.getMonth() != null) {
                        n5 = dstRule2.getMonth().getOrdinal();
                    }
                    n6 = dstRule2.getDay();
                    n7 = dstRule2.getDayMode();
                    n8 = dstRule2.getWeek();
                    if (dstRule2.getWeekday() != null) {
                        n9 = dstRule2.getWeekday().getOrdinal();
                    }
                }
                if ((dstRule = DstRule.getWallTimeRule((DstRule)bTimeZone.getDaylightEndRule(l), (int)1, (BTimeZone)bTimeZone)) != null && (dstRule.getDayMode() == 1 || dstRule.getDayMode() == 2) && this.getTimezoneDayModeSupport().getOrdinal() != 3) {
                    dstRule = DstRule.asWeekdayRule((DstRule)dstRule);
                }
                int n10 = -1;
                int n11 = -1;
                int n12 = -1;
                int n13 = -1;
                int n14 = -1;
                int n15 = -1;
                int n16 = -1;
                if (dstRule != null) {
                    if (dstRule.getTime() != null) {
                        n10 = dstRule.getTime().getHour();
                        n11 = dstRule.getTime().getMinute();
                    }
                    if (dstRule.getMonth() != null) {
                        n12 = dstRule.getMonth().getOrdinal();
                    }
                    n13 = dstRule.getDay();
                    n14 = dstRule.getDayMode();
                    n15 = dstRule.getWeek();
                    if (dstRule.getWeekday() != null) {
                        n16 = dstRule.getWeekday().getOrdinal();
                    }
                }
                if (!this.setPlatformTimeZone(bTimeZone.getId(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16)) {
                    if (this.stationSaveListenerActive) {
                        BPlatform.log.warning("Failed to setPlatformTimeZone(" + bTimeZone.getId() + ") during station save");
                    } else {
                        throw new BajaRuntimeException("Failed to setPlatformTimeZone(" + bTimeZone.getId() + ')');
                    }
                }
                if ((bDaemonSession = LocalSessionUtil.getLocalSession()) != null) {
                    try {
                        bDaemonSession.sendMessage(new DaemonMessage(){

                            public final String getMessageString() {
                                return "updatedaemon?reloadTz";
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.timeZoneUpdated = false;
        }
        if (this.timeUpdated) {
            if (this.getLocalDaemonAccess() != BDaemonAccessLevel.restricted && !this.setPlatformSystemTime(this.getSystemTime().getMillis())) {
                if (this.stationSaveListenerActive) {
                    BPlatform.log.warning("Failed to setPlatformSystemTime(" + this.getSystemTime().getMillis() + ") during station save");
                } else {
                    throw new BajaRuntimeException("Failed to setPlatformSystemTime(" + this.getSystemTime().getMillis() + ')');
                }
            }
            this.timeUpdated = false;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public void doReboot() throws Exception {
        if (LocalSessionUtil.localDaemonIsAvailable()) {
            new Thread("BSystemPlatormService::doReboot"){

                public final void run() {
                    try {
                        Thread.sleep(1L);
                        LocalSessionUtil.getLocalSession().sendRebootRequest(false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public void doSendThreadDumpToConsole() {
        NreLib.dumpThreads();
    }

    public void doRestartStation() throws Exception {
        if (Sys.getStation() == null) {
            throw new LocalizableRuntimeException("platform", "system.error.notStation");
        }
        if (!LocalSessionUtil.localDaemonIsAvailable()) {
            throw new LocalizableRuntimeException("platform", "system.error.localDaemonUnavailable");
        }
        new Thread(new Runnable(){

            public final void run() {
                try {
                    Thread.sleep(3000L);
                    BSystemPlatformService.this.sendRestartRequest(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }, "BSystemPlatormService::doRestartStation").start();
    }

    public void sendRestartRequest(boolean bl) throws Exception {
        if (Sys.getStation() == null) {
            throw new LocalizableRuntimeException("platform", "system.error.notStation");
        }
        if (!LocalSessionUtil.localDaemonIsAvailable()) {
            throw new LocalizableRuntimeException("platform", "system.error.localDaemonUnavailable");
        }
        BStationSurrogate bStationSurrogate = BStationSurrogate.make(LocalSessionUtil.getLocalSession(), this.getStationName());
        bStationSurrogate.restartStationAsync(bl);
    }

    public IPlatformLibrary getPlatformLibrary() {
        throw new UnsupportedOperationException();
    }

    public void systemLog(int n, String string) throws Exception {
        this.getPlatformLibrary().log(n, string);
    }

    public BTimeZone getPlatformTimeZone() throws Exception {
        String string;
        block2: {
            string = this.getPlatformLibrary().getNativeTimeZone();
            try {
                XParser.make((String)string).parse();
            }
            catch (Exception exception) {
                string = JavaTimeUtil.convertOlsonIdToTimeZoneXml((String)string);
                if (string != null) break block2;
                string = "<zone id=\"UTC\" utcOffset=\"0\"/>";
            }
        }
        return TzXmlDecoder.getTimeZone((XElem)XParser.make((String)string).parse(), (boolean)false);
    }

    public boolean setPlatformSystemTime(long l) {
        boolean bl = false;
        if (this.getPlatformLibrary().setSystemTime(l) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean setBajaTimeZoneId(String string) {
        return NreLib.setSystemProperty((String)"niagara.timezone", (String)string);
    }

    public boolean setBajaLocaleId(String string) {
        return NreLib.setSystemProperty((String)"niagara.lang", (String)string);
    }

    public boolean setPlatformTimeZone(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        int n17 = this.getPlatformLibrary().setNativeTimeZone(string, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16);
        boolean bl = false;
        if (n17 == 0) {
            bl = true;
        }
        return bl;
    }

    public BString doGetFilesystemForPath(BString bString) throws Exception {
        File file = BFileSystem.INSTANCE.pathToLocalFile(new FilePath(bString.toString()));
        FilePath filePath = BFileSystem.INSTANCE.localFileToPath(new File(file.getCanonicalPath()));
        return BString.make((String)this.makeRootName(filePath.nameAt(0)));
    }

    public void doRenameAndRestartStation(final BString bString) {
        new Thread(new Runnable(){

            public final void run() {
                BSystemPlatformService.this.renameAndRestart(Sys.getStation().getStationName(), bString.getString());
            }
        }, "RenameAndRestartStationThread").start();
    }

    private final void renameAndRestart(String string, String string2) {
        if (string == null || string2 == null) {
            BPlatform.log.error("No Station running to rename!");
            return;
        }
        try {
            BStationNameValidator.INSTANCE.validate((BObject)BString.make((String)string2), null);
        }
        catch (CannotValidateException cannotValidateException) {
            BPlatform.log.error("Cannot rename Station. " + cannotValidateException.getMessage(), (Throwable)cannotValidateException);
            return;
        }
        if (string.equals(string2)) {
            return;
        }
        try {
            int n;
            BDaemonSession bDaemonSession = LocalSessionUtil.getLocalSession();
            if (bDaemonSession == null) {
                BPlatform.log.error("No Daemon Session available. Please ensure Station is running from the Platform for Station rename!");
                return;
            }
            NiagaraPlatformDaemon niagaraPlatformDaemon = NiagaraPlatformDaemon.make(bDaemonSession, DaemonSessionTaskListener.NULL_TASK_LISTENER);
            RemoteStation[] remoteStationArray = niagaraPlatformDaemon.getStationManager().getAllStations();
            if (remoteStationArray.length > (n = bDaemonSession.getHostProperties().getMaxStations())) {
                BPlatform.log.error("Cannot rename Station. Max App limit reached! There cannot be more than " + n + " Stations in Niagara's 'stations' directory");
                return;
            }
            int n2 = 0;
            while (n2 < remoteStationArray.length) {
                if (remoteStationArray[n2].getName().equals(string2)) {
                    BPlatform.log.error("Cannot rename Station to " + string2 + ". Station already exists!");
                    return;
                }
                ++n2;
            }
            RemoteStation remoteStation = null;
            int n3 = 0;
            while (n3 < remoteStationArray.length) {
                if (remoteStationArray[n3].getName().equals(string)) {
                    remoteStation = remoteStationArray[n3];
                    break;
                }
                ++n3;
            }
            if (remoteStation == null) {
                BPlatform.log.error("Cannot find Station to rename: " + string);
                return;
            }
            this.doRenameAndRestart(bDaemonSession, string, string2);
        }
        catch (Exception exception) {
            BPlatform.log.error("Could not commit platform changes for Station rename", (Throwable)exception);
        }
    }

    protected void doRenameAndRestart(BDaemonSession bDaemonSession, String string, String string2) throws Exception {
        Runtime.getRuntime().addShutdownHook(new RenameShutdownHook(string, string2));
        BStationRenameCleanupJob bStationRenameCleanupJob = new BStationRenameCleanupJob();
        bStationRenameCleanupJob.setOldStationName(string);
        Sys.getStation().add(null, (BValue)bStationRenameCleanupJob, 5);
        BStationSurrogate bStationSurrogate = BStationSurrogate.make(bDaemonSession, string);
        bStationSurrogate.stopStation(null, null);
    }

    public boolean archiveEnabled(String string) {
        return false;
    }

    public FileArchive createFileArchive(String string) {
        return new NullFileArchive();
    }

    public void extractArchive(String string) {
    }

    public String getRuntimeDirectory(String string) {
        return "^" + string;
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getStationSaveAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getStationSaveAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    protected static BPlatformAlarmSupport initStationSaveAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platform:SystemPlatformService.stationSaveFailure)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platform:SystemPlatformService.stationSaveSuccess)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_STATION_SAVE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    public void doRequestGarbageCollection() {
        System.gc();
    }

    public BVector getStationTimeZones() {
        return this.getStationTimeZones(true);
    }

    public BVector doGetAllTimeZones() {
        return this.getStationTimeZones(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final BVector getStationTimeZones(boolean bl) {
        BTimeZone bTimeZone;
        Object object;
        Array array;
        block39: {
            InputStream inputStream;
            if (this.allTimeZones != null) return this.allTimeZones;
            array = null;
            BTimeChannel bTimeChannel = null;
            try {
                object = (Version)((BFoxSession)this.getSession()).fw(404, (Object)"platform", null, null, null);
                if (object != null && object.compareTo((Object)new Version("3.7.201")) != -1) {
                    bTimeChannel = (BTimeChannel)((BFoxSession)this.getSession()).getConnection().getChannels().get("time", BTimeChannel.TYPE);
                }
            }
            catch (Exception exception) {}
            if (bTimeChannel != null) {
                object = null;
                try {
                    try {
                        object = bTimeChannel.gettimezones();
                        array = TzJarUtil.getTimeZones((InputStream)object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        array = null;
                    }
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    try {
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)object).close();
            }
            if (array == null) {
                try {
                    InputStream inputStream2;
                    try {
                        object = (BIFile)BOrd.make((String)"file:!lib/timezones.jar").get((BObject)this);
                        inputStream2 = object.getInputStream();
                        try {
                            array = TzJarUtil.getTimeZones((InputStream)inputStream2);
                            Object var7_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            try {
                                inputStream2.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {}
                        catch (IOException iOException) {
                        }
                        inputStream2.close();
                    }
                    catch (UnresolvedException unresolvedException) {
                        if (!bl) break block39;
                        try {
                            inputStream2 = (BIFile)BOrd.make((String)"file:!lib/timezones.xml").get((BObject)this);
                            inputStream = inputStream2.getInputStream();
                            Class clazz = class$javax$baja$timezone$BTimeZone;
                            if (clazz == null) {
                                clazz = class$javax$baja$timezone$BTimeZone = BSystemPlatformService.class("[Ljavax.baja.timezone.BTimeZone;", false);
                            }
                            array = new Array(clazz);
                            try {
                                XElem[] xElemArray = XParser.make((InputStream)inputStream).parse().elems("zone");
                                int n = 0;
                                while (n < xElemArray.length) {
                                    array.add((Object)TzXmlDecoder.getTimeZone((XElem)xElemArray[n], (boolean)false));
                                    ++n;
                                }
                                bTimeZone = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_20 = null;
                                try {
                                    inputStream.close();
                                    throw throwable;
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {}
                            catch (IOException iOException) {}
                            inputStream.close();
                        }
                        catch (UnresolvedException unresolvedException2) {}
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
        }
        object = this;
        synchronized (object) {
            this.allTimeZones = new BVector();
            if (array == null) return this.allTimeZones;
            array = array.sort(TimeZoneUtil.TZ_COMPARATOR);
            int n = 0;
            while (n < array.size()) {
                bTimeZone = (BTimeZone)array.get(n);
                this.allTimeZones.add(SlotPath.escape((String)bTimeZone.getId()), (BValue)bTimeZone);
                ++n;
            }
            return this.allTimeZones;
        }
    }

    public String makeRootName(String string) {
        throw new UnsupportedOperationException();
    }

    public long getProcessId() {
        return -1;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"SystemPlatformService", 2);
        spyWriter.prop((Object)"onLocalHost", this.isOnLocalHost());
        spyWriter.prop((Object)"processId", (Object)(this.isProxy() ? "remote" : String.valueOf(this.getProcessId())));
        spyWriter.endProps();
    }

    public String checkForStationFault() {
        return null;
    }

    public void queryResources(ResourceReport resourceReport) {
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.allTimeZones = null;
        this.allowTimeUpdate = true;
        this.timeUpdated = false;
        this.timeZoneUpdated = false;
        this.localeUpdated = false;
        this.allowLocaleUpdate = true;
        this.saveListener = new SaveListener();
        this.stationSaveListenerActive = false;
    }

    public BSystemPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("SystemPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platform$BSystemPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platform$BSystemPlatformService = BSystemPlatformService.class("[Lcom.tridium.platform.BSystemPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"platform.png");
        STATION_OUTPUT_SERVLET = BTypeSpec.make((String)"platform", (String)"StationOutputServlet");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class StationStartupWorker
    extends Thread {
        public void run() {
            if (LocalSessionUtil.localDaemonIsAvailable()) {
                try {
                    try {
                        BSystemPlatformService.this.add("stationOutput", (BValue)Sys.getType((String)"platform:StationOutputServlet").getInstance(), 7);
                    }
                    catch (TypeNotFoundException typeNotFoundException) {}
                    Nre.getPlatform().reportSummaryFields(new String[]{"process"}, new String[]{String.valueOf(BSystemPlatformService.this.getProcessId())});
                    EngineMonitor engineMonitor = new EngineMonitor();
                    Thread thread = new Thread((Runnable)engineMonitor, "Plat:EngineMonitor");
                    thread.start();
                    Station.addSaveListener((Station.SaveListener)BSystemPlatformService.this.saveListener);
                }
                catch (Exception exception) {
                    BPlatform.log.error("Error reporting status to platform daemon", (Throwable)exception);
                }
            } else {
                BPlatform.log.warning("Local daemon session not available, skipping engine monitor initialization");
                Station.addSaveListener((Station.SaveListener)BSystemPlatformService.this.saveListener);
            }
        }

        public StationStartupWorker() {
            super("SystemPlatformService:StationStartupWorker");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RenameShutdownHook
    extends Thread {
        private String oldStationName;
        private String newStationName;

        public void run() {
            BPlatform.log.message("Running Station rename");
            this.finishRename();
        }

        public void finishRename() {
            try {
                BDaemonSession bDaemonSession = LocalSessionUtil.getLocalSession();
                if (bDaemonSession == null) {
                    BPlatform.log.error("No Daemon Session available. Please ensure Station is running from the Platform for Station rename!");
                    return;
                }
                NiagaraPlatformDaemon niagaraPlatformDaemon = NiagaraPlatformDaemon.make(bDaemonSession, DaemonSessionTaskListener.NULL_TASK_LISTENER);
                RemoteStation[] remoteStationArray = niagaraPlatformDaemon.getStationManager().getAllStations();
                int n = 0;
                while (n < remoteStationArray.length) {
                    if (remoteStationArray[n].getName().equals(this.oldStationName)) {
                        BPlatform.log.message("Waiting 10 seconds for lock to clear...");
                        Thread.sleep(10000L);
                        BPlatform.log.message("Renaming Station...");
                        BStationSurrogate bStationSurrogate = BStationSurrogate.make(bDaemonSession, this.oldStationName);
                        try {
                            DaemonFileUtil.transfer(bDaemonSession, FileTransferMessage.makeRename(new FilePath("!stations/" + bStationSurrogate.getStationName()), this.newStationName, bDaemonSession.getFileSpace()), null, null);
                        }
                        catch (Exception exception) {
                            BPlatform.log.error("Cannot rename Station; Station files must be in use by another process", (Throwable)exception);
                            bStationSurrogate.restartStationAsync(true);
                            BPlatform.log.error("Restarting original Station...");
                            return;
                        }
                        bDaemonSession.sendMessage(new UpdateStationMessage());
                        BStationSurrogate bStationSurrogate2 = BStationSurrogate.make(bDaemonSession, this.newStationName);
                        bDaemonSession.sendMessage(new UpdateStationMessage(this.newStationName, false, true, true, true));
                        bStationSurrogate2.startStationAsync();
                        bDaemonSession.sendMessage(new UpdateStationMessage(this.oldStationName, true, false, false, true));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                BPlatform.log.error("Could not commit platform changes for Station rename in Shutdown hook", (Throwable)exception);
            }
            BPlatform.log.message("Station rename complete for " + this.oldStationName + " -> " + this.newStationName);
        }

        public RenameShutdownHook(String string, String string2) {
            super("RenameShutdownHook");
            this.oldStationName = string;
            this.newStationName = string2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SaveListener
    implements Station.SaveListener {
        private Boolean lastSaveSuccessful;

        public void stationSave() {
            if (BSystemPlatformService.this.stationSaveListenerActive) {
                return;
            }
            BSystemPlatformService.this.stationSaveListenerActive = true;
            try {
                BSystemPlatformService.this.savePlatformServiceProperties();
            }
            catch (Exception exception) {
                BPlatform.log.warning("Error occurred in SystemPlatformService::savePlatformServiceProperties() during station save:", (Throwable)exception);
            }
            BSystemPlatformService.this.stationSaveListenerActive = false;
        }

        public void stationSaveOk() {
            if (this.lastSaveSuccessful == null || !this.lastSaveSuccessful.booleanValue()) {
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = BSystemPlatformService.this.getStationSaveAlarmSupport().makeToNormal();
                BSystemPlatformService.this.getStationSaveAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                this.lastSaveSuccessful = Boolean.TRUE;
            }
            if (LocalSessionUtil.localDaemonIsAvailable()) {
                new UpdateJobState("baja:StationSaveJob@" + BSystemPlatformService.this.getStationName(), BJobState.success.getTag() + '@' + Clock.millis()).start();
            }
        }

        public void stationSaveFail(String string) {
            if (this.lastSaveSuccessful == null || this.lastSaveSuccessful.booleanValue()) {
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = BSystemPlatformService.this.getStationSaveAlarmSupport().makeNewOffnormalAlarm();
                BSystemPlatformService.this.getStationSaveAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                this.lastSaveSuccessful = Boolean.FALSE;
            }
            if (LocalSessionUtil.localDaemonIsAvailable()) {
                new UpdateJobState("baja:StationSaveJob@" + BSystemPlatformService.this.getStationName(), BJobState.failed.getTag() + '@' + Clock.millis()).start();
            }
        }

        public String toString() {
            return "SystemPlatformService " + BSystemPlatformService.this.getNavOrd();
        }

        private final /* synthetic */ void this() {
            this.lastSaveSuccessful = null;
        }

        private SaveListener() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EngineMonitor
    implements Runnable {
        public void run() {
            try {
                while (true) {
                    int n;
                    if ((n = BSystemPlatformService.this.getEngineWatchdogTimeout().getSeconds()) == 0) {
                        Thread.sleep(60000L);
                    } else {
                        Thread.sleep(n * 200);
                    }
                    int n2 = Nre.engineManager.getCycles();
                    BSystemPlatformService.this.getPlatformLibrary().updateWatchdog(Sys.getStationHome().getName(), n2, BSystemPlatformService.this.getEngineWatchdogPolicy().getOrdinal(), n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        private EngineMonitor() {
        }
    }

    private static class UpdateJobState
    extends Thread {
        private String requestId;
        private String stateTag;

        public void run() {
            try {
                LocalSessionUtil.getLocalSession().sendMessage(new XmlResponseMessage(){

                    public final String getMessageString() {
                        return "report?requestId=" + HttpUtil.encodeUrl((String)UpdateJobState.this.requestId) + "&state=" + HttpUtil.encodeUrl((String)UpdateJobState.this.stateTag);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public UpdateJobState(String string, String string2) {
            super("SystemPlatformService::UpdateJobState");
            this.requestId = string;
            this.stateTag = string2;
        }
    }
}

