/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.ReportStatusMessage;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.resource.ResourceReport;
import java.io.File;
import java.net.ConnectException;
import javax.baja.data.BIDataValue;
import javax.baja.io.ValueDocDecoder;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BServiceContainer;
import javax.baja.xml.XException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPlatform
extends BObject
implements BIPlatform {
    public static final Type TYPE;
    private static final PlatformTypeResolver typeResolver;
    static final BFacets sysFacets;
    public static Log log;
    private int memoryUsage;
    private int totalMemory;
    private int cpuUsage;
    private BSystemPlatformService sys;
    static /* synthetic */ Class class$com$tridium$platform$BPlatform;
    static /* synthetic */ Class class$com$tridium$platform$BPlatformService;
    static /* synthetic */ Class class$com$tridium$platform$BFilesystemAttributes;

    public Type getType() {
        return TYPE;
    }

    public void initPlatform() throws Exception {
        Object object;
        File file = new File(Sys.getBajaHome(), "lib" + File.separator + "platform.bog");
        if (!file.exists()) {
            object = new File(Sys.getBajaHome(), "lib" + File.separator + "platform.bog.working");
            if (((File)object).exists()) {
                ((File)object).renameTo(file);
            } else {
                throw new BajaRuntimeException("!lib/platform.bog file does not exist, can not load platform");
            }
        }
        if (file.length() == 0L) {
            throw new BajaRuntimeException("!lib/platform.bog file is empty, can not load platform");
        }
        object = new ValueDocDecoder(file);
        object.setTypeResolver((ValueDocDecoder.ITypeResolver)typeResolver);
        BPlatformServiceContainer bPlatformServiceContainer = (BPlatformServiceContainer)object.decodeDocument();
        bPlatformServiceContainer.clearHandles();
        BServiceContainer bServiceContainer = null;
        try {
            bServiceContainer = (BServiceContainer)Sys.getService((Type)BServiceContainer.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            bServiceContainer = new BServiceContainer();
            Sys.getStation().add(null, (BValue)bServiceContainer);
        }
        bServiceContainer.add("PlatformServices", (BValue)bPlatformServiceContainer, 3);
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BPlatformService.TYPE.getTypeInfo());
        Class clazz = class$com$tridium$platform$BPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platform$BPlatformService = BPlatform.class("[Lcom.tridium.platform.BPlatformService;", false);
        }
        BPlatformService[] bPlatformServiceArray = (BPlatformService[])bPlatformServiceContainer.getChildren(clazz);
        int n = 0;
        while (n < typeInfoArray.length) {
            block24: {
                BPlatformService bPlatformService;
                boolean bl = false;
                int n2 = 0;
                while (n2 < bPlatformServiceArray.length) {
                    if (bPlatformServiceArray[n2].getType().getTypeInfo().equals(typeInfoArray[n])) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl && (bPlatformService = (BPlatformService)typeInfoArray[n].getInstance()).isValidPlatform()) {
                    String string = bPlatformService.getLicenseFeature();
                    String string2 = bPlatformService.getLicenseVendor();
                    if (string != null) {
                        try {
                            Sys.getLicenseManager().checkFeature(string2, string);
                        }
                        catch (FeatureNotLicensedException featureNotLicensedException) {
                            if (BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx)) {
                                log.warning("Platform Service " + (Object)((Object)bPlatformService) + " will not be added, feature \"" + string + "\" is not licensed");
                            }
                            break block24;
                        }
                        catch (LicenseDatabaseException licenseDatabaseException) {
                            break block24;
                        }
                    }
                    bPlatformServiceContainer.add(typeInfoArray[n].getTypeName(), (BValue)bPlatformService, bPlatformService.getSlotFlags());
                }
            }
            ++n;
        }
        Class clazz2 = class$com$tridium$platform$BPlatformService;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platform$BPlatformService = BPlatform.class("[Lcom.tridium.platform.BPlatformService;", false);
        }
        bPlatformServiceArray = (BPlatformService[])bPlatformServiceContainer.getChildren(clazz2);
        try {
            BModule bModule = Sys.loadModule((String)"platJennic");
            Class clazz3 = bModule.loadClass("com.tridium.platJennic.BJennicPlatformService");
            int n3 = 0;
            while (n3 < bPlatformServiceArray.length) {
                if (bPlatformServiceArray[n3] != null && clazz3.isInstance((Object)bPlatformServiceArray[n3])) {
                    log.warning("Removing platform service " + (Object)((Object)bPlatformServiceArray[n3]) + ", service is obsolete");
                    bPlatformServiceContainer.remove((BComplex)bPlatformServiceArray[n3]);
                    bPlatformServiceArray[n3] = null;
                }
                ++n3;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ModuleNotFoundException moduleNotFoundException) {}
        int n4 = 0;
        while (n4 < bPlatformServiceArray.length) {
            if (bPlatformServiceArray[n4] != null) {
                bPlatformServiceArray[n4].fw(1001, bServiceContainer, null, null, null);
            }
            ++n4;
        }
        this.sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
    }

    public BSystemPlatformService sys() {
        if (this.sys == null || this.sys.getParent() == null) {
            this.sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        }
        return this.sys;
    }

    public void stationStarted() {
        BPlatformServiceContainer bPlatformServiceContainer = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        Class clazz = class$com$tridium$platform$BPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platform$BPlatformService = BPlatform.class("[Lcom.tridium.platform.BPlatformService;", false);
        }
        BPlatformService[] bPlatformServiceArray = (BPlatformService[])bPlatformServiceContainer.getChildren(clazz);
        int n = 0;
        while (n < bPlatformServiceArray.length) {
            Property property;
            try {
                bPlatformServiceArray[n].doStationStarted(Sys.getStation());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (bPlatformServiceArray[n] instanceof BTcpIpPlatformService) {
                property = bPlatformServiceArray[n].getPropertyInParent();
                bPlatformServiceContainer.setFlags((Slot)property, bPlatformServiceContainer.getFlags((Slot)property) & 0xFFFFFFFB);
            } else if (bPlatformServiceArray[n] instanceof BSystemPlatformService) {
                property = bPlatformServiceArray[n].getPropertyInParent();
                bPlatformServiceContainer.setFlags((Slot)property, bPlatformServiceContainer.getFlags((Slot)property) & 0xFFFFFFFB);
            }
            ++n;
        }
    }

    public boolean isFlashFileSystem() {
        try {
            BSystemPlatformService bSystemPlatformService = this.sys();
            bSystemPlatformService.checkPropertiesLoaded();
            BVector bVector = bSystemPlatformService.getFilesystemAttributes();
            Class clazz = class$com$tridium$platform$BFilesystemAttributes;
            if (clazz == null) {
                clazz = class$com$tridium$platform$BFilesystemAttributes = BPlatform.class("[Lcom.tridium.platform.BFilesystemAttributes;", false);
            }
            BFilesystemAttributes[] bFilesystemAttributesArray = (BFilesystemAttributes[])bVector.getChildren(clazz);
            return bFilesystemAttributesArray[0].getIsFlash();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return false;
        }
    }

    public boolean isFlashFileSystem(String string) {
        try {
            BSystemPlatformService bSystemPlatformService = this.sys();
            bSystemPlatformService.checkPropertiesLoaded();
            BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)bSystemPlatformService.getFilesystemAttributes().get(SlotPath.escape((String)string));
            if (bFilesystemAttributes == null) {
                throw new BajaRuntimeException(string + " filesystem does not exist");
            }
            return bFilesystemAttributes.getIsFlash();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return false;
        }
    }

    public boolean isStationAutoSaveEnabled() {
        try {
            BSystemPlatformService bSystemPlatformService = this.sys();
            return bSystemPlatformService.getIsStationAutoSaveEnabled();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return true;
        }
    }

    public long getStationAutoSaveFrequency() {
        try {
            BSystemPlatformService bSystemPlatformService = this.sys();
            return bSystemPlatformService.getStationAutoSaveFrequency().getMillis();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return 3600000L;
        }
    }

    public int getStationSaveBackupCount() {
        try {
            BSystemPlatformService bSystemPlatformService = this.sys();
            return bSystemPlatformService.getStationSaveBackupCount();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return 3;
        }
    }

    public void poll() {
        try {
            BSystemPlatformService bSystemPlatformService = this.sys();
            bSystemPlatformService.checkPropertiesLoaded();
            bSystemPlatformService.invoke(BSystemPlatformService.poll, null, (Context)sysFacets);
            int n = bSystemPlatformService.getCurrentCpuUsage();
            this.cpuUsage = n < 0 ? 0 : n / bSystemPlatformService.getNumCpus();
            int n2 = bSystemPlatformService.getTotalPhysicalMemory();
            if (n2 > 0) {
                this.totalMemory = n2;
                int n3 = bSystemPlatformService.getFreePhysicalMemory();
                this.memoryUsage = n3 >= 0 ? n2 - n3 : 0;
            } else {
                this.totalMemory = 0;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.memoryUsage = 0;
            this.totalMemory = 0;
            this.cpuUsage = 0;
        }
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public int getTotalMemory() {
        return this.totalMemory;
    }

    public int getCpuUsage() {
        return this.cpuUsage;
    }

    public String checkForStationFault() {
        String string;
        BSystemPlatformService bSystemPlatformService = this.sys();
        String string2 = bSystemPlatformService.checkForStationFault();
        if (string2 != null) {
            return string2;
        }
        if (Nre.serviceManager.getActiveDataRecoveryService() != null && (string = Nre.serviceManager.getActiveDataRecoveryService().checkForStationFault()) != null) {
            return string;
        }
        return null;
    }

    public void queryResources(ResourceReport resourceReport) {
        this.sys.queryResources(resourceReport);
    }

    public void reportSummaryFields(String[] stringArray, String[] stringArray2) {
        if (LocalSessionUtil.localDaemonIsAvailable()) {
            try {
                LocalSessionUtil.getLocalSession().sendMessage(new ReportStatusMessage(stringArray, stringArray2));
            }
            catch (ConnectException connectException) {
            }
            catch (AuthenticationException authenticationException) {}
        }
    }

    public void resetLocalDaemonSession() {
        LocalSessionUtil.resetLocalSession();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.memoryUsage = 0;
        this.totalMemory = 0;
        this.cpuUsage = 0;
    }

    public BPlatform() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platform$BPlatform;
        if (clazz == null) {
            clazz = class$com$tridium$platform$BPlatform = BPlatform.class("[Lcom.tridium.platform.BPlatform;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        typeResolver = new PlatformTypeResolver();
        sysFacets = BFacets.make((String[])new String[]{"resourceOnly"}, (BIDataValue[])new BBoolean[]{BBoolean.TRUE});
        log = Log.getLog((String)"platform");
    }

    private static final class PlatformTypeResolver
    extends ValueDocDecoder.BogTypeResolver {
        public final BModule loadModule(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, String string2, String string3) {
            try {
                int n = string2.indexOf(61);
                String string4 = string2.substring(0, n).trim();
                String string5 = string2.substring(n + 1).trim();
                if (string2.equals("platJennic=platJennic")) {
                    log.warning("Ignoring platJennic based type '" + string3 + "' in platform.bog.");
                    return null;
                }
                NModule nModule = Nre.moduleManager.loadModule(string5);
                this.getModuleMap(valueDocDecoder).put(string4, nModule);
                return nModule.bmodule();
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                log.warning("Ignoring platform service '" + string3 + "' in platform.bog, required module not found!");
                return null;
            }
            catch (Exception exception) {
                throw new XException("Invalid module attribute '" + string2 + '\'');
            }
        }

        public final BValue newInstance(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, Property property, String string2) {
            if (string2 == null) {
                if (property != null) {
                    return property.getDefaultValue();
                }
                log.warning("Missing frozen property: " + string);
                return null;
            }
            try {
                int n = string2.indexOf(58);
                if (n <= 0) {
                    log.warning("Invalid typespec '" + string2 + '\'');
                    return null;
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                NModule nModule = (NModule)this.getModuleMap(valueDocDecoder).get(string3);
                if (nModule == null) {
                    return null;
                }
                Type type = nModule.getType(string4);
                return (BValue)type.getInstance();
            }
            catch (XException xException) {
                throw xException;
            }
            catch (TypeNotFoundException typeNotFoundException) {
                log.warning("Type \"" + typeNotFoundException.getMessage() + "\" not found: " + string);
                return null;
            }
            catch (Throwable throwable) {
                log.warning("Cannot instantiate type '" + string2 + '\'', throwable);
                return null;
            }
        }

        private PlatformTypeResolver() {
        }
    }
}

