/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install.part;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.ClassCondenser;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.ModuleManifest;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.sys.registry.NModuleInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.SlotPath;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModulePart
extends BPart {
    public static final Property status = BModulePart.newProperty((int)1, (BValue)BModuleStatus.ok, null);
    public static final Property buildDate = BModulePart.newProperty((int)1, (String)"", null);
    public static final Property buildAbsTime = BModulePart.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property buildHost = BModulePart.newProperty((int)1, (String)"", null);
    public static final Property archiveDate = BModulePart.newProperty((int)1, (String)"", null);
    public static final Property archiveHost = BModulePart.newProperty((int)1, (String)"", null);
    public static final Property archiveContent = BModulePart.newProperty((int)1, (BValue)BModuleContent.doc, null);
    public static final Property preferredSymbol = BModulePart.newProperty((int)1, (String)"", null);
    public static final Property fileSize = BModulePart.newProperty((int)1, (int)-1, null);
    public static final Property synthetic = BModulePart.newProperty((int)1, (boolean)false, null);
    public static final Property exclusions = BModulePart.newProperty((int)1, (BValue)new BVector(), null);
    public static final Property isNre = BModulePart.newProperty((int)1, (boolean)true, null);
    public static final Property isInstallable = BModulePart.newProperty((int)1, (boolean)true, null);
    public static final Type TYPE;
    public static final FilePath MODULES_PATH;
    public static final FilePath LIB_PATH;
    private static final BIcon icon;
    private BIFile file;
    private boolean localInstance;
    private boolean summaryInitialized;
    private boolean dependsInitialized;
    private ModuleManifest manifest;
    static /* synthetic */ Class class$com$tridium$install$part$BModulePart;

    public BModuleStatus getStatus() {
        return (BModuleStatus)this.get(status);
    }

    public void setStatus(BModuleStatus bModuleStatus) {
        this.set(status, (BValue)bModuleStatus, null);
    }

    public String getBuildDate() {
        return this.getString(buildDate);
    }

    public void setBuildDate(String string) {
        this.setString(buildDate, string, null);
    }

    public BAbsTime getBuildAbsTime() {
        return (BAbsTime)this.get(buildAbsTime);
    }

    public void setBuildAbsTime(BAbsTime bAbsTime) {
        this.set(buildAbsTime, (BValue)bAbsTime, null);
    }

    public String getBuildHost() {
        return this.getString(buildHost);
    }

    public void setBuildHost(String string) {
        this.setString(buildHost, string, null);
    }

    public String getArchiveDate() {
        return this.getString(archiveDate);
    }

    public void setArchiveDate(String string) {
        this.setString(archiveDate, string, null);
    }

    public String getArchiveHost() {
        return this.getString(archiveHost);
    }

    public void setArchiveHost(String string) {
        this.setString(archiveHost, string, null);
    }

    public BModuleContent getArchiveContent() {
        return (BModuleContent)this.get(archiveContent);
    }

    public void setArchiveContent(BModuleContent bModuleContent) {
        this.set(archiveContent, (BValue)bModuleContent, null);
    }

    public String getPreferredSymbol() {
        return this.getString(preferredSymbol);
    }

    public void setPreferredSymbol(String string) {
        this.setString(preferredSymbol, string, null);
    }

    public long getFileSize() {
        return this.getLong(fileSize);
    }

    public void setFileSize(long l) {
        this.setLong(fileSize, l, null);
    }

    public boolean getSynthetic() {
        return this.getBoolean(synthetic);
    }

    public void setSynthetic(boolean bl) {
        this.setBoolean(synthetic, bl, null);
    }

    public BVector getExclusions() {
        return (BVector)this.get(exclusions);
    }

    public void setExclusions(BVector bVector) {
        this.set(exclusions, (BValue)bVector, null);
    }

    public boolean getIsNre() {
        return this.getBoolean(isNre);
    }

    public void setIsNre(boolean bl) {
        this.setBoolean(isNre, bl, null);
    }

    public boolean getIsInstallable() {
        return this.getBoolean(isInstallable);
    }

    public void setIsInstallable(boolean bl) {
        this.setBoolean(isInstallable, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BModulePart make(BIFile bIFile) {
        BModuleInstallable bModuleInstallable = BModuleInstallable.make(bIFile, true);
        return bModuleInstallable == null ? null : bModuleInstallable.getModulePart();
    }

    public static BModulePart make(BIFile bIFile, boolean bl) {
        BModuleInstallable bModuleInstallable = BModuleInstallable.make(bIFile, bl);
        return bModuleInstallable == null ? null : bModuleInstallable.getModulePart();
    }

    public static BModulePart make(String string, XElem xElem) {
        if (string == null) {
            return null;
        }
        BModulePart bModulePart = new BModulePart();
        bModulePart.setPartName(string);
        if (xElem == null) {
            bModulePart.setStatus(BModuleStatus.nomanifest);
        } else {
            bModulePart.loadManifest(xElem);
        }
        return bModulePart;
    }

    public static BModulePart make(BIFile bIFile, BInstallable bInstallable) {
        try {
            InputStream inputStream = DaemonFileUtil.getZipStream(bIFile, new FilePath("META-INF/module.xml"));
            if (inputStream == null) {
                inputStream = DaemonFileUtil.getZipStream(bIFile, new FilePath("meta-inf/module.xml"));
            }
            if (inputStream == null) {
                inputStream = DaemonFileUtil.getZipStream(bIFile, new FilePath("META-INF/module.xml"));
            }
            if (inputStream == null) {
                return null;
            }
            return new BModulePart(bIFile, inputStream, bInstallable);
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "ModulePart.exception.manifestRead", new Object[]{bIFile.getFilePath()}, (Throwable)iOException);
        }
    }

    public boolean meets(BDependency bDependency) {
        this.initSummary();
        boolean bl = false;
        if (bDependency.getPartType().is(TYPE) && this.getVersion().meets(bDependency) && this.matchesName(bDependency.getPartName())) {
            bl = true;
        }
        return bl;
    }

    public boolean isInstallable() {
        return true;
    }

    public BVector getDependencies() {
        if (!this.dependsInitialized) {
            this.init();
        }
        return super.getDependencies();
    }

    public void initSummary() {
        if (!this.summaryInitialized) {
            this.init();
        }
    }

    public void init() {
        if (this.manifest != null || !this.localInstance || !this.getInstallable().getIsValid()) {
            return;
        }
        if (this.file != null) {
            try {
                InputStream inputStream = DaemonFileUtil.getZipStream(this.file, new FilePath("META-INF/module.xml"));
                if (inputStream == null) {
                    inputStream = DaemonFileUtil.getZipStream(this.file, new FilePath("meta-inf/module.xml"));
                }
                if (inputStream == null) {
                    inputStream = DaemonFileUtil.getZipStream(this.file, new FilePath("META-INF/module.xml"));
                }
                this.loadManifest(inputStream);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public BDependency getDependency(String string) {
        return (BDependency)this.getDependencies().get(SlotPath.escape((String)string));
    }

    public FilePath getDestinationPath() {
        if (!this.getSynthetic()) {
            return MODULES_PATH.merge(this.getPartName() + ".jar");
        }
        return MODULES_PATH.merge(this.getPartName() + ".sjar");
    }

    public BIcon getIcon() {
        return icon;
    }

    public InputStream getInputStream() {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        try {
            return this.file.getInputStream();
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "LocalModulePart.exception.notFound", new Object[]{this.file.getFilePath()}, (Throwable)iOException);
        }
    }

    public ModuleManifest getManifest() {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        this.init();
        return this.manifest;
    }

    public BVersion getVersionRequired(String string) {
        BDependency bDependency = this.getDependency(string);
        return bDependency == null ? BVersion.ZERO : bDependency.getVersion();
    }

    public Set getRequiredModuleNames() {
        Property[] propertyArray = this.getDependencies().getPropertiesArray();
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n < propertyArray.length) {
            hashSet.add(propertyArray[n].getName());
            ++n;
        }
        return hashSet;
    }

    public boolean isUpgradeFor(BModulePart bModulePart) {
        this.initSummary();
        if (bModulePart.getVersion().meetsVersionRequirement(this.getVersion(), BVersionRelation.minimum)) {
            return bModulePart.getBuildAbsTime() != null && this.getBuildAbsTime() != null && this.getBuildAbsTime().compareTo((Object)bModulePart.getBuildAbsTime()) > 0;
        }
        return true;
    }

    public boolean isUpdateFor(BModulePart bModulePart) {
        return this.isUpdateFor(bModulePart, null);
    }

    public boolean isUpdateFor(BModulePart bModulePart, BDaemonPlatform bDaemonPlatform) {
        this.initSummary();
        if (bDaemonPlatform != null && bDaemonPlatform.getModuleContent() != bModulePart.getArchiveContent()) {
            return true;
        }
        if (bModulePart.getVersion().equivalent((Object)this.getVersion())) {
            return bModulePart.getBuildAbsTime() == null || this.getBuildAbsTime() == null || !this.getBuildAbsTime().equals((Object)bModulePart.getBuildAbsTime());
        }
        return true;
    }

    public String toString(Context context) {
        return "Module: " + this.getPartName() + ' ' + (Object)((Object)this.getVersion());
    }

    public void writePackageArchive(BDaemonPlatform bDaemonPlatform, ZipOutputStream zipOutputStream) throws Exception {
        this.writePackageArchive(bDaemonPlatform.getModuleContent(), bDaemonPlatform.getStripLineNumbers(), zipOutputStream);
    }

    public void writePackageArchive(BModuleContent bModuleContent, boolean bl, ZipOutputStream zipOutputStream) throws Exception {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        this.init();
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(this.getInputStream());
            ClassCondenser classCondenser = new ClassCondenser();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                if (zipEntry.getName().equalsIgnoreCase("meta-inf/module.xml")) {
                    object = new ByteArrayOutputStream();
                    this.getManifest().write(bModuleContent, (OutputStream)object);
                    ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                    zipEntry2.setSize(((ByteArrayOutputStream)object).size());
                    zipEntry2.setTime(System.currentTimeMillis());
                    zipOutputStream.putNextEntry(zipEntry2);
                    zipOutputStream.write(((ByteArrayOutputStream)object).toByteArray(), 0, ((ByteArrayOutputStream)object).size());
                    zipOutputStream.closeEntry();
                    continue;
                }
                if (!this.getManifest().includePath(this.getDirectoryName(zipEntry), bModuleContent)) continue;
                if (bl && zipEntry.getName().endsWith(".class")) {
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    classCondenser.condense(zipInputStream, zipOutputStream, false);
                } else {
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry));
                    object = new byte[65000];
                    int n = zipInputStream.read((byte[])object);
                    while (n >= 0) {
                        zipOutputStream.write((byte[])object, 0, n);
                        n = zipInputStream.read((byte[])object);
                    }
                }
                zipOutputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "ModulePart.exception.writePackageArchive", new Object[]{this.getPartName()}, (Throwable)iOException);
        }
    }

    private final void loadManifest(XElem xElem) {
        this.loadManifest(ModuleManifest.make(xElem));
    }

    private final void loadManifest(InputStream inputStream) {
        this.loadManifest(inputStream, true);
    }

    private final void loadManifest(InputStream inputStream, boolean bl) {
        this.loadManifest(ModuleManifest.make(inputStream, bl));
    }

    private final void loadManifest(ModuleManifest moduleManifest) {
        this.manifest = moduleManifest;
        this.setStatus(moduleManifest.getStatus());
        if (!this.summaryInitialized) {
            this.setPartName(moduleManifest.getName());
            this.setBuildAbsTime(moduleManifest.getBuildAbsTime());
            this.setVersion((BVersion)moduleManifest.getVersion().newCopy());
            this.setDescription(moduleManifest.getDescription());
            this.setArchiveContent(moduleManifest.getModuleContent());
            this.summaryInitialized = true;
        }
        if (!this.dependsInitialized) {
            BVector bVector = (BVector)this.get(dependencies);
            bVector.removeAll();
            BDependency[] bDependencyArray = moduleManifest.getDependencies();
            int n = 0;
            while (n < bDependencyArray.length) {
                bVector.add(SlotPath.escape((String)bDependencyArray[n].getPartName()), bDependencyArray[n].newCopy());
                ++n;
            }
            BDependency[] bDependencyArray2 = moduleManifest.getExclusions();
            bVector = (BVector)this.get(exclusions);
            bVector.removeAll();
            int n2 = 0;
            while (n2 < bDependencyArray2.length) {
                bVector.add("excl?", (BValue)bDependencyArray2[n2]);
                ++n2;
            }
            this.dependsInitialized = true;
        }
        this.setBuildDate(moduleManifest.getBuildDate());
        this.setBuildHost(moduleManifest.getBuildHost());
        this.setArchiveDate(moduleManifest.getArchiveDate());
        this.setArchiveHost(moduleManifest.getArchiveHost());
        this.setPreferredSymbol(moduleManifest.getPreferredSymbol());
        this.setIsNre(moduleManifest.isNreModule());
        this.setIsInstallable(moduleManifest.isInstallable());
    }

    private final String getDirectoryName(ZipEntry zipEntry) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModulePart");
        }
        if (zipEntry.isDirectory()) {
            return zipEntry.getName();
        }
        int n = zipEntry.getName().lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return zipEntry.getName().substring(0, n);
    }

    public long getFilteredFileSize(BDaemonPlatform bDaemonPlatform) {
        return this.getFilteredFileSize(bDaemonPlatform.getModuleContent(), bDaemonPlatform.getStripLineNumbers());
    }

    public long getFilteredFileSize(BModuleContent bModuleContent, boolean bl) {
        if (this.localInstance && bModuleContent != BModuleContent.doc) {
            try {
                ByteCounter byteCounter = new ByteCounter();
                ZipOutputStream zipOutputStream = new ZipOutputStream(byteCounter);
                this.writePackageArchive(bModuleContent, bl, zipOutputStream);
                zipOutputStream.closeEntry();
                zipOutputStream.flush();
                zipOutputStream.close();
                byteCounter.flush();
                byteCounter.close();
                return byteCounter.size();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.getInstallable().getInstallableFileSize();
    }

    public boolean canMakeTransferElements() {
        return this.localInstance;
    }

    public FileTransferMessageElement makeTransferElement(BDaemonPlatform bDaemonPlatform) {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BModuleInstallable");
        }
        return new ModuleFileTransferElement(this, bDaemonPlatform.getDaemonSession());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.file = null;
        this.localInstance = false;
        this.summaryInitialized = false;
        this.dependsInitialized = false;
        this.manifest = null;
    }

    public BModulePart() {
        this.this();
    }

    public BModulePart(BIFile bIFile, NModuleInfo nModuleInfo, BInstallable bInstallable) {
        this.this();
        this.file = bIFile;
        this.localInstance = true;
        this.setInstallable(bInstallable);
        this.setStatus(BModuleStatus.ok);
        this.setFileSize(bIFile.getSize());
        this.setPartName(nModuleInfo.getModuleName());
        this.setBuildAbsTime(BAbsTime.make((long)nModuleInfo.getBuildTime()));
        this.getVersion().setVendor(nModuleInfo.getVendor());
        this.getVersion().setVendorVersion(nModuleInfo.getVendorVersion());
        this.setDescription(nModuleInfo.getDescription());
        this.setArchiveContent(BModuleContent.make(nModuleInfo.getModuleContent()));
        this.setSynthetic(bIFile.getExtension().equals("sjar"));
        this.summaryInitialized = true;
    }

    public BModulePart(BIFile bIFile, InputStream inputStream, BInstallable bInstallable) {
        this(bIFile, inputStream, bInstallable, true);
    }

    public BModulePart(BIFile bIFile, InputStream inputStream, BInstallable bInstallable, boolean bl) {
        this.this();
        this.file = bIFile;
        this.localInstance = true;
        this.setInstallable(bInstallable);
        if (inputStream == null) {
            this.setStatus(BModuleStatus.nomanifest);
            if (bInstallable != null) {
                bInstallable.setIsValid(false);
            }
        } else {
            this.setStatus(BModuleStatus.ok);
        }
        this.setFileSize(bIFile.getSize());
        if (bIFile.getExtension().equals("jar")) {
            this.setPartName(bIFile.getFileName().substring(0, bIFile.getFileName().length() - 4));
        } else if (bIFile.getExtension().equals("sjar")) {
            this.setPartName(bIFile.getFileName().substring(0, bIFile.getFileName().length() - 5));
            this.setSynthetic(true);
        }
        if (inputStream != null) {
            this.loadManifest(inputStream, bl);
        }
    }

    static {
        Class clazz = class$com$tridium$install$part$BModulePart;
        if (clazz == null) {
            clazz = class$com$tridium$install$part$BModulePart = BModulePart.class("[Lcom.tridium.install.part.BModulePart;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        MODULES_PATH = new FilePath("!modules");
        LIB_PATH = new FilePath("!lib");
        icon = BPart.getPartTypeIcon(TYPE);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ByteCounter
    extends OutputStream {
        private long size;

        public void write(byte[] byArray) throws IOException {
            this.size += (long)byArray.length;
        }

        public void write(byte[] byArray, int n, int n2) {
            this.size += (long)n2;
        }

        public void write(int n) {
            ++this.size;
        }

        public long size() {
            return this.size;
        }

        private final /* synthetic */ void this() {
            this.size = 0L;
        }

        private ByteCounter() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ModuleFileTransferElement
    extends FileTransferMessageElement {
        private static final BIcon icon = BIcon.std((String)"module.png");
        private BModulePart sourceModule;
        private BDaemonSession session;
        private byte[] buf;

        public InputStream getStream() throws IOException {
            try {
                if (this.modifyContents()) {
                    byte[] byArray = this.getModifiedBuf();
                    if ("true".equals(System.getProperty("niagara.install.copyProcessedModule", "false"))) {
                        BIFile bIFile = BFileSystem.INSTANCE.makeFile(new FilePath("!moduleCopies/" + this.sourceModule.getDestinationPath().getName()));
                        FileUtil.pipe((InputStream)new ByteArrayInputStream(byArray), (OutputStream)bIFile.getOutputStream());
                    }
                    return new ByteArrayInputStream(byArray);
                }
                return this.sourceModule.getInputStream();
            }
            catch (Exception exception) {
                throw new LocalizableRuntimeException("platform", "ModuleFileTransferElement.exception.read", (Throwable)exception);
            }
        }

        public long getSize() {
            if (this.modifyContents()) {
                return this.getModifiedBuf().length;
            }
            return this.sourceModule.getFileSize();
        }

        private final BDaemonPlatform getDaemonPlatform() {
            try {
                return BRemoteDaemonPlatform.make(this.session, null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        private final boolean modifyContents() {
            boolean bl = false;
            if (this.getDaemonPlatform().getModuleContent() != BModuleContent.doc) {
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final byte[] getModifiedBuf() {
            if (this.buf != null) return this.buf;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            try {
                try {
                    this.sourceModule.writePackageArchive(this.getDaemonPlatform(), zipOutputStream);
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    zipOutputStream.closeEntry();
                    zipOutputStream.flush();
                    zipOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var4_5 = null;
            }
            try {}
            catch (Exception exception) {}
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            zipOutputStream.close();
            this.buf = byteArrayOutputStream.toByteArray();
            return this.buf;
        }

        public BIcon getIcon() {
            return icon;
        }

        private final /* synthetic */ void this() {
            this.buf = null;
        }

        public ModuleFileTransferElement(BModulePart bModulePart, BDaemonSession bDaemonSession) {
            super(bModulePart.getDestinationPath(), bDaemonSession.getFileSpace());
            this.this();
            this.sourceModule = bModulePart;
            this.session = bDaemonSession;
        }
    }
}

