/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.IFilter;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

public class FilenameFilterUtil {
    public static final Lexicon lex = Lexicon.make((String)"platform");
    public static final IFilter NULL_FILTER = new NullFilenameFilter();

    public static IFilter make(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            if (string2 == null || string2.trim().length() == 0) {
                return NULL_FILTER;
            }
            return FilenameFilterUtil.makeExclude(string2);
        }
        if (string2 == null || string2.trim().length() == 0) {
            return FilenameFilterUtil.makeInclude(string);
        }
        return FilenameFilterUtil.makeAnd(new IFilter[]{FilenameFilterUtil.makeInclude(string), FilenameFilterUtil.makeExclude(string2)});
    }

    public static IFilter makeExclude(String string) {
        return FilenameFilterUtil.makeExclude((IFilter[])PatternFilter.parseList((String)string));
    }

    public static IFilter makeExclude(String string, String string2) {
        return FilenameFilterUtil.makeExclude((IFilter[])PatternFilter.parseList((String)string, (String)string2));
    }

    private static final IFilter makeExclude(IFilter[] iFilterArray) {
        if (iFilterArray.length == 0) {
            return NULL_FILTER;
        }
        IFilter[] iFilterArray2 = new IFilter[iFilterArray.length];
        int n = 0;
        while (n < iFilterArray2.length) {
            iFilterArray2[n] = FilenameFilterUtil.makeInverse(iFilterArray[n]);
            ++n;
        }
        return FilenameFilterUtil.makeAnd(iFilterArray2);
    }

    public static IFilter makeInclude(String string) {
        return FilenameFilterUtil.makeOr((IFilter[])PatternFilter.parseList((String)string));
    }

    public static IFilter makeInclude(String string, String string2) {
        return FilenameFilterUtil.makeOr((IFilter[])PatternFilter.parseList((String)string, (String)string2));
    }

    public static IFilter makeInverse(IFilter iFilter) {
        return new NotFilenameFilter(iFilter);
    }

    public static IFilter makeOr(IFilter[] iFilterArray) {
        if (iFilterArray.length == 0) {
            return NULL_FILTER;
        }
        return new OrFilenameFilter(iFilterArray);
    }

    public static IFilter makeAnd(IFilter[] iFilterArray) {
        if (iFilterArray.length == 0) {
            return NULL_FILTER;
        }
        return new AndFilenameFilter(iFilterArray);
    }

    private static final String getFilename(Object object) {
        if (object instanceof BIFile) {
            return ((BIFile)object).getFileName();
        }
        if (object instanceof FilePath) {
            return ((FilePath)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException("unrecognized file object");
    }

    public static class NotFilenameFilter
    implements IFilter {
        private IFilter invert;

        public boolean accept(Object object) {
            return this.invert.accept((Object)FilenameFilterUtil.getFilename(object)) ^ true;
        }

        public NotFilenameFilter(IFilter iFilter) {
            this.invert = iFilter;
        }
    }

    public static class OrFilenameFilter
    implements IFilter {
        private IFilter[] filters;

        public boolean accept(Object object) {
            int n = 0;
            while (n < this.filters.length) {
                if (this.filters[n].accept((Object)FilenameFilterUtil.getFilename(object))) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public OrFilenameFilter(IFilter[] iFilterArray) {
            if (iFilterArray == null || iFilterArray.length == 0) {
                throw new IllegalArgumentException();
            }
            this.filters = iFilterArray;
        }
    }

    public static class AndFilenameFilter
    implements IFilter {
        private IFilter[] filters;

        public boolean accept(Object object) {
            int n = 0;
            while (n < this.filters.length) {
                if (!this.filters[n].accept((Object)FilenameFilterUtil.getFilename(object))) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public AndFilenameFilter(IFilter[] iFilterArray) {
            if (iFilterArray == null || iFilterArray.length == 0) {
                throw new IllegalArgumentException();
            }
            this.filters = iFilterArray;
        }
    }

    private static class NullFilenameFilter
    implements IFilter {
        public boolean accept(Object object) {
            return true;
        }

        private NullFilenameFilter() {
        }
    }
}

