/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.InstallScenario;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DependencyUtil {
    private static final TreeSet ALL_WEB_UI_MODULES = new TreeSet();
    private static int ANALYSIS_REQ_STATION;
    private static int ANALYSIS_REQ_PLATFORM;
    private static int ANALYSIS_DEP_MISSING;
    private static int ANALYSIS_DEP_UNAVAILABLE;
    private static int ANALYSIS_DEP_UNSOLVABLE;

    public static BDependency[] getPlatformDependencies(BDaemonPlatform bDaemonPlatform) throws ConnectException, AuthenticationException {
        return DependencyUtil.getPlatformDependencies(bDaemonPlatform, bDaemonPlatform.getModuleContent());
    }

    public static BDependency[] getPlatformDependencies(BDaemonPlatform bDaemonPlatform, BModuleContent bModuleContent) throws ConnectException, AuthenticationException {
        return DependencyUtil.getModuleDeps(DependencyUtil.accumPlatformDeps(DependencyUtil.getWebUiModules(bDaemonPlatform, bModuleContent), bDaemonPlatform));
    }

    public static BDependency[] getStationDependencies(BDaemonPlatform bDaemonPlatform, FilePath filePath) throws ConnectException, AuthenticationException {
        return DependencyUtil.getStationDependencies(bDaemonPlatform, filePath, bDaemonPlatform.getModuleContent());
    }

    public static BDependency[] getStationDependencies(BDaemonPlatform bDaemonPlatform, FilePath filePath, BModuleContent bModuleContent) throws ConnectException, AuthenticationException {
        try {
            BDaemonFileStore bDaemonFileStore = new BDaemonFileStore(bDaemonPlatform.getDaemonSession().getFileSpace(), filePath.merge("config.bog"));
            InputStream inputStream = bDaemonFileStore.getInputStream();
            Set set = DependencyUtil.accumBogModuleDeps(DependencyUtil.getWebUiModules(bDaemonPlatform, bModuleContent), inputStream, "platform", "DependencyUtil.parseConfigBog");
            DependencyUtil.accumPlatformDeps(set, bDaemonPlatform);
            return DependencyUtil.getModuleDeps(set);
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "DependencyUtil.parseConfigBog", (Throwable)iOException);
        }
    }

    public static BDependency[] getStationDependencies(BDaemonPlatform bDaemonPlatform, BDirectory bDirectory) throws ConnectException, AuthenticationException {
        try {
            Object object;
            InputStream inputStream;
            if (bDirectory == null) {
                inputStream = null;
            } else if (bDirectory.getStore() instanceof BDaemonDirectoryStore) {
                object = new BDaemonFileStore(bDaemonPlatform.getDaemonSession().getFileSpace(), bDirectory.getFilePath().merge("config.bog"));
                inputStream = ((BDaemonFileStore)((Object)object)).getInputStream();
            } else {
                object = (BIFile)bDirectory.getNavChild("config.bog");
                inputStream = object == null ? null : object.getInputStream();
            }
            object = DependencyUtil.accumBogModuleDeps(null, inputStream, "platform", "DependencyUtil.parseConfigBog");
            DependencyUtil.accumPlatformDeps((Set)object, bDaemonPlatform);
            return DependencyUtil.getModuleDeps((Set)object);
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "DependencyUtil.parseConfigBog", (Throwable)iOException);
        }
    }

    public static BDependency[] getPlatformModuleDependencies(BDaemonPlatform bDaemonPlatform, BDistribution bDistribution) throws ConnectException {
        XElem xElem = bDistribution.getUpdatedPlatformBog(bDaemonPlatform);
        return xElem == null ? null : DependencyUtil.getBogModuleDeps(xElem);
    }

    private static final Set getWebUiModules(BDaemonPlatform bDaemonPlatform, BModuleContent bModuleContent) {
        if (bModuleContent == null) {
            bModuleContent = bDaemonPlatform.getModuleContent();
        }
        return bModuleContent == BModuleContent.runtime ? new TreeSet() : (Set)ALL_WEB_UI_MODULES.clone();
    }

    public static BDependency[] getBogModuleDeps(XElem xElem) {
        TreeSet treeSet = new TreeSet();
        DependencyUtil.accumBogModuleNames(treeSet, xElem);
        return DependencyUtil.getModuleDeps(treeSet);
    }

    private static final BDependency[] getModuleDeps(Set set) {
        BDependency[] bDependencyArray = new BDependency[set.size()];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            bDependencyArray[n] = BDependency.forModule((String)iterator.next());
            ++n;
        }
        return bDependencyArray;
    }

    private static final Set accumBogModuleNames(Set set, XElem xElem) {
        int n;
        Object object;
        Set set2;
        Set set3 = set2 = set == null ? new TreeSet() : set;
        if (xElem == null) {
            return set2;
        }
        if (xElem.name().equals("p") && (object = xElem.get("m", null)) != null) {
            n = ((String)object).indexOf(61);
            Object object2 = n < 0 ? object : ((String)object).substring(n + 1);
            set2.add(object2);
        }
        object = xElem.elems();
        n = 0;
        while (n < ((XElem[])object).length) {
            DependencyUtil.accumBogModuleNames(set2, (XElem)object[n]);
            ++n;
        }
        return set2;
    }

    private static final Set accumBogModuleDeps(Set set, InputStream inputStream, String string, String string2) throws ConnectException, AuthenticationException {
        Set set2 = set == null ? new TreeSet() : set;
        try {
            set2.add("platform");
            if (inputStream != null) {
                XParser xParser = XParser.make((InputStream)inputStream);
                while (xParser.next() != -1) {
                    String string3;
                    if (xParser.type() != 1 || !xParser.elem().name().equals("p") || (string3 = xParser.elem().get("m", null)) == null) continue;
                    int n = string3.indexOf(61);
                    String string4 = n < 0 ? string3 : string3.substring(n + 1);
                    set2.add(string4);
                }
            }
            return set2;
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Exception exception) {
            throw new LocalizableRuntimeException(string, string2, (Throwable)exception);
        }
    }

    private static final Set accumPlatformDeps(Set set, BDaemonPlatform bDaemonPlatform) throws ConnectException, AuthenticationException {
        Set set2 = set == null ? new TreeSet() : set;
        BDaemonFileStore bDaemonFileStore = new BDaemonFileStore(bDaemonPlatform.getDaemonSession().getFileSpace(), new FilePath("!lib/platform.bog"));
        try {
            InputStream inputStream = bDaemonFileStore.getInputStream();
            if (inputStream == null) {
                return set2;
            }
            return DependencyUtil.accumBogModuleDeps(set2, inputStream, "platform", "DependencyUtil.parsePlatformBog");
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "DependencyUtil.parsePlatformBog", (Throwable)iOException);
        }
    }

    public static AnalysisResults analyzeAllDependencies(BDaemonPlatform bDaemonPlatform, BFileSpace bFileSpace, FilePath filePath, BModuleContent bModuleContent, DaemonSessionTaskListener daemonSessionTaskListener) throws Exception {
        Set set;
        if (bModuleContent == null) {
            bModuleContent = bDaemonPlatform.getModuleContent();
        }
        Set set2 = DependencyUtil.accumPlatformDeps(DependencyUtil.getWebUiModules(bDaemonPlatform, bModuleContent), bDaemonPlatform);
        if (filePath == null) {
            set = new TreeSet(set2);
        } else {
            Object object = bFileSpace instanceof BDaemonFileSpace ? new BDaemonFileStore((BDaemonFileSpace)bFileSpace, filePath.merge("config.bog")) : bFileSpace.findStore(filePath.merge("config.bog"));
            InputStream inputStream = object.getInputStream();
            set = DependencyUtil.accumBogModuleDeps(new TreeSet(set2), inputStream, "platform", "DependencyUtil.parseConfigBog");
        }
        return new AnalysisResults(bDaemonPlatform, set, set2, bModuleContent, new SolutionParameters(daemonSessionTaskListener));
    }

    public static AnalysisResults analyzeAllDependencies(BDaemonPlatform bDaemonPlatform, BDirectory[] bDirectoryArray, BModuleContent bModuleContent, SolutionParameters solutionParameters) throws Exception {
        if (bModuleContent == null) {
            bModuleContent = bDaemonPlatform.getModuleContent();
        }
        Set set = DependencyUtil.accumPlatformDeps(DependencyUtil.getWebUiModules(bDaemonPlatform, bModuleContent), bDaemonPlatform);
        Set set2 = new TreeSet(set);
        if (bDirectoryArray != null) {
            int n = 0;
            while (n < bDirectoryArray.length) {
                BIFile bIFile = (BIFile)bDirectoryArray[n].getNavChild("config.bog");
                if (bIFile != null) {
                    InputStream inputStream = bIFile.getInputStream();
                    set2 = DependencyUtil.accumBogModuleDeps(set2, inputStream, "platform", "DependencyUtil.parseConfigBog");
                }
                ++n;
            }
        }
        return new AnalysisResults(bDaemonPlatform, set2, set, bModuleContent, solutionParameters);
    }

    static final /* synthetic */ BDependency[] access$0(Set set) {
        return DependencyUtil.getModuleDeps(set);
    }

    static {
        ALL_WEB_UI_MODULES.add("web");
        ALL_WEB_UI_MODULES.add("icons");
        ALL_WEB_UI_MODULES.add("converters");
        ALL_WEB_UI_MODULES.add("html");
        ALL_WEB_UI_MODULES.add("fonts");
        ALL_WEB_UI_MODULES.add("chart");
        ALL_WEB_UI_MODULES.add("wiresheet");
        ALL_WEB_UI_MODULES.add("workbench");
        ALL_WEB_UI_MODULES.add("pdf");
        ALL_WEB_UI_MODULES.add("kitPx");
        ANALYSIS_REQ_STATION = 1;
        ANALYSIS_REQ_PLATFORM = 2;
        ANALYSIS_DEP_MISSING = 256;
        ANALYSIS_DEP_UNAVAILABLE = 512;
        ANALYSIS_DEP_UNSOLVABLE = 1024;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class AnalysisResults {
        private InstallScenario solution;
        private TreeMap flagsByPartName;
        private int status;
        static /* synthetic */ Class class$com$tridium$install$installable$BModuleInstallable;

        public InstallScenario getSolution() {
            return this.solution;
        }

        public boolean anyUnsolvable() {
            boolean bl = false;
            if ((this.status & ANALYSIS_DEP_UNSOLVABLE) > 0) {
                bl = true;
            }
            return bl;
        }

        public boolean anyUnvailable() {
            boolean bl = false;
            if ((this.status & ANALYSIS_DEP_UNAVAILABLE) > 0) {
                bl = true;
            }
            return bl;
        }

        public boolean anyToInstall() {
            boolean bl = false;
            if ((this.status & ANALYSIS_DEP_MISSING) > 0) {
                bl = true;
            }
            return bl;
        }

        public String[] getPartNames() {
            Set set = this.flagsByPartName.keySet();
            return set.toArray(new String[set.size()]);
        }

        public boolean isStationModule(String string) {
            return this.isStatusFlagSet(string, ANALYSIS_REQ_STATION);
        }

        public boolean isPlatformModule(String string) {
            return this.isStatusFlagSet(string, ANALYSIS_REQ_PLATFORM);
        }

        public boolean isMissing(String string) {
            return this.isStatusFlagSet(string, ANALYSIS_DEP_MISSING);
        }

        public boolean isUnavailable(String string) {
            return this.isStatusFlagSet(string, ANALYSIS_DEP_UNAVAILABLE);
        }

        public boolean isUnsolvable(String string) {
            return this.isStatusFlagSet(string, ANALYSIS_DEP_UNSOLVABLE);
        }

        private final void accumModuleDependencies(String string, Set set, Map map, int n) {
            if (set.contains(string)) {
                return;
            }
            this.setStatusFlag(string, n);
            set.add(string);
            BModulePart bModulePart = (BModulePart)((Object)map.get(string));
            if (bModulePart != null) {
                BDependency[] bDependencyArray = bModulePart.getDependencyArray();
                int n2 = 0;
                while (n2 < bDependencyArray.length) {
                    if (bDependencyArray[n2].getPartType().equals(BModulePart.TYPE)) {
                        this.accumModuleDependencies(bDependencyArray[n2].getPartName(), set, map, n);
                    }
                    ++n2;
                }
            }
        }

        private final void setStatusFlag(String string, int n) {
            Integer n2 = (Integer)this.flagsByPartName.get(string);
            int n3 = 0;
            if (n2 != null) {
                n3 = n2;
            }
            int n4 = n3;
            this.flagsByPartName.put(string, new Integer(n4 | n));
            this.status |= n;
        }

        private final boolean isStatusFlagSet(String string, int n) {
            Integer n2 = (Integer)this.flagsByPartName.get(string);
            boolean bl = false;
            if (n2 != null && (n2 & n) > 0) {
                bl = true;
            }
            return bl;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.flagsByPartName = new TreeMap();
            this.status = 0;
        }

        /*
         * Unable to fully structure code
         */
        public AnalysisResults(BDaemonPlatform var1_1, Set var2_2, Set var3_3, BModuleContent var4_4, SolutionParameters var5_5) throws Exception {
            super();
            this.this();
            this.solution = new InstallScenario(var1_1, null, DependencyUtil.access$0(var2_2), null, null, null, var4_4, var5_5, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            var6_6 = false;
            var7_7 = 0;
            while (var7_7 < this.solution.getToInstall().length) {
                if (this.solution.getToInstall()[var7_7] instanceof BDistribution && (var8_9 = DependencyUtil.getPlatformModuleDependencies(var1_1, (BDistribution)this.solution.getToInstall()[var7_7])) != null) {
                    var9_12 = 0;
                    while (var9_12 < var8_9.length) {
                        if (var3_3.add(var8_9[var9_12].getPartName())) {
                            var6_6 = true;
                        }
                        if (var2_2.add(var8_9[var9_12].getPartName())) {
                            var6_6 = true;
                        }
                        ++var9_12;
                    }
                }
                ++var7_7;
            }
            if (var6_6) {
                this.solution = this.solution.solve(null, null, DependencyUtil.access$0(var2_2), null, LocalInstallableRegistry.getInstance());
            }
            var7_8 = new HashMap<String, BModulePart>();
            var8_9 = var1_1.getModuleList().getModules().getProperties();
            if (true) ** GOTO lbl27
            do {
                var9_14 = ((BModuleInstallable)var8_9.get()).getModulePart();
                var7_8.put(var9_14.getPartName(), var9_14);
lbl27:
                // 2 sources

                if ((v0 = AnalysisResults.class$com$tridium$install$installable$BModuleInstallable) != null) continue;
                v0 = AnalysisResults.class("[Lcom.tridium.install.installable.BModuleInstallable;", false);
            } while (var8_9.next(v0));
            var8_10 = 0;
            while (var8_10 < this.solution.getToInstall().length) {
                this.setStatusFlag(this.solution.getToInstall()[var8_10].getInstallableName(), DependencyUtil.access$1());
                if (this.solution.getToInstall()[var8_10] instanceof BModuleInstallable) {
                    var9_15 = ((BModuleInstallable)this.solution.getToInstall()[var8_10]).getModulePart();
                    var7_8.put(var9_15.getPartName(), var9_15);
                }
                ++var8_10;
            }
            var8_11 = this.solution.getUnmeetableDependencies();
            var9_16 = 0;
            while (var9_16 < var8_11.length) {
                var10_18 = var8_11[var9_16].dependency.getPartName();
                if (var8_11[var9_16].isUnsolvable) {
                    this.setStatusFlag((String)var10_18, DependencyUtil.access$2() | DependencyUtil.access$1());
                } else {
                    this.setStatusFlag((String)var10_18, DependencyUtil.access$3() | DependencyUtil.access$1());
                }
                ++var9_16;
            }
            var9_17 = new HashSet<E>();
            var10_18 = var3_3.iterator();
            while (var10_18.hasNext()) {
                this.accumModuleDependencies((String)var10_18.next(), var9_17, var7_8, DependencyUtil.access$4() | DependencyUtil.access$5());
            }
            var10_18 = var2_2.iterator();
            while (var10_18.hasNext()) {
                this.accumModuleDependencies((String)var10_18.next(), var9_17, var7_8, DependencyUtil.access$5());
            }
        }
    }
}

