/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.PartSpec;
import com.tridium.install.part.BPart;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DependencyMap {
    private Map map = new HashMap();

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public void merge(DependencyMap dependencyMap) {
        if (dependencyMap == null) {
            return;
        }
        Iterator iterator = dependencyMap.map.values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                PartSpec partSpec = (PartSpec)iterator2.next();
                this.addDependency(partSpec, (BDependency)((Object)map.get(partSpec)));
            }
        }
    }

    public boolean removeDependency(PartSpec partSpec, BDependency bDependency) {
        Map map = (Map)this.map.get(bDependency.getPartSpec());
        if (map != null) {
            Object v = map.remove(partSpec);
            if (map.size() == 0) {
                this.map.remove(bDependency.getPartSpec());
            }
            boolean bl = false;
            if (v != null) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public BDependency getStrictestDependencyOn(BPart bPart) {
        return this.getStrictestDependencyOn(bPart.getPartSpec());
    }

    public BDependency getStrictestDependencyOn(PartSpec partSpec) {
        BDependency bDependency = null;
        Map map = this.getDependenciesOn(partSpec);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            BDependency bDependency2 = (BDependency)((Object)iterator.next());
            if (bDependency != null && !bDependency2.supersedes(bDependency)) continue;
            bDependency = bDependency2;
        }
        return bDependency;
    }

    public Set getPartSpecs() {
        return this.map.keySet();
    }

    public Map getDependenciesOn(BPart bPart) {
        return this.getDependenciesOn(bPart.getPartSpec());
    }

    public Map getDependenciesOn(PartSpec partSpec) {
        return (Map)this.map.get(partSpec);
    }

    public boolean addDependencies(Map map) {
        if (map == null) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            PartSpec partSpec = (PartSpec)iterator.next();
            boolean bl2 = false;
            if (!this.addDependency(partSpec, (BDependency)((Object)map.get(partSpec))) && !bl) continue;
            bl2 = bl = true;
        }
        return bl;
    }

    public boolean addDependency(PartSpec partSpec, BDependency bDependency) {
        HashMap<PartSpec, BDependency> hashMap = (HashMap<PartSpec, BDependency>)this.map.get(bDependency.getPartSpec());
        if (hashMap == null) {
            hashMap = new HashMap<PartSpec, BDependency>();
            hashMap.put(partSpec, bDependency);
            this.map.put(bDependency.getPartSpec(), hashMap);
            return true;
        }
        BDependency bDependency2 = (BDependency)((Object)hashMap.get(partSpec));
        if (bDependency2 == null) {
            boolean bl = false;
            if (hashMap.put(partSpec, bDependency) == null) {
                bl = true;
            }
            return bl;
        }
        if (bDependency.supersedes(bDependency2)) {
            boolean bl = false;
            if (hashMap.put(partSpec, bDependency) == null) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void dump() {
        System.out.println("dumping " + this);
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = (Map)this.map.get(string);
            System.out.println("  dependencies on " + string);
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                PartSpec partSpec = (PartSpec)iterator2.next();
                BDependency bDependency = (BDependency)((Object)map.get(partSpec));
                System.out.println("    " + partSpec.getPartName() + " requires " + (Object)((Object)bDependency));
            }
        }
    }
}

