/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.Attrib;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClassCondenser {
    private static final int MAGIC = -889275714;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private static final String CODE_ATTRIB = "Code";
    private static final String LINE_NUMBER_TABLE_ATTRIB = "LineNumberTable";
    private static final int EXCEPTION_TABLE_ENTRY_SIZE = 8;
    private static final int ATTRIB_HEADER_SIZE = 6;
    private String[] cpUtf;

    public void condense(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.condense(inputStream, outputStream, true);
    }

    public void condense(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        if (this.echoInt(dataInputStream, dataOutputStream) != -889275714) {
            throw new IOException("Invalid magic");
        }
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.cpUtf = new String[this.echoUnsignedShort(dataInputStream, dataOutputStream)];
        int n2 = 1;
        while (n2 < this.cpUtf.length) {
            n = this.echoCpInfo(dataInputStream, dataOutputStream, n2);
            if (n != 0) {
                ++n2;
            }
            ++n2;
        }
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoFully(dataInputStream, dataOutputStream, this.echoUnsignedShort(dataInputStream, dataOutputStream) * 2);
        n2 = this.echoUnsignedShort(dataInputStream, dataOutputStream);
        n = 0;
        while (n < n2) {
            this.echoField(dataInputStream, dataOutputStream);
            ++n;
        }
        n2 = this.echoUnsignedShort(dataInputStream, dataOutputStream);
        n = 0;
        while (n < n2) {
            this.echoMethod(dataInputStream, dataOutputStream);
            ++n;
        }
        n2 = this.echoUnsignedShort(dataInputStream, dataOutputStream);
        n = 0;
        while (n < n2) {
            this.echoAttrib(dataInputStream, dataOutputStream);
            ++n;
        }
        dataOutputStream.flush();
        if (bl) {
            dataOutputStream.close();
            outputStream.close();
            dataInputStream.close();
            inputStream.close();
        }
    }

    private final int echoUnsignedByte(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        dataOutputStream.writeByte(n);
        return n;
    }

    private final int echoUnsignedShort(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataOutputStream.writeShort(n);
        return n;
    }

    private final int echoInt(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readInt();
        dataOutputStream.writeInt(n);
        return n;
    }

    private final byte[] echoFully(DataInputStream dataInputStream, DataOutputStream dataOutputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        dataOutputStream.write(byArray, 0, n);
        return byArray;
    }

    private final String echoUTF(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        String string = DataInputStream.readUTF(dataInputStream);
        dataOutputStream.writeUTF(string);
        return string;
    }

    private final void echoMethod(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        int n = this.echoUnsignedShort(dataInputStream, dataOutputStream);
        int n2 = 0;
        while (n2 < n) {
            this.echoAttrib(dataInputStream, dataOutputStream);
            ++n2;
        }
    }

    private final void echoField(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        this.echoUnsignedShort(dataInputStream, dataOutputStream);
        int n = this.echoUnsignedShort(dataInputStream, dataOutputStream);
        int n2 = 0;
        while (n2 < n) {
            this.echoAttrib(dataInputStream, dataOutputStream);
            ++n2;
        }
    }

    private final void echoAttrib(DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readInt();
        String string = this.cpUtf[n];
        if (string == null) {
            throw new IOException("Could not look up attribute.");
        }
        if (string.equals(CODE_ATTRIB)) {
            this.echoCodeAttrib(dataInputStream, dataOutputStream, n, n2);
        } else {
            dataOutputStream.writeShort(n);
            dataOutputStream.writeInt(n2);
            this.echoFully(dataInputStream, dataOutputStream, n2);
        }
    }

    private final void echoCodeAttrib(DataInputStream dataInputStream, DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedShort();
        int n5 = dataInputStream.readInt();
        byte[] byArray = new byte[n5];
        dataInputStream.readFully(byArray, 0, n5);
        int n6 = dataInputStream.readUnsignedShort();
        int n7 = n6 * 8;
        byte[] byArray2 = new byte[n7];
        dataInputStream.readFully(byArray2, 0, n7);
        Attrib[] attribArray = new Attrib[dataInputStream.readUnsignedShort()];
        int n8 = 0;
        int n9 = 0;
        while (n9 < attribArray.length) {
            attribArray[n9] = new Attrib(dataInputStream, this.cpUtf);
            if (attribArray[n9].name.equals(LINE_NUMBER_TABLE_ATTRIB)) {
                n2 -= attribArray[n9].len + 6;
                attribArray[n9] = null;
            } else {
                ++n8;
            }
            ++n9;
        }
        dataOutputStream.writeShort(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(n4);
        dataOutputStream.writeInt(n5);
        dataOutputStream.write(byArray, 0, n5);
        dataOutputStream.writeShort(n6);
        dataOutputStream.write(byArray2, 0, n7);
        dataOutputStream.writeShort(n8);
        n9 = 0;
        while (n9 < attribArray.length) {
            if (attribArray[n9] != null) {
                dataOutputStream.writeShort(attribArray[n9].nameIndex);
                dataOutputStream.writeInt(attribArray[n9].len);
                dataOutputStream.write(attribArray[n9].info, 0, attribArray[n9].len);
            }
            ++n9;
        }
    }

    private final boolean echoCpInfo(DataInputStream dataInputStream, DataOutputStream dataOutputStream, int n) throws IOException {
        int n2 = this.echoUnsignedByte(dataInputStream, dataOutputStream);
        switch (n2) {
            case 1: {
                this.cpUtf[n] = this.echoUTF(dataInputStream, dataOutputStream);
                return false;
            }
            case 3: {
                this.echoFully(dataInputStream, dataOutputStream, 4);
                return false;
            }
            case 4: {
                this.echoFully(dataInputStream, dataOutputStream, 4);
                return false;
            }
            case 5: {
                this.echoFully(dataInputStream, dataOutputStream, 8);
                return true;
            }
            case 6: {
                this.echoFully(dataInputStream, dataOutputStream, 8);
                return true;
            }
            case 7: {
                this.echoFully(dataInputStream, dataOutputStream, 2);
                return false;
            }
            case 8: {
                this.echoFully(dataInputStream, dataOutputStream, 2);
                return false;
            }
            case 9: {
                this.echoFully(dataInputStream, dataOutputStream, 4);
                return false;
            }
            case 10: {
                this.echoFully(dataInputStream, dataOutputStream, 4);
                return false;
            }
            case 11: {
                this.echoFully(dataInputStream, dataOutputStream, 4);
                return false;
            }
            case 12: {
                this.echoFully(dataInputStream, dataOutputStream, 4);
                return false;
            }
        }
        throw new IOException("Invalid cp tag 0x" + Integer.toHexString(n2));
    }
}

