/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.part.BPart;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVersion
extends BStruct
implements BIComparable,
BIDataValue {
    public static final Property bajaVersionString = BVersion.newProperty((int)1, (String)"", null);
    public static final Property vendor = BVersion.newProperty((int)1, (String)"", null);
    public static final Property vendorVersionString = BVersion.newProperty((int)1, (String)"", null);
    public static final Type TYPE;
    public static final LexiconText nameVersionText;
    public static final BVersion ZERO;
    public static final int LATER_VERSION = 1;
    public static final int SAME_VERSION = 2;
    public static final int EARLIER_VERSION = 4;
    public static final int DIFFERENT_VERSION = 8;
    public static final int EQUIVALENT_VERSION = 16;
    public static final int MORE_SPECIFIC_VERSION = 32;
    public static final int LESS_SPECIFIC_VERSION = 64;
    public static final int MEETS_MINIMUM = 115;
    public static final int MEETS_MAXIMUM = 118;
    private Version vendorVersionObject;
    private boolean setting;
    private String settingMonitor;
    static /* synthetic */ Class class$com$tridium$install$BVersion;

    public String getBajaVersionString() {
        return this.getString(bajaVersionString);
    }

    public void setBajaVersionString(String string) {
        this.setString(bajaVersionString, string, null);
    }

    public String getVendor() {
        return this.getString(vendor);
    }

    public void setVendor(String string) {
        this.setString(vendor, string, null);
    }

    public String getVendorVersionString() {
        return this.getString(vendorVersionString);
    }

    public void setVendorVersionString(String string) {
        this.setString(vendorVersionString, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public int compareTo(Object object) {
        BVersion bVersion = (BVersion)((Object)object);
        if (bVersion == null) {
            return 1;
        }
        int n = TextUtil.toLowerCase((String)this.getVendor()).compareTo(TextUtil.toLowerCase((String)bVersion.getVendor()));
        if (n == 0) {
            if (bVersion.getVendorVersion() == null) {
                int n2 = 0;
                if (this.getVendorVersion() == null) {
                    n2 = 1;
                }
                return 1 - n2;
            }
            if (this.getVendorVersion() == null) {
                return -1;
            }
            n = this.getVendorVersion().compareTo((Object)bVersion.getVendorVersion());
        }
        return n;
    }

    public static boolean meets(Version version, BDependency bDependency) {
        return BVersion.meetsVersionRequirement(version, bDependency.getVersion().getVendorVersion(), bDependency.getVersionRelation());
    }

    public static boolean meetsVersionRequirement(Version version, Version version2, BVersionRelation bVersionRelation) {
        int n = BVersion.checkVersionRequirement(version, version2);
        if (bVersionRelation == BVersionRelation.minimum) {
            boolean bl = false;
            if ((n & 0x73) > 0) {
                bl = true;
            }
            return bl;
        }
        if (bVersionRelation == BVersionRelation.maximum) {
            boolean bl = false;
            if ((n & 0x76) > 0) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if ((n & 2) > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean meets(BDependency bDependency) {
        return this.meetsVersionRequirement(bDependency.getVersion(), bDependency.getVersionRelation());
    }

    public boolean meetsVersionRequirement(BVersion bVersion, BVersionRelation bVersionRelation) {
        int n = this.checkVersionRequirement(bVersion);
        if (bVersionRelation == BVersionRelation.minimum) {
            boolean bl = false;
            if ((n & 0x73) > 0) {
                bl = true;
            }
            return bl;
        }
        if (bVersionRelation == BVersionRelation.maximum) {
            boolean bl = false;
            if ((n & 0x76) > 0) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if ((n & 2) > 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkVersionRequirement(BVersion bVersion) {
        int n;
        if (!bVersion.getVendor().equalsIgnoreCase(this.getVendor()) && bVersion.getVendor().trim().length() != 0 && this.getVendor().trim().length() != 0) return 8;
        if (bVersion.getVendorVersion() == null) {
            if (this.getVendorVersion() != null) return 32;
            n = 0;
        } else {
            if (this.getVendorVersion() == null) {
                return 64;
            }
            n = this.getVendorVersion().compareTo((Object)bVersion.getVendorVersion());
        }
        if (n == 0) {
            if (!bVersion.getVendor().equalsIgnoreCase(this.getVendor())) return 16;
            return 2;
        }
        if (n >= 0) return 1;
        return 4;
    }

    public static int checkVersionRequirement(Version version, Version version2) {
        int n = version2 == null ? 0 : (version == null ? -1 : version.compareTo((Object)version2));
        if (n == 0) {
            return 2;
        }
        if (n < 0) {
            return 4;
        }
        return 1;
    }

    public synchronized boolean equivalent(Object object) {
        if (object instanceof BVersion) {
            BVersion bVersion = (BVersion)((Object)object);
            if (this.getVendorVersion() == null) {
                if (bVersion.getVendorVersion() != null) {
                    return false;
                }
            } else {
                if (bVersion.getVendorVersion() == null) {
                    return false;
                }
                if (!this.getVendorVersion().equals((Object)bVersion.getVendorVersion())) {
                    return false;
                }
            }
            return bVersion.getVendor().equalsIgnoreCase(this.getVendor());
        }
        return false;
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getVendor().length() > 0) {
            stringBuffer.append(this.getVendor()).append(" ");
        }
        if (this.getVendorVersion() != null) {
            stringBuffer.append(this.getVendorVersion());
        }
        return stringBuffer.toString().trim();
    }

    public Version getBajaVersion() {
        if (this.getVersionString(this.getBajaVersionString()).trim().length() > 0) {
            return new Version(this.getVersionString(this.getBajaVersionString()));
        }
        return null;
    }

    public Version getVendorVersion() {
        if (this.vendorVersionObject == null && this.getVersionString(this.getVendorVersionString()).trim().length() > 0) {
            this.vendorVersionObject = new Version(this.getVersionString(this.getVendorVersionString()));
        }
        return this.vendorVersionObject;
    }

    public void setVendorVersion(Version version) {
        if (this.setting) {
            return;
        }
        this.vendorVersionObject = version;
        if (version == null) {
            this.setVendorVersionString("");
        } else {
            this.setVendorVersionString(version.toString());
        }
    }

    private final String getVersionString(String string) {
        if (string == null) {
            return "";
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '.' && !Character.isDigit(string.charAt(n))) {
                return string.substring(0, n);
            }
            ++n;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        String string = this.settingMonitor;
        synchronized (string) {
            this.setting = true;
            if (property == vendorVersionString) {
                String string2 = this.propertyValueToString(property, context);
                this.vendorVersionObject = string2.trim().length() == 0 ? null : new Version(this.getVersionString(string2));
            }
            this.setting = false;
            return;
        }
    }

    public static String formatNameVersion(BPart bPart, Context context) {
        return BVersion.formatNameVersion(bPart.getPartName(), bPart.getVersion(), context);
    }

    public static String formatNameVersion(String string, BVersion bVersion, Context context) {
        String string2 = bVersion.toString(context);
        if (string2.trim().length() == 0 || string2.equals("0")) {
            return string;
        }
        return nameVersionText.getText(context, new Object[]{string, string2});
    }

    public static BVersion makeZero() {
        return new BVersion();
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getBajaVersionString());
        dataOutput.writeUTF(this.getVendor());
        dataOutput.writeUTF(this.getVendorVersionString());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        BVersion bVersion = new BVersion();
        bVersion.setBajaVersionString(dataInput.readUTF());
        bVersion.setVendor(dataInput.readUTF());
        bVersion.setVendorVersionString(dataInput.readUTF());
        return bVersion;
    }

    public String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.getBajaVersionString());
        stringBuffer.append(';');
        stringBuffer.append(this.getVendor());
        stringBuffer.append(';');
        stringBuffer.append(this.getVendorVersionString());
        return stringBuffer.toString();
    }

    public BObject decodeFromString(String string) throws IOException {
        BVersion bVersion = new BVersion();
        String[] stringArray = TextUtil.split((String)string, (char)';');
        bVersion.setBajaVersionString(stringArray[0]);
        bVersion.setVendor(stringArray[1]);
        bVersion.setVendorVersionString(stringArray[2]);
        return bVersion;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.vendorVersionObject = null;
        this.setting = false;
        this.settingMonitor = new String("Setting");
    }

    public BVersion() {
        this.this();
    }

    public BVersion(String string) {
        this(null, string);
    }

    public BVersion(String string, String string2) {
        this.this();
        if (string != null && string.trim().length() > 0) {
            this.setVendor(string);
        } else {
            this.setVendor("");
        }
        if (string2 != null && string2.trim().length() > 0) {
            this.setVendorVersionString(string2);
        } else {
            this.setVendorVersionString("");
        }
    }

    static {
        Class clazz = class$com$tridium$install$BVersion;
        if (clazz == null) {
            clazz = class$com$tridium$install$BVersion = BVersion.class("[Lcom.tridium.install.BVersion;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        nameVersionText = LexiconText.make((String)"platform", (String)"Version.nameVersion");
        ZERO = new BVersion();
    }
}

