/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BVersion;
import com.tridium.install.PartSpec;
import com.tridium.install.part.BApplicationPart;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.install.BPlatformPartType;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.platform.install.PlatformDependency;
import javax.baja.platform.install.PlatformPart;
import javax.baja.registry.DependencyInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.LexiconText;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDependency
extends BStruct
implements BIDataValue {
    public static final Property partName = BDependency.newProperty((int)1, (String)"unknown", null);
    public static final Property version = BDependency.newProperty((int)1, (BValue)BVersion.makeZero(), null);
    public static final Property versionRelation = BDependency.newProperty((int)1, (BValue)BVersionRelation.minimum, null);
    public static final Property partTypeSpec = BDependency.newProperty((int)1, (BValue)BTypeSpec.DEFAULT, null);
    public static final Property solverFiltersString = BDependency.newProperty((int)1, (String)"*", null);
    public static final Type TYPE;
    public static final LexiconText anyVersionText;
    public static final LexiconText anyVersionTextWithExclude;
    public static final LexiconText nameVersionWithExclude;
    public static final LexiconText maxVersionText;
    public static final LexiconText maxVersionTextWithExclude;
    public static final LexiconText exactVersionText;
    public static final LexiconText exactVersionTextWithExclude;
    public static final LexiconText minVersionExclusiveText;
    public static final LexiconText notEqualVersionText;
    public static final LexiconText minMaxText;
    public static final LexiconText minNeText;
    public static final LexiconText maxInclusiveMinExclusiveText;
    public static final DependencySync DEP_SYNC_KEEP_FIRST;
    public static final DependencySync DEP_SYNC_KEEP_SECOND;
    public static final DependencySync DEP_SYNC_NO_CHANGE;
    public static final DependencySync DEP_SYNC_CONFLICT;
    public static final String DEFAULT_SOLVER = "default";
    public static final String NO_SOLVERS = "";
    public static final String COMMISSIONING_SOLVER = "commissioning";
    public static final String APP_SOLVER = "app";
    public static final String ANY_SOLVER = "*";
    public static final String EXCLUSION_FACET = "exclusion";
    public static final Comparator COMPARATOR;
    private Type resolvedType;
    private PartSpec spec;
    private PatternFilter[] solverFilters;
    static /* synthetic */ Class class$com$tridium$install$BDependency;

    public String getPartName() {
        return this.getString(partName);
    }

    public void setPartName(String string) {
        this.setString(partName, string, null);
    }

    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    public void setVersion(BVersion bVersion) {
        this.set(version, (BValue)bVersion, null);
    }

    public BVersionRelation getVersionRelation() {
        return (BVersionRelation)this.get(versionRelation);
    }

    public void setVersionRelation(BVersionRelation bVersionRelation) {
        this.set(versionRelation, (BValue)bVersionRelation, null);
    }

    public BTypeSpec getPartTypeSpec() {
        return (BTypeSpec)this.get(partTypeSpec);
    }

    public void setPartTypeSpec(BTypeSpec bTypeSpec) {
        this.set(partTypeSpec, (BValue)bTypeSpec, null);
    }

    public String getSolverFiltersString() {
        return this.getString(solverFiltersString);
    }

    public void setSolverFiltersString(String string) {
        this.setString(solverFiltersString, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public XElem getXml() {
        XElem xElem = new XElem();
        xElem.setAttr("name", this.getPartName());
        if (!this.getSolverFiltersString().equals(ANY_SOLVER)) {
            xElem.setAttr("solvers", this.getSolverFiltersString());
        }
        if (this.getVersion().getBajaVersionString().trim().length() > 0) {
            xElem.setAttr("bajaVersion", this.getVersion().getBajaVersionString());
        }
        if (this.getVersion().getVendorVersionString().trim().length() > 0) {
            xElem.setAttr("vendorVersion", this.getVersion().getVendorVersionString());
            if (this.getVersionRelation() != BVersionRelation.minimum) {
                xElem.setAttr("rel", this.getVersionRelation().getTag());
            }
        }
        if (this.getVersion().getVendor().trim().length() > 0) {
            xElem.setAttr("vendor", this.getVersion().getVendor());
        }
        if (this.getPartTypeSpec().equals((Object)BModulePart.TYPE.getTypeSpec())) {
            xElem.setName("dependency");
        } else if (this.getPartTypeSpec().equals((Object)BOsPart.TYPE.getTypeSpec())) {
            xElem.setName("os");
        } else if (this.getPartTypeSpec().equals((Object)BVmPart.TYPE.getTypeSpec())) {
            xElem.setName("vm");
        } else if (this.getPartTypeSpec().equals((Object)BArchPart.TYPE.getTypeSpec())) {
            xElem.setName("arch");
        } else if (this.getPartTypeSpec().equals((Object)BModelPart.TYPE.getTypeSpec())) {
            xElem.setName("model");
        } else if (this.getPartTypeSpec().equals((Object)BBrandPart.TYPE.getTypeSpec())) {
            xElem.setName("brand");
        } else if (this.getPartTypeSpec().equals((Object)BNrePart.TYPE.getTypeSpec())) {
            xElem.setName("nre");
        } else if (this.getPartTypeSpec().equals((Object)BApplicationPart.TYPE.getTypeSpec())) {
            xElem.setName(APP_SOLVER);
        } else {
            xElem.setName("part");
        }
        return xElem;
    }

    public static BDependency forModule(String string) {
        return new BDependency(string, BVersion.ZERO, BModulePart.TYPE.getTypeSpec());
    }

    public static BDependency forPart(BPart bPart) {
        return BDependency.forPart(bPart, BVersionRelation.minimum);
    }

    public static BDependency forPart(BPart bPart, BVersionRelation bVersionRelation) {
        return new BDependency(bPart.getPartName(), bPart.getVersion(), bVersionRelation, bPart.getType().getTypeSpec(), ANY_SOLVER);
    }

    public static BDependency make(XElem xElem) {
        if (xElem.name().equals("dependency") || xElem.name().equals("module")) {
            return new BDependency(xElem.get("name"), new BVersion(xElem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BModulePart.TYPE.getTypeSpec(), xElem.get("solvers", ANY_SOLVER));
        }
        if (xElem.name().equals("os")) {
            return new BDependency(xElem.get("name"), new BVersion(xElem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BOsPart.TYPE.getTypeSpec(), xElem.get("solvers", ANY_SOLVER));
        }
        if (xElem.name().equals("vm")) {
            return new BDependency(xElem.get("name"), new BVersion(xElem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BVmPart.TYPE.getTypeSpec(), xElem.get("solvers", ANY_SOLVER));
        }
        if (xElem.name().equals("arch")) {
            return new BDependency(xElem.get("name"), new BVersion(null, BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BArchPart.TYPE.getTypeSpec(), NO_SOLVERS);
        }
        if (xElem.name().equals("model")) {
            return new BDependency(xElem.get("name"), new BVersion(null, BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BModelPart.TYPE.getTypeSpec(), NO_SOLVERS);
        }
        if (xElem.name().equals("brand")) {
            return new BDependency(xElem.get("name"), BVersion.ZERO, BVersionRelation.minimum, BBrandPart.TYPE.getTypeSpec(), xElem.get("solvers", NO_SOLVERS));
        }
        if (xElem.name().equals("nre")) {
            return new BDependency(xElem.get("name"), new BVersion(xElem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BNrePart.TYPE.getTypeSpec(), xElem.get("solvers", ANY_SOLVER));
        }
        if (xElem.name().equals(APP_SOLVER)) {
            return new BDependency(xElem.get("name"), new BVersion(xElem.get("vendor", NO_SOLVERS), BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BApplicationPart.TYPE.getTypeSpec(), xElem.get("solvers", APP_SOLVER));
        }
        if (xElem.get("name", null) != null) {
            return new BDependency(xElem.get("name"), new BVersion(null, BDependency.getVendorVersion(xElem)), BVersionRelation.make(xElem.get("rel", "minimum")), BGenericPart.TYPE.getTypeSpec(), xElem.get("solvers", NO_SOLVERS));
        }
        return null;
    }

    public PlatformDependency asPlatformDependency() {
        return new PlatformDependency(){

            public final PlatformPart getPartPrototype() {
                return new PlatformPart(){

                    public final String getPartName() {
                        return BDependency.this.getPartName();
                    }

                    public final BPlatformPartType getPartType() {
                        return BPart.getPlatformPartType(BDependency.this.getPartTypeSpec());
                    }

                    public final Version getPartVersion() {
                        return BDependency.this.getVersion().getVendorVersion();
                    }
                };
            }

            public final BVersionRelation getVersionRelation() {
                return BDependency.this.getVersionRelation();
            }
        };
    }

    private static final String getVendorVersion(XElem xElem) {
        return xElem.get("vendorVersion", xElem.get("version", NO_SOLVERS));
    }

    public Type getPartType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.getPartTypeSpec().getResolvedType();
        }
        return this.resolvedType;
    }

    public PartSpec getPartSpec() {
        if (this.spec == null) {
            this.spec = new PartSpec(this.getPartName(), this.getPartTypeSpec());
        }
        return this.spec;
    }

    public void changed(Property property, Context context) {
        if (property == partTypeSpec) {
            this.resolvedType = this.getPartTypeSpec().getResolvedType();
        }
    }

    public boolean equivalent(Object object) {
        if (object instanceof BDependency) {
            BDependency bDependency = (BDependency)((Object)object);
            boolean bl = false;
            if (this.getPartName().equals(bDependency.getPartName()) && this.getPartType().equals(bDependency.getPartType()) && this.getVersionRelation().equals((Object)bDependency.getVersionRelation()) && this.getVersion().equivalent((Object)bDependency.getVersion()) && this.getSolverFiltersString().equals(bDependency.getSolverFiltersString())) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DependencySync sync(BDependency bDependency, BDependency bDependency2) {
        String string;
        BVersionRelation bVersionRelation;
        BVersion bVersion;
        String string2;
        block40: {
            int n;
            block46: {
                block45: {
                    block42: {
                        block44: {
                            block43: {
                                block41: {
                                    if (bDependency == bDependency2 || bDependency.equivalent((Object)bDependency2)) {
                                        return DEP_SYNC_KEEP_FIRST;
                                    }
                                    if (!bDependency.getPartTypeSpec().equals((Object)bDependency2.getPartTypeSpec())) {
                                        return DEP_SYNC_NO_CHANGE;
                                    }
                                    if (bDependency.getPartName().equals(bDependency2.getPartName()) || BPart.isWildcardName(bDependency2.getPartName()) && BPart.matchesName(bDependency.getPartName(), bDependency2.getPartName())) {
                                        string2 = bDependency.getPartName();
                                    } else if (BPart.isWildcardName(bDependency.getPartName()) && BPart.matchesName(bDependency2.getPartName(), bDependency.getPartName())) {
                                        string2 = bDependency2.getPartName();
                                    } else {
                                        return DEP_SYNC_NO_CHANGE;
                                    }
                                    bVersion = null;
                                    bVersionRelation = null;
                                    n = bDependency.getVersion().checkVersionRequirement(bDependency2.getVersion());
                                    if (n == 8) {
                                        return DEP_SYNC_CONFLICT;
                                    }
                                    if (bDependency.getVersionRelation() != BVersionRelation.exact) break block41;
                                    if (bDependency2.getVersionRelation() == BVersionRelation.exact) {
                                        if (n != 2 && n != 16) {
                                            return DEP_SYNC_CONFLICT;
                                        }
                                        bVersion = bDependency.getVersion();
                                        bVersionRelation = BVersionRelation.exact;
                                        break block40;
                                    } else if (bDependency2.getVersionRelation() == BVersionRelation.minimum) {
                                        if (n != 2 && n != 16 && n != 1 && n != 32) {
                                            return DEP_SYNC_CONFLICT;
                                        }
                                        bVersion = bDependency.getVersion();
                                        bVersionRelation = BVersionRelation.exact;
                                        break block40;
                                    } else {
                                        if (n != 4 && n != 32 && n != 2 && n != 16) {
                                            return DEP_SYNC_CONFLICT;
                                        }
                                        bVersion = bDependency.getVersion();
                                        bVersionRelation = BVersionRelation.exact;
                                    }
                                    break block40;
                                }
                                if (bDependency.getVersionRelation() != BVersionRelation.minimum) break block42;
                                if (bDependency2.getVersionRelation() != BVersionRelation.exact) break block43;
                                if (n != 2 && n != 16 && n != 4 && n != 64) {
                                    return DEP_SYNC_CONFLICT;
                                }
                                bVersion = bDependency2.getVersion();
                                bVersionRelation = BVersionRelation.exact;
                                break block40;
                            }
                            if (bDependency2.getVersionRelation() != BVersionRelation.minimum) break block44;
                            bVersionRelation = BVersionRelation.minimum;
                            bVersion = n == 2 || n == 16 || n == 1 || n == 32 ? bDependency.getVersion() : bDependency2.getVersion();
                            break block40;
                        }
                        if (n == 2 || n == 16) {
                            bVersion = bDependency.getVersion();
                            bVersionRelation = BVersionRelation.exact;
                            break block40;
                        } else if (n == 64) {
                            bVersion = bDependency2.getVersion();
                            bVersionRelation = BVersionRelation.maximum;
                            break block40;
                        } else {
                            if (n == 4) {
                                return DEP_SYNC_NO_CHANGE;
                            }
                            return DEP_SYNC_CONFLICT;
                        }
                    }
                    if (bDependency2.getVersionRelation() != BVersionRelation.exact) break block45;
                    if (n != 2 && n != 16 && n != 1) {
                        return DEP_SYNC_CONFLICT;
                    }
                    bVersion = bDependency2.getVersion();
                    bVersionRelation = BVersionRelation.exact;
                    break block40;
                }
                if (bDependency2.getVersionRelation() != BVersionRelation.minimum) break block46;
                if (n == 2 || n == 16) {
                    bVersion = bDependency.getVersion();
                    bVersionRelation = BVersionRelation.exact;
                    break block40;
                } else if (n == 32) {
                    bVersion = bDependency.getVersion();
                    bVersionRelation = BVersionRelation.maximum;
                    break block40;
                } else {
                    if (n == 1) {
                        return DEP_SYNC_NO_CHANGE;
                    }
                    return DEP_SYNC_CONFLICT;
                }
            }
            bVersionRelation = BVersionRelation.maximum;
            bVersion = n == 2 || n == 16 || n == 4 ? bDependency.getVersion() : bDependency2.getVersion();
        }
        if (bDependency.getSolverFiltersString().equals(bDependency2.getSolverFiltersString())) {
            string = bDependency.getSolverFiltersString();
        } else if (bDependency.getSolverFiltersString().equals(ANY_SOLVER) || bDependency2.getSolverFiltersString().equals(ANY_SOLVER)) {
            string = ANY_SOLVER;
        } else {
            TreeMap<String, PatternFilter> treeMap = new TreeMap<String, PatternFilter>();
            PatternFilter[] patternFilterArray = bDependency.getSolvers();
            int n = 0;
            while (n < patternFilterArray.length) {
                treeMap.put(patternFilterArray[n].getPattern(), patternFilterArray[n]);
                ++n;
            }
            PatternFilter[] patternFilterArray2 = bDependency2.getSolvers();
            int n2 = 0;
            while (n2 < patternFilterArray2.length) {
                if (!treeMap.containsKey(patternFilterArray2[n2].getPattern())) {
                    boolean bl = true;
                    Iterator iterator = treeMap.values().iterator();
                    while (iterator.hasNext()) {
                        PatternFilter patternFilter = (PatternFilter)iterator.next();
                        if (patternFilter.accept(patternFilterArray2[n2].getPattern())) {
                            bl = false;
                            break;
                        }
                        if (!patternFilterArray2[n2].accept(patternFilter.getPattern())) continue;
                        treeMap.remove(patternFilter.getPattern());
                        break;
                    }
                    if (bl) {
                        treeMap.put(patternFilterArray2[n2].getPattern(), patternFilterArray2[n2]);
                    }
                }
                ++n2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append((String)iterator.next());
            }
            string = stringBuffer.toString();
        }
        if (bDependency.getPartName().equals(string2) && bDependency.getVersion().equivalent((Object)bVersion) && bDependency.getVersionRelation().equals((Object)bVersionRelation) && bDependency.getSolverFiltersString().equals(string)) {
            return DEP_SYNC_KEEP_FIRST;
        }
        if (bDependency2.getPartName().equals(string2) && bDependency2.getVersion().equivalent((Object)bVersion) && bDependency2.getVersionRelation().equals((Object)bVersionRelation) && bDependency2.getSolverFiltersString().equals(string)) {
            return DEP_SYNC_KEEP_SECOND;
        }
        return new DependencySync(new BDependency(string2, bVersion, bVersionRelation, bDependency.getPartTypeSpec(), string));
    }

    public boolean supersedes(BDependency bDependency) {
        boolean bl = false;
        if (BDependency.sync(this, bDependency) == DEP_SYNC_KEEP_FIRST) {
            bl = true;
        }
        return bl;
    }

    public boolean isPlatformDependency() {
        boolean bl = false;
        if (this.getPartTypeSpec().equals((Object)BModelPart.TYPE.getTypeSpec()) || this.getPartTypeSpec().equals((Object)BArchPart.TYPE.getTypeSpec()) || this.getPartTypeSpec().equals((Object)BGenericPart.TYPE.getTypeSpec()) || this.getPartTypeSpec().equals((Object)BOsPart.TYPE.getTypeSpec())) {
            bl = true;
        }
        return bl;
    }

    public String toString(Context context) {
        String string;
        BDependency bDependency = null;
        if (context != null) {
            bDependency = (BDependency)context.getFacet(EXCLUSION_FACET);
            context = new BasicContext(context.getUser(), context.getLanguage());
        }
        if ((string = this.getVersion().toString(context)).trim().length() == 0) {
            if (bDependency != null) {
                if (bDependency.getPartName().equals(this.getPartName())) {
                    if (bDependency.getVersionRelation() == BVersionRelation.minimum) {
                        return maxVersionText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                    }
                    if (bDependency.getVersionRelation() == BVersionRelation.maximum) {
                        return minVersionExclusiveText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                    }
                    if (bDependency.getVersionRelation() == BVersionRelation.maximum) {
                        return notEqualVersionText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                    }
                } else {
                    return anyVersionTextWithExclude.getText(context, new Object[]{this.getPartName(), bDependency.toString(context)});
                }
            }
            return this.getPartName();
        }
        if (string.equals("0")) {
            if (bDependency != null && bDependency.getPartName().equals(this.getPartName())) {
                if (bDependency.getVersionRelation() == BVersionRelation.minimum) {
                    return maxVersionText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                }
                if (bDependency.getVersionRelation() == BVersionRelation.maximum) {
                    return minVersionExclusiveText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                }
                if (bDependency.getVersionRelation() == BVersionRelation.maximum) {
                    return notEqualVersionText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                }
            }
            string = anyVersionText.getText(context);
        }
        if (this.getVersionRelation() == BVersionRelation.minimum) {
            if (bDependency != null) {
                if (bDependency.getPartName().equals(this.getPartName())) {
                    if (bDependency.getVersionRelation() == BVersionRelation.minimum) {
                        return minMaxText.getText(context, new Object[]{this.getPartName(), string, bDependency.getVersion()});
                    }
                    if (bDependency.getVersionRelation() == BVersionRelation.maximum && this.getVersion().compareTo((Object)bDependency.getVersion()) <= 0) {
                        return minVersionExclusiveText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                    }
                    if (bDependency.getVersionRelation() == BVersionRelation.maximum) {
                        return minNeText.getText(context, new Object[]{this.getPartName(), string, bDependency.getVersion()});
                    }
                } else {
                    return nameVersionWithExclude.getText(context, new Object[]{this.getPartName(), string, bDependency.toString(context)});
                }
            }
            return BVersion.nameVersionText.getText(context, new Object[]{this.getPartName(), string});
        }
        if (this.getVersionRelation() == BVersionRelation.maximum) {
            if (bDependency != null) {
                if (bDependency.getPartName().equals(this.getPartName())) {
                    if (bDependency.getVersionRelation() == BVersionRelation.minimum && this.getVersion().compareTo((Object)bDependency.getVersion()) > 0) {
                        return maxVersionText.getText(context, new Object[]{this.getPartName(), bDependency.getVersion()});
                    }
                    if (bDependency.getVersionRelation() == BVersionRelation.maximum) {
                        return maxInclusiveMinExclusiveText.getText(context, new Object[]{this.getPartName(), string, bDependency.getVersion()});
                    }
                } else {
                    return maxVersionTextWithExclude.getText(context, new Object[]{this.getPartName(), bDependency.getVersion(), bDependency.toString(context)});
                }
            }
            return maxVersionText.getText(context, new Object[]{this.getPartName(), string});
        }
        if (bDependency == null || bDependency.getPartName().equals(this.getPartName())) {
            return exactVersionText.getText(context, new Object[]{this.getPartName(), string});
        }
        return exactVersionTextWithExclude.getText(context, new Object[]{this.getPartName(), string, bDependency.toString(context)});
    }

    public BIcon getIcon() {
        return BPart.getPartTypeIcon(this.getPartType());
    }

    public static BDependency[] merge(BDependency[] bDependencyArray) {
        Array array = new Array((Object[])bDependencyArray);
        array = array.sort(COMPARATOR);
        int n = 0;
        while (n < array.size() - 1) {
            BDependency bDependency = (BDependency)((Object)array.get(n));
            int n2 = n + 1;
            while (n2 < array.size()) {
                BDependency bDependency2 = (BDependency)((Object)array.get(n2));
                DependencySync dependencySync = BDependency.sync(bDependency, bDependency2);
                if (dependencySync == DEP_SYNC_KEEP_FIRST) {
                    array.remove(n2);
                    continue;
                }
                if (dependencySync == DEP_SYNC_KEEP_SECOND) {
                    array.swap(n, n2);
                    array.remove(n2);
                    continue;
                }
                if (dependencySync == DEP_SYNC_CONFLICT || dependencySync == DEP_SYNC_NO_CHANGE) {
                    ++n2;
                    continue;
                }
                array.set(n, (Object)dependencySync.mergedResult);
                array.remove(n2);
            }
            ++n;
        }
        return (BDependency[])array.trim();
    }

    public PatternFilter[] getSolvers() {
        if (this.solverFilters == null) {
            this.solverFilters = PatternFilter.parseList((String)this.getSolverFiltersString());
        }
        return this.solverFilters;
    }

    public boolean canSolveWith(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (this.canSolveWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean canSolveWith(String string) {
        this.getSolvers();
        int n = 0;
        while (n < this.solverFilters.length) {
            if (this.solverFilters[n].accept(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public BObject decode(DataInput dataInput) throws IOException {
        this.setPartName(dataInput.readUTF());
        this.setVersion((BVersion)BVersion.ZERO.decode(dataInput));
        this.setVersionRelation((BVersionRelation)BVersionRelation.minimum.decode(dataInput));
        this.setPartTypeSpec(BTypeSpec.make((String)dataInput.readUTF()));
        this.setSolverFiltersString(dataInput.readUTF());
        return null;
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getPartName());
        this.getVersion().encode(dataOutput);
        this.getVersionRelation().encode(dataOutput);
        dataOutput.writeUTF(this.getPartTypeSpec().toString());
        dataOutput.writeUTF(this.getSolverFiltersString());
    }

    public BObject decodeFromString(String string) throws IOException {
        BDependency bDependency = new BDependency();
        String[] stringArray = TextUtil.split((String)string, (char)';');
        bDependency.setPartName(stringArray[0]);
        bDependency.getVersion().setBajaVersionString(stringArray[1]);
        bDependency.getVersion().setVendor(stringArray[2]);
        bDependency.getVersion().setVendorVersionString(stringArray[3]);
        bDependency.setVersionRelation(BVersionRelation.make(stringArray[4]));
        bDependency.setPartTypeSpec(BTypeSpec.make((String)stringArray[5]));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 6;
        while (n < stringArray.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        bDependency.setSolverFiltersString(stringBuffer.toString());
        return bDependency;
    }

    public String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPartName());
        stringBuffer.append(';');
        stringBuffer.append(this.getVersion().encodeToString());
        stringBuffer.append(';');
        stringBuffer.append(this.getVersionRelation().getTag());
        stringBuffer.append(';');
        stringBuffer.append(this.getPartTypeSpec().toString());
        stringBuffer.append(';');
        stringBuffer.append(this.getSolverFiltersString());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.resolvedType = null;
        this.spec = null;
        this.solverFilters = null;
    }

    public BDependency() {
        this.this();
    }

    public BDependency(String string, BVersion bVersion, BTypeSpec bTypeSpec) {
        this(string, bVersion, BVersionRelation.minimum, bTypeSpec, ANY_SOLVER);
    }

    public BDependency(String string, BVersion bVersion, BVersionRelation bVersionRelation, BTypeSpec bTypeSpec) {
        this(string, bVersion, bVersionRelation, bTypeSpec, ANY_SOLVER);
    }

    public BDependency(String string, BVersion bVersion, BVersionRelation bVersionRelation, BTypeSpec bTypeSpec, String string2) {
        this.this();
        this.setPartName(string);
        this.setVersion((BVersion)bVersion.newCopy());
        this.setVersionRelation(bVersionRelation);
        this.setPartTypeSpec(bTypeSpec);
        this.setSolverFiltersString(string2);
    }

    public BDependency(DependencyInfo dependencyInfo) {
        this.this();
        this.setPartTypeSpec(BModulePart.TYPE.getTypeSpec());
        this.setPartName(dependencyInfo.getModuleName());
        if (dependencyInfo.getVendor() != null) {
            this.getVersion().setVendor(dependencyInfo.getVendor());
        }
        this.getVersion().setVendorVersion(dependencyInfo.getVendorVersion());
    }

    static {
        Class clazz = class$com$tridium$install$BDependency;
        if (clazz == null) {
            clazz = class$com$tridium$install$BDependency = BDependency.class("[Lcom.tridium.install.BDependency;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        anyVersionText = LexiconText.make((Type)TYPE, (String)"Dependency.anyVersion");
        anyVersionTextWithExclude = LexiconText.make((Type)TYPE, (String)"Dependency.anyVersion.exclude");
        nameVersionWithExclude = LexiconText.make((Type)TYPE, (String)"Dependency.nameVersion.exclude");
        maxVersionText = LexiconText.make((Type)TYPE, (String)"Dependency.maxVersion");
        maxVersionTextWithExclude = LexiconText.make((Type)TYPE, (String)"Dependency.maxVersion.exclude");
        exactVersionText = LexiconText.make((Type)TYPE, (String)"Dependency.exactVersion");
        exactVersionTextWithExclude = LexiconText.make((Type)TYPE, (String)"Dependency.exactVersion.exclude");
        minVersionExclusiveText = LexiconText.make((Type)TYPE, (String)"Dependency.minVersionExclusive");
        notEqualVersionText = LexiconText.make((Type)TYPE, (String)"Dependency.notEqualVersion");
        minMaxText = LexiconText.make((Type)TYPE, (String)"Dependency.minMax");
        minNeText = LexiconText.make((Type)TYPE, (String)"Dependency.minNe");
        maxInclusiveMinExclusiveText = LexiconText.make((Type)TYPE, (String)"Dependency.maxInclusiveMinExclusive");
        DEP_SYNC_KEEP_FIRST = new DependencySync("keep first");
        DEP_SYNC_KEEP_SECOND = new DependencySync("keep second");
        DEP_SYNC_NO_CHANGE = new DependencySync("no change");
        DEP_SYNC_CONFLICT = new DependencySync("conflict");
        COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                BDependency bDependency = (BDependency)((Object)object);
                BDependency bDependency2 = (BDependency)((Object)object2);
                int n = bDependency.getPartTypeSpec().toString().compareTo(bDependency2.getPartTypeSpec().toString());
                if (n == 0 && (n = bDependency.getPartName().compareTo(bDependency2.getPartName())) == 0 && (n = bDependency.getVersion().compareTo((Object)bDependency2.getVersion())) == 0) {
                    n = bDependency.getVersionRelation().getTag().compareTo(bDependency2.getVersionRelation().getTag());
                }
                return n;
            }
        };
    }

    public static class DependencySync {
        public BDependency mergedResult;
        public String descr;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.mergedResult != null && object instanceof DependencySync) {
                boolean bl = false;
                if (((DependencySync)object).mergedResult != null && ((DependencySync)object).mergedResult.equivalent((Object)this.mergedResult)) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public String toString() {
            return this.descr == null ? "merge into " + this.mergedResult.toString() : this.descr;
        }

        public DependencySync(BDependency bDependency) {
            this.mergedResult = bDependency;
            this.descr = null;
        }

        public DependencySync(String string) {
            this.mergedResult = null;
            this.descr = string;
        }
    }
}

