/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import com.tridium.install.BDependency;
import com.tridium.install.BModuleList;
import com.tridium.install.BRemoteModuleList;
import com.tridium.install.BVersion;
import com.tridium.install.part.BArchPart;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDaemonPlatform
extends BComponent {
    public static final Property hostId = BDaemonPlatform.newProperty((int)1, (String)"", null);
    public static final Property hostName = BDaemonPlatform.newProperty((int)1, (String)"", null);
    public static final Property port = BDaemonPlatform.newProperty((int)1, (int)-1, null);
    public static final Property archPart = BDaemonPlatform.newProperty((int)1, (BValue)BArchPart.makeNull(), null);
    public static final Property osPart = BDaemonPlatform.newProperty((int)1, (BValue)BOsPart.makeNull(), null);
    public static final Property nrePart = BDaemonPlatform.newProperty((int)1, (BValue)BNrePart.makeNull(), null);
    public static final Property brandPart = BDaemonPlatform.newProperty((int)1, (BValue)BBrandPart.makeNull(), null);
    public static final Property vmPart = BDaemonPlatform.newProperty((int)1, (BValue)BVmPart.makeNull(), null);
    public static final Property modelPart = BDaemonPlatform.newProperty((int)1, (BValue)BModelPart.makeNull(), null);
    public static final Property moduleList = BDaemonPlatform.newProperty((int)1, (BValue)new BModuleList(), null);
    public static final Property otherParts = BDaemonPlatform.newProperty((int)1, (BValue)new BVector(), null);
    public static final Property moduleContent = BDaemonPlatform.newProperty((int)1, (BValue)BModuleContent.doc, null);
    public static final Property stripLineNumbers = BDaemonPlatform.newProperty((int)1, (boolean)false, null);
    public static final Property maxStations = BDaemonPlatform.newProperty((int)1, (int)1, null);
    public static final Property maxSedonaApps = BDaemonPlatform.newProperty((int)1, (int)1, null);
    public static final Property osTimeZone = BDaemonPlatform.newProperty((int)1, (BValue)BTimeZone.NULL, null);
    public static final Property allowStationRestart = BDaemonPlatform.newProperty((int)1, (boolean)true, null);
    public static final Property configDistFileName = BDaemonPlatform.newProperty((int)1, (String)"nre-config-*.dist", null);
    public static final Property isNpsdk = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    public static final Property sedonaSupported = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    public static final Property sedonaEnabled = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    public static final Property niagaraStationsEnabled = BDaemonPlatform.newProperty((int)3, (boolean)true, null);
    public static final Property niagaraR2Supported = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    public static final Property niagaraR2Enabled = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    public static final Property platformSSLSupported = BDaemonPlatform.newProperty((int)3, (boolean)false, null);
    public static final Property platformSSLSettings = BDaemonPlatform.newProperty((int)3, (BValue)new BPlatformSSLSettings(), null);
    public static final Action checkSession = BDaemonPlatform.newAction((int)4, null);
    public static final Type TYPE;
    private static BIcon icon;
    private boolean sessionInvalid;
    private String daemonTimestamp;
    private BDaemonSession session;
    protected boolean localInstance;
    static /* synthetic */ Class class$com$tridium$install$BDaemonPlatform;

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String string) {
        this.setString(hostId, string, null);
    }

    public String getHostName() {
        return this.getString(hostName);
    }

    public void setHostName(String string) {
        this.setString(hostName, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public BArchPart getArchPart() {
        return (BArchPart)this.get(archPart);
    }

    public void setArchPart(BArchPart bArchPart) {
        this.set(archPart, (BValue)bArchPart, null);
    }

    public BOsPart getOsPart() {
        return (BOsPart)this.get(osPart);
    }

    public void setOsPart(BOsPart bOsPart) {
        this.set(osPart, (BValue)bOsPart, null);
    }

    public BNrePart getNrePart() {
        return (BNrePart)this.get(nrePart);
    }

    public void setNrePart(BNrePart bNrePart) {
        this.set(nrePart, (BValue)bNrePart, null);
    }

    public BBrandPart getBrandPart() {
        return (BBrandPart)this.get(brandPart);
    }

    public void setBrandPart(BBrandPart bBrandPart) {
        this.set(brandPart, (BValue)bBrandPart, null);
    }

    public BVmPart getVmPart() {
        return (BVmPart)this.get(vmPart);
    }

    public void setVmPart(BVmPart bVmPart) {
        this.set(vmPart, (BValue)bVmPart, null);
    }

    public BModelPart getModelPart() {
        return (BModelPart)this.get(modelPart);
    }

    public void setModelPart(BModelPart bModelPart) {
        this.set(modelPart, (BValue)bModelPart, null);
    }

    public BModuleList getModuleList() {
        return (BModuleList)this.get(moduleList);
    }

    public void setModuleList(BModuleList bModuleList) {
        this.set(moduleList, (BValue)bModuleList, null);
    }

    public BVector getOtherParts() {
        return (BVector)this.get(otherParts);
    }

    public void setOtherParts(BVector bVector) {
        this.set(otherParts, (BValue)bVector, null);
    }

    public BModuleContent getModuleContent() {
        return (BModuleContent)this.get(moduleContent);
    }

    public void setModuleContent(BModuleContent bModuleContent) {
        this.set(moduleContent, (BValue)bModuleContent, null);
    }

    public boolean getStripLineNumbers() {
        return this.getBoolean(stripLineNumbers);
    }

    public void setStripLineNumbers(boolean bl) {
        this.setBoolean(stripLineNumbers, bl, null);
    }

    public int getMaxStations() {
        return this.getInt(maxStations);
    }

    public void setMaxStations(int n) {
        this.setInt(maxStations, n, null);
    }

    public int getMaxSedonaApps() {
        return this.getInt(maxSedonaApps);
    }

    public void setMaxSedonaApps(int n) {
        this.setInt(maxSedonaApps, n, null);
    }

    public BTimeZone getOsTimeZone() {
        return (BTimeZone)this.get(osTimeZone);
    }

    public void setOsTimeZone(BTimeZone bTimeZone) {
        this.set(osTimeZone, (BValue)bTimeZone, null);
    }

    public boolean getAllowStationRestart() {
        return this.getBoolean(allowStationRestart);
    }

    public void setAllowStationRestart(boolean bl) {
        this.setBoolean(allowStationRestart, bl, null);
    }

    public String getConfigDistFileName() {
        return this.getString(configDistFileName);
    }

    public void setConfigDistFileName(String string) {
        this.setString(configDistFileName, string, null);
    }

    public boolean getIsNpsdk() {
        return this.getBoolean(isNpsdk);
    }

    public void setIsNpsdk(boolean bl) {
        this.setBoolean(isNpsdk, bl, null);
    }

    public boolean getSedonaSupported() {
        return this.getBoolean(sedonaSupported);
    }

    public void setSedonaSupported(boolean bl) {
        this.setBoolean(sedonaSupported, bl, null);
    }

    public boolean getSedonaEnabled() {
        return this.getBoolean(sedonaEnabled);
    }

    public void setSedonaEnabled(boolean bl) {
        this.setBoolean(sedonaEnabled, bl, null);
    }

    public boolean getNiagaraStationsEnabled() {
        return this.getBoolean(niagaraStationsEnabled);
    }

    public void setNiagaraStationsEnabled(boolean bl) {
        this.setBoolean(niagaraStationsEnabled, bl, null);
    }

    public boolean getNiagaraR2Supported() {
        return this.getBoolean(niagaraR2Supported);
    }

    public void setNiagaraR2Supported(boolean bl) {
        this.setBoolean(niagaraR2Supported, bl, null);
    }

    public boolean getNiagaraR2Enabled() {
        return this.getBoolean(niagaraR2Enabled);
    }

    public void setNiagaraR2Enabled(boolean bl) {
        this.setBoolean(niagaraR2Enabled, bl, null);
    }

    public boolean getPlatformSSLSupported() {
        return this.getBoolean(platformSSLSupported);
    }

    public void setPlatformSSLSupported(boolean bl) {
        this.setBoolean(platformSSLSupported, bl, null);
    }

    public BPlatformSSLSettings getPlatformSSLSettings() {
        return (BPlatformSSLSettings)this.get(platformSSLSettings);
    }

    public void setPlatformSSLSettings(BPlatformSSLSettings bPlatformSSLSettings) {
        this.set(platformSSLSettings, (BValue)bPlatformSSLSettings, null);
    }

    public void checkSession() {
        this.invoke(checkSession, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BPart getPart(String string, BTypeSpec bTypeSpec) {
        try {
            return this.getPart(string, bTypeSpec, null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public final BPart getPart(BPart bPart) {
        return this.getPart(bPart.getPartName(), bPart.getType().getTypeSpec());
    }

    public final BPart getPart(BDependency bDependency) {
        return this.getPart(bDependency.getPartName(), bDependency.getPartTypeSpec());
    }

    public final BDaemonSession getDaemonSession() {
        if (!this.localInstance) {
            throw new IllegalStateException("illegal call on proxy instance of BDaemonPlatform");
        }
        return this.session;
    }

    public boolean meets(BDependency bDependency) {
        BPart bPart = this.getPart(bDependency);
        boolean bl = false;
        if (bPart != null) {
            bl = bPart.meets(bDependency);
        }
        return bl;
    }

    protected final void init() throws ConnectException, AuthenticationException {
        this.init(null);
    }

    protected void init(DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        BPlatformSSLSettings bPlatformSSLSettings;
        BDaemonSession bDaemonSession = this.getDaemonSession();
        if (bDaemonSession == null) {
            return;
        }
        if (bDaemonSession.getHostProperties().getHostId().trim().length() == 0) {
            bDaemonSession.reloadHostProperties();
        }
        try {
            BTimeZone bTimeZone = DaemonTimeUtil.getOsTimeZone(bDaemonSession);
            if (bTimeZone != null) {
                this.setOsTimeZone(bTimeZone);
            }
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        this.daemonTimestamp = bDaemonSession.getHostProperties().getSessionTimestamp();
        this.setModuleContent(bDaemonSession.getHostProperties().getModuleContent());
        this.setStripLineNumbers(bDaemonSession.getHostProperties().getStripLineNumbers());
        this.setMaxStations(bDaemonSession.getHostProperties().getMaxStations());
        this.setMaxSedonaApps(bDaemonSession.getHostProperties().getMaxSedonaApps());
        this.setSedonaSupported(bDaemonSession.getHostProperties().getSedonaSupported());
        this.setSedonaEnabled(bDaemonSession.getHostProperties().getSedonaEnabled());
        this.setNiagaraStationsEnabled(bDaemonSession.getHostProperties().getNiagaraStationsEnabled());
        this.setAllowStationRestart(bDaemonSession.getHostProperties().getAllowStationRestart());
        this.setNiagaraR2Supported(bDaemonSession.getHostProperties().getNiagaraR2Supported());
        boolean bl = false;
        if (bDaemonSession.getHostProperties().getNiagaraR2Supported() && BDaemonDirectoryStore.make(bDaemonSession.getFileSpace(), new FilePath("/niagara/niagaraR2")) != null && bDaemonSession.getHostProperties().getNiagaraR2Enabled()) {
            bl = true;
        }
        this.setNiagaraR2Enabled(bl);
        this.setPlatformSSLSupported(bDaemonSession.getHostProperties().getSslSupported());
        if (bDaemonSession.getHostProperties().getSslSupported()) {
            bPlatformSSLSettings = bDaemonSession.getHostProperties().getSslSettings();
            this.setPlatformSSLSettings(new BPlatformSSLSettings(bPlatformSSLSettings));
        }
        this.setHostName(bDaemonSession.getRemoteHost().getHostname());
        if (bDaemonSession.getHostProperties().getHttpPort() != -1) {
            this.setPort(bDaemonSession.getHostProperties().getHttpPort());
        } else {
            this.setPort(bDaemonSession.getRemotePort());
        }
        this.setHostId(bDaemonSession.getHostProperties().getHostId());
        this.setArchPart(new BArchPart(bDaemonSession.getHostProperties().getHostArch(), null));
        if (bDaemonSession.getHostProperties().getIsVmUnspecified()) {
            this.setVmPart(new BVmPart());
        } else if (bDaemonSession.getHostProperties().getVmName().equals("unknown")) {
            this.setVmPart(BVmPart.makeNull());
        } else {
            this.setVmPart(new BVmPart(bDaemonSession.getHostProperties().getVmName(), new BVersion(bDaemonSession.getHostProperties().getVmVendor(), bDaemonSession.getHostProperties().getVmVersion()), null));
        }
        this.setModelPart(new BModelPart(bDaemonSession.getHostProperties().getModelName(), null));
        this.setOsPart(new BOsPart(bDaemonSession.getHostProperties().getOsName(), bDaemonSession.getHostProperties().getOsDesc(), new BVersion(null, bDaemonSession.getHostProperties().getOsVersion()), null, bDaemonSession.getHostProperties().getOsInstallable()));
        if (bDaemonSession.getHostProperties().getNrePartDesc().equals("unknown") || bDaemonSession.getHostProperties().getNrePartName().indexOf("-???") != -1) {
            this.setNrePart(BNrePart.makeNull());
        } else {
            this.setNrePart(new BNrePart(bDaemonSession.getHostProperties().getNrePartName(), bDaemonSession.getHostProperties().getNrePartDesc(), new BVersion(null, bDaemonSession.getHostProperties().getNrePartVersion()), null));
        }
        this.setBrandPart(new BBrandPart(bDaemonSession.getHostProperties().getBrandId(), null));
        this.getOtherParts().removeAll();
        bPlatformSSLSettings = bDaemonSession.getHostProperties().getParts().getProperties();
        while (bPlatformSSLSettings.next()) {
            this.getOtherParts().add(bPlatformSSLSettings.property().getName(), (BValue)((BPart)((BPart)bPlatformSSLSettings.get()).newCopy()));
        }
        this.setConfigDistFileName(bDaemonSession.getHostProperties().getConfigDistFileName());
        this.setIsNpsdk(bDaemonSession.getHostProperties().getIsNpsdk());
        this.sessionInvalid = false;
    }

    public final void checkSession(DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.doCheckSession(daemonSessionTaskListener);
    }

    public final void doCheckSession() throws ConnectException, AuthenticationException {
        this.doCheckSession(null);
    }

    public void doCheckSession(DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        if (!this.localInstance) {
            return;
        }
        if (this.getDaemonSession() == null || !this.getDaemonSession().getHostProperties().getSessionTimestamp().equals(this.daemonTimestamp) || this.sessionInvalid) {
            this.init(daemonSessionTaskListener);
        }
    }

    public void requestReload() {
        this.sessionInvalid = true;
    }

    public BPart getPart(String string, BTypeSpec bTypeSpec, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        this.checkSession(daemonSessionTaskListener);
        if (bTypeSpec == null) {
            return this.getPartCompat(string, daemonSessionTaskListener);
        }
        BPart bPart = null;
        if (bTypeSpec.equals((Object)BArchPart.TYPE.getTypeSpec())) {
            bPart = this.getArchPart();
        } else if (bTypeSpec.equals((Object)BOsPart.TYPE.getTypeSpec())) {
            bPart = this.getOsPart();
        } else if (bTypeSpec.equals((Object)BBrandPart.TYPE.getTypeSpec())) {
            bPart = this.getBrandPart();
        } else if (bTypeSpec.equals((Object)BModelPart.TYPE.getTypeSpec())) {
            bPart = this.getModelPart();
        } else if (bTypeSpec.equals((Object)BNrePart.TYPE.getTypeSpec())) {
            bPart = this.getNrePart();
        } else if (bTypeSpec.equals((Object)BVmPart.TYPE.getTypeSpec())) {
            bPart = this.getVmPart();
        } else {
            if (bTypeSpec.equals((Object)BModulePart.TYPE.getTypeSpec())) {
                BModuleList bModuleList = this.getModuleList();
                bModuleList.init(daemonSessionTaskListener);
                return bModuleList.getPart(string);
            }
            bPart = (BPart)this.getOtherParts().get(SlotPath.escape((String)string));
        }
        if (bPart != null && bPart.matchesName(string)) {
            return bPart;
        }
        return null;
    }

    public BPart getSingleModulePart(String string, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        BModuleList bModuleList = this.getModuleList();
        if (string != null && string.equalsIgnoreCase("baja") && bModuleList instanceof BRemoteModuleList) {
            BRemoteModuleList bRemoteModuleList = (BRemoteModuleList)bModuleList;
            try {
                XElem xElem;
                XElem[] xElemArray = bRemoteModuleList.fetchModules(string);
                if (xElemArray.length == 1 && (xElem = xElemArray[0]) != null && (xElem = xElem.elem("module")) != null) {
                    String string2 = null;
                    string2 = xElem.get("name", null);
                    if (string2 != null && string2.equalsIgnoreCase("baja")) {
                        return BModulePart.make(string2, xElem);
                    }
                }
                if (bRemoteModuleList != null) {
                    bRemoteModuleList.setModuleElems(xElemArray);
                }
            }
            catch (Exception exception) {}
        }
        bModuleList.init(daemonSessionTaskListener);
        return bModuleList.getPart(string);
    }

    protected BPart getPartCompat(String string, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        if (!this.getArchPart().isNull() && this.getArchPart().matchesName(string)) {
            return this.getArchPart();
        }
        if (!this.getOsPart().isNull() && this.getOsPart().matchesName(string)) {
            return this.getOsPart();
        }
        if (!this.getBrandPart().isNull() && this.getBrandPart().matchesName(string)) {
            return this.getBrandPart();
        }
        if (!this.getModelPart().isNull() && this.getModelPart().matchesName(string)) {
            return this.getModelPart();
        }
        if (!this.getNrePart().isNull() && this.getNrePart().matchesName(string)) {
            return this.getNrePart();
        }
        BPart bPart = (BPart)this.getOtherParts().get(SlotPath.escape((String)string));
        if (bPart != null) {
            return bPart;
        }
        if (this.getVmPart().matchesName(string)) {
            return this.getVmPart();
        }
        this.getModuleList().init(daemonSessionTaskListener);
        return this.getModuleList().getPart(string);
    }

    public BIcon getIcon() {
        if (icon == null) {
            icon = BIcon.std((String)"daemon.png");
        }
        return icon;
    }

    public String getNavDescription(Context context) {
        return this.getLexicon().getText("DaemonPlatform.navDescription", new Object[]{this.getHostName()});
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sessionInvalid = false;
        this.localInstance = false;
    }

    public BDaemonPlatform() {
        this.this();
    }

    public BDaemonPlatform(BDaemonSession bDaemonSession) {
        this.this();
        this.session = bDaemonSession;
        this.localInstance = true;
    }

    static {
        Class clazz = class$com$tridium$install$BDaemonPlatform;
        if (clazz == null) {
            clazz = class$com$tridium$install$BDaemonPlatform = BDaemonPlatform.class("[Lcom.tridium.install.BDaemonPlatform;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

