/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.alarm.BSourceState;
import javax.baja.sys.BBitString;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BAlarmTransitionBits
extends BBitString {
    public static final int TO_OFFNORMAL = 1;
    public static final int TO_FAULT = 2;
    public static final int TO_NORMAL = 4;
    public static final int TO_ALERT = 8;
    public static final BAlarmTransitionBits toOffnormal = new BAlarmTransitionBits(1);
    public static final BAlarmTransitionBits toFault = new BAlarmTransitionBits(2);
    public static final BAlarmTransitionBits toNormal = new BAlarmTransitionBits(4);
    public static final BAlarmTransitionBits toAlert = new BAlarmTransitionBits(8);
    public static final String SHOW_OFF_NORMAL = "showOffNormal";
    public static final String SHOW_NORMAL = "showNormal";
    public static final String SHOW_FAULT = "showFault";
    public static final String SHOW_ALERT = "showAlert";
    public static final BAlarmTransitionBits DEFAULT = new BAlarmTransitionBits(15);
    public static final BAlarmTransitionBits EMPTY = new BAlarmTransitionBits(0);
    public static final BAlarmTransitionBits ALL = DEFAULT;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private int bits;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmTransitionBits;

    public static final BAlarmTransitionBits make(boolean bl) {
        if (bl) {
            return ALL;
        }
        return EMPTY;
    }

    public static final BAlarmTransitionBits make(int n) {
        if (n == BAlarmTransitionBits.ALL.bits) {
            return ALL;
        }
        if (n == BAlarmTransitionBits.EMPTY.bits) {
            return EMPTY;
        }
        return new BAlarmTransitionBits(n);
    }

    public static final BAlarmTransitionBits make(BAlarmTransitionBits bAlarmTransitionBits, BAlarmTransitionBits bAlarmTransitionBits2, boolean bl) {
        if (bl) {
            return new BAlarmTransitionBits(bAlarmTransitionBits.getBits() | bAlarmTransitionBits2.getBits());
        }
        return new BAlarmTransitionBits(bAlarmTransitionBits.getBits() & ~bAlarmTransitionBits2.getBits());
    }

    public final int getBits() {
        return this.bits;
    }

    public final boolean includes(BSourceState bSourceState) {
        if (bSourceState == BSourceState.offnormal) {
            return this.isToOffnormal();
        }
        if (bSourceState == BSourceState.fault) {
            return this.isToFault();
        }
        if (bSourceState == BSourceState.normal) {
            return this.isToNormal();
        }
        if (bSourceState == BSourceState.alert) {
            return this.isToAlert();
        }
        return false;
    }

    public final boolean isToOffnormal() {
        boolean bl = false;
        if ((this.bits & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isToFault() {
        boolean bl = false;
        if ((this.bits & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isToNormal() {
        boolean bl = false;
        if ((this.bits & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isToAlert() {
        boolean bl = false;
        if ((this.bits & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean getBit(int n) {
        boolean bl = false;
        if ((this.bits & n) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean getBit(String string) {
        return this.getBit(this.tagToOrdinal(string));
    }

    public final int[] getOrdinals() {
        return support.getOrdinals();
    }

    public final boolean isOrdinal(int n) {
        return support.isOrdinal(n);
    }

    public final String getTag(int n) {
        return support.getTag(n);
    }

    public final String getDisplayTag(int n, Context context) {
        return support.getDisplayTag(n, context);
    }

    public final BBitString getInstance(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n |= nArray[n2];
            ++n2;
        }
        return BAlarmTransitionBits.make(n);
    }

    public final boolean isTag(String string) {
        return support.isTag(string);
    }

    public final int tagToOrdinal(String string) {
        return support.tagToOrdinal(string);
    }

    public final boolean isEmpty() {
        boolean bl = false;
        if (this.bits == 0) {
            bl = true;
        }
        return bl;
    }

    public final String getEmptyTag() {
        return "none";
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.bits == 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.bits;
    }

    public final boolean equals(Object object) {
        if (object instanceof BAlarmTransitionBits) {
            boolean bl = false;
            if (((BAlarmTransitionBits)((Object)object)).bits == this.bits) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final String toString(Context context) {
        BFacets bFacets = null;
        if (context != null) {
            bFacets = context.getFacets();
        }
        if (this.bits == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (this.isToAlert() && (bFacets == null || bFacets.getb(SHOW_ALERT, true))) {
            stringBuffer.append("alert ");
        }
        if (this.isToOffnormal() && (bFacets == null || bFacets.getb(SHOW_OFF_NORMAL, true))) {
            stringBuffer.append("toOffnormal ");
        }
        if (this.isToFault() && (bFacets == null || bFacets.getb(SHOW_FAULT, true))) {
            stringBuffer.append("toFault ");
        }
        if (this.isToNormal() && (bFacets == null || bFacets.getb(SHOW_NORMAL, true))) {
            stringBuffer.append("toNormal ");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
        return stringBuffer.toString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.bits);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BAlarmTransitionBits.make(dataInput.readInt());
    }

    public final String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BAlarmTransitionBits.make(Integer.parseInt(string, 16));
        }
        catch (Exception exception) {
            throw new IOException("Invalid bits: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BAlarmTransitionBits(int n) {
        this.bits = n;
    }

    static {
        support.add(1, "toOffnormal");
        support.add(2, "toFault");
        support.add(4, "toNormal");
        support.add(8, "toAlert");
        Class clazz = class$javax$baja$alarm$BAlarmTransitionBits;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmTransitionBits = BAlarmTransitionBits.class("[Ljavax.baja.alarm.BAlarmTransitionBits;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

