/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.BAlarmExtStatusJob;
import com.tridium.alarm.BIUpdatableAlarmSource;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.BPlatformServiceSourceState;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.sys.station.Station;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BIRemoteAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySourceService;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Version;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmService
extends BComponent
implements BIService,
BIAlarmClassFolder,
BIDataRecoverySourceService {
    public static final Property capacity = BAlarmService.newProperty((int)0, (int)500, (BFacets)BFacets.makeInt((BUnit)BUnit.make((String)"records", (BDimension)BDimension.DEFAULT), (int)1, (int)250000));
    public static final Property defaultAlarmClass = BAlarmService.newProperty((int)0, (BValue)new BAlarmClass(), null);
    public static final Property masterAlarmInstructions = BAlarmService.newProperty((int)0, (BValue)BAlarmInstructions.make(""), null);
    public static final Property escalationTimeTrigger = BAlarmService.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)1))), null);
    public static final Property coalesceAlarms = BAlarmService.newProperty((int)0, (boolean)BBoolean.TRUE.getBoolean(), null);
    public static final Action routeAlarm = BAlarmService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action ackAlarm = BAlarmService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action enableToOffnormal = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action disableToOffnormal = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action enableToFault = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action disableToFault = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action auditForceClear = BAlarmService.newAction((int)2052, (BValue)new BAlarmRecord(), null);
    public static final Action escalateAlarms = BAlarmService.newAction((int)2068, null);
    public static final Topic alarm = BAlarmService.newTopic((int)8, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static final BIcon icon;
    public static final Log logger;
    HashMap alarmClassDisplayNames;
    private Version remoteVersion;
    private PlatformServiceListener listener;
    private BAlarmDatabase alarmDb;
    private Queue alarmQueue;
    private Worker alarmWorker;
    private Station.SaveListener saveListener;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmService;
    static /* synthetic */ Class class$com$tridium$platform$BPlatformService;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmClass;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmClassFolder;

    public int getCapacity() {
        return this.getInt(capacity);
    }

    public void setCapacity(int n) {
        this.setInt(capacity, n, null);
    }

    public BAlarmClass getDefaultAlarmClass() {
        return (BAlarmClass)this.get(defaultAlarmClass);
    }

    public void setDefaultAlarmClass(BAlarmClass bAlarmClass) {
        this.set(defaultAlarmClass, (BValue)bAlarmClass, null);
    }

    public BAlarmInstructions getMasterAlarmInstructions() {
        return (BAlarmInstructions)this.get(masterAlarmInstructions);
    }

    public void setMasterAlarmInstructions(BAlarmInstructions bAlarmInstructions) {
        this.set(masterAlarmInstructions, (BValue)bAlarmInstructions, null);
    }

    public BTimeTrigger getEscalationTimeTrigger() {
        return (BTimeTrigger)this.get(escalationTimeTrigger);
    }

    public void setEscalationTimeTrigger(BTimeTrigger bTimeTrigger) {
        this.set(escalationTimeTrigger, (BValue)bTimeTrigger, null);
    }

    public boolean getCoalesceAlarms() {
        return this.getBoolean(coalesceAlarms);
    }

    public void setCoalesceAlarms(boolean bl) {
        this.setBoolean(coalesceAlarms, bl, null);
    }

    public void routeAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(routeAlarm, (BValue)bAlarmRecord, null);
    }

    public void ackAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public BOrd enableToOffnormal(BVector bVector) {
        return (BOrd)this.invoke(enableToOffnormal, (BValue)bVector, null);
    }

    public BOrd disableToOffnormal(BVector bVector) {
        return (BOrd)this.invoke(disableToOffnormal, (BValue)bVector, null);
    }

    public BOrd enableToFault(BVector bVector) {
        return (BOrd)this.invoke(enableToFault, (BValue)bVector, null);
    }

    public BOrd disableToFault(BVector bVector) {
        return (BOrd)this.invoke(disableToFault, (BValue)bVector, null);
    }

    public void auditForceClear(BAlarmRecord bAlarmRecord) {
        this.invoke(auditForceClear, (BValue)bAlarmRecord, null);
    }

    public void escalateAlarms() {
        this.invoke(escalateAlarms, null, null);
    }

    public void fireAlarm(BAlarmRecord bAlarmRecord) {
        this.fire(alarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        BPlatformServiceContainer bPlatformServiceContainer;
        try {
            bPlatformServiceContainer = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
            Class clazz = class$com$tridium$platform$BPlatformService;
            if (clazz == null) {
                clazz = class$com$tridium$platform$BPlatformService = BAlarmService.class("[Lcom.tridium.platform.BPlatformService;", false);
            }
            BPlatformService[] bPlatformServiceArray = (BPlatformService[])bPlatformServiceContainer.getChildren(clazz);
            int n = 0;
            while (n < bPlatformServiceArray.length) {
                if (bPlatformServiceArray[n] instanceof BIAlarmablePlatformService) {
                    ((BIAlarmablePlatformService)bPlatformServiceArray[n]).addPlatformServiceAlarmListener((PlatformServiceAlarmListener)this.listener);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            logger.error("Cannot setup alarming for platform service\n  " + exception);
        }
        if (this.alarmWorker == null) {
            this.alarmWorker = new Worker((Worker.ITodo)this.alarmQueue);
            this.alarmWorker.start("Alarm:ServiceWorker");
        }
        this.initAlarmDb();
        bPlatformServiceContainer = BFoxChannelRegistry.getPrototype();
        if (bPlatformServiceContainer.get("alarmdb") == null) {
            bPlatformServiceContainer.add("alarmdb", (BValue)new BAlarmDbChannel());
        }
        Station.addSaveListener((Station.SaveListener)this.saveListener);
    }

    public void atSteadyState() {
    }

    public void serviceStopped() throws Exception {
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        this.alarmWorker.stop();
        BFoxChannelRegistry bFoxChannelRegistry = BFoxChannelRegistry.getPrototype();
        if (bFoxChannelRegistry.get("alarmdb") != null) {
            bFoxChannelRegistry.remove("alarmdb");
        }
        this.alarmDb.close();
        this.alarmDb = null;
        BPlatformServiceContainer bPlatformServiceContainer = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        Class clazz = class$com$tridium$platform$BPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platform$BPlatformService = BAlarmService.class("[Lcom.tridium.platform.BPlatformService;", false);
        }
        BPlatformService[] bPlatformServiceArray = (BPlatformService[])bPlatformServiceContainer.getChildren(clazz);
        int n = 0;
        while (n < bPlatformServiceArray.length) {
            if (bPlatformServiceArray[n] instanceof BIAlarmablePlatformService) {
                ((BIAlarmablePlatformService)bPlatformServiceArray[n]).removePlatformServiceAlarmListener((PlatformServiceAlarmListener)this.listener);
            }
            ++n;
        }
    }

    public void initDataRecoverySource(BIDataRecoveryService bIDataRecoveryService) {
        if (this.alarmWorker == null) {
            this.alarmWorker = new Worker((Worker.ITodo)this.alarmQueue);
            this.alarmWorker.start("Alarm:ServiceWorker");
        }
        this.initAlarmDb();
    }

    private final void initAlarmDb() {
        if (this.alarmDb == null) {
            this.alarmDb = this.createAlarmDb();
            try {
                this.updateDbCapacity(this.alarmDb);
                this.alarmDb.open();
            }
            catch (Exception exception) {
                logger.error("Cannot open alarm database.", (Throwable)exception);
            }
        }
    }

    public final BAlarmDatabase getAlarmDb() {
        if (this.alarmDb == null) {
            throw new AlarmException("Alarm database is not open.");
        }
        return this.alarmDb;
    }

    protected BAlarmDatabase createAlarmDb() {
        return new BFileAlarmDatabase();
    }

    private final void updateDbCapacity(BAlarmDatabase bAlarmDatabase) throws Exception {
        try {
            Method method = ((Object)((Object)bAlarmDatabase)).getClass().getMethod("setCapacity", Integer.TYPE);
            method.invoke((Object)bAlarmDatabase, new Integer(this.getCapacity()));
        }
        catch (Exception exception) {
            logger.trace("Alarm database capacity could not be updated.");
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)escalateAlarms)) {
            this.alarmQueue.enqueue((Object)new Invocation((BComponent)this, action, null, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    public void doEscalateAlarms() {
        if (!this.isRunning()) {
            return;
        }
        try {
            Object object;
            Object object2;
            BAlarmClass.log.trace("Escalating");
            BAlarmClass[] bAlarmClassArray = this.getAlarmClasses();
            BAlarmDatabase bAlarmDatabase = this.getAlarmDb();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("alarm:|bql:select from openAlarms ");
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < bAlarmClassArray.length) {
                if (bAlarmClassArray[n2].getEscalationLevel1Enabled() || bAlarmClassArray[n2].getEscalationLevel2Enabled() || bAlarmClassArray[n2].getEscalationLevel3Enabled()) {
                    bl = true;
                    if (n++ != 0) {
                        stringBuffer.append("or ");
                    } else {
                        stringBuffer.append("where (");
                    }
                    stringBuffer.append("alarmClass='");
                    stringBuffer.append(SlotPath.escape((String)bAlarmClassArray[n2].getName()));
                    stringBuffer.append("' ");
                }
                ++n2;
            }
            if (n > 0) {
                stringBuffer.append(")");
            }
            if (!bl) {
                return;
            }
            BITable bITable = (BITable)BOrd.make((String)stringBuffer.toString()).get((BObject)this);
            Cursor cursor = bITable.cursor();
            Hashtable<BUuid, BValue> hashtable = new Hashtable<BUuid, BValue>();
            while (cursor.next()) {
                object2 = (BAlarmRecord)cursor.get();
                if (((BAlarmRecord)((Object)object2)).getAckState() != BAckState.unacked) continue;
                object = this.lookupAlarmClass(((BAlarmRecord)((Object)object2)).getAlarmClass());
                if (((BAlarmClass)((Object)object)).getEscalationLevel1Enabled() && ((BAlarmRecord)((Object)object2)).getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)""))) {
                    if (!((BAlarmRecord)((Object)object2)).getTimestamp().add(((BAlarmClass)((Object)object)).getEscalationLevel1Delay()).isBefore(BAbsTime.now())) continue;
                    ((BAlarmRecord)((Object)object2)).addAlarmFacet(BAlarmClass.ESCALATED, (BIDataValue)BString.make((String)BAlarmClass.LEVEL_1));
                    hashtable.put(((BAlarmRecord)((Object)object2)).getUuid(), object2.newCopy());
                    continue;
                }
                if (((BAlarmClass)((Object)object)).getEscalationLevel2Enabled() && (((BAlarmRecord)((Object)object2)).getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)BAlarmClass.LEVEL_1)) || ((BAlarmRecord)((Object)object2)).getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)"")))) {
                    if (!((BAlarmRecord)((Object)object2)).getTimestamp().add(((BAlarmClass)((Object)object)).getEscalationLevel2Delay()).isBefore(BAbsTime.now())) continue;
                    ((BAlarmRecord)((Object)object2)).addAlarmFacet(BAlarmClass.ESCALATED, (BIDataValue)BString.make((String)BAlarmClass.LEVEL_2));
                    hashtable.put(((BAlarmRecord)((Object)object2)).getUuid(), object2.newCopy());
                    BAlarmClass.log.trace("Escalating " + ((BAlarmRecord)((Object)object2)).getUuid() + " to level 2");
                    continue;
                }
                if (!((BAlarmClass)((Object)object)).getEscalationLevel3Enabled() || !((BAlarmRecord)((Object)object2)).getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)BAlarmClass.LEVEL_2)) && !((BAlarmRecord)((Object)object2)).getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)BAlarmClass.LEVEL_1)) && !((BAlarmRecord)((Object)object2)).getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)"")) || !((BAlarmRecord)((Object)object2)).getTimestamp().add(((BAlarmClass)((Object)object)).getEscalationLevel3Delay()).isBefore(BAbsTime.now())) continue;
                ((BAlarmRecord)((Object)object2)).addAlarmFacet(BAlarmClass.ESCALATED, (BIDataValue)BString.make((String)BAlarmClass.LEVEL_3));
                hashtable.put(((BAlarmRecord)((Object)object2)).getUuid(), object2.newCopy());
                BAlarmClass.log.trace("Escalating " + ((BAlarmRecord)((Object)object2)).getUuid() + " to level 3");
            }
            object2 = hashtable.elements();
            while (object2.hasMoreElements()) {
                object = (BAlarmRecord)((Object)object2.nextElement());
                bAlarmDatabase.update((BAlarmRecord)((Object)object));
                BAlarmClass bAlarmClass = this.lookupAlarmClass(object.getAlarmClass());
                if (object.getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)BAlarmClass.LEVEL_1))) {
                    bAlarmClass.fireAlarm((BAlarmRecord)((Object)object));
                    bAlarmClass.fireEscalatedAlarm1((BAlarmRecord)((Object)object));
                    continue;
                }
                if (object.getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)BAlarmClass.LEVEL_2))) {
                    bAlarmClass.fireAlarm((BAlarmRecord)((Object)object));
                    bAlarmClass.fireEscalatedAlarm1((BAlarmRecord)((Object)object));
                    bAlarmClass.fireEscalatedAlarm2((BAlarmRecord)((Object)object));
                    continue;
                }
                if (!object.getAlarmData().get(BAlarmClass.ESCALATED).equals((Object)BString.make((String)BAlarmClass.LEVEL_3))) continue;
                bAlarmClass.fireAlarm((BAlarmRecord)((Object)object));
                bAlarmClass.fireEscalatedAlarm1((BAlarmRecord)((Object)object));
                bAlarmClass.fireEscalatedAlarm2((BAlarmRecord)((Object)object));
                bAlarmClass.fireEscalatedAlarm3((BAlarmRecord)((Object)object));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BObject bObject = null;
        try {
            bObject = this.resolveAlarmSource(bAlarmRecord);
        }
        catch (UnresolvedException unresolvedException) {}
        if (bObject != null && bObject instanceof BIRemoteAlarmSource) {
            this.doRouteToSource(bAlarmRecord, bObject);
        } else if (bAlarmRecord.getAckRequired()) {
            this.doRouteToSource(bAlarmRecord, bObject);
        } else {
            bAlarmRecord.setAckState(BAckState.acked);
            this.doRouteToRecipient(bAlarmRecord);
        }
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        if (!this.isRunning()) {
            return;
        }
        logger.trace("BAlarmService.doRouteAlarm: " + (Object)((Object)bAlarmRecord.getSourceState()) + ' ' + (Object)((Object)bAlarmRecord.getAckState()) + ' ' + bAlarmRecord.getTimestamp() + ' ' + bAlarmRecord.getAlarmClass());
        this.doRouteToRecipient(bAlarmRecord);
    }

    public void doRouteToRecipient(BAlarmRecord bAlarmRecord) {
        BAlarmClass bAlarmClass = this.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        bAlarmClass.routeAlarm(bAlarmRecord);
        this.fireAlarm(bAlarmRecord);
    }

    public void doRouteToSource(BAlarmRecord bAlarmRecord) throws Exception {
        BObject bObject = null;
        try {
            bObject = this.resolveAlarmSource(bAlarmRecord);
        }
        catch (UnresolvedException unresolvedException) {}
        this.doRouteToSource(bAlarmRecord, bObject);
    }

    /*
     * Unable to fully structure code
     */
    public void doRouteToSource(BAlarmRecord var1_1, BObject var2_2) throws Exception {
        block18: {
            block19: {
                var3_3 = true;
                var4_4 = false;
                var5_5 = false;
                if (var1_1.getAckState() == BAckState.ackPending || var1_1.getAckState() == BAckState.acked && var1_1.getAckRequired()) {
                    var5_5 = true;
                }
                if (var2_2 == null) {
                    BAlarmService.logger.error("BAlarmService.doRouteToSource cannot resolve alarm source " + var1_1.getSource());
                    if (var5_5) {
                        var1_1.setAckState(BAckState.acked);
                        var1_1.setAckTime(BAbsTime.now());
                        var1_1.setAckRequired(false);
                        var1_1.addAlarmFacet("autoAcked", (BIDataValue)BString.make((String)("Cannot resolve: " + var1_1.getSource())));
                        this.doRouteToRecipient(var1_1);
                    }
                    return;
                }
                if (var2_2 == null || !var3_3) break block18;
                BAlarmService.logger.trace("BAlarmService.doRouteToSource: " + var2_2);
                if (!(var2_2 instanceof BIAlarmSource)) break block19;
                if (!var5_5) ** GOTO lbl26
                if (((BIAlarmSource)var2_2).ackAlarm(var1_1).getBoolean()) {
                    var4_4 = true;
                }
                if (var2_2 instanceof BIRemoteAlarmSource) {
                    return;
                }
                try {
                    break block18;
lbl26:
                    // 1 sources

                    if (var2_2 instanceof BIUpdatableAlarmSource) {
                        var6_6 = (BIUpdatableAlarmSource)var2_2;
                        var6_6.updateAlarm(var1_1);
                    }
                    break block18;
                }
                catch (Exception var6_7) {
                    if (var6_7 instanceof BajaRuntimeException) {
                        throw (Exception)((BajaRuntimeException)var6_7).getCause();
                    }
                    throw var6_7;
                }
            }
            if (var5_5 && var2_2 instanceof BIAlarmablePlatformService) {
                var7_9 = var1_1.getAlarmTransition();
                if (var7_9 == BSourceState.offnormal) {
                    var6_8 = BPlatformServiceSourceState.offnormal;
                } else if (var7_9 == BSourceState.fault) {
                    var6_8 = BPlatformServiceSourceState.fault;
                } else if (var7_9 == BSourceState.alert) {
                    var6_8 = BPlatformServiceSourceState.alert;
                } else {
                    throw new IllegalStateException();
                }
                var8_10 = var1_1.getSource();
                var9_11 = var8_10.get(var8_10.size() - 1);
                var10_12 = new BPlatformServiceAlarmRecord(var9_11, var1_1.getAlarmClass(), var6_8, var1_1.getAlarmData());
                var10_12.setTimestamp(var1_1.getTimestamp());
                if (((BIAlarmablePlatformService)var2_2).ackAlarm(var10_12).getBoolean()) {
                    var4_4 = true;
                }
                var1_1.setAckState(BAckState.acked);
                var1_1.setAckTime(BAbsTime.now());
                var1_1.setAckRequired(false);
                var1_1.setAlarmClass(var10_12.getAlarmClass());
                this.doRouteToRecipient(var1_1);
            }
        }
    }

    public BOrd doEnableToOffnormal(BVector bVector, Context context) {
        return new BAlarmExtStatusJob(this, bVector, BAlarmTransitionBits.toOffnormal, true).submit(context);
    }

    public BOrd doDisableToOffnormal(BVector bVector, Context context) {
        return new BAlarmExtStatusJob(this, bVector, BAlarmTransitionBits.toOffnormal, false).submit(context);
    }

    public BOrd doEnableToFault(BVector bVector, Context context) {
        return new BAlarmExtStatusJob(this, bVector, BAlarmTransitionBits.toFault, true).submit(context);
    }

    public BOrd doDisableToFault(BVector bVector, Context context) {
        return new BAlarmExtStatusJob(this, bVector, BAlarmTransitionBits.toFault, false).submit(context);
    }

    public void doAuditForceClear(BAlarmRecord bAlarmRecord, Context context) {
        Auditor auditor = Sys.getAuditor();
        if (auditor != null) {
            BUser bUser = context.getUser();
            String string = "";
            if (bUser != null) {
                string = bUser.getUsername();
            }
            bUser.getUsername();
            auditor.audit(new AuditEvent("Force Clear Alarm", bAlarmRecord.getSource().toString(), bAlarmRecord.getUuid().toString(), "", "", string));
        }
    }

    public BAlarmClass[] getAlarmClasses() {
        return this.loadFromFolder(this);
    }

    private final BAlarmClass[] loadFromFolder(BComponent bComponent) {
        Class clazz = class$javax$baja$alarm$BAlarmClass;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmClass = BAlarmService.class("[Ljavax.baja.alarm.BAlarmClass;", false);
        }
        Array array = new Array(clazz);
        bComponent.lease();
        Class clazz2 = class$javax$baja$alarm$BAlarmClass;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$alarm$BAlarmClass = BAlarmService.class("[Ljavax.baja.alarm.BAlarmClass;", false);
        }
        BComponent[] bComponentArray = (BComponent[])bComponent.getChildren(clazz2);
        int n = 0;
        while (n < bComponentArray.length) {
            array.add((Object)bComponentArray[n]);
            ++n;
        }
        Class clazz3 = class$javax$baja$alarm$BAlarmClassFolder;
        if (clazz3 == null) {
            clazz3 = class$javax$baja$alarm$BAlarmClassFolder = BAlarmService.class("[Ljavax.baja.alarm.BAlarmClassFolder;", false);
        }
        BAlarmClassFolder[] bAlarmClassFolderArray = (BAlarmClassFolder[])bComponent.getChildren(clazz3);
        int n2 = 0;
        while (n2 < bAlarmClassFolderArray.length) {
            this.loadFromFolder((BComponent)bAlarmClassFolderArray[n2]);
            BAlarmClass[] bAlarmClassArray = this.loadFromFolder((BComponent)bAlarmClassFolderArray[n2]);
            int n3 = 0;
            while (n3 < bAlarmClassArray.length) {
                array.add((Object)bAlarmClassArray[n3]);
                ++n3;
            }
            ++n2;
        }
        return (BAlarmClass[])array.trim();
    }

    public BAlarmClass lookupAlarmClass(String string) {
        BAlarmClass bAlarmClass = this.lookupAlarmClass(this, string);
        if (bAlarmClass == null) {
            bAlarmClass = this.getDefaultAlarmClass();
            logger.trace("BAlarmService.lookupAlarmClass can't find alarm class <" + string + "> using default <" + bAlarmClass.getName() + '>');
        } else {
            logger.trace("BAlarmService.lookupAlarmClass: will route alarm with " + (Object)((Object)bAlarmClass));
        }
        return bAlarmClass;
    }

    protected BAlarmClass lookupAlarmClass(BComponent bComponent, String string) {
        bComponent.lease();
        Property property = bComponent.getProperty(string);
        if (property == null || !bComponent.get(property).getType().is(BAlarmClass.TYPE)) {
            Class clazz = class$javax$baja$alarm$BAlarmClassFolder;
            if (clazz == null) {
                clazz = class$javax$baja$alarm$BAlarmClassFolder = BAlarmService.class("[Ljavax.baja.alarm.BAlarmClassFolder;", false);
            }
            BAlarmClassFolder[] bAlarmClassFolderArray = (BAlarmClassFolder[])bComponent.getChildren(clazz);
            int n = 0;
            while (n < bAlarmClassFolderArray.length) {
                BAlarmClass bAlarmClass = this.lookupAlarmClass((BComponent)bAlarmClassFolderArray[n], string);
                if (bAlarmClass != null) {
                    return bAlarmClass;
                }
                ++n;
            }
        } else {
            return (BAlarmClass)bComponent.get(property);
        }
        return null;
    }

    public BString getAlarmClassDisplayName(Object object, Context context) {
        if (Sys.getStation() == null) {
            if (this.remoteVersion == null) {
                try {
                    this.remoteVersion = (Version)((BFoxSession)this.getSession()).fw(404, (Object)"alarm", null, null, null);
                }
                catch (Exception exception) {}
            }
            if (this.remoteVersion != null && !this.remoteVersion.isNull() && this.remoteVersion.compareTo((Object)new Version("3.7.35")) >= 0) {
                try {
                    BString bString = (BString)this.getComponentSpace().fw(109, (Object)this, (Object)"reflect:getAlarmClassDisplayName", (Object)BString.make((String)object.toString()), null);
                    if (bString != null) {
                        return bString;
                    }
                }
                catch (Exception exception) {}
            }
            return BString.make((String)object.toString());
        }
        String string = (String)this.alarmClassDisplayNames.get(object.toString());
        if (string == null) {
            string = this.lookupAlarmClass(object.toString()).getDisplayName(context);
            this.alarmClassDisplayNames.put(object, string);
        }
        return BString.make((String)string);
    }

    private final BObject resolveAlarmSource(BAlarmRecord bAlarmRecord) throws Exception {
        BObject bObject = null;
        BOrdList bOrdList = bAlarmRecord.getSource();
        BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
        logger.trace("BAlarmService::resolveAlarmSource = " + bOrd);
        bObject = bOrd.get((BObject)this);
        logger.trace("  BAlarmService::resolveAlarmSource resolved = " + bObject);
        return bObject;
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        if (this.isRunning() && bValue.getType().is(BAlarmClass.TYPE)) {
            BAlarmClass bAlarmClass = this.lookupAlarmClass(string);
            if (string.equals("defaultAlarmClass") || !bAlarmClass.getName().equals("defaultAlarmClass")) {
                throw new LocalizableRuntimeException("alarm", "DuplicateAlarmClass", (Object[])new String[]{string});
            }
        }
        super.checkAdd(string, bValue, n, bFacets, context);
    }

    public void checkRename(Property property, String string, Context context) {
        if (property.getType().is(BAlarmClass.TYPE)) {
            BAlarmClass bAlarmClass = this.lookupAlarmClass(string);
            if (string.equals("defaultAlarmClass") || !bAlarmClass.getName().equals("defaultAlarmClass")) {
                throw new IllegalNameException("alarm", "DuplicateAlarmClass", (Object[])new String[]{string});
            }
            this.alarmClassDisplayNames.clear();
        }
        super.checkRename(property, string, context);
    }

    public void changed(Property property, Context context) {
        if (property.equals((Object)capacity)) {
            if (this.alarmDb != null) {
                try {
                    this.updateDbCapacity(this.alarmDb);
                }
                catch (Exception exception) {
                    logger.error("Cannot change database capacity to " + this.getCapacity() + '.', (Throwable)exception);
                }
            }
        } else if (property.getName().equals("displayNames")) {
            this.alarmClassDisplayNames.clear();
        }
    }

    public void added(Property property, Context context) {
        if (property.getName().equals("displayNames")) {
            this.alarmClassDisplayNames.clear();
        }
    }

    public void removed(Property property, BValue bValue, Context context) {
        if (property.getName().equals("displayNames")) {
            this.alarmClassDisplayNames.clear();
        }
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("wiresheet:WireSheet");
        return agentList;
    }

    public BIcon getIcon() {
        return icon;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.add(null, (BValue)new BLink(this.getEscalationTimeTrigger().getOrdInSession(), "fireTrigger", "escalateAlarms", true), 6);
                break;
            }
            case 21: {
                if (this.alarmDb == null) break;
                this.alarmDb.fw(n, object, object2, object3, object4);
                break;
            }
            case 601: {
                return this.alarmQueue;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BAlarmService", 2);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.alarmQueue != null) {
            n = this.alarmQueue.size();
        }
        spyWriter.prop((Object)"workInAlarmQueue", (Object)stringBuffer.append(n).toString());
        spyWriter.endProps();
        if (this.alarmWorker != null) {
            this.alarmWorker.spy(spyWriter);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.alarmClassDisplayNames = new HashMap();
        this.remoteVersion = null;
        this.listener = new PlatformServiceListener();
        this.alarmQueue = new CoalesceQueue();
        this.saveListener = new Station.SaveListener(){

            public final void stationSave() {
                try {
                    BAlarmService.this.getAlarmDb().save();
                }
                catch (Exception exception) {
                    BAlarmDatabase.log.error("Alarm database save failed.", (Throwable)exception);
                }
            }

            public final void stationSaveOk() {
            }

            public final void stationSaveFail(String string) {
            }

            public final String toString() {
                return "AlarmService " + BAlarmService.this.getNavOrd();
            }
        };
    }

    public BAlarmService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$alarm$BAlarmService;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmService = BAlarmService.class("[Ljavax.baja.alarm.BAlarmService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.std((String)"alarm.png");
        logger = Log.getLog((String)"alarm");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PlatformServiceListener
    implements PlatformServiceAlarmListener {
        public void platformServiceAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
            BSourceState bSourceState;
            BPlatformServiceSourceState bPlatformServiceSourceState = bPlatformServiceAlarmRecord.getSourceState();
            if (bPlatformServiceSourceState == BPlatformServiceSourceState.normal) {
                this.platformServiceToNormal(bPlatformServiceAlarmRecord);
                return;
            }
            if (bPlatformServiceSourceState == BPlatformServiceSourceState.offnormal) {
                bSourceState = BSourceState.offnormal;
            } else if (bPlatformServiceSourceState == BPlatformServiceSourceState.fault) {
                bSourceState = BSourceState.fault;
            } else if (bPlatformServiceSourceState == BPlatformServiceSourceState.alert) {
                bSourceState = BSourceState.alert;
            } else {
                throw new IllegalStateException();
            }
            BAlarmRecord bAlarmRecord = null;
            try {
                bAlarmRecord = BAlarmService.this.getAlarmDb().getRecord(bPlatformServiceAlarmRecord.getUuid());
            }
            catch (Exception exception) {}
            if (bAlarmRecord == null) {
                bAlarmRecord = new BAlarmRecord(bPlatformServiceAlarmRecord.getSource(), bPlatformServiceAlarmRecord.getAlarmClass(), bPlatformServiceAlarmRecord.getAlarmData());
                bAlarmRecord.setUuid(bPlatformServiceAlarmRecord.getUuid());
                bAlarmRecord.setTimestamp(bPlatformServiceAlarmRecord.getTimestamp());
            }
            bAlarmRecord.setSourceState(bSourceState);
            bAlarmRecord.setAlarmTransition(bSourceState);
            BAlarmService.this.routeAlarm(bAlarmRecord);
        }

        public void platformServiceToNormal(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
            try {
                Cursor cursor = BAlarmService.this.getAlarmDb().getAlarmsForSource(BOrdList.make((BOrd)bPlatformServiceAlarmRecord.getSource()));
                while (cursor.next()) {
                    BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                    if (bAlarmRecord.isNormal()) continue;
                    bAlarmRecord.setAlarmClass(bPlatformServiceAlarmRecord.getAlarmClass());
                    bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (BFacets)bPlatformServiceAlarmRecord.getAlarmData()));
                    bAlarmRecord.setNormalTime(bPlatformServiceAlarmRecord.getTimestamp());
                    bAlarmRecord.setSourceState(BSourceState.normal);
                    BAlarmService.this.routeAlarm((BAlarmRecord)bAlarmRecord.newCopy());
                }
            }
            catch (Exception exception) {
                logger.error("Unable to generate toNormal PlatformServiceAlarm for: " + bPlatformServiceAlarmRecord.getSource(), (Throwable)exception);
            }
        }

        PlatformServiceListener() {
        }
    }
}

