/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BAlarmRecord
extends BStruct {
    public static final Property timestamp = BAlarmRecord.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property uuid = BAlarmRecord.newProperty((int)0, (BValue)BUuid.make(), null);
    public static final Property sourceState = BAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, null);
    public static final Property ackState = BAlarmRecord.newProperty((int)0, (BValue)BAckState.unacked, null);
    public static final Property ackRequired = BAlarmRecord.newProperty((int)0, (boolean)true, null);
    public static final Property source = BAlarmRecord.newProperty((int)8, (BValue)BOrdList.DEFAULT, (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)512)));
    public static final Property alarmClass = BAlarmRecord.newProperty((int)8, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)256)));
    public static final Property priority = BAlarmRecord.newProperty((int)8, (int)0, null);
    public static final Property normalTime = BAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property ackTime = BAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property user = BAlarmRecord.newProperty((int)0, (String)"Unknown User", null);
    public static final Property alarmData = BAlarmRecord.newProperty((int)0, (BValue)BFacets.DEFAULT, (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)1024)));
    public static final Property alarmTransition = BAlarmRecord.newProperty((int)0, (BValue)BSourceState.offnormal, null);
    public static final Property lastUpdate = BAlarmRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Type TYPE;
    private static final int SERIAL_VERSION_ID = 0;
    public static final BFacets TIMESTAMP_FACETS;
    public static final String MSG_TEXT = "msgText";
    public static final String FROM_STATE = "fromState";
    public static final String TO_STATE = "toState";
    public static final String NOTIFY_TYPE = "notifyType";
    public static final String STATUS = "status";
    public static final String NEW_VALUE = "newValue";
    public static final String SETPT_VALUE = "setptValue";
    public static final String ERROR_LIMIT = "errorLimit";
    public static final String DEADBAND = "deadband";
    public static final String COUNT = "Count";
    public static final String HIGH_LIMIT = "highLimit";
    public static final String LOW_LIMIT = "lowLimit";
    public static final String ALARM_VALUE = "alarmValue";
    public static final String OFFNORMAL_VALUE = "offnormalValue";
    public static final String FAULT_VALUE = "faultValue";
    public static final String PRESENT_VALUE = "presentValue";
    public static final String NUMERIC_VALUE = "numericValue";
    public static final String FEEDBACK_VALUE = "feedbackValue";
    public static final String FEEDBACK_NUMERIC = "feedbackNumeric";
    public static final String CONTROLLED_VALUE = "controlledValue";
    public static final String HYPERLINK_ORD = "hyperlinkOrd";
    public static final String SOUND_FILE = "soundFile";
    public static final String ICON = "icon";
    public static final String SOURCE_NAME = "sourceName";
    public static final String NOTES = "notes";
    public static final String INSTRUCTIONS = "instructions";
    public static final String TIME_ZONE = "TimeZone";
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public final BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public final void setTimestamp(BAbsTime bAbsTime) {
        this.set(timestamp, (BValue)bAbsTime, null);
    }

    public final BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public final void setUuid(BUuid bUuid) {
        this.set(uuid, (BValue)bUuid, null);
    }

    public final BSourceState getSourceState() {
        return (BSourceState)this.get(sourceState);
    }

    public final void setSourceState(BSourceState bSourceState) {
        this.set(sourceState, (BValue)bSourceState, null);
    }

    public final BAckState getAckState() {
        return (BAckState)this.get(ackState);
    }

    public final void setAckState(BAckState bAckState) {
        this.set(ackState, (BValue)bAckState, null);
    }

    public final boolean getAckRequired() {
        return this.getBoolean(ackRequired);
    }

    public final void setAckRequired(boolean bl) {
        this.setBoolean(ackRequired, bl, null);
    }

    public final BOrdList getSource() {
        return (BOrdList)this.get(source);
    }

    public final void setSource(BOrdList bOrdList) {
        this.set(source, (BValue)bOrdList, null);
    }

    public final String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public final void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public final int getPriority() {
        return this.getInt(priority);
    }

    public final void setPriority(int n) {
        this.setInt(priority, n, null);
    }

    public final BAbsTime getNormalTime() {
        return (BAbsTime)this.get(normalTime);
    }

    public final void setNormalTime(BAbsTime bAbsTime) {
        this.set(normalTime, (BValue)bAbsTime, null);
    }

    public final BAbsTime getAckTime() {
        return (BAbsTime)this.get(ackTime);
    }

    public final void setAckTime(BAbsTime bAbsTime) {
        this.set(ackTime, (BValue)bAbsTime, null);
    }

    public final String getUser() {
        return this.getString(user);
    }

    public final void setUser(String string) {
        this.setString(user, string, null);
    }

    public final BFacets getAlarmData() {
        return (BFacets)this.get(alarmData);
    }

    public final void setAlarmData(BFacets bFacets) {
        this.set(alarmData, (BValue)bFacets, null);
    }

    public final BSourceState getAlarmTransition() {
        return (BSourceState)this.get(alarmTransition);
    }

    public final void setAlarmTransition(BSourceState bSourceState) {
        this.set(alarmTransition, (BValue)bSourceState, null);
    }

    public final BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public final void setLastUpdate(BAbsTime bAbsTime) {
        this.set(lastUpdate, (BValue)bAbsTime, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isFixedSize() {
        return false;
    }

    public final void ackAlarm() {
        this.ackAlarm(this.getUser());
    }

    public final void ackAlarm(String string) {
        BAbsTime bAbsTime = Clock.time();
        if (this.getAckRequired()) {
            this.setAckState(BAckState.ackPending);
        } else {
            this.setAckState(BAckState.acked);
        }
        this.setUser(string);
        this.setAckTime(bAbsTime);
        this.setLastUpdate(bAbsTime);
    }

    public final boolean isAlarm() {
        boolean bl = false;
        if (this.getSourceState() != BSourceState.normal && this.getAckState() != BAckState.acked) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAcknowledged() {
        boolean bl = false;
        if (this.getAckState() == BAckState.acked) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAckPending() {
        boolean bl = false;
        if (this.getAckState() == BAckState.ackPending) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNormal() {
        boolean bl = false;
        if (this.getSourceState() == BSourceState.normal) {
            bl = true;
        }
        return bl;
    }

    public final boolean isOpen() {
        if (this.getSourceState() == BSourceState.alert && this.getAckState() != BAckState.acked) {
            return true;
        }
        boolean bl = false;
        if (this.getAckState() != BAckState.acked && this.getAckRequired() || this.getSourceState() != BSourceState.normal && this.getSourceState() != BSourceState.alert) {
            bl = true;
        }
        return bl;
    }

    public final void addAlarmFacet(String string, BIDataValue bIDataValue) {
        this.setAlarmData(BFacets.make((BFacets)this.getAlarmData(), (String)string, (BIDataValue)bIDataValue));
    }

    public final BObject getAlarmFacet(String string) {
        return this.getAlarmData().get(string);
    }

    public final BObject getAlarmValue() {
        BObject bObject = this.getAlarmFacet(ALARM_VALUE);
        if (bObject != null) {
            return bObject;
        }
        bObject = this.getAlarmFacet(OFFNORMAL_VALUE);
        if (bObject != null) {
            return bObject;
        }
        return this.getAlarmFacet(FAULT_VALUE);
    }

    public final void removeAlarmFacet(String string) {
        this.setAlarmData(BFacets.makeRemove((BFacets)this.getAlarmData(), (String)string));
    }

    public final String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("timestamp = ");
        stringBuffer.append(this.getTimestamp()).append(", ");
        stringBuffer.append("sourceState = ");
        stringBuffer.append((Object)this.getSourceState()).append(", ");
        stringBuffer.append("ackState = ");
        stringBuffer.append((Object)this.getAckState()).append(", ");
        stringBuffer.append("ackRequired = ");
        stringBuffer.append(this.getAckRequired()).append(", ");
        stringBuffer.append("source = ");
        stringBuffer.append(this.getSource()).append(", ");
        stringBuffer.append("priority = ");
        stringBuffer.append(this.getPriority()).append(", ");
        stringBuffer.append("alarmClass = ");
        stringBuffer.append(this.getAlarmClass()).append(", ");
        return stringBuffer.toString();
    }

    public final String getAlarmClassDisplayName(Context context) {
        if (Sys.getStation() == null) {
            return this.getAlarmClass();
        }
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        return bAlarmService.getAlarmClassDisplayName(BString.make((String)this.getAlarmClass()), context).toString();
    }

    public final int getSerialVersionId() {
        return 0;
    }

    public final void write(DataOutput dataOutput) throws IOException {
        this.getTimestamp().encode(dataOutput);
        this.getUuid().encode(dataOutput);
        this.getSourceState().encode(dataOutput);
        this.getAckState().encode(dataOutput);
        dataOutput.writeBoolean(this.getAckRequired());
        this.getSource().encode(dataOutput);
        dataOutput.writeUTF(this.getAlarmClass());
        dataOutput.writeInt(this.getPriority());
        this.getNormalTime().encode(dataOutput);
        this.getAckTime().encode(dataOutput);
        dataOutput.writeUTF(this.getUser());
        this.getAlarmData().encode(dataOutput);
        this.getAlarmTransition().encode(dataOutput);
        this.getLastUpdate().encode(dataOutput);
    }

    public final void read(DataInput dataInput) throws IOException {
        this.setTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(dataInput));
        this.setUuid((BUuid)BUuid.DEFAULT.decode(dataInput));
        this.setSourceState((BSourceState)BSourceState.normal.decode(dataInput));
        this.setAckState((BAckState)BAckState.acked.decode(dataInput));
        this.setAckRequired(dataInput.readBoolean());
        this.setSource((BOrdList)BOrdList.DEFAULT.decode(dataInput));
        this.setAlarmClass(dataInput.readUTF());
        this.setPriority(dataInput.readInt());
        this.setNormalTime((BAbsTime)BAbsTime.NULL.decode(dataInput));
        this.setAckTime((BAbsTime)BAbsTime.NULL.decode(dataInput));
        this.setUser(dataInput.readUTF());
        this.setAlarmData((BFacets)BFacets.DEFAULT.decode(dataInput));
        this.setAlarmTransition((BSourceState)BSourceState.normal.decode(dataInput));
        this.setLastUpdate((BAbsTime)BAbsTime.NULL.decode(dataInput));
    }

    public final String toSummaryString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.getTimestamp().toString((Context)TIMESTAMP_FACETS));
        stringBuffer.append(": ");
        stringBuffer.append('(').append((Object)this.getAckState()).append(':').append((Object)this.getSourceState()).append(") ");
        stringBuffer.append(this.getUuid());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAlarmRecord() {
        this(BOrd.make((String)""), "defaultAlarmClass", BFacets.DEFAULT);
    }

    public BAlarmRecord(BComponent bComponent, String string, BFacets bFacets) {
        this(BOrd.make((OrdQuery)bComponent.getSlotPath()), string, bFacets);
    }

    public BAlarmRecord(BOrd bOrd, String string, BFacets bFacets) {
        this.setSource(BOrdList.make((BOrd)bOrd));
        this.setAlarmClass(string);
        this.setAlarmData(bFacets);
        BAbsTime bAbsTime = Clock.time();
        this.setUuid(BUuid.make());
        this.setTimestamp(bAbsTime);
        this.setLastUpdate(bAbsTime);
    }

    static {
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BAlarmRecord.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        TIMESTAMP_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    }
}

