/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.util.ArrayList;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTimeRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAlarmRecipient
extends BComponent {
    public static final Property timeRange = BAlarmRecipient.newProperty((int)0, (BValue)new BTimeRange(), null);
    public static final Property daysOfWeek = BAlarmRecipient.newProperty((int)0, (BValue)BDaysOfWeekBits.DEFAULT, null);
    public static final Property transitions = BAlarmRecipient.newProperty((int)0, (BValue)BAlarmTransitionBits.ALL, null);
    public static final Property routeAcks = BAlarmRecipient.newProperty((int)0, (boolean)true, null);
    public static final Action routeAlarmAck = BAlarmRecipient.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action routeAlarm = BAlarmRecipient.newAction((int)8, (BValue)new BAlarmRecord(), null);
    public static final Topic newUnackedAlarm = BAlarmRecipient.newTopic((int)4, null);
    public static final Type TYPE;
    private static final Log logger;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecipient;
    static /* synthetic */ Class class$javax$baja$sys$BLink;

    public BTimeRange getTimeRange() {
        return (BTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BTimeRange bTimeRange) {
        this.set(timeRange, (BValue)bTimeRange, null);
    }

    public BDaysOfWeekBits getDaysOfWeek() {
        return (BDaysOfWeekBits)this.get(daysOfWeek);
    }

    public void setDaysOfWeek(BDaysOfWeekBits bDaysOfWeekBits) {
        this.set(daysOfWeek, (BValue)bDaysOfWeekBits, null);
    }

    public BAlarmTransitionBits getTransitions() {
        return (BAlarmTransitionBits)this.get(transitions);
    }

    public void setTransitions(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(transitions, (BValue)bAlarmTransitionBits, null);
    }

    public boolean getRouteAcks() {
        return this.getBoolean(routeAcks);
    }

    public void setRouteAcks(boolean bl) {
        this.setBoolean(routeAcks, bl, null);
    }

    public void routeAlarmAck(BAlarmRecord bAlarmRecord) {
        this.invoke(routeAlarmAck, (BValue)bAlarmRecord, null);
    }

    public void routeAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(routeAlarm, (BValue)bAlarmRecord, null);
    }

    public void fireNewUnackedAlarm(BAlarmRecord bAlarmRecord) {
        this.fire(newUnackedAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void doRouteAlarm(BAlarmRecord bAlarmRecord) {
        if (this.accept(bAlarmRecord)) {
            this.handleAlarm(bAlarmRecord);
        }
    }

    public void doRouteAlarmAck(BAlarmRecord bAlarmRecord) {
        try {
            ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).doAckAlarm(bAlarmRecord);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            logger.warning("BAlarmRecipient: cannot find AlarmService");
            serviceNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            logger.warning("BAlarmRecipient: cannot resolve alarm source for: " + (Object)((Object)bAlarmRecord));
            exception.printStackTrace();
        }
    }

    public abstract void handleAlarm(BAlarmRecord var1);

    public String[] getSubscribedAlarmClasses() {
        return this.getSubscribedAlarmClasses("alarm");
    }

    public String[] getSubscribedEscalatedAlarmClasses(int n) {
        if (n < 1 || n > 3) {
            return new String[0];
        }
        return this.getSubscribedAlarmClasses("escalatedAlarm" + n);
    }

    /*
     * Unable to fully structure code
     */
    private final String[] getSubscribedAlarmClasses(String var1_1) {
        var2_2 = new ArrayList<String>();
        var3_3 = this.getProperties();
        if (true) ** GOTO lbl25
        do {
            block5: {
                try {
                    var4_4 = (BLink)var3_3.get();
                    if (!var4_4.isActive()) {
                        var4_4.activate();
                    }
                    if (!((var5_6 = var4_4.getSourceComponent()) instanceof BAlarmClass) || !var4_4.getSourceSlotName().equals(var1_1)) ** GOTO lbl21
                    var2_2.add(var5_6.getName());
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        var6_7 = (BAlarmClassFolder)var5_6;
                        var7_8 = var4_4.getSourceSlotName();
                        var4_4 = ((BCompositeTopic)var6_7.get((String)var7_8)).getMirror().link;
                        var5_6 = var4_4.getSourceComponent();
                        if (!(var5_6 instanceof BAlarmClass) || !var4_4.getSourceSlotName().equals(var1_1)) continue;
                        var2_2.add(var5_6.getName());
                        break block5;
lbl21:
                        // 2 sources

                        ** while (var5_6 instanceof BIAlarmClassFolder)
                    }
lbl22:
                    // 1 sources

                }
                catch (Exception var4_5) {
                    BAlarmRecipient.logger.error("alarm:BAlarmRecipient:getSubscribedAlarmClasses " + var4_5.getMessage(), (Throwable)var4_5);
                }
            }
            if ((v0 = BAlarmRecipient.class$javax$baja$sys$BLink) != null) continue;
            v0 = BAlarmRecipient.class("[Ljavax.baja.sys.BLink;", false);
        } while (var3_3.next(v0));
        var4_4 = new String[var2_2.size()];
        return (String[])var2_2.toArray((T[])var4_4);
    }

    public boolean accept(BAlarmRecord bAlarmRecord) {
        BAbsTime bAbsTime = bAlarmRecord.getTimestamp();
        if (!this.getDaysOfWeek().includes(bAbsTime.getWeekday())) {
            return false;
        }
        if (!this.getTimeRange().includes(bAbsTime)) {
            return false;
        }
        if (!this.getTransitions().includes(bAlarmRecord.getSourceState())) {
            return false;
        }
        if (!this.getRouteAcks() && bAlarmRecord.isAcknowledged()) {
            if (bAlarmRecord.getNormalTime().isNull()) {
                return false;
            }
            if (bAlarmRecord.getNormalTime().isBefore(bAlarmRecord.getAckTime())) {
                return false;
            }
        }
        return true;
    }

    public String toString(Context context) {
        if (this.isMounted()) {
            return this.getName();
        }
        return TYPE.getTypeName();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$alarm$BAlarmRecipient;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecipient = BAlarmRecipient.class("[Ljavax.baja.alarm.BAlarmRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        logger = Log.getLog((String)"alarm");
        icon = BIcon.make((String)"module://icons/x16/alarm/alarmRecipient.png");
    }
}

