/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.alarm.BSourceState;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BAlarmPriorities
extends BSimple {
    public static final BAlarmPriorities DEFAULT = new BAlarmPriorities();
    public static final int MAX_PRIORITY = 255;
    public static final int MIN_PRIORITY = 0;
    public static final Type TYPE;
    private int toNormal;
    private int toOffnormal;
    private int toFault;
    private int toAlert;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmPriorities;

    public static final BAlarmPriorities make(int n, int n2, int n3) {
        return new BAlarmPriorities(n, n2, n3, 255);
    }

    public static final BAlarmPriorities make(int n, int n2, int n3, int n4) {
        return new BAlarmPriorities(n, n2, n3, n4);
    }

    public final int getPriority(BSourceState bSourceState) {
        if (bSourceState == BSourceState.offnormal) {
            return this.toOffnormal;
        }
        if (bSourceState == BSourceState.fault) {
            return this.toFault;
        }
        if (bSourceState == BSourceState.normal) {
            return this.toNormal;
        }
        if (bSourceState == BSourceState.alert) {
            return this.toAlert;
        }
        throw new IllegalStateException();
    }

    public final int getToOffnormal() {
        return this.toOffnormal;
    }

    public final int getToNormal() {
        return this.toNormal;
    }

    public final int getToFault() {
        return this.toFault;
    }

    public final int getToAlert() {
        return this.toAlert;
    }

    private final int checkPriority(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalStateException(n + ": not in range 0-255");
        }
        return n;
    }

    public final int hashCode() {
        int n = 23 + this.toOffnormal;
        n = n * 37 + this.toNormal;
        n = n * 37 + this.toFault;
        return n * 37 + this.toAlert;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BAlarmPriorities)) {
            return false;
        }
        BAlarmPriorities bAlarmPriorities = (BAlarmPriorities)((Object)object);
        boolean bl = false;
        if (this.toOffnormal == bAlarmPriorities.getToOffnormal() && this.toNormal == bAlarmPriorities.getToNormal() && this.toFault == bAlarmPriorities.getToFault() && this.toAlert == bAlarmPriorities.getToAlert()) {
            bl = true;
        }
        return bl;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.toOffnormal);
        dataOutput.writeInt(this.toFault);
        dataOutput.writeInt(this.toNormal);
        dataOutput.writeInt(this.toAlert);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        int n4 = dataInput.readInt();
        return BAlarmPriorities.make(n, n2, n3, n4);
    }

    public final String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("toOffnormal=");
        stringBuffer.append(this.toOffnormal).append(';');
        stringBuffer.append("toFault=");
        stringBuffer.append(this.toFault).append(';');
        stringBuffer.append("toNormal=");
        stringBuffer.append(this.toNormal).append(';');
        stringBuffer.append("toAlert=");
        stringBuffer.append(this.toAlert).append(';');
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        BAlarmPriorities bAlarmPriorities = DEFAULT;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n5 = string2.indexOf("=");
            String string3 = string2.substring(0, n5);
            String string4 = string2.substring(n5 + 1);
            if (string3.equals("toOffnormal")) {
                n = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("toNormal")) {
                n3 = Integer.parseInt(string4);
                continue;
            }
            if (string3.equals("toFault")) {
                n2 = Integer.parseInt(string4);
                continue;
            }
            if (!string3.equals("toAlert")) continue;
            n4 = Integer.parseInt(string4);
        }
        return BAlarmPriorities.make(n, n2, n3, n4);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BAlarmPriorities(int n, int n2, int n3, int n4) {
        this.toOffnormal = this.checkPriority(n);
        this.toFault = this.checkPriority(n2);
        this.toNormal = this.checkPriority(n3);
        this.toAlert = this.checkPriority(n4);
    }

    private BAlarmPriorities() {
        this(255, 255, 255, 255);
    }

    static {
        Class clazz = class$javax$baja$alarm$BAlarmPriorities;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmPriorities = BAlarmPriorities.class("[Ljavax.baja.alarm.BAlarmPriorities;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

