/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.collection.BICollection;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlarmSupport {
    private static final Log logger = Log.getLog((String)"alarm");
    public static final String USER_OVERRIDE_FACET = "fw_BAlarmRecord_user";
    BComponent comp;
    String alarmClassName;
    BAlarmClass alarmClass;
    BAlarmSourceInfo info;
    BSourceState lastTransition;
    BAlarmRecord lastOffnormal;
    BAlarmRecord lastFault;
    BAlarmRecord lastAlert;
    int alarmCount;
    boolean firstNormal;
    BAlarmService as;

    public void setAlarmClass(String string) {
        this.alarmClassName = string;
        if (this.getAlarmService() != null) {
            this.alarmClass = this.getAlarmService().lookupAlarmClass(string);
        }
    }

    public BOrdList getSourceOrd() {
        return BOrdList.make((BOrd)this.comp.getNavOrd());
    }

    public String getAlarmClassName() {
        if (this.info != null) {
            return this.info.getAlarmClass();
        }
        return this.alarmClassName;
    }

    public boolean isAckRequired(BSourceState bSourceState) {
        this.getAlarmService();
        if (this.alarmClass != null) {
            return this.alarmClass.getAckRequired().includes(bSourceState);
        }
        return false;
    }

    public BAlarmRecord newAlert() throws Exception {
        return this.newAlert(BFacets.DEFAULT);
    }

    public BAlarmRecord newAlert(BFacets bFacets) throws Exception {
        return this.newAlarm(BSourceState.alert, bFacets);
    }

    public BAlarmRecord newOffnormalAlarm() throws Exception {
        return this.newOffnormalAlarm(BFacets.DEFAULT);
    }

    public BAlarmRecord newOffnormalAlarm(BFacets bFacets) throws Exception {
        return this.newAlarm(BSourceState.offnormal, bFacets);
    }

    public BAlarmRecord newFaultAlarm() throws Exception {
        return this.newFaultAlarm(BFacets.DEFAULT);
    }

    public BAlarmRecord newFaultAlarm(BFacets bFacets) throws Exception {
        return this.newAlarm(BSourceState.fault, bFacets);
    }

    protected BAlarmRecord newAlarm(BSourceState bSourceState, BFacets bFacets) {
        this.lastTransition = bSourceState;
        boolean bl = this.isAckRequired(bSourceState);
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        String string = bFacets.gets(USER_OVERRIDE_FACET, null);
        if (string != null) {
            bAlarmRecord.setUser(string);
            bFacets = BFacets.makeRemove((BFacets)bFacets, (String)USER_OVERRIDE_FACET);
        }
        if (this.info != null) {
            bFacets = BFacets.make((BFacets)this.info.makeAlarmData(bSourceState), (BFacets)bFacets);
        }
        bAlarmRecord.setSource(this.getSourceOrd());
        bAlarmRecord.setAlarmClass(this.getAlarmClassName());
        bAlarmRecord.setAlarmTransition(bSourceState);
        bAlarmRecord.setSourceState(bSourceState);
        bAlarmRecord.setAckRequired(bl);
        bAlarmRecord.setAlarmData(bFacets);
        if (bSourceState.equals((Object)BSourceState.offnormal)) {
            this.lastOffnormal = bAlarmRecord;
        } else if (bSourceState.equals((Object)BSourceState.fault)) {
            this.lastFault = bAlarmRecord;
        } else if (bSourceState.equals((Object)BSourceState.alert)) {
            this.lastAlert = bAlarmRecord;
        }
        ++this.alarmCount;
        if (this.getAlarmService() != null) {
            this.getAlarmService().routeAlarm(bAlarmRecord);
            return bAlarmRecord;
        }
        return null;
    }

    public synchronized BAlarmRecord toNormal() throws Exception {
        return this.toNormal(BFacets.DEFAULT);
    }

    public synchronized BAlarmRecord toNormal(BFacets bFacets) throws Exception {
        this.lastTransition = BSourceState.normal;
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        if (this.info != null) {
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)this.info.makeAlarmData(BSourceState.normal));
        }
        if (this.getAlarmService() == null) {
            return new BAlarmRecord();
        }
        boolean bl = this.alarmClass.getAckRequired().isToNormal();
        if (this.alarmCount > 1 || this.firstNormal) {
            StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select * where ");
            stringBuffer.append("source = OrdList '" + SlotPath.escape((String)this.getSourceOrd().encodeToString()) + "' and sourceState != alarm:SourceState.normal");
            BOrd bOrd = BOrd.make((String)stringBuffer.toString());
            Cursor cursor = ((BICollection)bOrd.resolve((BObject)this.as).get()).cursor();
            boolean bl2 = false;
            while (cursor.next()) {
                bl2 = true;
                BAlarmRecord bAlarmRecord2 = (BAlarmRecord)((BValue)cursor.get()).newCopy(true);
                if (bAlarmRecord2.getSourceState() == BSourceState.alert) continue;
                bAlarmRecord2.setSource(this.getSourceOrd());
                bAlarmRecord2.setAlarmClass(this.getAlarmClassName());
                bAlarmRecord2.setNormalTime(Clock.time());
                bAlarmRecord2.setSourceState(BSourceState.normal);
                boolean bl3 = false;
                if (bAlarmRecord2.getAckRequired() || bl) {
                    bl3 = true;
                }
                bAlarmRecord2.setAckRequired(bl3);
                bAlarmRecord2.setAlarmData(BFacets.make((BFacets)bAlarmRecord2.getAlarmData(), (BFacets)bFacets));
                if (bl) {
                    bAlarmRecord2.setAckState(BAckState.unacked);
                }
                if (this.getAlarmService() != null) {
                    this.getAlarmService().routeAlarm(bAlarmRecord2);
                }
                bAlarmRecord = bAlarmRecord2;
            }
            if (!bl2) {
                if (bl) {
                    bAlarmRecord.setAckState(BAckState.unacked);
                }
                bAlarmRecord.setSource(this.getSourceOrd());
                bAlarmRecord.setAlarmClass(this.getAlarmClassName());
                bAlarmRecord.setNormalTime(Clock.time());
                bAlarmRecord.setSourceState(BSourceState.normal);
                bAlarmRecord.setAckRequired(bl);
                bAlarmRecord.setAlarmData(bFacets);
                if (this.getAlarmService() != null) {
                    this.getAlarmService().routeAlarm(bAlarmRecord);
                }
            }
        } else {
            BAlarmRecord bAlarmRecord3 = null;
            if (this.lastAlert != null && !this.lastAlert.isNormal()) {
                this.lastAlert.setSourceState(BSourceState.normal);
                bAlarmRecord3 = this.getAlarmService().getAlarmDb().getRecord(this.lastAlert.getUuid());
                if (bAlarmRecord3 == null) {
                    bAlarmRecord3 = new BAlarmRecord();
                    bAlarmRecord3.setUuid(this.lastAlert.getUuid());
                }
            } else if (this.lastFault != null && !this.lastFault.isNormal()) {
                this.lastFault.setSourceState(BSourceState.normal);
                bAlarmRecord3 = this.getAlarmService().getAlarmDb().getRecord(this.lastFault.getUuid());
                if (bAlarmRecord3 == null) {
                    bAlarmRecord3 = new BAlarmRecord();
                    bAlarmRecord3.setUuid(this.lastFault.getUuid());
                }
            } else if (this.lastOffnormal != null && !this.lastOffnormal.isNormal()) {
                this.lastOffnormal.setSourceState(BSourceState.normal);
                bAlarmRecord3 = this.getAlarmService().getAlarmDb().getRecord(this.lastOffnormal.getUuid());
                if (bAlarmRecord3 == null) {
                    bAlarmRecord3 = new BAlarmRecord();
                    bAlarmRecord3.setUuid(this.lastOffnormal.getUuid());
                }
            } else {
                bAlarmRecord3 = new BAlarmRecord();
            }
            bAlarmRecord3.setSource(this.getSourceOrd());
            bAlarmRecord3.setAlarmClass(this.getAlarmClassName());
            bAlarmRecord3.setNormalTime(Clock.time());
            bAlarmRecord3.setSourceState(BSourceState.normal);
            boolean bl4 = false;
            if (bAlarmRecord3.getAckRequired() || bl) {
                bl4 = true;
            }
            bAlarmRecord3.setAckRequired(bl4);
            bAlarmRecord3.setAlarmData(BFacets.make((BFacets)bAlarmRecord3.getAlarmData(), (BFacets)bFacets));
            if (bl) {
                bAlarmRecord3.setAckState(BAckState.unacked);
            }
            if (this.getAlarmService() != null) {
                this.getAlarmService().routeAlarm(bAlarmRecord3);
            }
            bAlarmRecord = bAlarmRecord3;
        }
        this.firstNormal = false;
        this.alarmCount = 0;
        return bAlarmRecord;
    }

    public synchronized void toNormal(Context context) throws Exception {
        this.toNormal(BFacets.DEFAULT, context);
    }

    public synchronized void toNormal(BFacets bFacets, Context context) throws Exception {
        this.lastTransition = BSourceState.normal;
        if (this.info != null) {
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)this.info.makeAlarmData(BSourceState.normal));
        }
        if (this.getAlarmService() == null) {
            return;
        }
        boolean bl = this.alarmClass.getAckRequired().isToNormal();
        if (this.alarmCount > 1 || this.firstNormal) {
            BAlarmRecord bAlarmRecord = new BAlarmRecord();
            if (bl) {
                bAlarmRecord.setAckState(BAckState.unacked);
            }
            bAlarmRecord.setSource(this.getSourceOrd());
            bAlarmRecord.setAlarmClass(this.getAlarmClassName());
            bAlarmRecord.setNormalTime(Clock.time());
            bAlarmRecord.setSourceState(BSourceState.normal);
            bAlarmRecord.setAckRequired(bl);
            bAlarmRecord.setAlarmData(bFacets);
            this.getAlarmService().getAlarmDb().toNormal(bAlarmRecord);
        } else {
            BAlarmRecord bAlarmRecord = null;
            if (this.lastAlert != null && !this.lastAlert.isNormal()) {
                this.lastAlert.setSourceState(BSourceState.normal);
                bAlarmRecord = this.getAlarmService().getAlarmDb().getRecord(this.lastAlert.getUuid());
                if (bAlarmRecord == null) {
                    bAlarmRecord = new BAlarmRecord();
                    bAlarmRecord.setUuid(this.lastAlert.getUuid());
                }
            } else if (this.lastFault != null && !this.lastFault.isNormal()) {
                this.lastFault.setSourceState(BSourceState.normal);
                bAlarmRecord = this.getAlarmService().getAlarmDb().getRecord(this.lastFault.getUuid());
                if (bAlarmRecord == null) {
                    bAlarmRecord = new BAlarmRecord();
                    bAlarmRecord.setUuid(this.lastFault.getUuid());
                }
            } else if (this.lastOffnormal != null && !this.lastOffnormal.isNormal()) {
                this.lastOffnormal.setSourceState(BSourceState.normal);
                bAlarmRecord = this.getAlarmService().getAlarmDb().getRecord(this.lastOffnormal.getUuid());
                if (bAlarmRecord == null) {
                    bAlarmRecord = new BAlarmRecord();
                    bAlarmRecord.setUuid(this.lastOffnormal.getUuid());
                }
            } else {
                bAlarmRecord = new BAlarmRecord();
            }
            bAlarmRecord.setSource(this.getSourceOrd());
            bAlarmRecord.setAlarmClass(this.getAlarmClassName());
            bAlarmRecord.setNormalTime(Clock.time());
            bAlarmRecord.setSourceState(BSourceState.normal);
            boolean bl2 = false;
            if (bAlarmRecord.getAckRequired() || bl) {
                bl2 = true;
            }
            bAlarmRecord.setAckRequired(bl2);
            bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (BFacets)bFacets));
            if (bl) {
                bAlarmRecord.setAckState(BAckState.unacked);
            }
            this.getAlarmService().routeAlarm(bAlarmRecord);
            BOrdList bOrdList = this.getSourceOrd();
            BObject bObject = bOrdList.get(0).resolve().get();
            if (bObject instanceof BAlarmSourceExt) {
                BAlarmSourceExt bAlarmSourceExt = (BAlarmSourceExt)bObject;
                bAlarmSourceExt.fireToNormal(bAlarmRecord);
            }
        }
        this.firstNormal = false;
        this.alarmCount = 0;
    }

    public boolean ackAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        bAlarmRecord.setAckTime(Clock.time());
        boolean bl = false;
        bAlarmRecord.setAckState(BAckState.acked);
        bAlarmRecord.setAckRequired(false);
        bAlarmRecord.setAlarmClass(this.getAlarmClassName());
        if (this.lastTransition == BSourceState.normal && bAlarmRecord.getSourceState() != BSourceState.normal) {
            bAlarmRecord.setSourceState(BSourceState.normal);
        }
        if (bAlarmRecord.getAlarmTransition() == BSourceState.offnormal) {
            boolean bl2 = true;
            if (this.lastOffnormal != null) {
                bl2 = bAlarmRecord.getUuid().equals((Object)this.lastOffnormal.getUuid());
            }
            bl = bl2;
        } else if (bAlarmRecord.getAlarmTransition() == BSourceState.fault) {
            boolean bl3 = true;
            if (this.lastFault != null) {
                bl3 = bAlarmRecord.getUuid().equals((Object)this.lastFault.getUuid());
            }
            bl = bl3;
        } else if (bAlarmRecord.getAlarmTransition() == BSourceState.alert) {
            boolean bl4 = true;
            if (this.lastAlert != null) {
                bl4 = bAlarmRecord.getUuid().equals((Object)this.lastAlert.getUuid());
            }
            bl = bl4;
        }
        try {
            this.getAlarmService().routeAlarm(bAlarmRecord);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public BAlarmRecord getLastOffnormal() {
        return this.lastOffnormal;
    }

    public BAlarmRecord getLastFault() {
        return this.lastFault;
    }

    public BAlarmRecord getLastAlert() {
        return this.lastAlert;
    }

    private final BAlarmService getAlarmService() {
        if (this.as == null) {
            try {
                this.as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                this.alarmClass = this.as.lookupAlarmClass(this.getAlarmClassName());
            }
            catch (Exception exception) {
                System.out.println("Could Not Get AlarmService");
                exception.printStackTrace();
                return null;
            }
        }
        return this.as;
    }

    private final /* synthetic */ void this() {
        this.info = null;
        this.lastOffnormal = null;
        this.lastFault = null;
        this.lastAlert = null;
        this.alarmCount = 0;
        this.firstNormal = true;
        this.as = null;
    }

    public AlarmSupport(BIAlarmSource bIAlarmSource, String string) {
        this.this();
        this.comp = (BComponent)bIAlarmSource;
        this.alarmClassName = string;
    }

    public AlarmSupport(BIAlarmSource bIAlarmSource, BAlarmSourceInfo bAlarmSourceInfo) {
        this.this();
        this.comp = (BComponent)bIAlarmSource;
        this.alarmClassName = bAlarmSourceInfo.getAlarmClass();
        this.info = bAlarmSourceInfo;
    }
}

