/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui.portal;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxSession;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BICollection;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableSelection;
import javax.baja.workbench.BWbShell;

public class BPortalAlarmConsole
extends BAlarmConsole {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$portal$BPortalAlarmConsole == null ? (class$com$tridium$alarm$ui$portal$BPortalAlarmConsole = BPortalAlarmConsole.class$("com.tridium.alarm.ui.portal.BPortalAlarmConsole")) : class$com$tridium$alarm$ui$portal$BPortalAlarmConsole));
    BAlarmPortalTool tool;
    BButton serviceToggle;
    public Command startCommand;
    public Command stopCommand;
    public ToggleCommand autoStartCommand;
    static /* synthetic */ Class class$com$tridium$alarm$ui$portal$BPortalAlarmConsole;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        Object object;
        Object object2;
        if (this.sourceTable.getModel() instanceof DynamicTableModel) {
            object2 = (DynamicTableModel)this.sourceTable.getModel();
            object = new StringBuffer();
            for (int i = 0; i < object2.getRootColumnCount(); ++i) {
                if (!object2.showColumn(i)) continue;
                object.append(i + ",");
            }
            if (object2.getRootColumnCount() > 0) {
                this.options.setDisplayColumns(object.toString());
            }
        }
        this.options.setSortColumn(this.sourceModel.getLastSortColumn());
        this.options.setSortAscending(this.sourceModel.getLastSortAscending());
        this.options.save();
        if (!this.tool.serviceRunning()) {
            object2 = this.tool.recipients.keys();
            while (object2.hasMoreElements()) {
                object = (BConsoleRecipient)((Object)this.tool.recipients.get(object2.nextElement()));
                if (this.channel((BConsoleRecipient)((Object)object)) == null) continue;
                this.channel((BConsoleRecipient)((Object)object)).unregister((BConsoleRecipient)((Object)object));
                this.channel((BConsoleRecipient)((Object)object)).unregister(this);
            }
            if (this.tool.trayIcon != null && this.tool.trayIcon.isShowing()) {
                this.tool.trayIcon.hide();
            }
        }
    }

    public void doLoadValue(BObject bObject, Context context) throws Exception {
        this.tool = (BAlarmPortalTool)bObject;
        super.doLoadValue((BObject)this.tool.getAlarmPortalConsoleRecipient(), context);
        this.sourceTable.setCellRenderer((TableCellRenderer)new AlarmPortalTableCellRenderer());
    }

    public BGridPane makeToolBar() {
        BGridPane bGridPane = super.makeToolBar();
        return bGridPane;
    }

    public void doProcessAlarm(BAlarmRecord bAlarmRecord) {
        super.doProcessAlarm(bAlarmRecord);
        if (this.options.getAlarmFilters().accept((BComplex)bAlarmRecord)) {
            int n = this.getAckedAlarmCount();
            int n2 = this.getUnackedAlarmCount();
            this.tool.updateTrayIcon(n, n2, this.sourcesInAlarm());
            this.tool.showAlarmDialog(n, n2, this.sourcesInAlarm(), bAlarmRecord);
        }
    }

    public void doTimeRangeModified() throws Exception {
        this.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        this.reload();
    }

    public int getAckedAlarmCount() {
        if (this.sourceModel == null || this.tool == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.sourceModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            n += this.sourceModel.getAckedCountForSource(this.sourceModel.getRecord(i).getSource());
        }
        this.tool.acked = n;
        return n;
    }

    public int getUnackedAlarmCount() {
        if (this.sourceModel == null || this.tool == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.sourceModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            n += this.sourceModel.getUnackedCountForSource(this.sourceModel.getRecord(i).getSource());
        }
        this.tool.unacked = n;
        return n;
    }

    public boolean sourcesInAlarm() {
        if (this.sourceModel == null || this.tool == null) {
            return false;
        }
        boolean bl = false;
        int n = this.sourceModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            bl |= !this.sourceModel.getRecord(i).isNormal();
        }
        this.tool.sourcesInAlarm = bl;
        return bl;
    }

    public BAlarmRecord getMostRecentRecord() {
        if (this.sourceModel == null || this.tool == null) {
            return null;
        }
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        bAlarmRecord.setTimestamp(BAbsTime.NULL);
        int n = this.sourceModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            BAlarmRecord bAlarmRecord2 = this.sourceModel.getRecord(i);
            if (!bAlarmRecord2.getTimestamp().isAfter(bAlarmRecord.getTimestamp())) continue;
            bAlarmRecord = bAlarmRecord2;
        }
        return bAlarmRecord;
    }

    public void removeAlarmsFrom(BConsoleRecord bConsoleRecord) {
        int n;
        String string = bConsoleRecord.getUseFoxs() ? "|foxs:" : "|fox:";
        BOrd bOrd = BOrd.make((String)(bConsoleRecord.getHostOrd() + string + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd()));
        if (this.sourceModel == null) {
            return;
        }
        int n2 = this.sourceModel.getRowCount();
        ArrayList<BOrdList> arrayList = new ArrayList<BOrdList>();
        for (n = 0; n < n2; ++n) {
            BOrdList bOrdList = this.sourceModel.getRecord(n).getSource();
            if (!this.ordListContains(bOrdList, bOrd)) continue;
            arrayList.add(bOrdList);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                this.sourceModel.removeSource((BOrdList)arrayList.get(n));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean ordListContains(BOrdList bOrdList, BOrd bOrd) {
        for (int i = 0; i < bOrdList.size(); ++i) {
            BOrd bOrd2 = bOrdList.get(i);
            if (!bOrd2.equals((Object)bOrd)) continue;
            return true;
        }
        return false;
    }

    public void load() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object;
        Object object2;
        this.sourceModel.clear();
        Enumeration enumeration = this.tool.recipients.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (BConsoleRecipient)((Object)this.tool.recipients.get(enumeration.nextElement()));
            BConsoleRecord bConsoleRecord = this.tool.getRecordForRecipient((BConsoleRecipient)((Object)object2));
            object = bConsoleRecord.getUseFoxs() ? "foxs:" : "fox:";
            BOrd bOrd = BOrd.make((BOrd)bConsoleRecord.getHostOrd(), (String)((String)object + bConsoleRecord.getPort() + "|station:|" + bConsoleRecord.getConsoleOrd().toString()));
            this.enterBusy();
            try {
                String string;
                BAbsTimeFilter bAbsTimeFilter;
                StringBuffer stringBuffer = new StringBuffer(this.channel((BConsoleRecipient)((Object)object2)).getInitialAlarmQuery(this, (BConsoleRecipient)((Object)object2), bOrd).toString());
                StringBuffer stringBuffer2 = new StringBuffer(64);
                String string2 = this.options.getAlarmFilters().getPredicate();
                if (string2 != null && string2.length() > 0) {
                    if (stringBuffer2.length() != 0) {
                        stringBuffer2.append(" and ");
                    }
                    stringBuffer2.append(string2);
                }
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(" and ").append(stringBuffer2.toString());
                }
                if (!this.timeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
                    bAbsTimeFilter = new BAbsTimeFilter();
                    bAbsTimeFilter.initFromDynamicTimeRange(this.timeRange);
                    string = bAbsTimeFilter.getPredicate(BAlarmRecord.timestamp.getName());
                    stringBuffer.append(" and ").append(string.toString());
                }
                stringBuffer.append(" order by timestamp desc, ");
                stringBuffer.append(this.sourceModel.getColumns().getColumn(this.options.getSortColumn()).getQueryName());
                if (this.options.getSortAscending()) {
                    stringBuffer.append(" asc");
                } else {
                    stringBuffer.append(" desc");
                }
                bAbsTimeFilter = BOrd.make((BOrd)((BWbShell)this.getShell()).getActiveOrd(), (BOrd)BOrd.make((String)stringBuffer.toString()));
                string = (BICollection)bAbsTimeFilter.resolve((BObject)object2).get();
                Cursor cursor = string.cursor();
                BAlarmRecord bAlarmRecord = null;
                if (!cursor.next()) continue;
                bAlarmRecord = (BAlarmRecord)cursor.get();
                BOrdList bOrdList = bAlarmRecord.getSource();
                bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)bOrd);
                bAlarmRecord.setSource(bOrdList);
                this.sourceModel.update(bAlarmRecord);
                this.sourceTable.sizeColumnsToFit();
                while (cursor.next()) {
                    bAlarmRecord = (BAlarmRecord)cursor.get();
                    bOrdList = bAlarmRecord.getSource();
                    bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)bOrd);
                    bAlarmRecord.setSource(bOrdList);
                    this.sourceModel.update(bAlarmRecord, false);
                }
                this.sourceModel.sortByColumn(this.sourceModel.getLastSortColumn(), this.sourceModel.getLastSortAscending());
                this.sourceModel.updateTable();
                this.sourceTable.sizeColumnsToFit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.exitBusy();
                this.loadComplete();
                this.sourceModel.init(this, this.ctx);
                this.sourceTable.sizeColumnsToFit();
            }
        }
        this.exitBusy();
        object2 = null;
        for (int i = 0; i < this.sourceModel.getRowCount(); ++i) {
            object = this.sourceModel.getRecord(i);
            if (object.isAlarm()) {
                this.soundAlarmFor((BAlarmRecord)((Object)object));
            }
            if (object2 == null) {
                object2 = object;
                continue;
            }
            if (!((BAlarmRecord)((Object)object2)).getTimestamp().isBefore(object.getTimestamp())) continue;
            object2 = object;
        }
    }

    protected void init() {
        this.sourceModel.init(this, this.ctx);
    }

    protected void ackAlarms(BAlarmRecord[] bAlarmRecordArray) {
        try {
            BOrdList bOrdList;
            Object object;
            Hashtable<BConsoleRecipient, Array> hashtable = new Hashtable<BConsoleRecipient, Array>();
            for (int i = 0; i < bAlarmRecordArray.length && !((BAlarmRecord)((Object)(object = (BAlarmRecord)bAlarmRecordArray[i].newCopy()))).isAcknowledged(); ++i) {
                bOrdList = ((BAlarmRecord)((Object)object)).getSource();
                BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
                BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordFor(bOrd);
                BConsoleRecipient bConsoleRecipient = this.tool.getRecipientForRecord(bConsoleRecord);
                ((BAlarmRecord)((Object)object)).setUser(this.getUsername((BAlarmRecord)((Object)object)));
                ((BAlarmRecord)((Object)object)).setAckTime(BAbsTime.now());
                ((BAlarmRecord)((Object)object)).setAckState(BAckState.ackPending);
                this.sourceModel.update((BAlarmRecord)((Object)object));
                Array array = (Array)hashtable.get((Object)bConsoleRecipient);
                if (array == null) {
                    array = new Array(class$javax$baja$alarm$BAlarmRecord == null ? BPortalAlarmConsole.class$("javax.baja.alarm.BAlarmRecord") : class$javax$baja$alarm$BAlarmRecord);
                }
                BAlarmRecord bAlarmRecord = (BAlarmRecord)object.newCopy();
                bAlarmRecord.setSource(BOrdList.remove((BOrdList)((BAlarmRecord)((Object)object)).getSource(), (int)(((BAlarmRecord)((Object)object)).getSource().size() - 1)));
                array.add((Object)bAlarmRecord);
                hashtable.put(bConsoleRecipient, array);
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (BConsoleRecipient)((Object)enumeration.nextElement());
                bOrdList = (Array)hashtable.get(object);
                this.channel((BConsoleRecipient)((Object)object)).ackAlarms(this.tool.getAlarmPortalConsoleRecipient(), (BAlarmRecord[])bOrdList.trim());
            }
            this.sourceTable.sizeColumnsToFit();
            this.sourceTable.fireTableModified(null);
            if (this.alarmTable != null) {
                this.alarmTable.fireTableModified(null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String getUsername(BAlarmRecord bAlarmRecord) {
        BOrdList bOrdList = bAlarmRecord.getSource();
        BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
        BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordFor(bOrd);
        if (bConsoleRecord == null) {
            return null;
        }
        BConsoleRecipient bConsoleRecipient = this.tool.getRecipientForRecord(bConsoleRecord);
        if (!bConsoleRecipient.isMounted()) {
            return null;
        }
        return ((BFoxSession)bConsoleRecipient.getSession()).getConnection().getUsername();
    }

    public BAlarmService getAlarmService() {
        SourceTableModel sourceTableModel = (SourceTableModel)((DynamicTableModel)this.sourceModel.getModel()).getRootModel();
        BAlarmRecord bAlarmRecord = sourceTableModel.getRecord(this.sourceModel.getSelection().getSelection().getRow());
        BOrdList bOrdList = bAlarmRecord.getSource();
        BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
        String string = bOrd.toString();
        string = string.substring(0, string.indexOf("|station:|"));
        BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordForStation(BOrd.make((String)string));
        BConsoleRecipient bConsoleRecipient = this.tool.getRecipientForRecord(bConsoleRecord);
        BOrd bOrd2 = BOrd.make((String)"service:alarm:AlarmService");
        BAlarmService bAlarmService = (BAlarmService)bOrd2.resolve((BObject)bConsoleRecipient).get();
        bAlarmService.lease();
        return bAlarmService;
    }

    protected boolean canModifySelectedAlarms(TableSelection tableSelection) {
        if (tableSelection == null || tableSelection.isEmpty()) {
            return false;
        }
        int[] nArray = tableSelection.getRows();
        SourceTableModel sourceTableModel = (SourceTableModel)((DynamicTableModel)this.sourceModel.getModel()).getRootModel();
        for (int i = 0; i < nArray.length; ++i) {
            BAlarmRecord bAlarmRecord = sourceTableModel.getRecord(nArray[i]);
            BOrdList bOrdList = bAlarmRecord.getSource();
            BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
            String string = bOrd.toString();
            string = string.substring(0, string.indexOf("|station:|"));
            BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordForStation(BOrd.make((String)string));
            BConsoleRecipient bConsoleRecipient = this.tool.getRecipientForRecord(bConsoleRecord);
            BOrd bOrd2 = BOrd.make((String)"service:alarm:AlarmService");
            BAlarmService bAlarmService = (BAlarmService)bOrd2.resolve((BObject)bConsoleRecipient).get();
            bAlarmService.lease();
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (!(bAlarmClass == null ? !bAlarmService.getDefaultAlarmClass().getPermissions(this.ctx).hasOperatorWrite() : !bAlarmClass.getPermissions(this.ctx).hasOperatorWrite())) continue;
            return false;
        }
        return true;
    }

    protected void hyperlink(BAlarmRecord bAlarmRecord) {
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null) {
            BAlarmClassDef bAlarmClassDef;
            BAlarmClassMapping bAlarmClassMapping;
            BOrd bOrd = BOrd.make((String)bAlarmRecord.getAlarmData().get("hyperlinkOrd").toString());
            if (bOrd == null || bOrd.isNull()) {
                bAlarmClassMapping = this.options.getAlarmClassMapping();
                bAlarmClassDef = bAlarmClassMapping.getAlarmClassDefFor(bAlarmRecord.getAlarmClass());
                bOrd = bAlarmClassDef.getAlarmUrl();
            }
            if (!bOrd.isNull()) {
                bAlarmClassMapping = bAlarmRecord.getSource();
                bAlarmClassDef = bAlarmClassMapping.get(bAlarmClassMapping.size() - 1);
                String string = bAlarmClassDef.toString();
                string = string.substring(0, string.indexOf("|station:|"));
                BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordForStation(BOrd.make((String)string));
                BConsoleRecipient bConsoleRecipient = this.tool.getRecipientForRecord(bConsoleRecord);
                BOrd bOrd2 = BOrd.make((BOrd)bConsoleRecipient.getNavOrd(), (BOrd)bOrd);
                bWbShell.hyperlink(bOrd2);
                if (this.detailsDlg != null) {
                    this.detailsDlg.close();
                }
                if (this.alarmReport != null) {
                    this.alarmReport.close();
                }
            }
        }
    }

    public void soundAlarmFor(BAlarmRecord bAlarmRecord) {
        BOrd bOrd = BOrd.NULL;
        if (bAlarmRecord.getAlarmData().get("soundFile") != null) {
            bOrd = BOrd.make((BOrd)BOrd.toSpace((BObject)this.getRecipientForAlarm(bAlarmRecord)).getNavOrd(), (String)bAlarmRecord.getAlarmData().get("soundFile").toString());
        }
        if (bOrd == null || bOrd.isNull()) {
            BAlarmClassMapping bAlarmClassMapping;
            BAlarmClassDef bAlarmClassDef = null;
            if (this.options != null && (bAlarmClassMapping = this.options.getAlarmClassMapping()) != null && (bAlarmClassDef = bAlarmClassMapping.getAlarmClassDefFor(bAlarmRecord.getAlarmClass())) != null) {
                bOrd = bAlarmClassDef.getAlarmSound();
            }
        }
        try {
            if (bOrd == null || bOrd.isNull()) {
                this.soundAlarm(bAlarmRecord);
            } else {
                this.soundAlarm(bAlarmRecord.getSource(), bOrd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected BConsoleRecipient getRecipientForAlarm(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord == null) {
            return null;
        }
        BOrdList bOrdList = bAlarmRecord.getSource();
        BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
        String string = bOrd.toString();
        string = string.substring(0, string.indexOf("|station:|"));
        BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordForStation(BOrd.make((String)string));
        return this.tool.getRecipientForRecord(bConsoleRecord);
    }

    public BAlarmService getAlarmService(BAlarmRecord bAlarmRecord) {
        BConsoleRecipient bConsoleRecipient = this.getRecipientForAlarm(bAlarmRecord);
        BConsoleRecord bConsoleRecord = this.tool.getRecordForRecipient(bConsoleRecipient);
        if (bConsoleRecipient == null) {
            return null;
        }
        if (bConsoleRecord == null || !bConsoleRecord.isInitialLoadComplete()) {
            return null;
        }
        try {
            return (BAlarmService)BOrd.make((String)"service:alarm:AlarmService").resolve((BObject)bConsoleRecipient).get();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void sendUpdatedAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BOrdList bOrdList = bAlarmRecord.getSource();
        BOrd bOrd = bOrdList.get(bOrdList.size() - 1);
        BConsoleRecord bConsoleRecord = this.tool.getConsoleRecordFor(bOrd);
        BConsoleRecipient bConsoleRecipient = this.tool.getRecipientForRecord(bConsoleRecord);
        BAlarmRecord bAlarmRecord2 = (BAlarmRecord)bAlarmRecord.newCopy();
        bAlarmRecord2.setSource(BOrdList.remove((BOrdList)bOrdList, (int)(bOrdList.size() - 1)));
        this.channel(bConsoleRecipient).updateAlarm(bAlarmRecord2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AlarmPortalTableCellRenderer
    extends BAlarmConsole.AlarmTableCellRenderer {
        public BBrush getForeground(TableCellRenderer.Cell cell) {
            int n = cell.row;
            BAlarmRecord bAlarmRecord = BPortalAlarmConsole.this.sourceModel.getRecord(n);
            BOrd bOrd = bAlarmRecord.getSource().get(bAlarmRecord.getSource().size() - 1);
            BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)((Object)BPortalAlarmConsole.this.tool.recipients.get(bOrd.toString()));
            return bConsoleRecipient != null && bConsoleRecipient.isMounted() ? super.getForeground(cell) : BBrush.makeSolid((BColor)BColor.gray);
        }
    }

    public static class SourceModCursor
    implements Cursor {
        Cursor inner;
        BOrd srcAdd;
        BAlarmRecord rec;

        public SourceModCursor(BOrd bOrd, Cursor cursor) {
            this.srcAdd = bOrd;
            this.inner = cursor;
        }

        public Context getContext() {
            return this.inner.getContext();
        }

        public BObject get() {
            if (this.rec == null) {
                this.rec = (BAlarmRecord)this.inner.get();
                BOrdList bOrdList = this.rec.getSource();
                bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)this.srcAdd);
                this.rec.setSource(bOrdList);
            }
            return this.rec;
        }

        public boolean next() {
            this.rec = null;
            return this.inner.next();
        }

        public boolean nextComponent() {
            this.rec = null;
            return this.inner.nextComponent();
        }

        public boolean next(Class clazz) {
            this.rec = null;
            return this.inner.next(clazz);
        }
    }
}

