/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.data.BDataTable;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BFormat;

public abstract class ConsoleTableModel
extends TableModel {
    private static BImage alarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    private static BImage redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    private static BImage greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
    private static BImage whiteAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmWhite.png");
    public BAlarmConsoleOptions options = BAlarmConsoleOptions.getDefault();
    private ConsoleColumns columns;
    private int sortCol = 5;
    private boolean sortAsc = false;
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);

    public ConsoleTableModel(ConsoleColumns consoleColumns) {
        this.columns = consoleColumns;
        consoleColumns.addModel(this);
    }

    public void init(BIAlarmServiceView bIAlarmServiceView, Context context) {
        this.columns.init(bIAlarmServiceView, context);
    }

    public abstract BAlarmRecord getRecord(int var1);

    public BAlarmRecord getRecord(BOrdList bOrdList, int n) {
        return this.getRecord(n);
    }

    public abstract int getAlarmCount();

    public int getAlarmCount(BOrdList bOrdList) {
        return this.getAlarmCount();
    }

    public abstract int getSourceCount();

    public ConsoleColumns getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.columns.getColumn(n).getName();
    }

    public void addDataColumn(String string, String string2) {
        this.columns.addDataColumn(string, string2);
    }

    public void removeDataColumn(String string) {
        this.columns.removeDataColumn(string);
    }

    public void columnsModified() {
        this.updateTable();
    }

    public Object getSubject(int n) {
        return this.getRecord(n);
    }

    public Object getValueAt(int n, int n2) {
        BAlarmRecord bAlarmRecord;
        ConsoleColumns.Column column = this.columns.getColumn(n2);
        Object object = column.getValue(bAlarmRecord = this.getRecord(n));
        if (object instanceof BAbsTime) {
            if (this.options.getTimeZoneDisplay() == BTimeZoneDisplay.source) {
                return ((BAbsTime)object).toString((Context)BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (BFacets)TIME_FACETS));
            }
            return ((BAbsTime)object).toString((Context)BFacets.make((BFacets)TIME_FACETS, (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
        }
        if (object instanceof BString || object instanceof String) {
            return TextUtil.replace((String)object.toString(), (String)"\\n", (String)" ");
        }
        if (object instanceof BFacets) {
            return BFormat.make((String)object.toString()).format((Object)bAlarmRecord).replace('\n', ' ');
        }
        if (object instanceof String) {
            return TextUtil.replace((String)object.toString(), (String)"\\n", (String)" ");
        }
        return object;
    }

    public BImage getRowIcon(int n) {
        BAlarmRecord bAlarmRecord = this.getRecord(n);
        BImage bImage = alarmImg;
        BSourceState bSourceState = bAlarmRecord.getSourceState();
        BAckState bAckState = bAlarmRecord.getAckState();
        if (bSourceState == BSourceState.alert && bAckState != BAckState.acked) {
            bImage = orangeAlarmImg;
        } else if (bSourceState == BSourceState.alert && bAckState == BAckState.acked) {
            bImage = whiteAlarmImg;
        } else if (bAckState == BAckState.acked && bSourceState != BSourceState.normal) {
            bImage = alarmImg;
        } else if (bSourceState == BSourceState.normal && bAckState != BAckState.acked) {
            bImage = greenAlarmImg;
        } else if (bAckState != BAckState.acked && bSourceState != BSourceState.normal) {
            bImage = redAlarmImg;
        } else if (bAckState == BAckState.acked && bSourceState == BSourceState.normal) {
            bImage = whiteAlarmImg;
        }
        if (bAlarmRecord.getAlarmData().get("notes") != null) {
            return BImage.make((BIcon)BIcon.make((BIcon)BIcon.make((BOrdList)bImage.getOrdList()), (BIcon)BIcon.std((String)"badges/note.png")));
        }
        return bImage;
    }

    public void close() {
        this.columns.removeModel(this);
    }

    public BITable export() {
        int n;
        int n2 = this.getTable().getModel().getColumnCount();
        int n3 = this.getTable().getModel().getRowCount();
        BDataTable bDataTable = new BDataTable();
        for (n = 0; n < n2; ++n) {
            String string = this.getTable().getModel().getColumnName(n);
            String string2 = SlotPath.escape((String)string);
            Type type = BIDataValue.TYPE;
            bDataTable.addColumn(string2, string, type, 0, BFacets.NULL);
        }
        bDataTable.startRows();
        for (n = 0; n < n3; ++n) {
            bDataTable.startRow();
            for (int i = 0; i < n2; ++i) {
                int n4 = i;
                if (this.getTable().getModel() instanceof DynamicTableModel) {
                    n4 = ((DynamicTableModel)this.getTable().getModel()).toRootColumnIndex(i);
                }
                bDataTable.set(this.export(n, n4).toDataValue(), BFacets.NULL);
            }
            bDataTable.endRow();
        }
        bDataTable.endRows();
        return bDataTable;
    }

    public BObject export(int n, int n2) {
        ConsoleColumns.Column column = this.getColumns().getColumn(n2);
        if (column instanceof ConsoleColumns.DataColumn) {
            return BString.make((String)SlotPath.unescape((String)this.hexCorrection(this.getValueAt(n, n2).toString())));
        }
        return super.export(n, n2);
    }

    private String hexCorrection(String string) {
        int n = string.split("at ").length;
        int n2 = string.split(".java:").length;
        string = string.replaceAll("\n", " ").trim();
        if (n == n2 && string.matches(".*java:[0-9]+\\)$")) {
            string = string.replaceAll("\\$", "\\$24");
        }
        return string;
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public void setInitialSort(int n, boolean bl) {
        this.sortCol = n;
        this.sortAsc = bl;
    }

    public int getLastSortColumn() {
        return this.sortCol;
    }

    public boolean getLastSortAscending() {
        return this.sortAsc;
    }
}

