/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import java.util.Hashtable;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BAlarmInstructionsManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmInstructionsManager == null ? (class$com$tridium$alarm$ui$BAlarmInstructionsManager = BAlarmInstructionsManager.class$("com.tridium.alarm.ui.BAlarmInstructionsManager")) : class$com$tridium$alarm$ui$BAlarmInstructionsManager));
    protected BAlarmService alarmService;
    protected Context cx;
    protected Model model;
    protected BTable table;
    protected BList instructionList;
    protected BList masterList;
    Command mAddCmd;
    Command mRemoveCmd;
    Command mEditCmd;
    Command mSaveCmd;
    Command saveCmd;
    Command addFromMasterCmd;
    Command addCmd;
    Command removeCmd;
    Command moveUpCmd;
    Command moveDownCmd;
    Command editCmd;
    Hashtable instructions = new Hashtable();
    public static final UiLexicon lexicon = new UiLexicon(class$com$tridium$alarm$ui$BAlarmInstructionsManager == null ? (class$com$tridium$alarm$ui$BAlarmInstructionsManager = BAlarmInstructionsManager.class$("com.tridium.alarm.ui.BAlarmInstructionsManager")) : class$com$tridium$alarm$ui$BAlarmInstructionsManager);
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmInstructionsManager;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmSourceInfo;

    public Type getType() {
        return TYPE;
    }

    public BAlarmInstructionsManager() {
        this.addCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.addMsg"){

            public CommandArtifact doInvoke() {
                String string = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Add", (String)"", (int)40);
                if (string != null) {
                    BAlarmInstructionsManager.this.instructionList.addItem((Object)BString.make((String)string));
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.removeCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.removeMsg"){

            public CommandArtifact doInvoke() {
                BAlarmInstructionsManager.this.instructionList.removeSelectedItems();
                BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                return null;
            }
        };
        this.removeCmd.setEnabled(false);
        this.editCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.editMsg"){

            public CommandArtifact doInvoke() {
                if (BAlarmInstructionsManager.this.instructionList.getSelectedItem() == null) {
                    return null;
                }
                String string = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Edit", (String)BAlarmInstructionsManager.this.instructionList.getSelectedItem().toString(), (int)40);
                if (string != null) {
                    BAlarmInstructionsManager.this.instructionList.setItem(BAlarmInstructionsManager.this.instructionList.getSelectedIndex(), (Object)BString.make((String)string));
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.editCmd.setEnabled(false);
        this.moveUpCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.moveUp"){

            public CommandArtifact doInvoke() {
                int n = BAlarmInstructionsManager.this.instructionList.getSelectedIndex();
                if (n > 0) {
                    Object object = BAlarmInstructionsManager.this.instructionList.getItem(n);
                    Object object2 = BAlarmInstructionsManager.this.instructionList.getItem(n - 1);
                    BAlarmInstructionsManager.this.instructionList.setItem(n, object2);
                    BAlarmInstructionsManager.this.instructionList.setItem(n - 1, object);
                    BAlarmInstructionsManager.this.instructionList.getSelection().deselectAll();
                    BAlarmInstructionsManager.this.instructionList.getSelection().select(n - 1);
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.moveUpCmd.setEnabled(false);
        this.moveDownCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.moveDown"){

            public CommandArtifact doInvoke() {
                int n = BAlarmInstructionsManager.this.instructionList.getSelectedIndex();
                if (n < BAlarmInstructionsManager.this.instructionList.getItemCount() - 1) {
                    Object object = BAlarmInstructionsManager.this.instructionList.getItem(n);
                    Object object2 = BAlarmInstructionsManager.this.instructionList.getItem(n + 1);
                    BAlarmInstructionsManager.this.instructionList.setItem(n, object2);
                    BAlarmInstructionsManager.this.instructionList.setItem(n + 1, object);
                    BAlarmInstructionsManager.this.instructionList.getSelection().deselectAll();
                    BAlarmInstructionsManager.this.instructionList.getSelection().select(n + 1);
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.moveDownCmd.setEnabled(false);
        this.saveCmd = new Command((BWidget)this, UiLexicon.bajaui.module, "commands.save"){

            public CommandArtifact doInvoke() {
                int[] nArray = BAlarmInstructionsManager.this.table.getSelection().getRows();
                for (int i = 0; i < nArray.length; ++i) {
                    BAlarmInstructions bAlarmInstructions = ((Controller)BAlarmInstructionsManager.this.table.getController()).getInstructions(nArray[i]);
                    BFormat[] bFormatArray = new BFormat[BAlarmInstructionsManager.this.instructionList.getItemCount()];
                    for (int j = 0; j < BAlarmInstructionsManager.this.instructionList.getItemCount(); ++j) {
                        bFormatArray[j] = BFormat.make((String)BAlarmInstructionsManager.this.instructionList.getItem(j).toString());
                    }
                    bAlarmInstructions = BAlarmInstructions.make(bFormatArray);
                    ((Controller)BAlarmInstructionsManager.this.table.getController()).setInstructions(nArray[i], bAlarmInstructions);
                }
                BAlarmInstructionsManager.this.saveCmd.setEnabled(false);
                return null;
            }
        };
        this.saveCmd.setEnabled(false);
        this.addFromMasterCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.addFromMaster"){

            public CommandArtifact doInvoke() {
                Object[] objectArray = BAlarmInstructionsManager.this.masterList.getSelectedItems();
                for (int i = 0; i < objectArray.length; ++i) {
                    BAlarmInstructionsManager.this.instructionList.addItem((Object)((BFormat)objectArray[i]));
                    BAlarmInstructionsManager.this.saveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.addFromMasterCmd.setEnabled(false);
        this.mAddCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.addMsg"){

            public CommandArtifact doInvoke() {
                String string = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Add", (String)"", (int)40);
                if (string != null) {
                    BAlarmInstructionsManager.this.masterList.addItem((Object)BFormat.make((String)string));
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.mRemoveCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.removeMsg"){

            public CommandArtifact doInvoke() {
                BAlarmInstructionsManager.this.masterList.removeSelectedItems();
                BAlarmInstructionsManager.this.setModified();
                BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                return null;
            }
        };
        this.mRemoveCmd.setEnabled(false);
        this.mEditCmd = new Command((BWidget)this, BAlarmInstructionsManager.lexicon.module, "commands.editMsg"){

            public CommandArtifact doInvoke() {
                if (BAlarmInstructionsManager.this.masterList.getSelectedItem() == null) {
                    return null;
                }
                String string = BDialog.prompt((BWidget)BAlarmInstructionsManager.this, (String)"Edit", (String)BAlarmInstructionsManager.this.masterList.getSelectedItem().toString(), (int)40);
                if (string != null) {
                    BAlarmInstructionsManager.this.masterList.setItem(BAlarmInstructionsManager.this.masterList.getSelectedIndex(), (Object)BFormat.make((String)string));
                    BAlarmInstructionsManager.this.setModified();
                    BAlarmInstructionsManager.this.mSaveCmd.setEnabled(true);
                }
                return null;
            }
        };
        this.mEditCmd.setEnabled(false);
        this.mSaveCmd = new Command((BWidget)this, UiLexicon.bajaui.module, "commands.save"){

            public CommandArtifact doInvoke() throws Exception {
                BAlarmInstructionsManager.this.saveValue();
                BAlarmInstructionsManager.this.mSaveCmd.setEnabled(false);
                return null;
            }
        };
        this.mSaveCmd.setEnabled(false);
        BSplitPane bSplitPane = new BSplitPane(BOrientation.vertical, 50.0);
        BEdgePane bEdgePane = new BEdgePane();
        this.instructionList = new BList();
        this.instructionList.setController((ListController)new InstListController());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setValign(BValign.top);
        bGridPane.add(null, (BValue)new BButton(this.addCmd));
        bGridPane.add(null, (BValue)new BButton(this.removeCmd));
        bGridPane.add(null, (BValue)new BButton(this.editCmd));
        bGridPane.add(null, (BValue)new BButton(this.saveCmd));
        bGridPane.add(null, (BValue)new BLabel(""));
        bGridPane.add(null, (BValue)new BButton(this.moveUpCmd));
        bGridPane.add(null, (BValue)new BButton(this.moveDownCmd));
        bEdgePane.setCenter((BWidget)this.instructionList);
        bEdgePane.setRight((BWidget)bGridPane);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.add(null, (BValue)new BButton(this.addFromMasterCmd));
        bEdgePane.setBottom((BWidget)bGridPane2);
        bSplitPane.setWidget1((BWidget)new BTitlePane("Point Instructions", (BWidget)bEdgePane));
        BEdgePane bEdgePane2 = new BEdgePane();
        this.masterList = new BList();
        this.masterList.setController((ListController)new MasterListController());
        BGridPane bGridPane3 = new BGridPane(1);
        bGridPane3.setColumnAlign(BHalign.fill);
        bGridPane3.setValign(BValign.top);
        bGridPane3.add(null, (BValue)new BButton(this.mAddCmd));
        bGridPane3.add(null, (BValue)new BButton(this.mRemoveCmd));
        bGridPane3.add(null, (BValue)new BButton(this.mEditCmd));
        bGridPane3.add(null, (BValue)new BButton(this.mSaveCmd));
        bEdgePane2.setCenter((BWidget)this.masterList);
        bEdgePane2.setRight((BWidget)bGridPane3);
        bSplitPane.setWidget2((BWidget)new BTitlePane("Master Instructions List", (BWidget)bEdgePane2));
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        BSplitPane bSplitPane2 = new BSplitPane(BOrientation.horizontal, 35.0);
        bSplitPane2.setWidget1((BWidget)new BTitlePane("Points", (BWidget)this.table));
        bSplitPane2.setWidget2((BWidget)bSplitPane);
        this.setContent((BWidget)new BBorderPane((BWidget)bSplitPane2));
    }

    public void doLoadValue(BObject bObject, Context context) {
        System.out.println("start");
        this.alarmService = (BAlarmService)bObject;
        this.cx = context;
        this.model = new Model();
        this.table.setModel((TableModel)new DynamicTableModel((TableModel)this.model, new int[]{0, 1}));
        this.table.setController((TableController)new Controller());
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BAlarmInstructionsManager.this.enterBusy();
                try {
                    BAlarmInstructionsManager.this.alarmService.lease();
                    BAlarmInstructions bAlarmInstructions = BAlarmInstructionsManager.this.alarmService.getMasterAlarmInstructions();
                    for (int i = 0; i < bAlarmInstructions.size(); ++i) {
                        BAlarmInstructionsManager.this.masterList.addItem((Object)bAlarmInstructions.get(i));
                    }
                    BObject[] bObjectArray = BAlarmInstructionsManager.this.queryPoints();
                    for (int i = 0; i < bObjectArray.length; ++i) {
                        try {
                            BComponent bComponent = (BComponent)bObjectArray[i];
                            bComponent.lease();
                            Property[] propertyArray = bComponent.getPropertiesArray();
                            for (int j = 0; j < propertyArray.length; ++j) {
                                Property property = propertyArray[j];
                                if (property.getType().equals(BAlarmInstructions.TYPE)) {
                                    BAlarmInstructionsManager.this.model.addRow(bComponent, property);
                                    continue;
                                }
                                if (!property.getType().equals(BAlarmSourceInfo.TYPE)) continue;
                                BAlarmInstructionsManager.this.model.addRow(bComponent, property);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    BAlarmInstructionsManager.this.exitBusy();
                    BAlarmInstructionsManager.this.table.sizeColumnsToFit();
                }
            }
        }.start();
    }

    protected BObject[] queryPoints() {
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"station:|slot:/|bql:select slotPath from alarm:IAlarmSource").normalize();
        BITable bITable = ((BICollection)bOrd2.resolve().get()).toTable();
        Column column = bITable.getColumns().get(0);
        BObject[] bObjectArray = new BObject[bITable.size()];
        for (int i = 0; i < bITable.size(); ++i) {
            BOrd bOrd3 = BOrd.make((String)bITable.getString(i, column));
            bObjectArray[i] = bOrd3.resolve((BObject)this.alarmService).get();
        }
        return bObjectArray;
    }

    public BObject doSaveValue(BObject bObject, Context context) {
        BAlarmService bAlarmService = (BAlarmService)bObject;
        BFormat[] bFormatArray = new BFormat[this.masterList.getItemCount()];
        for (int i = 0; i < this.masterList.getItemCount(); ++i) {
            bFormatArray[i] = BFormat.make((String)this.masterList.getItem(i).toString());
        }
        bAlarmService.setMasterAlarmInstructions(BAlarmInstructions.make(bFormatArray));
        return bAlarmService;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MasterListController
    extends ListController {
        MasterListController() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            this.enabledCommands();
        }

        public void mouseReleased(BMouseEvent bMouseEvent) {
            super.mouseReleased(bMouseEvent);
            this.enabledCommands();
        }

        protected void enabledCommands() {
            int n = this.getList().getSelection().getItemCount();
            if (n > 0) {
                BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(true);
                BAlarmInstructionsManager.this.mRemoveCmd.setEnabled(true);
                BAlarmInstructionsManager.this.mEditCmd.setEnabled(true);
            } else {
                BAlarmInstructionsManager.this.addFromMasterCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mRemoveCmd.setEnabled(false);
                BAlarmInstructionsManager.this.mEditCmd.setEnabled(false);
            }
        }
    }

    class InstListController
    extends ListController {
        InstListController() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            this.enabledCommands();
        }

        public void mouseReleased(BMouseEvent bMouseEvent) {
            super.mouseReleased(bMouseEvent);
            this.enabledCommands();
        }

        protected void enabledCommands() {
            int n = BAlarmInstructionsManager.this.instructionList.getSelection().getItemCount();
            if (n > 0) {
                BAlarmInstructionsManager.this.removeCmd.setEnabled(true);
                BAlarmInstructionsManager.this.editCmd.setEnabled(true);
                if (this.getList().getItemCount() > 1) {
                    BAlarmInstructionsManager.this.moveUpCmd.setEnabled(true);
                    BAlarmInstructionsManager.this.moveDownCmd.setEnabled(true);
                } else {
                    BAlarmInstructionsManager.this.moveUpCmd.setEnabled(false);
                    BAlarmInstructionsManager.this.moveDownCmd.setEnabled(false);
                }
            } else {
                BAlarmInstructionsManager.this.removeCmd.setEnabled(false);
                BAlarmInstructionsManager.this.moveUpCmd.setEnabled(false);
                BAlarmInstructionsManager.this.moveDownCmd.setEnabled(false);
                BAlarmInstructionsManager.this.editCmd.setEnabled(false);
            }
        }
    }

    protected class Controller
    extends TableController {
        Hashtable components = new Hashtable();

        protected Controller() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            this.showInstructions();
        }

        public void mouseReleased(BMouseEvent bMouseEvent) {
            super.mouseReleased(bMouseEvent);
            this.showInstructions();
        }

        protected void setInstructions(int n, BAlarmInstructions bAlarmInstructions) {
            BComponent bComponent = BAlarmInstructionsManager.this.model.getComponent(n);
            bComponent.lease();
            Property property = BAlarmInstructionsManager.this.model.getProperty(n);
            if (property.getType() == BAlarmInstructions.TYPE) {
                bComponent.set(BAlarmInstructionsManager.this.model.getProperty(n), (BValue)bAlarmInstructions);
            } else {
                BAlarmSourceInfo bAlarmSourceInfo = (BAlarmSourceInfo)bComponent.get(BAlarmInstructionsManager.this.model.getProperty(n));
                bAlarmSourceInfo.lease();
                bAlarmSourceInfo.setAlarmInstructions(bAlarmInstructions);
            }
        }

        protected BAlarmInstructions getInstructions(int n) {
            BComponent bComponent = BAlarmInstructionsManager.this.model.getComponent(n);
            bComponent.lease();
            Property property = BAlarmInstructionsManager.this.model.getProperty(n);
            if (property.getType() == BAlarmInstructions.TYPE) {
                return (BAlarmInstructions)bComponent.get(property);
            }
            BAlarmSourceInfo bAlarmSourceInfo = (BAlarmSourceInfo)bComponent.get(BAlarmInstructionsManager.this.model.getProperty(n));
            bAlarmSourceInfo.lease();
            return bAlarmSourceInfo.getAlarmInstructions();
        }

        protected void showInstructions() {
            TableSelection tableSelection = this.getTable().getSelection();
            BAlarmInstructionsManager.this.instructionList.getSelection().deselectAll();
            if (tableSelection.getRowCount() == 1) {
                BAlarmInstructions bAlarmInstructions = this.getInstructions(tableSelection.getRow());
                BAlarmInstructionsManager.this.instructionList.removeAllItems();
                for (int i = 0; i < bAlarmInstructions.size(); ++i) {
                    BAlarmInstructionsManager.this.instructionList.addItem((Object)bAlarmInstructions.get(i));
                }
            } else if (tableSelection.getRowCount() > 1) {
                int n;
                BAlarmInstructionsManager.this.instructionList.removeAllItems();
                int[] nArray = tableSelection.getRows();
                BAlarmInstructions bAlarmInstructions = null;
                boolean bl = true;
                for (n = 0; n < nArray.length; ++n) {
                    BAlarmInstructions bAlarmInstructions2 = this.getInstructions(nArray[n]);
                    if (bAlarmInstructions == null) {
                        bAlarmInstructions = (BAlarmInstructions)bAlarmInstructions2.newCopy();
                        continue;
                    }
                    if (bAlarmInstructions.equivalent((Object)bAlarmInstructions2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (n = 0; n < bAlarmInstructions.size(); ++n) {
                        BAlarmInstructionsManager.this.instructionList.addItem((Object)bAlarmInstructions.get(n));
                    }
                }
            } else {
                return;
            }
            ((InstListController)BAlarmInstructionsManager.this.instructionList.getController()).enabledCommands();
            BAlarmInstructionsManager.this.saveCmd.setEnabled(false);
        }
    }

    protected class Model
    extends DefaultTableModel {
        Hashtable controllers = new Hashtable();

        public Model() {
            super(new String[]{"Point", "Condition", "Path"});
        }

        public BComponent getComponent(int n) {
            return (BComponent)super.getValueAt(n, 0);
        }

        public Property getProperty(int n) {
            return (Property)super.getValueAt(n, 1);
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 2) {
                try {
                    BComponent bComponent = this.getComponent(n);
                    return bComponent.toPathString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                if (n2 == 1) {
                    return ((Property)super.getValueAt(n, n2)).getDefaultDisplayName(BAlarmInstructionsManager.this.cx);
                }
                if (n2 == 0) {
                    BComponent bComponent = this.getComponent(n);
                    bComponent.lease();
                    String string = bComponent.getDisplayName(BAlarmInstructionsManager.this.cx);
                    if (bComponent instanceof BAlarmSourceExt) {
                        string = ((BAlarmSourceExt)bComponent).getSourceName().format((Object)bComponent);
                    } else {
                        BAlarmSourceInfo[] bAlarmSourceInfoArray = (BAlarmSourceInfo[])bComponent.getChildren(class$javax$baja$alarm$BAlarmSourceInfo == null ? (class$javax$baja$alarm$BAlarmSourceInfo = BAlarmInstructionsManager.class$("javax.baja.alarm.BAlarmSourceInfo")) : class$javax$baja$alarm$BAlarmSourceInfo);
                        if (bAlarmSourceInfoArray.length > 0) {
                            bAlarmSourceInfoArray[0].lease();
                            string = bAlarmSourceInfoArray[0].getSourceName().format((Object)bAlarmSourceInfoArray[0]);
                        }
                    }
                    return string;
                }
            }
            return "???";
        }

        public void addRow(BComponent bComponent, Property property) {
            BComponent bComponent2 = bComponent;
            this.addRow(new Object[]{bComponent2, property, null});
        }
    }
}

