/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BAlarmExtStatusJob;
import com.tridium.alarm.ui.BAlarmClassFE;
import com.tridium.alarm.ui.BInstructionsFE;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

public class BAlarmExtManager
extends BWbComponentView {
    public static final Action updateCommands = BAlarmExtManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmExtManager == null ? (class$com$tridium$alarm$ui$BAlarmExtManager = BAlarmExtManager.class$("com.tridium.alarm.ui.BAlarmExtManager")) : class$com$tridium$alarm$ui$BAlarmExtManager));
    private static final String[] ATTRS = new String[]{"parent.toPathString", "toPathString", "name", "alarmState", "alarmEnable.isToOffnormal", "alarmEnable.isToFault", "alarmState.ordinal", "alarmClass", "alarmInstructions", "status"};
    private static final int[] DISPLAY = new int[]{0, 2, 3, 4, 5, 7, 8};
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private BAlarmService alarmService;
    private BTable table;
    private BITable itable;
    private CollectionTableModel collectionModel;
    private ToggleCommand enableToOffnormal;
    private ToggleCommand enableToFault;
    private Command editAlarmClass;
    private Command editInstructions;
    private IntHashMap nameMap;
    private BBorderPane topPane;
    private BJobBar jobBar;
    private BJob job;
    private boolean jobComplete;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmExtManager;
    static /* synthetic */ Class class$com$tridium$alarm$BAlarmExtStatusJob;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmExtManager() {
        BEdgePane bEdgePane = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        this.topPane = new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        bEdgePane.setTop((BWidget)this.topPane);
        this.topPane.setVisible(false);
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("alarm.alarmSourceExts"), (BTable)this.table, (String)lex.getText("alarm.exts")));
        this.setContent((BWidget)bEdgePane);
        this.enableToOffnormal = new EnableToOffnormal();
        this.enableToFault = new EnableToFault();
        this.editAlarmClass = new EditAlarmClass();
        this.editInstructions = new EditInstructions();
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"alarm.point");
        this.nameMap.put(2, (Object)"alarm.extension");
        this.nameMap.put(3, (Object)"alarm.alarmState");
        this.nameMap.put(4, (Object)"alarm.toOffnormalEnabled.label");
        this.nameMap.put(5, (Object)"alarm.toFaultEnabled.label");
        this.nameMap.put(7, (Object)"alarm.alarmClass");
        this.nameMap.put(8, (Object)"alarm.instructions");
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.alarmService = (BAlarmService)bObject;
        this.updateTable();
        this.table.fireTableModified(null);
    }

    private void updateTable() {
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)this.query()).normalize();
        this.itable = ((BICollection)bOrd2.resolve().get()).toTable();
        boolean bl = false;
        int n = -1;
        boolean bl2 = true;
        if (this.table.getModel() instanceof AlarmExtTableModel) {
            bl = true;
            n = ((AlarmExtTableModel)this.table.getModel()).sortCol;
            bl2 = ((AlarmExtTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel columnNameTableModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        AlarmExtTableModel alarmExtTableModel = new AlarmExtTableModel((TableModel)columnNameTableModel, DISPLAY);
        alarmExtTableModel.setColumnShowable(1, false);
        alarmExtTableModel.setColumnShowable(6, false);
        if (bl && n != -1) {
            alarmExtTableModel.sortByColumn(n, bl2);
        }
        this.table.setModel((TableModel)alarmExtTableModel);
        this.table.relayout();
    }

    private String query() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ATTRS[i]);
        }
        stringBuffer.append(" from alarm:AlarmSourceExt");
        return stringBuffer.toString();
    }

    public void doUpdateCommands() {
    }

    public BOrd[] getSelectedOrds() {
        int[] nArray = this.table.getSelection().getRows();
        int n = nArray.length;
        BOrd[] bOrdArray = new BOrd[n];
        for (int i = 0; i < n; ++i) {
            String string = this.itable.getString(nArray[i], this.itable.getColumns().get("toPathString"));
            bOrdArray[i] = BOrd.make((String)("station:|slot:" + string)).normalize();
        }
        return bOrdArray;
    }

    public BAlarmSourceExt getExtensionForRow(int n) {
        String string = this.collectionModel.getValueAt(n, 1).toString();
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("slot:" + string)).normalize();
        return (BAlarmSourceExt)bOrd2.resolve().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableToOffnormal() {
        BWidgetShell bWidgetShell;
        BOrd[] bOrdArray = this.getSelectedOrds();
        if (bOrdArray.length == 0) {
            return;
        }
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"service:baja:JobService");
        BJobService bJobService = (BJobService)bOrd2.resolve().get();
        bJobService.lease();
        BAlarmExtStatusJob[] bAlarmExtStatusJobArray = (BAlarmExtStatusJob[])bJobService.getChildren(class$com$tridium$alarm$BAlarmExtStatusJob == null ? (class$com$tridium$alarm$BAlarmExtStatusJob = BAlarmExtManager.class$("com.tridium.alarm.BAlarmExtStatusJob")) : class$com$tridium$alarm$BAlarmExtStatusJob);
        if (bAlarmExtStatusJobArray != null) {
            for (int i = 0; i < bAlarmExtStatusJobArray.length; ++i) {
                if (bAlarmExtStatusJobArray[i] == null) continue;
                bAlarmExtStatusJobArray[i].lease();
                if (!bAlarmExtStatusJobArray[i].isAlive()) continue;
                BDialog.error((BWidget)this, (String)lex.getText("alarmExtManager.commandFail"), (Object)lex.getText("alarmExtManager.statusJobExists"));
                return;
            }
        }
        if (!this.topPane.isVisible()) {
            this.topPane.setVisible(true);
            this.topPane.getParentWidget().relayout();
        }
        if ((bWidgetShell = this.getShell()) != null) {
            bWidgetShell.enterBusy();
        }
        try {
            BOrd bOrd3 = BOrd.make((BOrd)bOrd, (String)"service:alarm:AlarmService");
            BAlarmService bAlarmService = (BAlarmService)bOrd3.resolve().get();
            BVector bVector = new BVector();
            for (int i = 0; i < bOrdArray.length; ++i) {
                bVector.add("o" + i, (BValue)bOrdArray[i]);
            }
            if (this.enableToOffnormal.isSelected()) {
                this.setJob(bAlarmService.enableToOffnormal(bVector), bAlarmService);
            } else {
                this.setJob(bAlarmService.disableToOffnormal(bVector), bAlarmService);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bWidgetShell != null) {
                bWidgetShell.exitBusy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableToFault() {
        BWidgetShell bWidgetShell;
        BOrd[] bOrdArray = this.getSelectedOrds();
        if (bOrdArray.length == 0) {
            return;
        }
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"service:baja:JobService");
        BJobService bJobService = (BJobService)bOrd2.resolve().get();
        bJobService.lease();
        BAlarmExtStatusJob[] bAlarmExtStatusJobArray = (BAlarmExtStatusJob[])bJobService.getChildren(class$com$tridium$alarm$BAlarmExtStatusJob == null ? (class$com$tridium$alarm$BAlarmExtStatusJob = BAlarmExtManager.class$("com.tridium.alarm.BAlarmExtStatusJob")) : class$com$tridium$alarm$BAlarmExtStatusJob);
        if (bAlarmExtStatusJobArray != null) {
            for (int i = 0; i < bAlarmExtStatusJobArray.length; ++i) {
                if (bAlarmExtStatusJobArray[i] == null) continue;
                bAlarmExtStatusJobArray[i].lease();
                if (!bAlarmExtStatusJobArray[i].isAlive()) continue;
                BDialog.error((BWidget)this, (String)lex.getText("alarmExtManager.commandFail"), (Object)lex.getText("alarmExtManager.statusJobExists"));
                return;
            }
        }
        if (!this.topPane.isVisible()) {
            this.topPane.setVisible(true);
            this.topPane.getParentWidget().relayout();
        }
        if ((bWidgetShell = this.getShell()) != null) {
            bWidgetShell.enterBusy();
        }
        try {
            BOrd bOrd3 = BOrd.make((BOrd)bOrd, (String)"service:alarm:AlarmService");
            BAlarmService bAlarmService = (BAlarmService)bOrd3.resolve().get();
            BVector bVector = new BVector();
            for (int i = 0; i < bOrdArray.length; ++i) {
                bVector.add("o" + i, (BValue)bOrdArray[i]);
            }
            if (this.enableToOffnormal.isSelected()) {
                this.setJob(bAlarmService.enableToFault(bVector), bAlarmService);
            } else {
                this.setJob(bAlarmService.disableToFault(bVector), bAlarmService);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bWidgetShell != null) {
                bWidgetShell.exitBusy();
            }
        }
    }

    private BJob getJob() {
        return this.job;
    }

    private void setJob(BJob bJob) {
        this.job = bJob;
        this.jobComplete = false;
        this.registerForComponentEvents((BComponent)bJob);
        this.jobBar.load(bJob);
        if (bJob != null && bJob.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(bJob);
        }
    }

    private void setJob(BOrd bOrd, BAlarmService bAlarmService) throws Exception {
        bAlarmService.getComponentSpace().sync();
        BJob bJob = (BJob)bOrd.get((BObject)bAlarmService);
        this.setJob(bJob);
    }

    private void jobComplete(BJob bJob) {
        this.updateTable();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AlarmExtTableModel
    extends DynamicTableModel {
        public int sortCol = -1;
        public boolean sortAsc = true;

        public AlarmExtTableModel(TableModel tableModel, int[] nArray) {
            super(tableModel, nArray);
        }

        public AlarmExtTableModel(TableModel tableModel) {
            super(tableModel);
        }

        public void sortByColumn(int n, boolean bl) {
            this.sortCol = n;
            this.sortAsc = bl;
            super.sortByColumn(n, bl);
        }

        public Object getValueAt(int n, int n2) {
            Object object = super.getValueAt(n, n2);
            if (this.toRootColumnIndex(n2) == 7) {
                try {
                    return BAlarmExtManager.this.alarmService.getAlarmClassDisplayName(BString.make((String)object.toString()), null).toString();
                }
                catch (Exception exception) {
                    return object.toString();
                }
            }
            if (object instanceof String) {
                object = SlotPath.unescape((String)((String)object));
            }
            return object;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int n, BITable bITable) {
            super("alarmExtManager.goto.point", n, bITable);
        }

        public BOrd getTargetOrd() {
            return BOrd.make((String)("slot:" + BAlarmExtManager.this.collectionModel.getValueAt(this.row, 0)));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable itable;

        public Goto(String string, int n, BITable bITable) {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmExtManager == null ? (class$com$tridium$alarm$ui$BAlarmExtManager = BAlarmExtManager.class$("com.tridium.alarm.ui.BAlarmExtManager")) : class$com$tridium$alarm$ui$BAlarmExtManager)), string);
            this.row = n;
            this.itable = bITable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd bOrd = this.getTargetOrd();
            if (bOrd == null) {
                return null;
            }
            BOrd bOrd2 = ((BWbShell)BAlarmExtManager.this.getShell()).getActiveOrd();
            BOrd bOrd3 = BOrd.make((BOrd)bOrd2, (BOrd)bOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(bOrd3);
            return null;
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        BIDataTable lastTable = null;
        int stateOrdCol = -1;

        private CellRenderer() {
        }

        protected void paintCellBackground(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.selected) {
                super.paintCellBackground(graphics, cell);
                return;
            }
            try {
                ColumnList columnList = BAlarmExtManager.this.itable.getColumns();
                if (BAlarmExtManager.this.itable != this.lastTable || this.stateOrdCol == -1) {
                    this.stateOrdCol = columnList.indexOf("alarmState.ordinal");
                }
                BColor bColor = null;
                BColor bColor2 = null;
                TableModel tableModel = BAlarmExtManager.this.table.getModel();
                if (!(tableModel instanceof WrapperTableModel)) {
                    super.paintCellBackground(graphics, cell);
                    return;
                }
                int n = Integer.parseInt(((WrapperTableModel)tableModel).getRootModel().getValueAt(cell.row, this.stateOrdCol).toString());
                if (n != BAlarmState.normal.getOrdinal()) {
                    if (n == BAlarmState.fault.getOrdinal()) {
                        bColor = (BColor)BStatus.faultBg;
                        bColor2 = (BColor)BStatus.faultFg;
                    } else {
                        bColor = (BColor)BStatus.alarmBg;
                        bColor2 = (BColor)BStatus.alarmFg;
                    }
                }
                if (bColor != null) {
                    graphics.setBrush(bColor);
                    graphics.fillRect(0.0, 0.0, cell.width, cell.height);
                    graphics.setBrush(bColor2);
                } else {
                    graphics.setBrush(Theme.table().getTextBrush());
                }
                graphics.setFont(Theme.table().getCellFont());
            }
            catch (ClassCastException classCastException) {
                super.paintCellBackground(graphics, cell);
            }
            catch (NullPointerException nullPointerException) {
                super.paintCellBackground(graphics, cell);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            ColumnList columnList = BAlarmExtManager.this.itable.getColumns();
            BOrd bOrd = null;
            String string = BAlarmExtManager.this.collectionModel.getValueAt(n, 1).toString();
            BOrd bOrd2 = ((BWbShell)this.getShell()).getActiveOrd();
            bOrd = BOrd.make((BOrd)bOrd2, (String)("slot:" + string)).normalize();
            if (bOrd != null) {
                ((BWbShell)this.getShell()).hyperlink(bOrd);
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            ColumnList columnList = BAlarmExtManager.this.itable.getColumns();
            String string = BAlarmExtManager.this.collectionModel.getValueAt(n, 1).toString();
            BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("slot:" + string)).normalize();
            BComponent bComponent = (BComponent)bOrd2.get();
            BMenu bMenu = new BMenu();
            bMenu.add(null, (BValue)new BSubMenuItem(NavMenuUtil.makeViewsMenu((BWidget)this.getTable(), (BObject)bComponent)));
            bMenu.add(null, (BValue)new BSubMenuItem(NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)bComponent)));
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)new GotoPoint(n, BAlarmExtManager.this.itable));
            bMenu.add(null, (BValue)new BSeparator());
            if (BAlarmExtManager.this.table.getModel().getSelection().getRows().length == 1) {
                BAlarmExtManager.this.enableToOffnormal.setSelected(BAlarmExtManager.this.itable.getBoolean(n, columnList.get("alarmEnable.isToOffnormal")));
                BAlarmExtManager.this.enableToFault.setSelected(BAlarmExtManager.this.itable.getBoolean(n, columnList.get("alarmEnable.isToFault")));
            }
            bMenu.add("toOffnormal", (Command)BAlarmExtManager.this.enableToOffnormal);
            bMenu.add("toFault", (Command)BAlarmExtManager.this.enableToFault);
            bMenu.add("editAlarmClass", BAlarmExtManager.this.editAlarmClass);
            bMenu.add("editInstructions", BAlarmExtManager.this.editInstructions);
            bMenu.open((BWidget)this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    public class EditInstructions
    extends Command {
        public EditInstructions() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmExtManager == null ? (class$com$tridium$alarm$ui$BAlarmExtManager = BAlarmExtManager.class$("com.tridium.alarm.ui.BAlarmExtManager")) : class$com$tridium$alarm$ui$BAlarmExtManager)), "alarm.editInstructions");
        }

        public CommandArtifact doInvoke() {
            Object object;
            int[] nArray = BAlarmExtManager.this.table.getSelection().getRows();
            BAlarmInstructions bAlarmInstructions = BAlarmInstructions.NULL;
            if (nArray.length == 1) {
                object = BAlarmExtManager.this.getExtensionForRow(nArray[0]);
                object.lease();
                bAlarmInstructions = ((BAlarmSourceExt)object).getAlarmInstructions();
            }
            object = new BInstructionsFE();
            BAlarmExtManager.this.add("temp", (BValue)object);
            object.loadValue((BObject)bAlarmInstructions, null);
            BAlarmExtManager.this.remove("temp");
            int n = BDialog.open((BWidget)BAlarmExtManager.this, (String)lex.get("alarm.editAlarmClass.label"), (Object)object, (int)3, (BImage)null);
            if (n == 1) {
                try {
                    bAlarmInstructions = (BAlarmInstructions)object.saveValue((BObject)bAlarmInstructions, null);
                    for (int i = 0; i < nArray.length; ++i) {
                        BAlarmSourceExt bAlarmSourceExt = BAlarmExtManager.this.getExtensionForRow(nArray[i]);
                        bAlarmSourceExt.lease();
                        bAlarmSourceExt.setAlarmInstructions(bAlarmInstructions);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BAlarmExtManager.this.updateTable();
            }
            return null;
        }
    }

    public class EditAlarmClass
    extends Command {
        public EditAlarmClass() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmExtManager == null ? (class$com$tridium$alarm$ui$BAlarmExtManager = BAlarmExtManager.class$("com.tridium.alarm.ui.BAlarmExtManager")) : class$com$tridium$alarm$ui$BAlarmExtManager)), "alarm.editAlarmClass");
        }

        public CommandArtifact doInvoke() {
            Object object;
            int[] nArray = BAlarmExtManager.this.table.getSelection().getRows();
            String string = "";
            if (nArray.length == 1) {
                object = BAlarmExtManager.this.getExtensionForRow(nArray[0]);
                object.lease();
                string = ((BAlarmSourceExt)object).getAlarmClass();
            }
            object = new BAlarmClassFE();
            BAlarmExtManager.this.add("temp", (BValue)object);
            object.loadValue((BObject)BString.make((String)string), null);
            BAlarmExtManager.this.remove("temp");
            int n = BDialog.open((BWidget)BAlarmExtManager.this, (String)lex.get("alarm.editAlarmClass.label"), (Object)object, (int)3, (BImage)null);
            if (n == 1) {
                try {
                    string = object.saveValue((BObject)BString.make((String)string), null).toString();
                    for (int i = 0; i < nArray.length; ++i) {
                        BAlarmSourceExt bAlarmSourceExt = BAlarmExtManager.this.getExtensionForRow(nArray[i]);
                        bAlarmSourceExt.lease();
                        bAlarmSourceExt.setAlarmClass(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BAlarmExtManager.this.updateTable();
            }
            return null;
        }
    }

    public class EnableToFault
    extends ToggleCommand {
        public EnableToFault() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmExtManager == null ? (class$com$tridium$alarm$ui$BAlarmExtManager = BAlarmExtManager.class$("com.tridium.alarm.ui.BAlarmExtManager")) : class$com$tridium$alarm$ui$BAlarmExtManager)), "alarm.toFaultEnabled");
        }

        public CommandArtifact doInvoke() {
            BAlarmExtManager.this.enableToFault();
            return null;
        }
    }

    public class EnableToOffnormal
    extends ToggleCommand {
        public EnableToOffnormal() {
            super((BWidget)BAlarmExtManager.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmExtManager == null ? (class$com$tridium$alarm$ui$BAlarmExtManager = BAlarmExtManager.class$("com.tridium.alarm.ui.BAlarmExtManager")) : class$com$tridium$alarm$ui$BAlarmExtManager)), "alarm.toOffnormalEnabled");
        }

        public CommandArtifact doInvoke() {
            BAlarmExtManager.this.enableToOffnormal();
            return null;
        }
    }
}

