/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.BNotesDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.ui.theme.Theme;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class BAlarmDetailsDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmDetailsDialog == null ? (class$com$tridium$alarm$ui$BAlarmDetailsDialog = BAlarmDetailsDialog.class$("com.tridium.alarm.ui.BAlarmDetailsDialog")) : class$com$tridium$alarm$ui$BAlarmDetailsDialog));
    BAlarmConsole console;
    BAlarmService alarmService;
    BGridPane alarmPane = new BGridPane(2);
    protected BAlarmRecord alarm;
    BTimeZoneDisplay timeZoneDisplay;
    BAlarmDbChannel alarmDbChannel;
    ConsoleTableModel tm;
    Log logger = Log.getLog((String)"alarm");
    Command ackCmd;
    Command closeCmd;
    Command hyperlinkCmd;
    Command notesCmd;
    Command showVideoCmd;
    Command nextCmd;
    Command prevCmd;
    public static final BFacets TIME_FACETS = BFacets.make((String)"showSeconds", (boolean)true);
    public static final UiLexicon lex = new UiLexicon(class$com$tridium$alarm$ui$BAlarmDetailsDialog == null ? (class$com$tridium$alarm$ui$BAlarmDetailsDialog = BAlarmDetailsDialog.class$("com.tridium.alarm.ui.BAlarmDetailsDialog")) : class$com$tridium$alarm$ui$BAlarmDetailsDialog);
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmDetailsDialog;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsole;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    public BAlarmDetailsDialog() {
        throw new IllegalStateException();
    }

    public BAlarmDetailsDialog(BAlarmConsole bAlarmConsole, BTimeZoneDisplay bTimeZoneDisplay, BAlarmRecord bAlarmRecord, ConsoleTableModel consoleTableModel) {
        this(bAlarmConsole, bTimeZoneDisplay, bAlarmRecord, consoleTableModel, null);
    }

    public BAlarmDetailsDialog(BAlarmService bAlarmService, BTimeZoneDisplay bTimeZoneDisplay, BAlarmRecord bAlarmRecord, ConsoleTableModel consoleTableModel, Context context) {
        this(bAlarmService, null, bTimeZoneDisplay, bAlarmRecord, consoleTableModel, context);
    }

    public BAlarmDetailsDialog(BAlarmService bAlarmService, BTimeZoneDisplay bTimeZoneDisplay, BAlarmRecord bAlarmRecord, ConsoleTableModel consoleTableModel, Context context, BAlarmDbChannel bAlarmDbChannel) {
        this(bAlarmService, null, bTimeZoneDisplay, bAlarmRecord, consoleTableModel, context, bAlarmDbChannel);
    }

    public BAlarmDetailsDialog(BAlarmConsole bAlarmConsole, BTimeZoneDisplay bTimeZoneDisplay, BAlarmRecord bAlarmRecord, ConsoleTableModel consoleTableModel, Context context) {
        this(null, bAlarmConsole, bTimeZoneDisplay, bAlarmRecord, consoleTableModel, context);
    }

    protected BAlarmDetailsDialog(BAlarmService bAlarmService, BAlarmConsole bAlarmConsole, BTimeZoneDisplay bTimeZoneDisplay, BAlarmRecord bAlarmRecord, ConsoleTableModel consoleTableModel, Context context) {
        this(bAlarmService, bAlarmConsole, bTimeZoneDisplay, bAlarmRecord, consoleTableModel, context, null);
    }

    protected BAlarmDetailsDialog(BAlarmService bAlarmService, BAlarmConsole bAlarmConsole, BTimeZoneDisplay bTimeZoneDisplay, BAlarmRecord bAlarmRecord, ConsoleTableModel consoleTableModel, Context context, BAlarmDbChannel bAlarmDbChannel) {
        super((BWidget)bAlarmConsole, "Alarm Record", true);
        BEdgePane bEdgePane;
        Object object;
        BAlarmClass bAlarmClass;
        this.console = bAlarmConsole;
        this.alarm = bAlarmRecord;
        this.tm = consoleTableModel;
        this.timeZoneDisplay = bTimeZoneDisplay;
        if (bAlarmConsole != null) {
            this.alarmService = bAlarmConsole.getAlarmService();
        }
        if (bAlarmService != null) {
            this.alarmService = bAlarmService;
        }
        this.alarmDbChannel = bAlarmDbChannel;
        this.hyperlinkCmd = new HyperlinkCommand((BWidget)this);
        BButton bButton = new BButton(this.hyperlinkCmd, true, true);
        this.ackCmd = new AckCommand((BWidget)this);
        BButton bButton2 = new BButton(this.ackCmd, true, true);
        this.notesCmd = new NotesCommand((BWidget)this);
        BButton bButton3 = new BButton(this.notesCmd, true, true);
        this.showVideoCmd = new ShowVideoCommand((BWidget)this);
        BButton bButton4 = new BButton(this.showVideoCmd, true, true);
        this.closeCmd = new CloseCommand((BWidget)this);
        BButton bButton5 = new BButton(this.closeCmd, true, true);
        this.nextCmd = new PrevCommand((BWidget)this, context);
        BButton bButton6 = new BButton(this.nextCmd, false, true);
        this.prevCmd = new NextCommand((BWidget)this, context);
        BButton bButton7 = new BButton(this.prevCmd, false, true);
        BOrdList bOrdList = bAlarmRecord.getSource();
        boolean bl = false;
        int n = consoleTableModel.getAlarmCount(bOrdList);
        for (int i = 0; i < n; ++i) {
            if (!consoleTableModel.getRecord(bOrdList, i).getUuid().equals((Object)bAlarmRecord.getUuid())) continue;
            this.prevCmd.setEnabled(i != 0);
            this.nextCmd.setEnabled(i + 1 < n);
            bl = true;
            break;
        }
        if (!bl) {
            this.prevCmd.setEnabled(false);
            this.nextCmd.setEnabled(false);
        }
        this.createAlarmPane(context);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add("next", (BValue)bButton6);
        if (bAlarmConsole != null) {
            bAlarmClass = bAlarmConsole.getAlarmService().lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (bAlarmClass.getPermissions(bAlarmConsole.ctx).hasOperatorWrite()) {
                bGridPane.add("ack", (BValue)bButton2);
            }
            bGridPane.add("url", (BValue)bButton);
            bGridPane.add("notes", (BValue)bButton3);
            if (BAlarmConsole.isVideoDriverAvailable() && (object = bAlarmRecord.getAlarmData().gets("cameraOrd", null)) != null && !(bEdgePane = BOrd.make((String)object)).equals((Object)BOrd.NULL)) {
                bGridPane.add("showVideo", (BValue)bButton4);
            }
        }
        bGridPane.add("close", (BValue)bButton5);
        bGridPane.add("prev", (BValue)bButton7);
        bGridPane.setColumnCount(bGridPane.getChildWidgets().length);
        bAlarmClass = new BScrollPane();
        object = new BBorderPane();
        bAlarmClass.setContent((BWidget)object);
        object.setContent((BWidget)this.alarmPane);
        bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bAlarmClass));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane));
        this.setContent((BWidget)bEdgePane);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    void createAlarmPane(Context context) {
        Object object;
        Object object2;
        BOrd bOrd;
        Property[] propertyArray = this.alarm.loadSlots().getPropertiesArray();
        int n = propertyArray.length;
        this.alarmPane.removeAll();
        this.alarmPane.setColorRows(true);
        this.alarmPane.setRowAlign(BValign.top);
        this.alarmPane.setColumnGap(9.0);
        for (int i = 0; i < n; ++i) {
            BTextEditor bTextEditor;
            if (Flags.isHidden((BComplex)this.alarm, (Slot)propertyArray[i])) continue;
            bOrd = new BLabel(this.alarm.getDisplayName((Slot)propertyArray[i], this.console != null ? this.console.ctx : null), BHalign.left);
            bOrd.setFont(Theme.label().getBoldText());
            this.alarmPane.add(null, (BValue)bOrd, null);
            if (propertyArray[i].getName().equals("alarmData")) {
                object2 = (BFacets)this.alarm.get(propertyArray[i]);
                object = new BGridPane(2);
                object.setHalign(BHalign.fill);
                object.setColumnGap(5.0);
                object.setRowAlign(BValign.top);
                bTextEditor = object2.list();
                bTextEditor = this.addNotePropertyIfNotPresent((String[])bTextEditor);
                SortUtil.sort((Object[])bTextEditor, (Object[])bTextEditor, (Comparator)new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((String)object).compareToIgnoreCase((String)object2);
                    }
                });
                for (int j = 0; j < ((Object[])bTextEditor).length; ++j) {
                    BFormat bFormat;
                    Object object3;
                    BLabel bLabel = new BLabel(lex.get("alarmData." + (String)bTextEditor[j], TextUtil.toFriendly((String)bTextEditor[j])), BHalign.left);
                    bLabel.setFont(Theme.label().getBoldText());
                    object.add(null, (BValue)bLabel, null);
                    if (bTextEditor[j].equals("notes")) {
                        object3 = new Command((BWidget)this, "", BImage.make((BIcon)BIcon.std((String)"doubleArrowRight.png")), null, ""){

                            public CommandArtifact doInvoke() {
                                try {
                                    BAlarmDetailsDialog.this.notesCmd.doInvoke();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return null;
                            }
                        };
                        bFormat = new BToolBar();
                        bFormat.add("eb", (BValue)new BButton(object3, false, true));
                        object.add(null, (BValue)bFormat, null);
                        continue;
                    }
                    if (bTextEditor[j].equals("msgText")) {
                        bFormat = BFormat.make((String)object2.getFacet((String)bTextEditor[j]).toString());
                        object3 = bFormat.format((Object)this.alarm);
                    } else {
                        object3 = bTextEditor[j].equals("instructions") ? BFormat.make((String)object2.getFacet((String)bTextEditor[j]).toString()).format((Object)this) : object2.getFacet((String)bTextEditor[j]).toString();
                    }
                    object3 = TextUtil.replace((String)object3, (String)"\\n", (String)"\n");
                    bFormat = new BTextEditor((String)object3, false);
                    bFormat.setRenderer(new TextRenderer(){

                        public BBrush getBackground() {
                            return BBrush.NULL;
                        }
                    });
                    object.add(null, (BValue)bFormat);
                }
                this.alarmPane.add(null, (BValue)object, null);
                continue;
            }
            if (propertyArray[i].getType().is(BOrdList.TYPE)) {
                try {
                    BString bString;
                    object2 = (BOrdList)this.alarm.get(propertyArray[i]);
                    object = new StringBuffer();
                    for (int j = object2.size() - 1; j >= 0; --j) {
                        if (j < object2.size() - 1) {
                            ((StringBuffer)object).append("-> ");
                        }
                        ((StringBuffer)object).append(SlotPath.unescape((String)object2.get(j).encodeToString()).toString());
                        if (j - 1 < 0) continue;
                        ((StringBuffer)object).append("\n");
                    }
                    if (propertyArray[i].getName().equals("source") && (bString = (BString)this.alarm.getAlarmData().get("sourceName")) != null && bString != BString.DEFAULT) {
                        ((StringBuffer)object).insert(0, BFormat.make((String)bString.toString(context)).format((Object)this.alarm) + "\n");
                    }
                    bTextEditor = new BTextEditor(((StringBuffer)object).toString(), false);
                    bTextEditor.setRenderer(new TextRenderer(){

                        public BBrush getBackground() {
                            return BBrush.NULL;
                        }
                    });
                    this.alarmPane.add(null, (BValue)bTextEditor, null);
                }
                catch (Exception exception) {
                    this.alarmPane.add(null, (BValue)new BLabel("unknown"), null);
                }
                continue;
            }
            if (propertyArray[i].getType().is(BAbsTime.TYPE)) {
                object2 = (BAbsTime)this.alarm.get(propertyArray[i]);
                object = "";
                object = this.timeZoneDisplay == BTimeZoneDisplay.source ? object2.toString((Context)BFacets.make((BFacets)this.alarm.getAlarmData(), (BFacets)TIME_FACETS)) : object2.toString((Context)BFacets.make((BFacets)TIME_FACETS, (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
                bTextEditor = new BTextEditor((String)object, false);
                bTextEditor.setRenderer(new TextRenderer(){

                    public BBrush getBackground() {
                        return BBrush.NULL;
                    }
                });
                this.alarmPane.add(null, (BValue)bTextEditor);
                continue;
            }
            object2 = SlotPath.unescape((String)this.alarm.get(propertyArray[i].getName()).toString());
            object2 = TextUtil.replace((String)object2, (String)"\\n", (String)"\n");
            if (propertyArray[i].getName().equals("alarmClass")) {
                object2 = this.alarmService.getAlarmClassDisplayName(BString.make((String)this.alarm.get(propertyArray[i].getName()).toString()), context).toString();
            }
            object = new BTextEditor((String)object2, false);
            object.setRenderer(new TextRenderer(){

                public BBrush getBackground() {
                    return BBrush.NULL;
                }
            });
            this.alarmPane.add(null, (BValue)object);
        }
        BString bString = (BString)this.alarm.getAlarmData().get("hyperlinkOrd");
        bOrd = BOrd.NULL;
        if (bString != null) {
            bOrd = BOrd.make((String)bString.toString());
        }
        if (bOrd == null || bOrd.isNull() && this.console != null) {
            object2 = this.console.options.getAlarmClassMapping();
            object = object2.getAlarmClassDefFor(this.alarm.getAlarmClass());
            bOrd = ((BAlarmClassDef)((Object)object)).getAlarmUrl();
        }
        if (bOrd != null && !bOrd.isNull()) {
            this.hyperlinkCmd.setEnabled(true);
        } else {
            this.hyperlinkCmd.setEnabled(false);
        }
    }

    private String[] addNotePropertyIfNotPresent(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"notes".equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            String[] stringArray2 = new String[stringArray.length + 1];
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = stringArray[n];
            }
            stringArray2[n] = "notes";
            stringArray = stringArray2;
        }
        return stringArray;
    }

    protected void alarmCleared() {
        this.notesCmd.setEnabled(false);
        this.ackCmd.setEnabled(false);
        this.hyperlinkCmd.setEnabled(false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ShowVideoCommand
    extends Command {
        public ShowVideoCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.showVideo");
        }

        public CommandArtifact doInvoke() {
            block8: {
                try {
                    Class clazz = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.alarm.AlarmConsoleExt");
                    if (clazz != null) {
                        Method method = clazz.getMethod("doShowVideo", class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmDetailsDialog.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole, class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmDetailsDialog.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord);
                        if (method != null) {
                            method.invoke((Object)clazz, new Object[]{BAlarmDetailsDialog.this.console, BAlarmDetailsDialog.this.alarm});
                        } else {
                            System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                        }
                        break block8;
                    }
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)noSuchMethodException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)illegalAccessException);
                }
            }
            return null;
        }
    }

    private class NextCommand
    extends Command {
        Context cx;

        public NextCommand(BWidget bWidget, Context context) {
            super(bWidget, (Lexicon)UiLexicon.bajaui, "commands.forward");
            this.cx = context;
        }

        public String getLabel() {
            return "Previous";
        }

        public CommandArtifact doInvoke() {
            BOrdList bOrdList = BAlarmDetailsDialog.this.alarm.getSource();
            int n = BAlarmDetailsDialog.this.tm.getAlarmCount(bOrdList);
            for (int i = 0; i < n; ++i) {
                if (!BAlarmDetailsDialog.this.tm.getRecord(bOrdList, i).getUuid().equals((Object)BAlarmDetailsDialog.this.alarm.getUuid())) continue;
                if (i > 0) {
                    BAlarmDetailsDialog.this.alarm = BAlarmDetailsDialog.this.tm.getRecord(bOrdList, i - 1);
                    BAlarmDetailsDialog.this.createAlarmPane(this.cx);
                    BAlarmDetailsDialog.this.alarmPane.relayout();
                    --i;
                }
                BAlarmDetailsDialog.this.prevCmd.setEnabled(i != 0);
                BAlarmDetailsDialog.this.nextCmd.setEnabled(i + 1 < n);
                return null;
            }
            BAlarmDetailsDialog.this.prevCmd.setEnabled(false);
            BAlarmDetailsDialog.this.nextCmd.setEnabled(false);
            return null;
        }
    }

    private class PrevCommand
    extends Command {
        Context cx;

        public PrevCommand(BWidget bWidget, Context context) {
            super(bWidget, (Lexicon)UiLexicon.bajaui, "commands.back");
            this.cx = context;
        }

        public String getLabel() {
            return "Next";
        }

        public CommandArtifact doInvoke() {
            BOrdList bOrdList = BAlarmDetailsDialog.this.alarm.getSource();
            int n = BAlarmDetailsDialog.this.tm.getAlarmCount(bOrdList);
            for (int i = 0; i < n; ++i) {
                if (!BAlarmDetailsDialog.this.tm.getRecord(bOrdList, i).getUuid().equals((Object)BAlarmDetailsDialog.this.alarm.getUuid())) continue;
                if (i + 1 < n) {
                    BAlarmDetailsDialog.this.alarm = BAlarmDetailsDialog.this.tm.getRecord(bOrdList, i + 1);
                    BAlarmDetailsDialog.this.createAlarmPane(this.cx);
                    BAlarmDetailsDialog.this.alarmPane.relayout();
                    ++i;
                }
                BAlarmDetailsDialog.this.prevCmd.setEnabled(i != 0);
                BAlarmDetailsDialog.this.nextCmd.setEnabled(i + 1 < n);
                return null;
            }
            BAlarmDetailsDialog.this.prevCmd.setEnabled(false);
            BAlarmDetailsDialog.this.nextCmd.setEnabled(false);
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)UiLexicon.bajaui, "commands.close");
        }

        public CommandArtifact doInvoke() {
            BAlarmDetailsDialog.this.close();
            return null;
        }
    }

    private class HyperlinkCommand
    extends Command {
        public HyperlinkCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.hyperlink");
        }

        public CommandArtifact doInvoke() {
            BAlarmDetailsDialog.this.console.hyperlink(BAlarmDetailsDialog.this.alarm);
            return null;
        }
    }

    private class NotesCommand
    extends Command {
        public NotesCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.notes");
        }

        public CommandArtifact doInvoke() {
            if (BAlarmDetailsDialog.this.console != null) {
                BAlarmDetailsDialog.this.console.showNotes((BWidget)BAlarmDetailsDialog.this.alarmPane, new BAlarmRecord[]{BAlarmDetailsDialog.this.alarm});
            } else {
                if (BAlarmDetailsDialog.this.alarmDbChannel == null) {
                    AlarmException alarmException = new AlarmException("Unable to find alarmDBChannel");
                    BAlarmDetailsDialog.this.logger.error("Unable to find alarmDBChannel", (Throwable)((Object)alarmException));
                    throw alarmException;
                }
                this.showAndAddNotes();
            }
            return null;
        }

        private void showAndAddNotes() {
            String string = "";
            try {
                string = ((BString)BAlarmDetailsDialog.this.alarm.getAlarmData().getFacet("notes")).getString();
            }
            catch (Exception exception) {
                BAlarmDetailsDialog.this.logger.error("Exception occurred while fetching the notes ", (Throwable)exception);
            }
            String string2 = BAlarmDetailsDialog.this.alarmDbChannel.getClientConnection().getUsername();
            BNotesDialog bNotesDialog = new BNotesDialog(null, string, string2, true);
            bNotesDialog.setBoundsCenteredOnOwner();
            bNotesDialog.open();
            String string3 = bNotesDialog.getNewNotes();
            if (string3 != null) {
                string = string3 + string;
                BFacets bFacets = BAlarmDetailsDialog.this.alarm.getAlarmData();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String[] stringArray = bFacets.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("notes")) continue;
                    BObject bObject = bFacets.get(stringArray[i]);
                    hashMap.put(stringArray[i], bObject);
                }
                hashMap.put("notes", BString.make((String)string));
                BFacets bFacets2 = BFacets.make(hashMap);
                BAlarmDetailsDialog.this.alarm.setAlarmData(bFacets2);
                try {
                    BAlarmDetailsDialog.this.alarmDbChannel.update(BAlarmDetailsDialog.this.alarm);
                }
                catch (Exception exception) {
                    BAlarmDetailsDialog.this.logger.error("Exception while updating the notes for an alarm", (Throwable)exception);
                }
            }
        }
    }

    private class AckCommand
    extends Command {
        public AckCommand(BWidget bWidget) {
            super(bWidget, (Lexicon)BAlarmConsole.lexicon, "commands.acknowledge");
        }

        public CommandArtifact doInvoke() {
            BAlarmDetailsDialog.this.console.acknowledgeAlarms(new BAlarmRecord[]{BAlarmDetailsDialog.this.alarm});
            BAlarmDetailsDialog.this.prevCmd.setEnabled(false);
            BAlarmDetailsDialog.this.nextCmd.setEnabled(false);
            return null;
        }
    }
}

