/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.ui.BAlarmDbView;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableController;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BAlarmDbMaintenance
extends BAlarmDbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmDbMaintenance == null ? (class$com$tridium$alarm$ui$BAlarmDbMaintenance = BAlarmDbMaintenance.class$("com.tridium.alarm.ui.BAlarmDbMaintenance")) : class$com$tridium$alarm$ui$BAlarmDbMaintenance));
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private ToggleCommand clearRecordsBeforeSelected;
    private ToggleCommand clearAllRecords;
    private ToggleCommand clearOldRecords;
    private Command runMaintenance;
    private BWbEditor dateEditor;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmDbMaintenance;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
        BWidget bWidget = this.getContent();
        this.setContent((BWidget)new BLabel(""));
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        OptionGroup optionGroup = new OptionGroup();
        this.clearOldRecords = new ClearOldRecords();
        optionGroup.add(this.clearOldRecords);
        bGridPane.add("clearOld", (BValue)new BRadioButton(this.clearOldRecords));
        this.dateEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT);
        BAbsTime bAbsTime = Clock.time();
        BAbsTime bAbsTime2 = BAbsTime.make((int)(bAbsTime.getYear() - 5), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay());
        this.dateEditor.loadValue((BObject)bAbsTime2);
        BFlowPane bFlowPane = new BFlowPane();
        bFlowPane.add("before", (BValue)new BLabel(lex.getText("before")));
        bFlowPane.add("dateEditor", (BValue)this.dateEditor);
        bGridPane.add("date", (BValue)new BBorderPane((BWidget)bFlowPane, 0.0, 0.0, 0.0, 10.0));
        this.clearRecordsBeforeSelected = new ClearRecordsBeforeSelected();
        optionGroup.add(this.clearRecordsBeforeSelected);
        bGridPane.add("clearBeforeSelected", (BValue)new BRadioButton(this.clearRecordsBeforeSelected));
        bGridPane.add(null, (BValue)new BLabel(""));
        this.clearAllRecords = new ClearAllRecords();
        optionGroup.add(this.clearAllRecords);
        bGridPane.add("clearAll", (BValue)new BRadioButton(this.clearAllRecords));
        bGridPane.add(null, (BValue)new BLabel(""));
        this.runMaintenance = new RunMaintenance();
        BButton bButton = new BButton(this.runMaintenance);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.add("run", (BValue)bButton);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane));
        bEdgePane.setBottom((BWidget)bGridPane2);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter(bWidget);
        bEdgePane2.setBottom((BWidget)bEdgePane);
        this.setContent((BWidget)bEdgePane2);
        this.query();
    }

    public void runMaintenance() {
        try {
            if (this.clearAllRecords.isSelected()) {
                String string;
                String string2 = lex.getText("confirmClear.title");
                if (BDialog.confirm((BWidget)this, (String)string2, (Object)(string = lex.getText("confirmClear"))) != 4) {
                    return;
                }
            } else if (this.clearRecordsBeforeSelected.isSelected()) {
                int n = this.table.getSelection().getRow();
                if (n == -1) {
                    BDialog.error((BWidget)this, (String)lex.getText("confirmClear.title"), (Object)lex.getText("alarm.noRecordSelected"));
                } else {
                    String string;
                    BAbsTime bAbsTime = this.model.getRecord(n).getTimestamp();
                    String string3 = lex.getText("confirmClear.title");
                    if (BDialog.confirm((BWidget)this, (String)string3, (Object)(string = lex.getText("confirmClear"))) != 4) {
                        return;
                    }
                }
            } else if (this.clearOldRecords.isSelected()) {
                BAbsTime bAbsTime = (BAbsTime)this.dateEditor.saveValue();
                String string = lex.getText("confirmClear.title");
                String string4 = lex.getText("confirmClear.before", new Object[]{bAbsTime.toString()});
                if (BDialog.confirm((BWidget)this, (String)string, (Object)string4) != 4) {
                    return;
                }
            }
            this.query();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new MaintenanceThread().start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            if (bMouseEvent.getClickCount() == 2) {
                BAlarmDbMaintenance.this.showDetailsDialog(BAlarmDbMaintenance.this.model.getRecord(n));
            }
        }
    }

    private class RunMaintenance
    extends Command {
        public RunMaintenance() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmDbMaintenance == null ? (class$com$tridium$alarm$ui$BAlarmDbMaintenance = BAlarmDbMaintenance.class$("com.tridium.alarm.ui.BAlarmDbMaintenance")) : class$com$tridium$alarm$ui$BAlarmDbMaintenance)), "command.runMaintenance");
        }

        public CommandArtifact doInvoke() {
            BAlarmDbMaintenance.this.runMaintenance();
            return null;
        }
    }

    private class ClearOldRecords
    extends ToggleCommand {
        public ClearOldRecords() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmDbMaintenance == null ? (class$com$tridium$alarm$ui$BAlarmDbMaintenance = BAlarmDbMaintenance.class$("com.tridium.alarm.ui.BAlarmDbMaintenance")) : class$com$tridium$alarm$ui$BAlarmDbMaintenance)), "command.clearOldRecords");
        }
    }

    private class ClearRecordsBeforeSelected
    extends ToggleCommand {
        public ClearRecordsBeforeSelected() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmDbMaintenance == null ? (class$com$tridium$alarm$ui$BAlarmDbMaintenance = BAlarmDbMaintenance.class$("com.tridium.alarm.ui.BAlarmDbMaintenance")) : class$com$tridium$alarm$ui$BAlarmDbMaintenance)), "command.clearRecordsBeforeSelected");
        }
    }

    private class ClearAllRecords
    extends ToggleCommand {
        public ClearAllRecords() {
            super((BWidget)BAlarmDbMaintenance.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmDbMaintenance == null ? (class$com$tridium$alarm$ui$BAlarmDbMaintenance = BAlarmDbMaintenance.class$("com.tridium.alarm.ui.BAlarmDbMaintenance")) : class$com$tridium$alarm$ui$BAlarmDbMaintenance)), "command.clearAllRecords");
        }
    }

    private class OptionGroup
    extends ToggleCommandGroup {
        private OptionGroup() {
        }

        public void selected(ToggleCommand toggleCommand) {
            if (BAlarmDbMaintenance.this.dateEditor != null) {
                BAlarmDbMaintenance.this.dateEditor.setReadonly(toggleCommand != BAlarmDbMaintenance.this.clearOldRecords);
            }
        }
    }

    private class MaintenanceThread
    extends Thread {
        public void run() {
            BAlarmDbMaintenance.this.enterBusy();
            try {
                if (BAlarmDbMaintenance.this.clearAllRecords.isSelected()) {
                    BAlarmDbMaintenance.this.getAlarmDbChannel().clearAllRecords();
                } else if (BAlarmDbMaintenance.this.clearRecordsBeforeSelected.isSelected()) {
                    int n = BAlarmDbMaintenance.this.table.getSelection().getRow();
                    BAbsTime bAbsTime = BAlarmDbMaintenance.this.model.getRecord(n).getTimestamp();
                    BAlarmDbMaintenance.this.getAlarmDbChannel().clearOldRecords(bAbsTime);
                    BAlarmDbMaintenance.this.model.getSelection().deselectAll();
                } else if (BAlarmDbMaintenance.this.clearOldRecords.isSelected()) {
                    BAbsTime bAbsTime = (BAbsTime)BAlarmDbMaintenance.this.dateEditor.saveValue();
                    BAlarmDbMaintenance.this.getAlarmDbChannel().clearOldRecords(bAbsTime);
                }
                BAlarmDbMaintenance.this.query();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                BAlarmDbMaintenance.this.exitBusy();
            }
        }
    }
}

