/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BPortalAlarmConsole;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAlarmConsoleUIChannel
extends BAlarmConsoleChannel {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmConsoleUIChannel == null ? (class$com$tridium$alarm$ui$BAlarmConsoleUIChannel = BAlarmConsoleUIChannel.class$("com.tridium.alarm.ui.BAlarmConsoleUIChannel")) : class$com$tridium$alarm$ui$BAlarmConsoleUIChannel));
    private Array recips = new Array(class$java$lang$String == null ? (class$java$lang$String = BAlarmConsoleUIChannel.class$("java.lang.String")) : class$java$lang$String);
    private Array consoles = new Array(class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmConsoleUIChannel.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole);
    private HashMap recipOrdMap = new HashMap();
    private BAlarmPortalTool tool;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsoleUIChannel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsole;

    public Type getType() {
        return TYPE;
    }

    public BAlarmConsoleUIChannel() {
        super("alarmui");
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (this.isTraceOn()) {
            this.trace("AlarmConsoleChannel: command = " + string);
        }
        if (string == "new") {
            return this.newAlarms(foxRequest);
        }
        if (string == "error") {
            return this.error(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    private FoxResponse newAlarms(FoxRequest foxRequest) {
        if (this.isTraceOn()) {
            this.trace("recieved: new");
            foxRequest.dump();
        }
        FoxTuple[] foxTupleArray = foxRequest.list("alarmRec");
        for (int i = 0; i < foxTupleArray.length; ++i) {
            try {
                BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm(((FoxMessage)foxTupleArray[i]).getMessage("alarm"));
                String string = ((FoxMessage)foxTupleArray[i]).getString("ord");
                BAlarmConsole[] bAlarmConsoleArray = this.getConsolesRegisteredOn(string);
                for (int j = 0; j < bAlarmConsoleArray.length; ++j) {
                    BOrd bOrd;
                    BAlarmRecord bAlarmRecord2;
                    BOrdList bOrdList;
                    if (bAlarmConsoleArray[j] == null) {
                        bOrdList = bAlarmRecord.getSource();
                        bAlarmRecord2 = (BAlarmRecord)bAlarmRecord.newCopy();
                        bOrd = (BOrd)this.recipOrdMap.get(string);
                        if (bOrd == null) continue;
                        bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)bOrd);
                        bAlarmRecord2.setSource(bOrdList);
                        this.tool.processAlarm(bAlarmRecord2);
                        continue;
                    }
                    if (bAlarmConsoleArray[j] instanceof BPortalAlarmConsole) {
                        bOrdList = bAlarmRecord.getSource();
                        bAlarmRecord2 = (BAlarmRecord)bAlarmRecord.newCopy();
                        bOrd = (BOrd)this.recipOrdMap.get(string);
                        if (bOrd == null) continue;
                        bOrdList = BOrdList.add((BOrdList)bOrdList, (BOrd)bOrd);
                        bAlarmRecord2.setSource(bOrdList);
                        bAlarmConsoleArray[j].processAlarm(bAlarmRecord2);
                        continue;
                    }
                    bAlarmConsoleArray[j].processAlarm(bAlarmRecord);
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void ackAlarms(BConsoleRecipient bConsoleRecipient, BAlarmRecord[] bAlarmRecordArray) throws Exception {
        int n;
        int n2 = 100;
        int n3 = 0;
        int n4 = n = n2 < bAlarmRecordArray.length ? n2 : bAlarmRecordArray.length;
        while (n3 < bAlarmRecordArray.length) {
            int n5;
            FoxRequest foxRequest = this.makeRequest("ack");
            foxRequest.add("ord", bConsoleRecipient.getOrdInSession().encodeToString());
            int n6 = 0;
            for (n5 = n3; n5 < n; ++n5) {
                ++n6;
                foxRequest.add("alarm", FoxAlarmCodec.encodeAlarm(bAlarmRecordArray[n5]));
            }
            if (this.isTraceOn()) {
                this.trace("sending: ack");
            }
            n5 = foxRequest.list("alarm").length;
            this.sendAsync(foxRequest);
            n3 = n;
            n = (n += n2) < bAlarmRecordArray.length ? n : bAlarmRecordArray.length;
        }
    }

    public String getInitialAlarmQuery(BAlarmConsole bAlarmConsole, BConsoleRecipient bConsoleRecipient) throws Exception {
        return this.getInitialAlarmQuery(bAlarmConsole, bConsoleRecipient, BOrd.NULL);
    }

    public String getInitialAlarmQuery(BAlarmPortalTool bAlarmPortalTool, BConsoleRecipient bConsoleRecipient) throws Exception {
        this.tool = bAlarmPortalTool;
        return this.getInitialAlarmQuery(null, bConsoleRecipient, BOrd.NULL);
    }

    public String getInitialAlarmQuery(BAlarmConsole bAlarmConsole, BConsoleRecipient bConsoleRecipient, BOrd bOrd) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getInitialAlarmQuery");
        String string = bConsoleRecipient.getOrdInSession().encodeToString();
        foxRequest.add("ord", string);
        if (bOrd != null && !bOrd.isNull()) {
            this.recipOrdMap.put(string, bOrd);
        }
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            String string2 = foxResponse.getString("error", null);
            if (string2 != null) {
                throw new Exception(string2);
            }
            this.register(bAlarmConsole, string);
            return foxResponse.getString("query");
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    private FoxResponse error(FoxRequest foxRequest) {
        try {
            String string = foxRequest.getString("msg");
            Exception exception = new Exception(foxRequest.getString("error"));
            String string2 = foxRequest.getString("ord");
            BAlarmConsole[] bAlarmConsoleArray = this.getConsolesRegisteredOn(string2);
            for (int i = 0; i < bAlarmConsoleArray.length; ++i) {
                if (bAlarmConsoleArray[i] == null) continue;
                bAlarmConsoleArray[i].showError(string, exception);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void unregister(BConsoleRecipient bConsoleRecipient) throws Exception {
        FoxRequest foxRequest = this.makeRequest("unregister");
        String string = bConsoleRecipient.getOrdInSession().encodeToString();
        foxRequest.add("ord", string);
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            String string2 = foxResponse.getString("error", null);
            if (string2 != null) {
                throw new Exception(string2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        FoxRequest foxRequest = this.makeRequest("updateAlarm");
        foxRequest.add("alarm", FoxAlarmCodec.encodeAlarm(bAlarmRecord));
        if (this.isTraceOn()) {
            this.trace("sending: update : timestamp: " + bAlarmRecord.getTimestamp());
            this.trace("              source: " + bAlarmRecord.getSource().encodeToString());
        }
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            String string = foxResponse.getString("error", null);
            if (string != null) {
                throw new Exception(string);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private void register(BAlarmConsole bAlarmConsole, String string) {
        this.recips.add((Object)string);
        this.consoles.add((Object)bAlarmConsole);
    }

    public void unregister(BAlarmConsole bAlarmConsole) {
        int n = this.consoles.indexOf((Object)bAlarmConsole);
        if (n < 0) {
            return;
        }
        if (this.consoles.size() > n) {
            this.consoles.remove(n);
        }
        if (this.recips.size() > n) {
            this.recips.remove(n);
        }
    }

    private BAlarmConsole[] getConsolesRegisteredOn(String string) {
        Array array = new Array(class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmConsoleUIChannel.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole);
        for (int i = 0; i < this.recips.size(); ++i) {
            if (!this.recips.get(i).equals(string)) continue;
            array.add(this.consoles.get(i));
        }
        return (BAlarmConsole[])array.trim();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

