/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import java.util.ArrayList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.gx.BFont;
import javax.baja.gx.Insets;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BIWbViewExporter;

public class BAlarmConsoleToPdf
extends BPdfExporter
implements BIWbViewExporter {
    public static final Property showAllColumns = BAlarmConsoleToPdf.newProperty((int)0, (boolean)false, null);
    public static final Property showOnlySelectedRows = BAlarmConsoleToPdf.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmConsoleToPdf == null ? (class$com$tridium$alarm$ui$BAlarmConsoleToPdf = BAlarmConsoleToPdf.class$("com.tridium.alarm.ui.BAlarmConsoleToPdf")) : class$com$tridium$alarm$ui$BAlarmConsoleToPdf));
    private BPdfFlowPane pane;
    private PdfDocument doc;
    private PdfOp op;
    private String msgTxt = null;
    private String notesTxt = null;
    private boolean showAlarmData = false;
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private static final int MAXSTR = 70;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsoleToPdf;

    public boolean getShowAllColumns() {
        return this.getBoolean(showAllColumns);
    }

    public void setShowAllColumns(boolean bl) {
        this.setBoolean(showAllColumns, bl, null);
    }

    public boolean getShowOnlySelectedRows() {
        return this.getBoolean(showOnlySelectedRows);
    }

    public void setShowOnlySelectedRows(boolean bl) {
        this.setBoolean(showOnlySelectedRows, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp pdfOp) throws Exception {
        this.op = pdfOp;
        BAlarmConsole bAlarmConsole = (BAlarmConsole)pdfOp.get();
        TableModel tableModel = bAlarmConsole.sourceTable.getModel();
        TableSelection tableSelection = bAlarmConsole.sourceTable.getController().getSelection();
        BWidgetToPdf bWidgetToPdf = new BWidgetToPdf();
        this.doc = new PdfDocument(pdfOp.getOutputStream(), pdfOp.getWidth(), pdfOp.getHeight());
        this.pane = new BPdfFlowPane();
        this.makeHeader(bAlarmConsole.recipient);
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (this.getShowOnlySelectedRows() && (!this.getShowOnlySelectedRows() || !tableSelection.isSelected(i))) continue;
            this.makeRecord(tableModel, i);
        }
        this.pane.setupPane();
        bWidgetToPdf.renderDocument((BWidget)this.pane, this.doc, pdfOp);
    }

    private void makeHeader(BConsoleRecipient bConsoleRecipient) {
        BFont bFont = BFont.make((String)lex.getText("alarmConsoleToPdf.font.reportHeader"));
        BFont bFont2 = BFont.make((String)lex.getText("alarmConsoleToPdf.font.normal"));
        BLabel bLabel = new BLabel(lex.getText("alarmConsoleToPdf.header") + " " + bConsoleRecipient.getDisplayName((Context)this.op));
        bLabel.setHalign(BHalign.left);
        bLabel.setFont(bFont);
        this.pane.add(null, (BValue)bLabel);
        BLabel bLabel2 = new BLabel(BAbsTime.now().toString((Context)this.op), bFont2, BHalign.left);
        this.pane.add(null, (BValue)bLabel2);
    }

    private void makeRecord(TableModel tableModel, int n) {
        BFacets bFacets;
        this.notesTxt = null;
        this.msgTxt = null;
        BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)tableModel.getSubject(n));
        StringBuffer stringBuffer = new StringBuffer();
        BString bString = (BString)bAlarmRecord.getAlarmData().get("sourceName");
        if (bString != null && bString != BString.DEFAULT) {
            stringBuffer.append(BFormat.make((String)bString.toString((Context)this.op)).format((Object)bAlarmRecord));
        } else {
            stringBuffer.append(bAlarmRecord.get(BAlarmRecord.source).toString((Context)this.op));
        }
        stringBuffer.append(" - ").append(bAlarmRecord.getSourceState().toString((Context)this.op)).append(" / ");
        stringBuffer.append(bAlarmRecord.getAckState().toString((Context)this.op));
        BLabel bLabel = new BLabel(stringBuffer.toString(), BFont.make((String)lex.getText("alarmConsoleToPdf.font.source")), BHalign.left);
        bLabel.setImage(tableModel.getRowIcon(n));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.buildColumnsAndValues(arrayList, arrayList2, tableModel, n);
        if (this.showAlarmData) {
            bFacets = bAlarmRecord.getAlarmData();
            String[] stringArray = bFacets.list();
            arrayList.add("");
            arrayList2.add("");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = bFacets.get(stringArray[i]).toString((Context)this.op);
                if (stringArray[i].equals("notes")) {
                    this.notesTxt = string;
                    continue;
                }
                arrayList.add("Alarm Data (" + stringArray[i] + ")");
                if (stringArray[i].equals("msgText") && string.length() > 70) {
                    string = string.substring(0, 68) + "...";
                }
                arrayList2.add(string);
            }
        }
        bFacets = new BTable((TableModel)new Model(arrayList, arrayList2));
        this.pane.add(null, (BValue)new BLabel(""));
        this.pane.add(null, (BValue)bLabel);
        this.pane.add(null, (BValue)bFacets);
        if (this.msgTxt != null) {
            this.buildMultiLineLabels("Message", this.msgTxt, ' ');
        }
        if (this.notesTxt != null) {
            this.pane.add(null, (BValue)new BLabel(""));
            this.buildMultiLineLabels("Note", this.notesTxt, ' ');
        }
    }

    private void buildColumnsAndValues(ArrayList arrayList, ArrayList arrayList2, TableModel tableModel, int n) {
        if (this.getShowAllColumns()) {
            String[] stringArray = tableModel.getColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.equals("Msg Text")) {
                    this.msgTxt = tableModel.getRowValues(n)[i].toString();
                    if (this.msgTxt.length() > 70 || this.msgTxt.length() == 0) continue;
                    this.msgTxt = null;
                } else if (string.equals("Alarm Data")) {
                    this.showAlarmData = true;
                    continue;
                }
                arrayList.add(string);
                arrayList2.add(tableModel.getRowValues(n)[i]);
            }
        } else {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                String string = tableModel.getColumnName(i);
                if (string.equals("Msg Text")) {
                    this.msgTxt = tableModel.getValueAt(n, i).toString();
                    if (this.msgTxt.length() > 70 || this.msgTxt.length() == 0) continue;
                    this.msgTxt = null;
                } else if (string.equals("Alarm Data")) {
                    this.showAlarmData = true;
                    continue;
                }
                arrayList.add(string);
                arrayList2.add(tableModel.getValueAt(n, i));
            }
        }
    }

    private void buildMultiLineLabels(String string, String string2, char c) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(":  ").append(string2);
        BLabel[] bLabelArray = this.split(stringBuffer.toString(), c);
        for (int i = 0; i < bLabelArray.length; ++i) {
            this.pane.add(null, (BValue)bLabelArray[i]);
        }
    }

    private BLabel[] split(String string, char c) {
        BFont bFont = BFont.make((String)lex.getText("alarmConsoleToPdf.font.normal"));
        Insets insets = this.doc.getMargins();
        double d = this.doc.getPageSize().width - insets.right;
        ArrayList<BLabel> arrayList = new ArrayList<BLabel>();
        String string2 = string;
        while (bFont.width(string2) > d) {
            int n;
            int n2 = string2.indexOf(c, 0);
            boolean bl = false;
            if (n2 == -1 || bFont.width(string2.substring(0, n2)) > d) {
                bl = true;
                n = 1;
                while (bFont.width(string2.substring(0, n)) < d) {
                    ++n;
                }
                n2 = n - 2;
            } else {
                n = n2;
                String string3 = string2.substring(0, n2 + 1);
                while (bFont.width(string3) < d && n != -1) {
                    n2 = n;
                    n = string2.indexOf(c, n + 1);
                    string3 = string2.substring(0, n + 1);
                }
            }
            String string4 = string2.substring(0, n2 + 1);
            if (bl) {
                string4 = string4 + "-";
            }
            string2 = string2.substring(n2 + 1);
            arrayList.add(new BLabel(string4, bFont, BHalign.left));
        }
        arrayList.add(new BLabel(string2, bFont, BHalign.left));
        return arrayList.toArray(new BLabel[arrayList.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Model
    extends TableModel {
        private String[] cols = new String[]{"Attribute", "Value"};
        private ArrayList names = new ArrayList();
        private ArrayList values = new ArrayList();

        public Model(ArrayList arrayList, ArrayList arrayList2) {
            this.names = arrayList;
            this.values = arrayList2;
        }

        public int getRowCount() {
            return this.names.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int n) {
            return this.cols[n];
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? this.names.get(n) : this.values.get(n);
        }
    }
}

