/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.alarm.BAlarmConsoleChannel;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.AlarmTableModel;
import com.tridium.alarm.ui.BAlarmClassDef;
import com.tridium.alarm.ui.BAlarmClassMapping;
import com.tridium.alarm.ui.BAlarmClassMappingFE;
import com.tridium.alarm.ui.BAlarmConsoleOptions;
import com.tridium.alarm.ui.BAlarmConsoleUIChannel;
import com.tridium.alarm.ui.BAlarmDetailsDialog;
import com.tridium.alarm.ui.BAlarmReportDialog;
import com.tridium.alarm.ui.BAlarmTitlePane;
import com.tridium.alarm.ui.BIAlarmServiceView;
import com.tridium.alarm.ui.BNotesDialog;
import com.tridium.alarm.ui.BTimeZoneDisplay;
import com.tridium.alarm.ui.ConsoleColumns;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.MediaPlayer;
import com.tridium.alarm.ui.SoundPlayer;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import com.tridium.workbench.fieldeditors.BDynamicTimeRangeFE;
import com.tridium.workbench.fieldeditors.gx.BColorFE;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.bql.BIBqlFilter;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.log.Log;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbComponentView;

public class BAlarmConsole
extends BWbComponentView
implements SoundPlayer.MediaPlayerListener,
BIExportableTableView,
BIAlarmServiceView {
    public static final Property title = BAlarmConsole.newProperty((int)0, (String)new UiLexicon(class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmConsole.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole).getText("alarm.openAlarmSources"), null);
    public static final Property showTitle = BAlarmConsole.newProperty((int)0, (BValue)BBoolean.TRUE, null);
    public static final Action processAlarm = BAlarmConsole.newAction((int)0, (BValue)new BAlarmRecord(), null);
    public static final Action timeRangeModified = BAlarmConsole.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmConsole.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole));
    protected BTable sourceTable;
    protected SourceTableModel sourceModel;
    protected BTable alarmTable;
    protected BList instructions;
    protected BSplitPane contentPane;
    protected BButton filterBtn;
    protected BConsoleRecipient recipient;
    protected BAlarmService alarmService;
    private List remotelyAcknowledgedAlarms;
    private List locallyAcknowledgedAlarms;
    private BMenu menu;
    private ConsoleColumns columns;
    private BGridPane toolBar;
    BAlarmTitlePane alarmTitlePane;
    protected BDynamicTimeRangeFE timeRangeEd;
    protected BDynamicTimeRange timeRange;
    protected BAlarmDetailsDialog detailsDlg;
    protected BAlarmReportDialog alarmReport;
    protected Context ctx;
    private static SoundPlayer soundPlayer = UiEnv.get().isMicroEdition() ? new SoundPlayer() : new MediaPlayer();
    Hashtable sounds = new Hashtable();
    protected Command ackCommand;
    protected Command ackRecentCommand;
    private Command silenceCommand;
    private Command urlCommand;
    protected Command notesCommand;
    private Command filterConfigCommand;
    private Command showVideoCmd;
    private ToggleCommand soundOnCommand;
    private ToggleCommand continuousAlarmCommand;
    private Command filterCmd;
    private Command alarmClassMappingCommand;
    private Command priorityColorsCommand;
    protected Command addColumnCommand;
    protected Command removeColumnCommand;
    protected Command detailsCommand;
    protected Command forceClear;
    private ToggleCommand sourceTimeCommand;
    private ToggleCommand consoleTimeCommand;
    public BAlarmConsoleOptions options;
    public static final Log logger = Log.getLog((String)"alarm");
    public static final UiLexicon lexicon = new UiLexicon(class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmConsole.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole);
    public final BImage lnkImg = BImage.make((String)lexicon.get("commands.hyperlink.icon"));
    public final BImage ackImg = BImage.make((String)lexicon.get("commands.acknowledge.icon"));
    Object dataMutex = new Object();
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmConsole;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$sys$BString;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$tridium$bql$filter$BFilterEntry;

    public String getTitle() {
        return this.getString(title);
    }

    public void setTitle(String string) {
        this.setString(title, string, null);
    }

    public boolean getShowTitle() {
        return this.getBoolean(showTitle);
    }

    public void setShowTitle(boolean bl) {
        this.setBoolean(showTitle, bl, null);
    }

    public void processAlarm(BAlarmRecord bAlarmRecord) {
        this.invoke(processAlarm, (BValue)bAlarmRecord, null);
    }

    public void timeRangeModified() {
        this.invoke(timeRangeModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmConsole() {
        Object object;
        this.sourceTable = new BTable();
        this.sourceTable.setController((TableController)this.getController());
        this.sourceTable.setCellRenderer((TableCellRenderer)new AlarmTableCellRenderer());
        this.options = this.getDefaultOptions();
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setStretchRow(0);
        bGridPane.setStretchColumn(0);
        bGridPane.setHalign(BHalign.fill);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setValign(BValign.fill);
        bGridPane.setRowAlign(BValign.fill);
        this.instructions = new BList();
        bGridPane.add(null, (BValue)new BTitlePane(lexicon.getText("alarm.instructions"), (BWidget)this.instructions));
        this.timeRangeEd = new BDynamicTimeRangeFE();
        this.ackCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.acknowledge"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.acknowledgeAlarms(BAlarmConsole.this.getSelectedAlarmsDeep(BAlarmConsole.this.sourceTable));
                return null;
            }
        };
        this.ackCommand.setEnabled(false);
        this.ackRecentCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.acknowledgeRecent"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.acknowledgeAlarms(BAlarmConsole.this.getSelectedAlarms(BAlarmConsole.this.sourceTable));
                return null;
            }
        };
        this.ackRecentCommand.setEnabled(false);
        this.silenceCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.silence"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.alarmSilenceSelected();
                return null;
            }
        };
        this.silenceCommand.setEnabled(false);
        this.urlCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.hyperlink"){

            public CommandArtifact doInvoke() {
                int n = BAlarmConsole.this.sourceTable.getSelection().getRow();
                if (n != -1) {
                    BAlarmConsole.this.hyperlink(BAlarmConsole.this.sourceModel.getRecord(n));
                }
                return null;
            }
        };
        this.urlCommand.setEnabled(false);
        this.notesCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.notes"){

            public CommandArtifact doInvoke() {
                BAlarmRecord[] bAlarmRecordArray = BAlarmConsole.this.getSelectedAlarmsDeep(BAlarmConsole.this.sourceTable);
                BAlarmConsole.this.showNotes((BWidget)BAlarmConsole.this, bAlarmRecordArray);
                return null;
            }
        };
        this.notesCommand.setEnabled(false);
        this.detailsCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.details"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.showDetailsDialog(BAlarmConsole.this.sourceTable, BAlarmConsole.this.sourceTable.getSelection().getRow());
                return null;
            }
        };
        this.detailsCommand.setEnabled(false);
        this.filterCmd = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.filter"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.configFilters();
                return null;
            }
        };
        this.showVideoCmd = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.showVideo"){

            public CommandArtifact doInvoke() {
                block8: {
                    try {
                        Class clazz = Sys.loadClass((String)"videoDriver", (String)"com.tridium.videoDriver.alarm.AlarmConsoleExt");
                        if (clazz != null) {
                            Method method = clazz.getMethod("doShowVideo", class$com$tridium$alarm$ui$BAlarmConsole == null ? (class$com$tridium$alarm$ui$BAlarmConsole = BAlarmConsole.class$("com.tridium.alarm.ui.BAlarmConsole")) : class$com$tridium$alarm$ui$BAlarmConsole, class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmConsole.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord);
                            if (method != null) {
                                int n = BAlarmConsole.this.sourceTable.getSelection().getRow();
                                ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)BAlarmConsole.this.sourceTable.getModel()).getRootModel();
                                BAlarmRecord bAlarmRecord = consoleTableModel.getRecord(n);
                                method.invoke((Object)clazz, new Object[]{BAlarmConsole.this, bAlarmRecord});
                            } else {
                                System.out.println("The 'doShowVideo' method was not found on class AlarmConsoleExt in videoDriver.jar. Please have my program fixed");
                            }
                            break block8;
                        }
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)classNotFoundException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)noSuchMethodException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new LocalizableRuntimeException("alarm", "VideoDriverModuleNotFound", (Throwable)illegalAccessException);
                    }
                }
                return null;
            }
        };
        this.showVideoCmd.setEnabled(false);
        this.soundOnCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.soundOn"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.options.setSoundsEnabled(this.isSelected());
                BAlarmConsole.this.options.save();
                return null;
            }
        };
        this.soundOnCommand.setSelected(this.options.getSoundsEnabled());
        this.continuousAlarmCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.continuousAlarm"){

            public CommandArtifact doInvoke() {
                BAlarmConsole.this.options.setContinuousAlarm(this.isSelected());
                BAlarmConsole.this.options.save();
                return null;
            }
        };
        this.continuousAlarmCommand.setSelected(this.options.getContinuousAlarm());
        this.continuousAlarmCommand.setEnabled(this.soundOnCommand.isSelected());
        this.alarmClassMappingCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.alarmClassMapping"){

            public CommandArtifact doInvoke() {
                BAlarmClassMapping bAlarmClassMapping = BAlarmConsole.this.options.getAlarmClassMapping();
                BAlarmClassMappingFE bAlarmClassMappingFE = new BAlarmClassMappingFE();
                BAlarmConsole.this.add("temp", (BValue)bAlarmClassMappingFE);
                bAlarmClassMappingFE.loadValue((BObject)bAlarmClassMapping);
                BOptionDialog bOptionDialog = new BOptionDialog((BWidget)BAlarmConsole.this, "AlarmClassMapper", bAlarmClassMappingFE.createPopup(), 3, (BImage)null, (String)null);
                bOptionDialog.setBoundsCenteredOnOwner();
                IRectGeom iRectGeom = bOptionDialog.getScreenBounds();
                bOptionDialog.setScreenBounds(iRectGeom.x(), iRectGeom.y(), 500.0, 400.0);
                bOptionDialog.open();
                int n = bOptionDialog.getResult();
                if (n == 1) {
                    try {
                        bAlarmClassMapping = (BAlarmClassMapping)bAlarmClassMappingFE.doSaveValue((BObject)bAlarmClassMapping, null);
                        BAlarmConsole.this.options.setAlarmClassMapping(bAlarmClassMapping);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                BAlarmConsole.this.remove((BComplex)bAlarmClassMappingFE);
                return null;
            }
        };
        this.priorityColorsCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.priorityColors"){

            public CommandArtifact doInvoke() {
                BColor bColor = BAlarmConsole.this.options.getLowPriorityColor();
                BColor bColor2 = BAlarmConsole.this.options.getMidPriorityColor();
                BColor bColor3 = BAlarmConsole.this.options.getHighPriorityColor();
                BColorFE bColorFE = new BColorFE();
                bColorFE.loadValue((BObject)bColor);
                BColorFE bColorFE2 = new BColorFE();
                bColorFE2.loadValue((BObject)bColor2);
                BColorFE bColorFE3 = new BColorFE();
                bColorFE3.loadValue((BObject)bColor3);
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add("l1", (BValue)new BLabel("Low Priority Color"));
                bGridPane.add("f1", (BValue)bColorFE);
                bGridPane.add("l2", (BValue)new BLabel("Mid Priority Color"));
                bGridPane.add("f2", (BValue)bColorFE2);
                bGridPane.add("l3", (BValue)new BLabel("High Priority Color"));
                bGridPane.add("f3", (BValue)bColorFE3);
                int n = BDialog.open((BWidget)BAlarmConsole.this, (String)lexicon.getText("commands.priorityColors.label"), (Object)bGridPane, (int)3, (BImage)null);
                if (n == 1) {
                    try {
                        bColor = (BColor)bColorFE.saveValue((BObject)bColor, null);
                        bColor2 = (BColor)bColorFE2.saveValue((BObject)bColor2, null);
                        bColor3 = (BColor)bColorFE3.saveValue((BObject)bColor3, null);
                        BAlarmConsole.this.options.setLowPriorityColor(bColor);
                        BAlarmConsole.this.options.setMidPriorityColor(bColor2);
                        BAlarmConsole.this.options.setHighPriorityColor(bColor3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ((AlarmTableCellRenderer)BAlarmConsole.this.sourceTable.getCellRenderer()).resetPriorityColors();
                    BAlarmConsole.this.repaint();
                }
                return null;
            }
        };
        this.addColumnCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.addColumn"){

            public CommandArtifact doInvoke() {
                int n;
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add("lbl", (BValue)new BLabel("AlarmData."));
                BTextDropDown bTextDropDown = new BTextDropDown();
                Field[] fieldArray = (class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmConsole.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord).getDeclaredFields();
                Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BAlarmConsole.class$("java.lang.String")) : class$java$lang$String);
                for (int i = 0; i < fieldArray.length; ++i) {
                    try {
                        if (!(fieldArray[i].get(null) instanceof String)) continue;
                        array.add(fieldArray[i].get(null));
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                Object[] objectArray = (String[])array.trim();
                SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)new Comparator(){

                    public int compare(Object object, Object object2) {
                        return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
                    }
                });
                for (n = 0; n < objectArray.length; ++n) {
                    bTextDropDown.getList().addItem(objectArray[n]);
                }
                bGridPane.add("dataFacet", (BValue)bTextDropDown);
                n = BDialog.open((BWidget)BAlarmConsole.this, (String)lexicon.getText("commands.addColumn.label"), (Object)bGridPane, (int)3, (BImage)null);
                if (n == 1) {
                    try {
                        String string = bTextDropDown.getText();
                        BAlarmConsole.this.columns.addDataColumn(null, string);
                        for (int i = 0; i < 2; ++i) {
                            DynamicTableModel dynamicTableModel = null;
                            if (i == 0) {
                                dynamicTableModel = (DynamicTableModel)BAlarmConsole.this.sourceTable.getModel();
                            } else {
                                if (BAlarmConsole.this.alarmTable == null) break;
                                dynamicTableModel = (DynamicTableModel)BAlarmConsole.this.alarmTable.getModel();
                            }
                            dynamicTableModel.setColumnShowable(BAlarmConsole.this.columns.getColumnCount() - 1, true);
                            dynamicTableModel.setShowColumn(BAlarmConsole.this.columns.getColumnCount() - 1, true);
                            dynamicTableModel.updateTable();
                        }
                        BAlarmConsole.this.options.getAlarmDataCols().add(SlotPath.escape((String)string), (BValue)BString.make((String)string));
                        BAlarmConsole.this.options.save();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        };
        this.removeColumnCommand = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.removeColumn"){

            public CommandArtifact doInvoke() {
                int n;
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.add("lbl", (BValue)new BLabel("AlarmData."));
                ArrayList arrayList = new ArrayList();
                BString[] bStringArray = (BString[])BAlarmConsole.this.options.getAlarmDataCols().getChildren(class$javax$baja$sys$BString == null ? (class$javax$baja$sys$BString = BAlarmConsole.class$("javax.baja.sys.BString")) : class$javax$baja$sys$BString);
                BListDropDown bListDropDown = new BListDropDown();
                for (n = 0; n < bStringArray.length; ++n) {
                    bListDropDown.getList().addItem((Object)bStringArray[n].toString());
                }
                bGridPane.add("tf", (BValue)bListDropDown);
                n = BDialog.open((BWidget)BAlarmConsole.this, (String)lexicon.getText("commands.removeColumn.label"), (Object)bGridPane, (int)3, (BImage)null);
                if (n == 1) {
                    String string = bListDropDown.getSelectedItem().toString();
                    int n2 = BAlarmConsole.this.columns.dataColumnIndex(string);
                    if (n2 == -1) {
                        return null;
                    }
                    for (int i = 0; i < 2; ++i) {
                        int n3;
                        DynamicTableModel dynamicTableModel = null;
                        if (i == 0) {
                            dynamicTableModel = (DynamicTableModel)BAlarmConsole.this.sourceTable.getModel();
                        } else {
                            if (BAlarmConsole.this.alarmTable == null) break;
                            dynamicTableModel = (DynamicTableModel)BAlarmConsole.this.alarmTable.getModel();
                        }
                        boolean[] blArray = new boolean[BAlarmConsole.this.columns.getColumnCount()];
                        for (n3 = 0; n3 < blArray.length; ++n3) {
                            blArray[n3] = dynamicTableModel.showColumn(n3);
                        }
                        for (n3 = n2; n3 < blArray.length - 1; ++n3) {
                            blArray[n3] = blArray[n3 + 1];
                        }
                        blArray[blArray.length - 1] = false;
                        for (n3 = 0; n3 < blArray.length; ++n3) {
                            dynamicTableModel.setShowColumn(n3, blArray[n3]);
                        }
                    }
                    BAlarmConsole.this.columns.removeDataColumn(string);
                    BAlarmConsole.this.options.getAlarmDataCols().remove(SlotPath.escape((String)string));
                    BAlarmConsole.this.options.save();
                    BAlarmConsole.this.sourceModel.updateTable();
                }
                return null;
            }
        };
        this.forceClear = new Command((BWidget)this, BAlarmConsole.lexicon.module, "commands.forceClear"){

            public CommandArtifact doInvoke() {
                BAlarmRecord[] bAlarmRecordArray = BAlarmConsole.this.getSelectedAlarmsDeep(BAlarmConsole.this.sourceTable);
                for (int i = 0; i < bAlarmRecordArray.length; ++i) {
                    BAlarmRecord bAlarmRecord = (BAlarmRecord)bAlarmRecordArray[i].newCopy();
                    bAlarmRecord.setSourceState(BSourceState.normal);
                    bAlarmRecord.setAckState(BAckState.acked);
                    bAlarmRecord.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)BAlarmConsole.this.getUsername(bAlarmRecord)));
                    if (bAlarmRecord.getAckTime().equals((Object)BAbsTime.NULL)) {
                        bAlarmRecord.setAckTime(BAbsTime.now());
                    }
                    if (bAlarmRecord.getNormalTime().equals((Object)BAbsTime.NULL)) {
                        bAlarmRecord.setNormalTime(BAbsTime.now());
                    }
                    try {
                        BAlarmConsole.this.sendUpdatedAlarm(bAlarmRecord);
                        BAlarmConsole.this.getAlarmService().auditForceClear(bAlarmRecord);
                        BAlarmConsole.this.removeAlarm(bAlarmRecord);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        };
        this.forceClear.setEnabled(false);
        this.columns = this.getConsoleColumns();
        BString[] bStringArray = (BString[])this.options.getAlarmDataCols().getChildren(class$javax$baja$sys$BString == null ? (class$javax$baja$sys$BString = BAlarmConsole.class$("javax.baja.sys.BString")) : class$javax$baja$sys$BString);
        for (int i = 0; i < bStringArray.length; ++i) {
            this.columns.addDataColumn(null, bStringArray[i].toString());
        }
        this.sourceModel = this.makeSourceTableModel(this.columns, this.recipient, null);
        this.sourceModel.setInitialSort(this.options.getSortColumn(), this.options.getSortAscending());
        String string = this.options.getDisplayColumns();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Array array = new Array(class$java$lang$Integer == null ? (class$java$lang$Integer = BAlarmConsole.class$("java.lang.Integer")) : class$java$lang$Integer);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            array.add((Object)new Integer((String)object));
        }
        object = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            object[i] = (Integer)array.get(i);
        }
        this.sourceTable.setModel((TableModel)new DynamicTableModel((TableModel)this.sourceModel, (int[])object));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)this.timeRangeEd);
        this.toolBar = this.makeToolBar();
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)this.toolBar));
        this.alarmTitlePane = BAlarmTitlePane.makePane(this.getTitle(), this.sourceTable);
        bEdgePane.setCenter((BWidget)this.alarmTitlePane);
        if (this.options.getViewInstructions()) {
            double d = this.options.getInstructionsDividerPosition();
            this.contentPane = new BSplitPane(BOrientation.vertical, d);
            this.contentPane.setWidget1((BWidget)bEdgePane);
            this.contentPane.setWidget2((BWidget)bGridPane);
            this.setContent((BWidget)this.contentPane);
        } else {
            this.setContent((BWidget)bEdgePane);
        }
    }

    public BTable getExportTable() {
        return this.sourceTable;
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("filter", this.filterCmd);
        return bToolBar;
    }

    public void changed(Property property, Context context) {
        if (property.equals(title) && this.alarmTitlePane != null) {
            this.alarmTitlePane.setTitle(this.getTitle());
        }
        if (property.equals(showTitle) && this.alarmTitlePane != null) {
            this.alarmTitlePane.setTitleVisible(this.getShowTitle());
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.channel() != null) {
            this.channel().unregister(this.recipient);
            this.channel().unregister(this);
        }
        if (soundPlayer != null) {
            soundPlayer.stop();
            soundPlayer.removeListener(this);
        }
        if (this.contentPane != null) {
            this.options.setInstructionsDividerPosition(this.contentPane.getDividerPosition());
        }
        DynamicTableModel dynamicTableModel = (DynamicTableModel)this.sourceTable.getModel();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dynamicTableModel.getRootColumnCount(); ++i) {
            if (!dynamicTableModel.showColumn(i)) continue;
            stringBuffer.append(i + ",");
        }
        if (dynamicTableModel.getRootColumnCount() > 0) {
            this.options.setDisplayColumns(stringBuffer.toString());
        }
        this.options.setSortColumn(this.sourceModel.getLastSortColumn());
        this.options.setSortAscending(this.sourceModel.getLastSortAscending());
        this.options.save();
    }

    public BAlarmConsoleOptions getDefaultOptions() {
        return BAlarmConsoleOptions.getDefault();
    }

    public ConsoleColumns getConsoleColumns() {
        return new ConsoleColumns();
    }

    protected Controller getController() {
        return new Controller();
    }

    protected SourceTableModel makeSourceTableModel(ConsoleColumns consoleColumns, BConsoleRecipient bConsoleRecipient, Context context) {
        return new SourceTableModel(consoleColumns, bConsoleRecipient, context);
    }

    public void doLoadValue(BObject bObject, Context context) throws Exception {
        this.recipient = (BConsoleRecipient)bObject;
        this.ctx = context;
        this.locallyAcknowledgedAlarms = Collections.synchronizedList(new ArrayList());
        this.remotelyAcknowledgedAlarms = new ArrayList();
        this.sourceTable.setMultipleSelection(true);
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell == null) {
            bWbShell = this.getShell();
        }
        this.sourceTimeCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.sourceTimeZone");
        this.consoleTimeCommand = new ToggleCommand((BWidget)this, BAlarmConsole.lexicon.module, "commands.consoleTimeZone");
        BTimeZoneDisplay bTimeZoneDisplay = this.options.getTimeZoneDisplay();
        RadioGroup radioGroup = new RadioGroup();
        radioGroup.add(this.sourceTimeCommand);
        radioGroup.add(this.consoleTimeCommand);
        if (bTimeZoneDisplay == BTimeZoneDisplay.console) {
            this.consoleTimeCommand.setSelected(true);
        } else {
            this.sourceTimeCommand.setSelected(true);
        }
        this.timeRange = this.recipient.getDefaultTimeRange();
        this.timeRangeEd.loadValue((BObject)this.timeRange);
        BFilterSet bFilterSet = this.options.getAlarmFilters();
        BFilterEntry[] bFilterEntryArray = (BFilterEntry[])bFilterSet.getChildren(class$com$tridium$bql$filter$BFilterEntry == null ? (class$com$tridium$bql$filter$BFilterEntry = BAlarmConsole.class$("com.tridium.bql.filter.BFilterEntry")) : class$com$tridium$bql$filter$BFilterEntry);
        boolean bl = false;
        for (int i = 0; i < bFilterEntryArray.length; ++i) {
            if (!bFilterEntryArray[i].getActive()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.filterBtn.setImage(BImage.make((String)lexicon.getText("commands.filtered.icon")));
            this.filterBtn.setForeground(BBrush.makeSolid((BColor)BColor.red));
        }
        this.linkTo("rangeLink", (BComponent)this.timeRangeEd, (Slot)BWbFieldEditor.setModified, (Slot)timeRangeModified);
        if (bWbShell instanceof BWbShell) {
            new LoadThread().start();
        }
    }

    public BGridPane makeToolBar() {
        BGridPane bGridPane = new BGridPane(BAlarmConsole.isVideoDriverAvailable() ? 6 : 5);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        BButton bButton = new BButton(this.ackCommand, true, true);
        bGridPane.add("ack", (BValue)bButton);
        BButton bButton2 = new BButton(this.urlCommand, true, true);
        bGridPane.add("hyp", (BValue)bButton2);
        BButton bButton3 = new BButton(this.notesCommand, true, true);
        bGridPane.add("notes", (BValue)bButton3);
        BButton bButton4 = new BButton(this.silenceCommand, true, true);
        bGridPane.add("sil", (BValue)bButton4);
        this.filterBtn = new BButton(this.filterCmd, true, true);
        bGridPane.add("filter", (BValue)this.filterBtn);
        if (BAlarmConsole.isVideoDriverAvailable()) {
            BButton bButton5 = new BButton(this.showVideoCmd, true, true);
            bGridPane.add("showVideo", (BValue)bButton5);
        }
        return bGridPane;
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = lexicon.buildMenu("menu.alarm.label");
        bMenu.add("acknowledge", this.ackCommand);
        bMenu.add("hyperlink", this.urlCommand);
        bMenu.add("notes", this.notesCommand);
        bMenu.add("deatils", this.detailsCommand);
        bMenu.add("silence", this.silenceCommand);
        bMenu.add("sep0", (BValue)new BSeparator());
        if (this.getRecipientForAlarm(null) == null || this.getRecipientForAlarm(null).getPermissions(this.ctx).hasAdminWrite() || this.getRecipientForAlarm(null).getPermissions(this.ctx).hasAdminInvoke()) {
            bMenu.add("forceClear", this.forceClear);
            bMenu.add("sep1", (BValue)new BSeparator());
        }
        bMenu.add("soundOn", (Command)this.soundOnCommand);
        bMenu.add("continuousAlarm", (Command)this.continuousAlarmCommand);
        bMenu.add("acMap", this.alarmClassMappingCommand);
        bMenu.add("pColors", this.priorityColorsCommand);
        bMenu.add("sep2", (BValue)new BSeparator());
        bMenu.add("sourceTime", (Command)this.sourceTimeCommand);
        bMenu.add("consoleTime", (Command)this.consoleTimeCommand);
        bMenu.add("sep3", (BValue)new BSeparator());
        bMenu.add("addCol", this.addColumnCommand);
        bMenu.add("removeCol", this.removeColumnCommand);
        return new BMenu[]{bMenu};
    }

    public void doProcessAlarm(BAlarmRecord bAlarmRecord) {
        logger.trace("BAlarmConsole.doProcess(): " + this.recipient.getName() + " got alarm: " + bAlarmRecord.getTimestamp() + " : " + (Object)((Object)bAlarmRecord.getSourceState()));
        if (!bAlarmRecord.isOpen()) {
            this.removeAlarm(bAlarmRecord);
        } else {
            BAbsTime bAbsTime = BAbsTime.now();
            BAbsTime bAbsTime2 = this.timeRange.getStartTime(bAbsTime);
            BAbsTime bAbsTime3 = this.timeRange.getEndTime(bAbsTime);
            if (this.options.getAlarmFilters().accept((BComplex)bAlarmRecord) && (bAbsTime2.isNull() || bAbsTime2.isBefore(bAlarmRecord.getTimestamp())) && (bAbsTime3.isNull() || this.timeRange.getEndTime(bAbsTime).isAfter(bAlarmRecord.getTimestamp()))) {
                this.updateAlarm(bAlarmRecord, true);
            } else {
                this.removeAlarm(bAlarmRecord);
            }
        }
        this.options.setSortColumn(this.sourceModel.getLastSortColumn());
        this.options.setSortAscending(this.sourceModel.getLastSortAscending());
        this.sourceModel.sortByColumn(this.sourceModel.getLastSortColumn(), this.sourceModel.getLastSortAscending());
        ((Controller)this.sourceTable.getController()).enableCommands();
    }

    public void doTimeRangeModified() throws Exception {
        this.timeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue();
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell == null) {
            bWbShell = this.getShell();
        }
        if (bWbShell instanceof BWbShell) {
            new LoadThread().start();
        } else {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAlarms(BAlarmRecord[] bAlarmRecordArray) {
        Object object = this.dataMutex;
        synchronized (object) {
            if (this.options.getNotesRequiredOnAck()) {
                BTextDropDown bTextDropDown = new BTextDropDown(false);
                BEdgePane bEdgePane = new BEdgePane();
                String string = lexicon.getText("alarm.multipleAlarmNotes");
                if (bAlarmRecordArray.length == 1) {
                    string = bAlarmRecordArray[0].getAlarmData().get("notes") != null ? bAlarmRecordArray[0].getAlarmData().get("notes").toString() : "";
                }
                BTextEditorPane bTextEditorPane = new BTextEditorPane(string.toString(), 12, 80, false);
                bEdgePane.setTop((BWidget)bTextEditorPane);
                BList bList = bTextDropDown.getList();
                BVector bVector = this.options.getAlarmAckResponses();
                BString[] bStringArray = (BString[])bVector.getChildren(class$javax$baja$sys$BString == null ? (class$javax$baja$sys$BString = BAlarmConsole.class$("javax.baja.sys.BString")) : class$javax$baja$sys$BString);
                for (int i = 0; i < bStringArray.length; ++i) {
                    bList.addItem((Object)BFormat.make((String)bStringArray[i].toString()).format((Object)this));
                }
                BEdgePane bEdgePane2 = new BEdgePane();
                if (bList.getItemCount() > 0) {
                    bEdgePane2.setTop((BWidget)bTextDropDown);
                }
                BTextEditorPane bTextEditorPane2 = new BTextEditorPane("", 8, 80, true);
                bEdgePane2.setCenter((BWidget)bTextEditorPane2);
                bEdgePane.setCenter((BWidget)bEdgePane2);
                bTextEditorPane2.getEditor().requestFocus();
                int n = BDialog.open((BWidget)this, (String)lexicon.getText("commands.notes.label"), (Object)new BBorderPane((BWidget)bEdgePane), (int)3);
                if (n == 2) {
                    return;
                }
                String string2 = bTextEditorPane2.getText();
                if (bList.getItemCount() > 0) {
                    string2 = bTextDropDown.getText() + "\n" + bTextEditorPane2.getText();
                }
                for (int i = 0; i < bAlarmRecordArray.length; ++i) {
                    StringBuffer stringBuffer;
                    BFacets bFacets = bAlarmRecordArray[i].getAlarmData();
                    HashMap<String, StringBuffer> hashMap = new HashMap<String, StringBuffer>();
                    String[] stringArray = bFacets.list();
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (stringArray[j].equals("notes")) continue;
                        stringBuffer = bFacets.get(stringArray[j]);
                        hashMap.put(stringArray[j], stringBuffer);
                    }
                    String string3 = "";
                    if (bFacets.get("notes") != null) {
                        string3 = bFacets.get("notes").toString();
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("## " + BAbsTime.now() + " - " + this.getUsername(bAlarmRecordArray[i]) + " ##\n");
                    stringBuffer.append(string2);
                    stringBuffer.append("\n\n");
                    stringBuffer.append(string3);
                    hashMap.put("notes", (StringBuffer)BString.make((String)stringBuffer.toString()));
                    BFacets bFacets2 = BFacets.make(hashMap);
                    bAlarmRecordArray[i].setAlarmData(bFacets2);
                }
            }
            this.ackAlarms(bAlarmRecordArray);
            if (bAlarmRecordArray.length > 1) {
                this.sourceTable.getSelection().deselectAll();
            }
        }
    }

    public void alarmSilenceSelected() {
        if (soundPlayer != null) {
            soundPlayer.stop();
        }
        this.mediaPlayerStopped();
    }

    public void mediaPlayerStopped() {
        this.silenceCommand.setEnabled(false);
    }

    public void showError(String string, Throwable throwable) {
        BDialog.error((BWidget)this, (String)"Error", (Object)string, (Throwable)throwable);
    }

    public void showNotes(BWidget bWidget, BAlarmRecord[] bAlarmRecordArray) {
        if (bAlarmRecordArray.length == 0) {
            return;
        }
        String string = "";
        if (bAlarmRecordArray.length == 1) {
            try {
                string = ((BString)bAlarmRecordArray[0].getAlarmData().getFacet("notes")).getString();
            }
            catch (Exception exception) {}
        } else {
            string = lexicon.getText("alarm.multipleAlarmNotes");
        }
        BNotesDialog bNotesDialog = new BNotesDialog((BWidget)this, string, this.getUsername(bAlarmRecordArray[0]), this.canModifySelectedAlarms());
        bNotesDialog.setBoundsCenteredOnOwner();
        bNotesDialog.open();
        String string2 = bNotesDialog.getNewNotes();
        for (int i = 0; i < bAlarmRecordArray.length; ++i) {
            if (string2 == null) continue;
            try {
                string = string2 + ((BString)bAlarmRecordArray[i].getAlarmData().getFacet("notes")).getString();
            }
            catch (Exception exception) {
                string = string2;
            }
            BFacets bFacets = bAlarmRecordArray[i].getAlarmData();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String[] stringArray = bFacets.list();
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j].equals("notes")) continue;
                BObject bObject = bFacets.get(stringArray[j]);
                hashMap.put(stringArray[j], bObject);
            }
            hashMap.put("notes", BString.make((String)string));
            BFacets bFacets2 = BFacets.make(hashMap);
            bAlarmRecordArray[i].setAlarmData(bFacets2);
            try {
                this.sendUpdatedAlarm(bAlarmRecordArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected String getUsername(BAlarmRecord bAlarmRecord) {
        BFoxSession bFoxSession = (BFoxSession)this.getCurrentValueSession();
        BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
        return bFoxClientConnection.getUsername();
    }

    protected boolean canModifySelectedAlarms() {
        return this.canModifySelectedAlarms(this.sourceModel.getSelection());
    }

    protected boolean canModifySelectedAlarms(TableSelection tableSelection) {
        if (tableSelection == null || tableSelection.isEmpty()) {
            return false;
        }
        int[] nArray = tableSelection.getRows();
        SourceTableModel sourceTableModel = (SourceTableModel)((DynamicTableModel)this.sourceModel.getModel()).getRootModel();
        BAlarmService bAlarmService = this.getAlarmService();
        for (int i = 0; i < nArray.length; ++i) {
            BAlarmRecord bAlarmRecord = sourceTableModel.getRecord(nArray[i]);
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (!(bAlarmClass == null ? !bAlarmService.getDefaultAlarmClass().getPermissions(this.ctx).hasOperatorWrite() : !bAlarmClass.getPermissions(this.ctx).hasOperatorWrite())) continue;
            return false;
        }
        return true;
    }

    protected void loadComplete() {
        this.exitBusy();
        this.exitBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.dataMutex;
        synchronized (object) {
            this.enterBusy();
            try {
                String string;
                BAbsTimeFilter bAbsTimeFilter;
                BDynamicTimeRange bDynamicTimeRange;
                StringBuffer stringBuffer = new StringBuffer(this.channel().getInitialAlarmQuery(this, this.recipient).toString());
                BFilterSet bFilterSet = this.options.getAlarmFilters();
                StringBuffer stringBuffer2 = new StringBuffer(64);
                String string2 = bFilterSet.getPredicate();
                if (string2 != null && string2.length() > 0) {
                    if (stringBuffer2.length() != 0) {
                        stringBuffer2.append(" and ");
                    }
                    stringBuffer2.append(string2);
                }
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(" and ").append(stringBuffer2.toString());
                }
                if (!(bDynamicTimeRange = (BDynamicTimeRange)this.timeRangeEd.saveValue()).equals((Object)BDynamicTimeRange.DEFAULT)) {
                    bAbsTimeFilter = new BAbsTimeFilter();
                    bAbsTimeFilter.initFromDynamicTimeRange(bDynamicTimeRange);
                    string = bAbsTimeFilter.getPredicate(BAlarmRecord.timestamp.getName());
                    stringBuffer.append(" and ").append(string.toString());
                }
                stringBuffer.append(" order by timestamp desc, ");
                if (this.options.getSortColumn() < this.sourceModel.getColumns().getColumnCount()) {
                    stringBuffer.append(this.sourceModel.getColumns().getColumn(this.options.getSortColumn()).getQueryName());
                } else {
                    stringBuffer.append(this.sourceModel.getColumns().getColumn(0).getQueryName());
                }
                if (this.options.getSortAscending()) {
                    stringBuffer.append(" asc");
                } else {
                    stringBuffer.append(" desc");
                }
                bAbsTimeFilter = BOrd.make((BOrd)this.getCurrentValueSession().getAbsoluteOrd(), (BOrd)BOrd.make((String)stringBuffer.toString()));
                string = (BICollection)bAbsTimeFilter.resolve(this.getCurrentValue()).get();
                Cursor cursor = string.cursor();
                this.sourceModel.clear();
                if (cursor.next()) {
                    BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                    if (bAlarmRecord.isOpen()) {
                        this.sourceModel.update(bAlarmRecord);
                        this.sourceTable.sizeColumnsToFit();
                    }
                    while (cursor.next()) {
                        bAlarmRecord = (BAlarmRecord)cursor.get();
                        if (bAlarmRecord.getSourceState() == BSourceState.normal && (bAlarmRecord.isAcknowledged() || !bAlarmRecord.getAckRequired())) continue;
                        this.sourceModel.update(bAlarmRecord, false);
                    }
                    this.sourceModel.sortByColumn(this.sourceModel.getLastSortColumn(), this.sourceModel.getLastSortAscending());
                    this.sourceModel.updateTable();
                    this.sourceTable.sizeColumnsToFit();
                }
                for (int i = 0; i < this.sourceModel.getRowCount(); ++i) {
                    if (!this.sourceModel.getRecord(i).isAlarm()) continue;
                    this.soundAlarmFor(this.sourceModel.getRecord(i));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.exitBusy();
                this.loadComplete();
                this.sourceModel.init(this, this.ctx);
                this.sourceTable.sizeColumnsToFit();
                this.sourceModel.getTable().fireTableModified(null);
            }
        }
    }

    public void configFilters() {
        if (this.sourceTable == null) {
            return;
        }
        SlotCursor slotCursor = this.options.getAlarmFilters().getProperties();
        if (!slotCursor.next(class$com$tridium$bql$filter$BFilterEntry == null ? (class$com$tridium$bql$filter$BFilterEntry = BAlarmConsole.class$("com.tridium.bql.filter.BFilterEntry")) : class$com$tridium$bql$filter$BFilterEntry)) {
            this.options.setAlarmFilters(this.buildFilterSet());
        }
        BFilterSetEditor bFilterSetEditor = new BFilterSetEditor();
        bFilterSetEditor.loadValue((BObject)this.options.getAlarmFilters());
        BBorderPane bBorderPane = new BBorderPane((BWidget)bFilterSetEditor, 10.0, 10.0, 10.0, 10.0);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)bBorderPane, (int)3) != 2) {
            try {
                BWbShell bWbShell;
                if (bFilterSetEditor.isModified()) {
                    bWbShell = (BFilterSet)bFilterSetEditor.saveValue();
                    this.options.setAlarmFilters((BFilterSet)bWbShell);
                    BFilterEntry[] bFilterEntryArray = (BFilterEntry[])bWbShell.getChildren(class$com$tridium$bql$filter$BFilterEntry == null ? (class$com$tridium$bql$filter$BFilterEntry = BAlarmConsole.class$("com.tridium.bql.filter.BFilterEntry")) : class$com$tridium$bql$filter$BFilterEntry);
                    boolean bl = false;
                    for (int i = 0; i < bFilterEntryArray.length; ++i) {
                        if (!bFilterEntryArray[i].getActive()) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        this.filterBtn.setImage(BImage.make((String)lexicon.getText("commands.filtered.icon")));
                        this.filterBtn.setForeground(BBrush.makeSolid((BColor)BColor.red));
                    } else {
                        this.filterBtn.setImage(BImage.make((String)lexicon.getText("commands.filter.icon")));
                        this.filterBtn.setForeground(BBrush.NULL);
                    }
                }
                if ((bWbShell = this.getWbShell()) == null) {
                    bWbShell = this.getShell();
                }
                if (bWbShell instanceof BWbShell) {
                    new LoadThread().start();
                } else {
                    this.load();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    private BFilterSet buildFilterSet() {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        BFilterSet bFilterSet = new BFilterSet();
        Property[] propertyArray = bAlarmRecord.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            BValue bValue;
            AgentList agentList;
            if (propertyArray[i].equals(BAlarmRecord.timestamp) || (agentList = (bValue = bAlarmRecord.get(propertyArray[i])).getAgents().filter(AgentFilter.is((Type)BIBqlFilter.TYPE))).size() == 0) continue;
            BIBqlFilter bIBqlFilter = (BIBqlFilter)agentList.getDefault().getInstance();
            bIBqlFilter.init((BObject)bValue);
            BFilterEntry bFilterEntry = new BFilterEntry(false, propertyArray[i].getDefaultDisplayName(this.getCurrentContext()), bIBqlFilter);
            bFilterSet.add(propertyArray[i].getName(), (BValue)bFilterEntry, 0, bAlarmRecord.getSlotFacets((Slot)propertyArray[i]), null);
        }
        return bFilterSet;
    }

    public void updateAlarm(BAlarmRecord bAlarmRecord, boolean bl) {
        logger.trace("BAlarmConsole.alarmCreated(): update alarm: uuid = " + bAlarmRecord.getUuid() + ", priority = " + bAlarmRecord.getPriority());
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = this.timeRange.getStartTime(bAbsTime);
        BAbsTime bAbsTime3 = this.timeRange.getEndTime(bAbsTime);
        if (this.options.getAlarmFilters().accept((BComplex)bAlarmRecord) && (bAbsTime2.isNull() || bAbsTime2.isBefore(bAlarmRecord.getTimestamp())) && (bAbsTime3.isNull() || bAbsTime3.isAfter(bAlarmRecord.getTimestamp()))) {
            this.sourceModel.update(bAlarmRecord);
            this.sourceTable.sizeColumnsToFit();
        }
        if (bl && bAlarmRecord.isAlarm()) {
            this.soundAlarmFor(bAlarmRecord);
        } else if (bl) {
            this.silenceAlarm(bAlarmRecord);
        }
    }

    public void removeAlarm(BAlarmRecord bAlarmRecord) {
        this.sourceModel.remove(bAlarmRecord);
        this.silenceAlarm(bAlarmRecord);
        if (this.detailsDlg != null && this.detailsDlg.alarm.getUuid().equals((Object)bAlarmRecord.getUuid())) {
            this.detailsDlg.alarmCleared();
        }
    }

    protected void viewAll() {
        int n = this.sourceModel.getSelection().getRow();
        if (n == -1) {
            return;
        }
        BAlarmRecord bAlarmRecord = this.sourceModel.getRecord(n);
        BOrdList bOrdList = bAlarmRecord.getSource();
        this.alarmTable = new BTable();
        this.alarmTable.setController((TableController)this.getController());
        this.alarmTable.setCellRenderer((TableCellRenderer)new AlarmTableCellRenderer());
        AlarmTableModel alarmTableModel = this.sourceModel.getModelForSource(bOrdList);
        DynamicTableModel dynamicTableModel = new DynamicTableModel((TableModel)alarmTableModel);
        DynamicTableModel dynamicTableModel2 = (DynamicTableModel)this.sourceTable.getModel();
        int n2 = this.columns.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            dynamicTableModel.setShowColumn(i, dynamicTableModel2.showColumn(i));
            dynamicTableModel.setColumnShowable(i, dynamicTableModel2.isColumnShowable(i));
        }
        this.alarmTable.setModel((TableModel)dynamicTableModel);
        this.alarmReport = new BAlarmReportDialog(this, bOrdList.toString(), this.alarmTable);
        IRectGeom iRectGeom = UiEnv.get().getScreenBounds((BWidget)this);
        double d = iRectGeom.x() + (iRectGeom.width() - iRectGeom.width() / 1.3) / 2.0;
        double d2 = iRectGeom.y() + (iRectGeom.height() - iRectGeom.height() / 2.0) / 2.0;
        this.alarmReport.setPreferredSize(iRectGeom.width() / 1.3, iRectGeom.height() / 2.0);
        this.alarmReport.setScreenBounds(d, d2, iRectGeom.width() / 1.3, iRectGeom.height() / 2.0);
        this.alarmReport.setVisible(true);
        this.alarmReport.open();
        alarmTableModel.close();
        this.alarmTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmRecord[] getSelectedAlarms(BTable bTable) {
        Object object = this.dataMutex;
        synchronized (object) {
            ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)bTable.getModel()).getRootModel();
            int[] nArray = bTable.getSelection().getRows();
            BAlarmRecord[] bAlarmRecordArray = new BAlarmRecord[nArray.length];
            ConsoleTableModel consoleTableModel2 = consoleTableModel;
            synchronized (consoleTableModel2) {
                for (int i = 0; i < nArray.length; ++i) {
                    bAlarmRecordArray[i] = consoleTableModel.getRecord(nArray[i]);
                }
            }
            return bAlarmRecordArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmRecord[] getSelectedAlarmsDeep(BTable bTable) {
        ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)bTable.getModel()).getRootModel();
        if (!(consoleTableModel instanceof SourceTableModel)) {
            return this.getSelectedAlarms(bTable);
        }
        SourceTableModel sourceTableModel = (SourceTableModel)consoleTableModel;
        int[] nArray = bTable.getSelection().getRows();
        Array array = new Array(class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmConsole.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord);
        SourceTableModel sourceTableModel2 = sourceTableModel;
        synchronized (sourceTableModel2) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = sourceTableModel.getRecordCount(nArray[i]);
                for (int j = 0; j < n; ++j) {
                    array.add((Object)sourceTableModel.getRecordAt(nArray[i], j));
                }
            }
        }
        return (BAlarmRecord[])array.trim();
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            BOrd bOrd = this.getCurrentValueSession().getAbsoluteOrd();
            try {
                BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"service:alarm:AlarmService");
                this.alarmService = (BAlarmService)bOrd2.resolve().get();
            }
            catch (Exception exception) {
                logger.warning("Unable to Audit Force Clear: Cannot find alarm Service", (Throwable)exception);
            }
        }
        return this.alarmService;
    }

    protected boolean alarmLocallyAcknowledged(BAlarmRecord bAlarmRecord) {
        ListIterator listIterator = this.locallyAcknowledgedAlarms.listIterator();
        BAlarmRecord bAlarmRecord2 = null;
        while (listIterator.hasNext()) {
            bAlarmRecord2 = (BAlarmRecord)((Object)listIterator.next());
            if (!bAlarmRecord2.getUuid().equals((Object)bAlarmRecord.getUuid())) continue;
            return true;
        }
        return false;
    }

    protected boolean alarmRemotelyAcknowledged(BAlarmRecord bAlarmRecord) {
        ListIterator listIterator = this.remotelyAcknowledgedAlarms.listIterator();
        BAlarmRecord bAlarmRecord2 = null;
        while (listIterator.hasNext()) {
            bAlarmRecord2 = (BAlarmRecord)((Object)listIterator.next());
            if (!bAlarmRecord2.getUuid().equals((Object)bAlarmRecord.getUuid())) continue;
            return true;
        }
        return false;
    }

    protected void ackAlarms(BAlarmRecord[] bAlarmRecordArray) {
        try {
            Array array = new Array(class$javax$baja$alarm$BAlarmRecord == null ? (class$javax$baja$alarm$BAlarmRecord = BAlarmConsole.class$("javax.baja.alarm.BAlarmRecord")) : class$javax$baja$alarm$BAlarmRecord);
            for (int i = 0; i < bAlarmRecordArray.length; ++i) {
                if (bAlarmRecordArray[i].isAcknowledged()) continue;
                BAlarmRecord bAlarmRecord = (BAlarmRecord)bAlarmRecordArray[i].newCopy();
                bAlarmRecord.setUser(this.getUsername(bAlarmRecord));
                bAlarmRecord.setAckTime(BAbsTime.now());
                bAlarmRecord.setAckState(BAckState.ackPending);
                this.sourceModel.update(bAlarmRecord);
                array.add((Object)bAlarmRecord);
            }
            this.channel().ackAlarms(this.recipient, (BAlarmRecord[])array.trim());
            this.sourceTable.sizeColumnsToFit();
            this.sourceTable.fireTableModified(null);
            if (this.alarmTable != null) {
                this.alarmTable.fireTableModified(null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void soundAlarmFor(BAlarmRecord bAlarmRecord) {
        if (!this.options.getSoundsEnabled()) {
            return;
        }
        try {
            BOrd bOrd = BOrd.NULL;
            try {
                if (bAlarmRecord.getAlarmData().get("soundFile") != null) {
                    bOrd = BOrd.make((BOrd)BOrd.toSpace((BObject)this.getRecipientForAlarm(bAlarmRecord)).getNavOrd(), (String)bAlarmRecord.getAlarmData().get("soundFile").toString());
                }
            }
            catch (NullOrdException nullOrdException) {
                // empty catch block
            }
            if (bOrd == null || bOrd.isNull()) {
                BAlarmClassMapping bAlarmClassMapping;
                BAlarmClassDef bAlarmClassDef = null;
                if (this.options != null && (bAlarmClassMapping = this.options.getAlarmClassMapping()) != null && (bAlarmClassDef = bAlarmClassMapping.getAlarmClassDefFor(bAlarmRecord.getAlarmClass())) != null) {
                    bOrd = bAlarmClassDef.getAlarmSound();
                }
            }
            if (bOrd == null || bOrd.isNull()) {
                this.soundAlarm(bAlarmRecord);
            } else {
                this.soundAlarm(bAlarmRecord.getSource(), bOrd);
            }
        }
        catch (Exception exception) {
            logger.message("Cannot Sound Alarm: ", (Throwable)exception);
        }
    }

    public void soundAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        if (!this.options.getDefaultSoundFile().isNull()) {
            if (this.options.getDefaultSoundFile().relativizeToHost().equals((Object)BLocalHost.INSTANCE.getAbsoluteOrd())) {
                this.soundAlarm(bAlarmRecord.getSource(), this.options.getDefaultSoundFile());
            } else if (!BOrd.toSpace((BObject)this.getRecipientForAlarm(bAlarmRecord)).getNavOrd().isNull()) {
                this.soundAlarm(bAlarmRecord.getSource(), BOrd.make((BOrd)BOrd.toSpace((BObject)this.getRecipientForAlarm(bAlarmRecord)).getNavOrd(), (String)this.options.getDefaultSoundFile().toString()));
            }
        }
    }

    public void soundAlarm(BOrdList bOrdList, BOrd bOrd) {
        try {
            if (!this.options.getSoundsEnabled() || bOrd.isNull()) {
                return;
            }
            BAbstractFile bAbstractFile = (BAbstractFile)this.sounds.get(bOrd);
            if (bAbstractFile == null) {
                bAbstractFile = (BAbstractFile)bOrd.get();
                this.sounds.put(bOrd, bAbstractFile);
            }
            if (soundPlayer == null) {
                soundPlayer = UiEnv.get().isMicroEdition() ? new SoundPlayer() : new MediaPlayer();
                soundPlayer.addMediaObject((BValue)bOrdList, bAbstractFile);
                soundPlayer.addListener(this);
            }
            if (soundPlayer.addMediaObject((BValue)bOrdList, bAbstractFile)) {
                soundPlayer.play(this.options.getContinuousAlarm(), this.options.getContinuousAlarmDelay());
            }
            this.silenceCommand.setEnabled(true);
        }
        catch (Exception exception) {
            logger.warning("Cannot sound alarm: MediaPlayer exception: " + exception);
        }
    }

    public void silenceAlarm(BAlarmRecord bAlarmRecord) {
        if (!this.options.getSoundsEnabled()) {
            return;
        }
        soundPlayer.removeMediaObject((BValue)bAlarmRecord.getSource());
        if (!soundPlayer.hasMediaObjects()) {
            this.silenceCommand.setEnabled(false);
        }
    }

    public void showDetailsDialog(BTable bTable, int n) {
        ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)bTable.getModel()).getRootModel();
        this.detailsDlg = new BAlarmDetailsDialog(this, this.options.getTimeZoneDisplay(), consoleTableModel.getRecord(n), consoleTableModel, this.ctx);
        this.detailsDlg.setBoundsCenteredOnOwner();
        this.detailsDlg.open();
    }

    protected void hyperlink(BAlarmRecord bAlarmRecord) {
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null) {
            BOrd bOrd = BOrd.NULL;
            if (bAlarmRecord.getAlarmData().get("hyperlinkOrd") != null) {
                bOrd = BOrd.make((String)bAlarmRecord.getAlarmData().get("hyperlinkOrd").toString());
            }
            if (bOrd == null || bOrd.isNull()) {
                BAlarmClassMapping bAlarmClassMapping = this.options.getAlarmClassMapping();
                BAlarmClassDef bAlarmClassDef = bAlarmClassMapping.getAlarmClassDefFor(bAlarmRecord.getAlarmClass());
                bOrd = bAlarmClassDef.getAlarmUrl();
            }
            if (!bOrd.isNull()) {
                bWbShell.hyperlink(bOrd);
                if (this.detailsDlg != null) {
                    this.detailsDlg.close();
                }
                if (this.alarmReport != null) {
                    this.alarmReport.close();
                }
            }
        }
    }

    protected BConsoleRecipient getRecipientForAlarm(BAlarmRecord bAlarmRecord) {
        return this.recipient;
    }

    public BAlarmService getAlarmService(BAlarmRecord bAlarmRecord) {
        return this.getAlarmService();
    }

    protected void sendUpdatedAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        this.channel().updateAlarm(bAlarmRecord);
    }

    public BAlarmConsoleUIChannel channel() {
        return this.channel(this.recipient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAlarmConsoleUIChannel channel(BConsoleRecipient bConsoleRecipient) {
        try {
            if (bConsoleRecipient.getComponentSpace() == null) {
                throw new BajaRuntimeException("Console recipient component space is null.");
            }
            BFoxSession bFoxSession = (BFoxSession)bConsoleRecipient.getSession();
            if (bFoxSession == null) {
                throw new BajaRuntimeException("Console recipient session is null.");
            }
            BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
            if (bFoxSession == null) {
                throw new BajaRuntimeException("Console recipient connection is null.");
            }
            Object object = BAlarmConsoleChannel.channelMutex;
            synchronized (object) {
                BAlarmConsoleChannel bAlarmConsoleChannel = (BAlarmConsoleChannel)bFoxClientConnection.getChannels().get("alarmui");
                if (bAlarmConsoleChannel == null || !(bAlarmConsoleChannel instanceof BAlarmConsoleUIChannel)) {
                    if (bAlarmConsoleChannel != null) {
                        ((BFoxSession)bConsoleRecipient.getSession()).getConnection().getChannels().remove("alarmui");
                    }
                    bAlarmConsoleChannel = new BAlarmConsoleUIChannel();
                    ((BFoxSession)bConsoleRecipient.getSession()).getConnection().getChannels().add("alarmui", (BValue)bAlarmConsoleChannel);
                }
                return (BAlarmConsoleUIChannel)bAlarmConsoleChannel;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static boolean isVideoDriverAvailable() {
        BModule bModule = null;
        try {
            bModule = Sys.loadModule((String)"videoDriver");
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            bModule = null;
        }
        catch (ModuleException moduleException) {
            bModule = null;
        }
        return bModule != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AlarmTableCellRenderer
    extends TableCellRenderer {
        IntHashMap priorityColors = new IntHashMap();
        IntHashMap priorityFgColors = new IntHashMap();

        public void resetPriorityColors() {
            this.priorityColors.clear();
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (this.getTable() == null || this.getTable().getModel() == null) {
                return 0.0;
            }
            if (cell.column == 0) {
                return super.getPreferredCellWidth(cell) + 18.0 + 18.0 + 18.0;
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            Object object;
            Object object2;
            TableModel tableModel = this.getTable().getModel();
            this.paintCellBackground(graphics, cell);
            double d = 2.0;
            double d2 = (cell.height - 16.0) / 2.0;
            if (cell.column == 0) {
                String string;
                object2 = null;
                try {
                    object = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                    object2 = ((ConsoleTableModel)((Object)object)).getRecord(cell.row);
                }
                catch (Exception exception) {
                    return;
                }
                object = ((BAlarmRecord)((Object)object2)).getAlarmClass();
                BAlarmClassMapping bAlarmClassMapping = BAlarmConsole.this.options.getAlarmClassMapping();
                BAlarmClassDef bAlarmClassDef = bAlarmClassMapping.getAlarmClassDefFor((String)object);
                BImage bImage = null;
                try {
                    if (((BAlarmRecord)((Object)object2)).getAlarmData().get("icon") != null && BOrd.make((String)((BAlarmRecord)((Object)object2)).getAlarmData().get("icon").toString()) != BOrd.NULL) {
                        bImage = BImage.make((BOrd)BOrd.make((BOrd)BOrd.toSpace((BObject)BAlarmConsole.this.getRecipientForAlarm((BAlarmRecord)((Object)object2))).getNavOrd(), (String)((BAlarmRecord)((Object)object2)).getAlarmData().get("icon").toString()));
                    } else if (bAlarmClassDef != null && bAlarmClassDef.getAlarmIcon() != BOrd.NULL) {
                        bImage = BImage.make((BOrd)bAlarmClassDef.getAlarmIcon());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bImage != null) {
                    d2 = (cell.height - bImage.getHeight()) / 2.0;
                    graphics.drawImage(bImage, d, d2);
                }
                d += 18.0;
                BOrd bOrd = BOrd.NULL;
                if (((BAlarmRecord)((Object)object2)).getAlarmData().get("hyperlinkOrd") != null && !BOrd.make((String)((BAlarmRecord)((Object)object2)).getAlarmData().get("hyperlinkOrd").toString()).isNull()) {
                    bOrd = BOrd.make((String)((BAlarmRecord)((Object)object2)).getAlarmData().get("hyperlinkOrd").toString());
                } else if (bAlarmClassDef != null) {
                    bOrd = bAlarmClassDef.getAlarmUrl();
                }
                if (bOrd != null && !bOrd.isNull() && BAlarmConsole.this.lnkImg != null) {
                    d2 = (cell.height - BAlarmConsole.this.lnkImg.getHeight()) / 2.0;
                    graphics.drawImage(BAlarmConsole.this.lnkImg, d, d2);
                }
                d += 18.0;
                String string2 = ((BAlarmRecord)((Object)object2)).getAlarmData().gets("cameraOrd", null);
                if (string2 != null && !BOrd.make((String)string2).isNull()) {
                    string = lexicon.getText("commands.showVideo.icon");
                    BImage bImage2 = BImage.make((String)string);
                    d2 = (cell.height - bImage2.getHeight()) / 2.0;
                    graphics.drawImage(bImage2, d, d2);
                }
                d += 18.0;
                string = tableModel.getRowIcon(cell.row);
                if (string != null) {
                    d2 = (cell.height - string.getHeight()) / 2.0;
                    graphics.drawImage((BImage)string, d, d2);
                    d += 18.0;
                }
            }
            object2 = this.getCellText(cell);
            object = Theme.table().getCellFont();
            switch (tableModel.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    d = cell.width - 2.0 - object.width((String)object2);
                    break;
                }
                case 1: {
                    d = (cell.width - object.width((String)object2)) / 2.0;
                }
            }
            graphics.setFont(Theme.table().getCellFont());
            graphics.drawString((String)object2, d, (cell.height + object.getAscent() - object.getDescent()) / 2.0);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            try {
                BColor bColor;
                DynamicTableModel dynamicTableModel = (DynamicTableModel)this.getTable().getModel();
                BAlarmRecord bAlarmRecord = ((ConsoleTableModel)dynamicTableModel.getRootModel()).getRecord(cell.row);
                int n = 0;
                if (bAlarmRecord != null) {
                    n = bAlarmRecord.getPriority();
                }
                if ((bColor = (BColor)this.priorityColors.get(n)) != null) {
                    return BBrush.makeSolid((BColor)bColor);
                }
                bColor = this.solveSpectrum(n, BAlarmConsole.this.options.getLowPriorityColor(), BAlarmConsole.this.options.getMidPriorityColor(), BAlarmConsole.this.options.getHighPriorityColor());
                this.priorityColors.put(n, (Object)bColor);
                return BBrush.makeSolid((BColor)bColor);
            }
            catch (Exception exception) {
                return super.getBackground(cell);
            }
        }

        private BColor solveSpectrum(int n, BColor bColor, BColor bColor2, BColor bColor3) {
            int n2;
            int n3;
            int n4;
            int n5;
            float f = 128.0f;
            float f2 = n;
            float f3 = 128.0f;
            if (f2 > f) {
                if (f2 > f + f3) {
                    return bColor;
                }
                float f4 = (float)(bColor.getRed() - bColor2.getRed()) / f3;
                float f5 = (float)bColor2.getRed() - f4 * f;
                n5 = (int)(f4 * f2 + f5);
                float f6 = (float)(bColor.getGreen() - bColor2.getGreen()) / f3;
                float f7 = (float)bColor2.getGreen() - f6 * f;
                n4 = (int)(f6 * f2 + f7);
                float f8 = (float)(bColor.getBlue() - bColor2.getBlue()) / f3;
                float f9 = (float)bColor2.getBlue() - f8 * f;
                n3 = (int)(f8 * f2 + f9);
                float f10 = (float)(bColor.getAlpha() - bColor2.getAlpha()) / f3;
                float f11 = (float)bColor2.getAlpha() - f10 * f;
                n2 = (int)(f10 * f2 + f11);
            } else {
                if (f2 < f - f3) {
                    return bColor3;
                }
                float f12 = (float)(bColor2.getRed() - bColor3.getRed()) / f3;
                float f13 = (float)bColor2.getRed() - f12 * f;
                n5 = (int)(f12 * f2 + f13);
                float f14 = (float)(bColor2.getGreen() - bColor3.getGreen()) / f3;
                float f15 = (float)bColor2.getGreen() - f14 * f;
                n4 = (int)(f14 * f2 + f15);
                float f16 = (float)(bColor2.getBlue() - bColor3.getBlue()) / f3;
                float f17 = (float)bColor2.getBlue() - f16 * f;
                n3 = (int)(f16 * f2 + f17);
                float f18 = (float)(bColor2.getAlpha() - bColor3.getAlpha()) / f3;
                float f19 = (float)bColor2.getAlpha() - f18 * f;
                n2 = (int)(f18 * f2 + f19);
            }
            return BColor.make((int)n5, (int)n4, (int)n3, (int)n2);
        }
    }

    protected class Controller
    extends TableController {
        int lastRowEntered = -1;

        protected Controller() {
        }

        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            this.enableCommands();
        }

        public void mouseReleased(BMouseEvent bMouseEvent) {
            super.mouseReleased(bMouseEvent);
            this.enableCommands();
        }

        void enableCommands() {
            TableSelection tableSelection = this.getTable().getSelection();
            boolean bl = tableSelection.getRows().length > 0 && BAlarmConsole.this.canModifySelectedAlarms(tableSelection);
            BAlarmConsole.this.ackCommand.setEnabled(bl);
            BAlarmConsole.this.ackRecentCommand.setEnabled(bl);
            BAlarmConsole.this.forceClear.setEnabled(bl);
            if (tableSelection.getRows().length == 1) {
                Object object;
                BOrd bOrd;
                ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                BAlarmRecord bAlarmRecord = consoleTableModel.getRecord(tableSelection.getRow());
                String string = bAlarmRecord.getAlarmData().gets("cameraOrd", null);
                if (string != null) {
                    bOrd = BOrd.make((String)string);
                    if (!bOrd.equals((Object)BOrd.NULL)) {
                        BAlarmConsole.this.showVideoCmd.setEnabled(true);
                    } else {
                        BAlarmConsole.this.showVideoCmd.setEnabled(false);
                    }
                } else {
                    BAlarmConsole.this.showVideoCmd.setEnabled(false);
                }
                bOrd = (BString)bAlarmRecord.getAlarmData().get("hyperlinkOrd");
                BOrd bOrd2 = BOrd.NULL;
                if (bOrd != null) {
                    bOrd2 = BOrd.make((String)bOrd.toString());
                }
                if (bOrd2 == null || bOrd2.isNull()) {
                    object = BAlarmConsole.this.options.getAlarmClassMapping();
                    BAlarmClassDef bAlarmClassDef = ((BAlarmClassMapping)((Object)object)).getAlarmClassDefFor(bAlarmRecord.getAlarmClass());
                    bOrd2 = bAlarmClassDef.getAlarmUrl();
                }
                if (bOrd2 != null && !bOrd2.isNull()) {
                    BAlarmConsole.this.urlCommand.setEnabled(true);
                } else {
                    BAlarmConsole.this.urlCommand.setEnabled(false);
                }
                BAlarmConsole.this.notesCommand.setEnabled(true);
                BAlarmConsole.this.detailsCommand.setEnabled(true);
                BAlarmConsole.this.instructions.removeAllItems();
                if (bAlarmRecord.getAlarmData().get("instructions") != null && (object = BAlarmInstructions.make(bAlarmRecord.getAlarmData().get("instructions").toString())) != null) {
                    for (int i = 0; i < ((BAlarmInstructions)((Object)object)).size(); ++i) {
                        BAlarmConsole.this.instructions.addItem((Object)(i + 1 + ". " + ((BAlarmInstructions)((Object)object)).get(i).format((Object)this)));
                    }
                }
            } else {
                BAlarmConsole.this.urlCommand.setEnabled(false);
                BAlarmConsole.this.notesCommand.setEnabled(false);
                BAlarmConsole.this.showVideoCmd.setEnabled(false);
                BAlarmConsole.this.detailsCommand.setEnabled(false);
                BAlarmConsole.this.instructions.removeAllItems();
            }
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            if (bMouseEvent.getClickCount() == 2) {
                if (this.getTable() == BAlarmConsole.this.sourceTable) {
                    BAlarmConsole.this.viewAll();
                } else {
                    BAlarmConsole.this.showDetailsDialog(this.getTable(), n);
                }
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            BTable bTable = this.getTable();
            BMenu bMenu = new BMenu();
            bMenu.add("ack", BAlarmConsole.this.ackCommand);
            bMenu.add("ackAll", BAlarmConsole.this.ackRecentCommand);
            bMenu.add("url", BAlarmConsole.this.urlCommand);
            bMenu.add("notes", BAlarmConsole.this.notesCommand);
            bMenu.add("details", BAlarmConsole.this.detailsCommand);
            if (BAlarmConsole.this.getRecipientForAlarm(null) == null || BAlarmConsole.this.getRecipientForAlarm(null).getPermissions(BAlarmConsole.this.ctx).hasAdminInvoke() || BAlarmConsole.this.getRecipientForAlarm(null).getPermissions(BAlarmConsole.this.ctx).hasAdminWrite()) {
                bMenu.add("forceClear", BAlarmConsole.this.forceClear);
            }
            bMenu.open((BWidget)bTable, bMouseEvent.getX(), bMouseEvent.getY());
        }

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
            if (consoleTableModel instanceof SourceTableModel) {
                int n3 = ((SourceTableModel)consoleTableModel).getRecordCount(n);
                BWidgetShell bWidgetShell = BAlarmConsole.this.getShell();
                if (bWidgetShell != null) {
                    bWidgetShell.showStatus("" + n3 + " Alarm(s)");
                }
            }
        }

        protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
            BWidgetShell bWidgetShell = BAlarmConsole.this.getShell();
            if (bWidgetShell != null) {
                bWidgetShell.showStatus(null);
            }
        }

        public BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.add("acSep", (BValue)new BSeparator());
            bMenu.add("addColumn", BAlarmConsole.this.addColumnCommand);
            bMenu.add("removeColumn", BAlarmConsole.this.removeColumnCommand);
            return bMenu;
        }
    }

    class RadioGroup
    extends ToggleCommandGroup {
        RadioGroup() {
        }

        protected void selected(ToggleCommand toggleCommand) {
            super.selected(toggleCommand);
            if (toggleCommand == BAlarmConsole.this.sourceTimeCommand) {
                BAlarmConsole.this.options.setTimeZoneDisplay(BTimeZoneDisplay.source);
            } else {
                BAlarmConsole.this.options.setTimeZoneDisplay(BTimeZoneDisplay.console);
            }
            BAlarmConsole.this.sourceTable.fireTableModified(null);
        }
    }

    public class LoadThread
    extends Thread {
        public LoadThread() {
            super("AlarmConsole:LoadThread");
        }

        public void run() {
            BAlarmConsole.this.load();
        }
    }
}

