/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BAlarmClassSummary
extends BWbComponentView {
    public static final Action updateCommands = BAlarmClassSummary.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$ui$BAlarmClassSummary == null ? (class$com$tridium$alarm$ui$BAlarmClassSummary = BAlarmClassSummary.class$("com.tridium.alarm.ui.BAlarmClassSummary")) : class$com$tridium$alarm$ui$BAlarmClassSummary));
    private static final String[] ATTRS = new String[]{"displayName", "totalAlarmCount", "openAlarmCount", "inAlarmCount", "unackedAlarmCount", "timeOfLastAlarm", "ackRequired", "priority", "toPathString"};
    private static final int[] DISPLAY = new int[]{0, 1, 2, 3, 4, 5};
    private static Lexicon lex = Lexicon.make((String)"alarm");
    private BTable table = new BTable();
    private BITable itable;
    private CollectionTableModel collectionModel;
    private ToggleCommand enableToOffnormal;
    private ToggleCommand enableToFault;
    private Command editAlarmClass;
    private IntHashMap nameMap;
    static /* synthetic */ Class class$com$tridium$alarm$ui$BAlarmClassSummary;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAlarmClassSummary() {
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.setContent((BWidget)BTitlePane.makePane((String)TYPE.getDisplayName(null), (BTable)this.table, (String)lex.getText("alarm.alarmClasses")));
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"alarmClass.name");
        this.nameMap.put(1, (Object)"alarmClass.totalAlarmCount");
        this.nameMap.put(2, (Object)"alarmClass.openAlarmCount");
        this.nameMap.put(3, (Object)"alarmClass.inAlarmCount");
        this.nameMap.put(4, (Object)"alarmClass.unackedAlarmCount");
        this.nameMap.put(5, (Object)"alarmClass.timeOfLastAlarm");
        this.nameMap.put(6, (Object)"alarmClass.ackRequired");
        this.nameMap.put(7, (Object)"alarmClass.priority");
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.updateTable();
        this.table.fireTableModified(null);
    }

    private void updateTable() {
        BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)this.query()).normalize();
        this.itable = ((BICollection)bOrd2.resolve().get()).toTable();
        boolean bl = false;
        int n = -1;
        boolean bl2 = true;
        if (this.table.getModel() instanceof AlarmClassSummaryTableModel) {
            bl = true;
            n = ((AlarmClassSummaryTableModel)this.table.getModel()).sortCol;
            bl2 = ((AlarmClassSummaryTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel columnNameTableModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        AlarmClassSummaryTableModel alarmClassSummaryTableModel = new AlarmClassSummaryTableModel((TableModel)columnNameTableModel, DISPLAY);
        alarmClassSummaryTableModel.setColumnShowable(1, false);
        alarmClassSummaryTableModel.setColumnShowable(6, false);
        if (bl && n != -1) {
            alarmClassSummaryTableModel.sortByColumn(n, bl2);
        }
        this.table.setModel((TableModel)alarmClassSummaryTableModel);
        this.table.relayout();
    }

    private String query() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ATTRS[i]);
        }
        stringBuffer.append(" from alarm:AlarmClass");
        return stringBuffer.toString();
    }

    public void doUpdateCommands() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        private CellRenderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            if (cell.row == this.getTable().getModel().getRowCount() - 2) {
                return Theme.table().getGridBrush();
            }
            return null;
        }
    }

    public class AlarmClassSummaryTableModel
    extends DynamicTableModel {
        public int sortCol = -1;
        public boolean sortAsc = true;

        public AlarmClassSummaryTableModel(TableModel tableModel, int[] nArray) {
            super(tableModel, nArray);
        }

        public AlarmClassSummaryTableModel(TableModel tableModel) {
            super(tableModel);
        }

        public void sortByColumn(int n, boolean bl) {
            this.sortCol = n;
            this.sortAsc = bl;
            super.sortByColumn(n, bl);
        }

        public Object getValueAt(int n, int n2) {
            if (n < super.getRowCount()) {
                return super.getValueAt(n, n2);
            }
            if (n == super.getRowCount()) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return lex.getText("alarmClass.total");
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int n3 = 0;
                    for (int i = 0; i < super.getRowCount(); ++i) {
                        n3 += Integer.parseInt((String)this.getValueAt(i, n2));
                    }
                    return "" + n3;
                }
            }
            return "";
        }

        public int getRowCount() {
            return super.getRowCount() + 2;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int n, BITable bITable) {
            super("alarmClass.goto.alarmClass", n, bITable);
        }

        public BOrd getTargetOrd() {
            return BOrd.make((String)("slot:" + BAlarmClassSummary.this.itable.getString(this.row, BAlarmClassSummary.this.itable.getColumns().get("toPathString"))));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable itable;

        public Goto(String string, int n, BITable bITable) {
            super((BWidget)BAlarmClassSummary.this, Sys.getModuleForClass((Class)(class$com$tridium$alarm$ui$BAlarmClassSummary == null ? (class$com$tridium$alarm$ui$BAlarmClassSummary = BAlarmClassSummary.class$("com.tridium.alarm.ui.BAlarmClassSummary")) : class$com$tridium$alarm$ui$BAlarmClassSummary)), string);
            this.row = n;
            this.itable = bITable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd bOrd = this.getTargetOrd();
            if (bOrd == null) {
                return null;
            }
            BOrd bOrd2 = ((BWbShell)BAlarmClassSummary.this.getShell()).getActiveOrd();
            BOrd bOrd3 = BOrd.make((BOrd)bOrd2, (BOrd)bOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(bOrd3);
            return null;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            if (n >= this.getTable().getModel().getRowCount() - 2) {
                return;
            }
            ColumnList columnList = BAlarmClassSummary.this.itable.getColumns();
            BOrd bOrd = null;
            String string = BAlarmClassSummary.this.itable.getString(n, columnList.get("toPathString"));
            BOrd bOrd2 = ((BWbShell)this.getShell()).getActiveOrd();
            bOrd = BOrd.make((BOrd)bOrd2, (String)("slot:" + string)).normalize();
            if (bOrd != null) {
                ((BWbShell)this.getShell()).hyperlink(bOrd);
            }
        }

        protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            if (n >= this.getTable().getModel().getRowCount() - 2) {
                return;
            }
            ColumnList columnList = BAlarmClassSummary.this.itable.getColumns();
            String string = BAlarmClassSummary.this.itable.getString(n, columnList.get("toPathString"));
            BOrd bOrd = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("slot:" + string)).normalize();
            BComponent bComponent = (BComponent)bOrd2.get();
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new GotoPoint(n, BAlarmClassSummary.this.itable));
            bMenu.open((BWidget)this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }
    }
}

