/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.print;

import java.io.ByteArrayInputStream;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class BLinePrinterRecipient
extends BAlarmRecipient
implements BIAlarmSource {
    public static final Property printer = BLinePrinterRecipient.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:LinePrinterFE")));
    public static final Property language = BLinePrinterRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)6)));
    public static final Property printFormat = BLinePrinterRecipient.newProperty((int)0, (BValue)BLinePrinterRecipient.makeDefaultPrintFormat(), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property alertOnFailure = BLinePrinterRecipient.newProperty((int)0, (boolean)false, null);
    public static final Property alarmSourceInfo = BLinePrinterRecipient.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    public static final Action ackAlarm = BLinePrinterRecipient.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action loadPrinters = BLinePrinterRecipient.newAction((int)0, null);
    public static final Topic printersLoaded = BLinePrinterRecipient.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarm$print$BLinePrinterRecipient == null ? (class$com$tridium$alarm$print$BLinePrinterRecipient = BLinePrinterRecipient.class$("com.tridium.alarm.print.BLinePrinterRecipient")) : class$com$tridium$alarm$print$BLinePrinterRecipient));
    private AlarmSupport support;
    private Queue printQueue = new Queue();
    private Worker printThread = new Worker((Worker.ITodo)this.printQueue);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"print.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final Log log = Log.getLog((String)"alarm.printer");
    static /* synthetic */ Class class$com$tridium$alarm$print$BLinePrinterRecipient;

    public BDynamicEnum getPrinter() {
        return (BDynamicEnum)this.get(printer);
    }

    public void setPrinter(BDynamicEnum bDynamicEnum) {
        this.set(printer, (BValue)bDynamicEnum, null);
    }

    public String getLanguage() {
        return this.getString(language);
    }

    public void setLanguage(String string) {
        this.setString(language, string, null);
    }

    public BFormat getPrintFormat() {
        return (BFormat)this.get(printFormat);
    }

    public void setPrintFormat(BFormat bFormat) {
        this.set(printFormat, (BValue)bFormat, null);
    }

    public boolean getAlertOnFailure() {
        return this.getBoolean(alertOnFailure);
    }

    public void setAlertOnFailure(boolean bl) {
        this.setBoolean(alertOnFailure, bl, null);
    }

    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    public void setAlarmSourceInfo(BAlarmSourceInfo bAlarmSourceInfo) {
        this.set(alarmSourceInfo, (BValue)bAlarmSourceInfo, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public void loadPrinters() {
        this.invoke(loadPrinters, null, null);
    }

    public void firePrintersLoaded(BValue bValue) {
        this.fire(printersLoaded, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.printThread.start("alarm:printing");
    }

    public void stopped() throws Exception {
        this.printThread.stop();
    }

    public static BFormat makeDefaultPrintFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Source:      %alarmData.sourceName%\n");
        stringBuffer.append("Timestamp:   %timestamp%\n");
        stringBuffer.append("State:       %sourceState% / %ackState%\n");
        stringBuffer.append("Priority:    %priority%\n");
        stringBuffer.append("Alarm Class: %alarmClass%\n");
        stringBuffer.append("Text:        %alarmData.msgText%\n");
        stringBuffer.append("\n");
        return BFormat.make((String)stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadPrinters() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
        String[] stringArray = new String[printServiceArray.length];
        for (int i = 0; i < printServiceArray.length; ++i) {
            stringArray[i] = SlotPath.escape((String)printServiceArray[i].getName());
        }
        BEnumRange bEnumRange = BEnumRange.make((String[])stringArray);
        try {
            BDynamicEnum bDynamicEnum;
            BDynamicEnum bDynamicEnum2 = this.getPrinter();
            if (bDynamicEnum2.equals((Object)BDynamicEnum.DEFAULT)) {
                bDynamicEnum = BDynamicEnum.make((int)0, (BEnumRange)bEnumRange);
            } else {
                BEnum bEnum = bEnumRange.get(bDynamicEnum2.getTag());
                bDynamicEnum = BDynamicEnum.make((int)bEnum.getOrdinal(), (BEnumRange)bEnumRange);
            }
            this.setPrinter(bDynamicEnum);
        }
        catch (InvalidEnumException invalidEnumException) {
        }
        finally {
            this.firePrintersLoaded(null);
        }
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord.getSource().equals((Object)BOrdList.make((BOrd)this.getNavOrd()))) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Enqueue");
        }
        String string = BFormat.make((String)this.getPrintFormat().format((Object)bAlarmRecord)).format((Object)bAlarmRecord);
        this.printQueue.enqueue((Object)new PrintJob(string));
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        try {
            return BBoolean.make((boolean)this.support.ackAlarm(bAlarmRecord));
        }
        catch (Exception exception) {
            return BBoolean.FALSE;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PrintJob
    implements Runnable {
        String text;

        public PrintJob(String string) {
            this.text = string;
        }

        public void run() {
            if (log.isTraceOn()) {
                log.trace("Dequeueing print job for " + SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()));
            }
            try {
                HashAttributeSet hashAttributeSet = new HashAttributeSet();
                hashAttributeSet.add(new PrinterName(SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()), null));
                PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, hashAttributeSet);
                if (printServiceArray.length < 1) {
                    throw new BajaRuntimeException("Printer '" + SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()) + "' not found.");
                }
                DocPrintJob docPrintJob = printServiceArray[0].createPrintJob();
                String[] stringArray = TextUtil.replace((String)this.text, (String)"\n", (String)"\n\r").split("\n\r");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    if (stringArray[i].length() < 80) {
                        stringBuffer.append(stringArray[i]);
                        stringBuffer.append("\n\r");
                        continue;
                    }
                    for (int j = 0; j < stringArray[i].length(); j += n) {
                        n = Math.min(80, stringArray[i].length() - j);
                        int n2 = n;
                        if (j + n2 < stringArray[i].length()) {
                            while (stringArray[i].charAt(j + n2 - 1) != ' ' && n2 > 1) {
                                --n2;
                            }
                            if (n2 > 1) {
                                n = n2;
                            }
                        }
                        stringBuffer.append(stringArray[i].substring(j, j + n));
                        stringBuffer.append("\n\r");
                    }
                }
                docPrintJob.print(new SimpleDoc(new ByteArrayInputStream(stringBuffer.toString().getBytes()), DocFlavor.INPUT_STREAM.AUTOSENSE, null), null);
            }
            catch (Exception exception) {
                BFacets bFacets = BLinePrinterRecipient.this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
                bFacets = BFacets.make((BFacets)bFacets, (String)"msgText", (BIDataValue)BString.make((String)(SlotPath.unescape((String)BLinePrinterRecipient.this.getPrinter().getTag()) + " print error.")));
                try {
                    if (BLinePrinterRecipient.this.getAlertOnFailure()) {
                        BLinePrinterRecipient.this.support.newAlert(bFacets);
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                log.error("Print error", (Throwable)exception);
            }
        }
    }
}

