/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.hx;

import com.tridium.alarm.BConsoleRecipient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHxAlarmConsole
extends BHxView {
    public static final BHxAlarmConsole INSTANCE = new BHxAlarmConsole();
    public static final Type TYPE;
    public static final Lexicon lexicon;
    public static final BFacets HX_TIMESTAMP_FACETS;
    private static BImage yellowAlarmImg;
    private static BImage redAlarmImg;
    private static BImage greenAlarmImg;
    private static BImage orangeAlarmImg;
    private static BImage sortAsc;
    private static BImage sortDesc;
    private static BImage arrow;
    private static BImage linkImg;
    private static BImage blankImg;
    static boolean disablePngFixing;
    BAlarmService alarmService;
    public String sheetClass;
    public String headClass;
    public String rowClass;
    public AlarmCommand acknowledge;
    public AlarmCommand forceClear;
    public AlarmCommand showRecurring;
    public AlarmCommand showAll;
    public AlarmCommand showDetails;
    public AlarmCommand addNotes;
    public Command sort;
    static /* synthetic */ Class class$com$tridium$alarm$hx$BHxAlarmConsole;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;
    static /* synthetic */ Class class$com$tridium$alarm$hx$BHxAlarmConsole$AlarmCommand;

    public Type getType() {
        return TYPE;
    }

    public void write(HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        hxOp.setDynamic();
        hxOp.addJavaScript("module://alarm/com/tridium/alarm/hx/alarm.js");
        hxOp.addStyleSheet("module://alarm/com/tridium/alarm/hx/alarm.css");
        htmlWriter.w((Object)"<table height='100%' width='100%' cellspacing='0' cellpadding='0'>");
        htmlWriter.w((Object)"<tr><td>");
        htmlWriter.w((Object)("<div id=\"" + hxOp.scope("tableTitle") + "\"class=\"controlShadow-bg tableViewHeader hx-AlarmConsole-header\">"));
        this.writeTableTitle(false, hxOp);
        htmlWriter.w((Object)"</div>");
        htmlWriter.w((Object)"</td></tr>");
        htmlWriter.w((Object)"<tr><td valign='top' height='100%' style='background-color: #EEEEEE;'>");
        htmlWriter.w((Object)("<div id=\"" + hxOp.scope("tableRecords") + '\"'));
        htmlWriter.w((Object)" style=\"overflow:auto; width:100%;\"");
        htmlWriter.w((Object)">");
        htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
        this.writeTableHeader(hxOp, false);
        htmlWriter.w((Object)"<tr><td colspan=\"9\">Loading...</td></tr>");
        htmlWriter.w((Object)"</table></div>");
        htmlWriter.w((Object)"</td></tr>");
        htmlWriter.w((Object)"<tr><td>");
        htmlWriter.w((Object)("<div class=\"control-bg hx-AlarmConsole-controlBg\" style=\"border-top:1px solid black; padding:10px; text-align:center;\" id=\"" + hxOp.scope("commands") + "\">"));
        htmlWriter.w((Object)"</div>");
        htmlWriter.w((Object)"</td></tr>");
        htmlWriter.w((Object)"</table>");
        hxOp.addOnload(this.sort.getInvokeCode(hxOp));
    }

    public void update(HxOp hxOp) throws Exception {
        super.update(hxOp);
    }

    public void showAll(HxOp hxOp) throws Exception {
        Object object;
        Object object2;
        BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)hxOp.get();
        String string = bConsoleRecipient.getInitialAlarmQuery(hxOp.getUser());
        BOrd bOrd = BOrd.make((String)string.toString());
        BICollection bICollection = (BICollection)bOrd.resolve((BObject)bConsoleRecipient).get();
        Cursor cursor = bICollection.cursor();
        Hashtable<BOrdList, Object> hashtable = new Hashtable<BOrdList, Object>();
        while (cursor.next()) {
            object2 = (BAlarmRecord)cursor.get();
            object = null;
            object = hashtable.containsKey(((BAlarmRecord)((Object)object2)).getSource()) ? (SourceAlarm)hashtable.get(((BAlarmRecord)((Object)object2)).getSource()) : new SourceAlarm();
            ((SourceAlarm)object).update((BAlarmRecord)object2.newCopy());
            hashtable.put(((BAlarmRecord)((Object)object2)).getSource(), object);
        }
        object2 = hashtable.values();
        object = object2.toArray(new SourceAlarm[object2.size()]);
        Array array = new Array((Object[])object);
        String string2 = "timestamp";
        boolean bl = false;
        if (hxOp.getPostBody() != null) {
            if (hxOp.getFormValue("sortBy") != null) {
                string2 = hxOp.getFormValue("sortBy");
            }
            try {
                bl = new Boolean(hxOp.getFormValue("sortAscending"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        array = bl ? this.sortSourceAlarms(array, string2, SortUtil.ASCENDING) : this.sortSourceAlarms(array, string2, SortUtil.DESCENDING);
        this.writeTableHeader(hxOp, true);
        int n = 0;
        while (n < array.size()) {
            SourceAlarm sourceAlarm = (SourceAlarm)array.get(n);
            BAlarmRecord bAlarmRecord = sourceAlarm.alarm;
            this.writeAlarmRow(hxOp, bAlarmRecord, sourceAlarm);
            ++n;
        }
    }

    public void writeCommands(AlarmCommand[] alarmCommandArray, HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        int n = 0;
        while (n < alarmCommandArray.length) {
            htmlWriter.w((Object)"<span class=\"command\"").w((Object)" onclick=\"").w((Object)alarmCommandArray[n].getInvokeCode(hxOp)).w((Object)"\">");
            if (alarmCommandArray[n].getIcon(hxOp) != null) {
                this.makeImage(alarmCommandArray[n].getIcon(hxOp), hxOp);
                htmlWriter.w((Object)"&nbsp;");
            }
            htmlWriter.w((Object)alarmCommandArray[n].getDisplayName(hxOp));
            htmlWriter.w((Object)"</span>&nbsp;");
            ++n;
        }
    }

    public void ackAlarmByUuid(String string, String string2, HxOp hxOp) throws Exception {
        if (string == null) {
            return;
        }
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            array.add((Object)bAlarmRecord.newCopy());
        }
        int n = 0;
        while (n < array.size()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
            this.ackAlarm(bAlarmRecord, string2, hxOp);
            ++n;
        }
    }

    public void addAlarmNoteByUuid(String string, String string2, HxOp hxOp) throws AlarmException, IOException {
        if (string == null) {
            return;
        }
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            array.add((Object)bAlarmRecord.newCopy());
        }
        int n = 0;
        while (n < array.size()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
            this.addNotes(bAlarmRecord, string2, hxOp);
            this.getAlarmService().getAlarmDb().update(bAlarmRecord);
            ++n;
        }
    }

    public void ackAlarmBySource(String string, String string2, HxOp hxOp) throws Exception {
        if (string == null) {
            return;
        }
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            array.add((Object)bAlarmRecord.newCopy());
        }
        int n = 0;
        while (n < array.size()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
            this.ackAlarm(bAlarmRecord, string2, hxOp);
            ++n;
        }
    }

    public void addAlarmNoteBySource(String string, String string2, HxOp hxOp) throws AlarmException, IOException {
        if (string == null) {
            return;
        }
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            array.add((Object)bAlarmRecord.newCopy());
        }
        int n = 0;
        while (n < array.size()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
            this.addNotes(bAlarmRecord, string2, hxOp);
            this.getAlarmService().getAlarmDb().update(bAlarmRecord);
            ++n;
        }
    }

    public void ackAlarm(BAlarmRecord bAlarmRecord, String string, HxOp hxOp) throws Exception {
        BAlarmClass bAlarmClass = this.getAlarmService().lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass == null) {
            bAlarmClass = this.getAlarmService().getDefaultAlarmClass();
        }
        hxOp.getUser().check((BIProtected)bAlarmClass, BPermissions.operatorWrite);
        bAlarmRecord.setUser(hxOp.getUser().getUsername());
        bAlarmRecord.setAckTime(BAbsTime.now());
        bAlarmRecord.setAckState(BAckState.ackPending);
        this.addNotes(bAlarmRecord, string, hxOp);
        BAlarmRecord bAlarmRecord2 = this.getAlarmService().getAlarmDb().getRecord(bAlarmRecord.getUuid());
        if (bAlarmRecord2 == null || bAlarmRecord2.getAckState() != BAckState.ackPending) {
            this.getAlarmService().getAlarmDb().update(bAlarmRecord);
        }
        this.getAlarmService().ackAlarm(bAlarmRecord);
    }

    protected void addNotes(BAlarmRecord bAlarmRecord, String string, HxOp hxOp) {
        if (string == null) {
            return;
        }
        BFacets bFacets = bAlarmRecord.getAlarmData();
        String string2 = "";
        if (bFacets.get("notes") != null) {
            string2 = bFacets.get("notes").toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("## " + BAbsTime.now() + " - " + hxOp.getUser().getUsername() + " ##\n");
        stringBuffer.append(string);
        stringBuffer.append("\n\n");
        stringBuffer.append(string2);
        BFacets bFacets2 = BFacets.make((BFacets)bFacets, (BFacets)BFacets.make((String)"notes", (BIDataValue)BString.make((String)stringBuffer.toString())));
        bAlarmRecord.setAlarmData(bFacets2);
    }

    public void forceClearBySource(String string, HxOp hxOp) throws Exception {
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            array.add((Object)bAlarmRecord.newCopy());
        }
        try {
            int n = 0;
            while (n < array.size()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
                BAlarmClass bAlarmClass = this.getAlarmService().lookupAlarmClass(bAlarmRecord.getAlarmClass());
                if (bAlarmClass == null) {
                    bAlarmClass = this.getAlarmService().getDefaultAlarmClass();
                }
                hxOp.getUser().check((BIProtected)bAlarmClass, BPermissions.adminWrite);
                bAlarmRecord.setUser(hxOp.getUser().getUsername());
                bAlarmRecord.setAckTime(BAbsTime.now());
                bAlarmRecord.setAckState(BAckState.acked);
                bAlarmRecord.setSourceState(BSourceState.normal);
                bAlarmRecord.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)hxOp.getUser().getUsername()));
                this.getAlarmService().getAlarmDb().update(bAlarmRecord);
                this.getAlarmService().auditForceClear(bAlarmRecord);
                ++n;
            }
        }
        catch (PermissionException permissionException) {
            System.out.println("Invalid Permissions");
        }
        catch (Exception exception) {
            System.out.println("Cannot find: " + string);
        }
    }

    public void forceClearByUuid(String string, HxOp hxOp) throws Exception {
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            array.add((Object)bAlarmRecord.newCopy());
        }
        try {
            int n = 0;
            while (n < array.size()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
                BAlarmClass bAlarmClass = this.getAlarmService().lookupAlarmClass(bAlarmRecord.getAlarmClass());
                if (bAlarmClass == null) {
                    bAlarmClass = this.getAlarmService().getDefaultAlarmClass();
                }
                hxOp.getUser().check((BIProtected)bAlarmClass, BPermissions.adminWrite);
                bAlarmRecord.setUser(hxOp.getUser().getUsername());
                bAlarmRecord.setAckTime(BAbsTime.now());
                bAlarmRecord.setAckState(BAckState.acked);
                bAlarmRecord.setSourceState(BSourceState.normal);
                bAlarmRecord.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)hxOp.getUser().getUsername()));
                this.getAlarmService().getAlarmDb().update(bAlarmRecord);
                this.getAlarmService().auditForceClear(bAlarmRecord);
                ++n;
            }
        }
        catch (PermissionException permissionException) {
            System.out.println("Invalid Permissions");
        }
        catch (Exception exception) {
            System.out.println("Cannot find: " + string);
        }
    }

    protected void writeTableTitle(boolean bl, HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        htmlWriter.w((Object)("<span class=\"hx-AlarmConsole-title\"><b>" + lexicon.getText("HxAlarmConsole.displayName") + "</b></span>"));
        if (bl) {
            htmlWriter.w((Object)"<span class=\"hx-AlarmConsole-title\">&nbsp;");
            this.makeImage(arrow, hxOp);
            htmlWriter.w((Object)("&nbsp;<b>" + lexicon.getText("hx.recurringAlarms") + "</b></span>"));
        }
    }

    public void showRecurringAlarms(String string, HxOp hxOp) throws Exception {
        Object object;
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)hxOp.get();
        String string2 = bConsoleRecipient.getInitialAlarmQuery(hxOp.getUser());
        string2 = string2 + " and source='" + string + '\'';
        BOrd bOrd = BOrd.make((String)string2);
        BICollection bICollection = (BICollection)bOrd.resolve((BObject)bConsoleRecipient).get();
        Cursor cursor = bICollection.cursor();
        Class clazz = class$javax$baja$alarm$BAlarmRecord;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        Array array = new Array(clazz);
        while (cursor.next()) {
            object = (BAlarmRecord)cursor.get();
            array.add((Object)object.newCopy());
        }
        object = "timestamp";
        boolean bl = false;
        if (hxOp.getPostBody() != null) {
            if (hxOp.getFormValue("sortBy") != null) {
                object = hxOp.getFormValue("sortBy");
            }
            try {
                bl = new Boolean(hxOp.getFormValue("sortAscending"));
            }
            catch (Exception exception) {}
        }
        array = bl ? this.sortAlarms(array, (String)object, SortUtil.ASCENDING) : this.sortAlarms(array, "timestamp", SortUtil.DESCENDING);
        htmlWriter.w((Object)("<input type=\"hidden\" name=\"" + hxOp.scope("recurringAlarms") + "\" value=\"true\" />"));
        htmlWriter.w((Object)("<input type=\"hidden\" name=\"" + hxOp.scope("source") + "\" value=\"" + string + "\" />"));
        this.writeTableHeader(hxOp, true);
        int n = 0;
        while (n < array.size()) {
            BString bString;
            BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
            BString bString2 = (BString)bAlarmRecord.getAlarmData().get("sourceName");
            if (bString2 == null) {
                bString2 = BString.make((String)bAlarmRecord.getSource().toString());
            }
            if ((bString = (BString)bAlarmRecord.getAlarmData().get("msgText")) == null) {
                bString = BString.make((String)"");
            }
            this.writeAlarmRow(hxOp, bAlarmRecord, null);
            ++n;
        }
    }

    protected void writeTableHeader(HxOp hxOp, boolean bl) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        htmlWriter.w((Object)"<tr class=\"hx-AlarmConsole-header\">");
        htmlWriter.w((Object)"<th class=\"hx-AlarmConsole-header\">");
        htmlWriter.w((Object)"<input type=\"checkbox\" onclick=\"ac.selectAll(event);\"/>");
        htmlWriter.w((Object)"</th>");
        htmlWriter.w((Object)"<th class=\"hx-AlarmConsole-header\">&nbsp;</th>");
        this.writeColumnHeader(hxOp, BAlarmRecord.timestamp, bl);
        this.writeColumnHeader(hxOp, BAlarmRecord.source, bl);
        this.writeColumnHeader(hxOp, BAlarmRecord.sourceState, bl);
        this.writeColumnHeader(hxOp, BAlarmRecord.ackState, bl);
        this.writeColumnHeader(hxOp, BAlarmRecord.priority, bl);
        this.writeColumnHeader(hxOp, BAlarmRecord.alarmClass, bl);
        htmlWriter.w((Object)"<th class=\"hx-AlarmConsole-header\">Message</th>");
        htmlWriter.w((Object)"</tr>");
    }

    protected void writeColumnHeader(HxOp hxOp, Property property, boolean bl) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        String string = "timestamp";
        boolean bl2 = false;
        if (hxOp.getPostBody() != null) {
            if (hxOp.getFormValue("sortBy") != null) {
                string = hxOp.getFormValue("sortBy");
            }
            try {
                bl2 = new Boolean(hxOp.getFormValue("sortAscending"));
            }
            catch (Exception exception) {}
        }
        htmlWriter.w((Object)"<th class=\"hx-AlarmConsole-header\">");
        boolean bl3 = false;
        if (property.getName().equals(string)) {
            bl3 = bl2 ^ true;
        }
        htmlWriter.w((Object)"<span class=\"hx-AlarmConsole-link\" style=\"cursor: pointer; cursor: hand;\" ");
        if (bl) {
            htmlWriter.w((Object)("onclick=\"hx.setFormValue(&quot;" + hxOp.scope("sortBy") + "&quot;,&quot;" + property.getName() + "&quot;);hx.setFormValue(&quot;" + hxOp.scope("sortAscending") + "&quot;,&quot;" + bl3 + "&quot;);hx.fireEvent(&quot;" + hxOp.getPath() + "&quot;,&quot;" + this.sort.getId() + "&quot;);\""));
        }
        htmlWriter.w((Object)">");
        htmlWriter.w((Object)property.getDefaultDisplayName((Context)hxOp));
        if (property.getName().equals(string)) {
            if (bl2) {
                this.makeImage(sortAsc, hxOp);
            } else {
                this.makeImage(sortDesc, hxOp);
            }
        }
        htmlWriter.w((Object)"</span>");
        htmlWriter.w((Object)"</th>");
    }

    protected void writeAlarmRow(HxOp hxOp, BAlarmRecord bAlarmRecord, SourceAlarm sourceAlarm) throws Exception {
        BImage bImage;
        BString bString;
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        BString bString2 = (BString)bAlarmRecord.getAlarmData().get("sourceName");
        if (bString2 == null) {
            bString2 = BString.make((String)bAlarmRecord.getSource().toString());
        }
        if ((bString = (BString)bAlarmRecord.getAlarmData().get("msgText")) == null) {
            bString = BString.make((String)"");
        }
        BFormat bFormat = BFormat.make((String)bString.toString());
        String string = bFormat.format((Object)bAlarmRecord);
        BImage bImage2 = greenAlarmImg;
        if (bAlarmRecord.getSourceState() == BSourceState.alert) {
            bImage2 = orangeAlarmImg;
        } else if (bAlarmRecord.isAcknowledged() && !bAlarmRecord.isNormal()) {
            bImage2 = yellowAlarmImg;
        } else if (!bAlarmRecord.isAcknowledged() && !bAlarmRecord.isNormal()) {
            bImage2 = redAlarmImg;
        }
        htmlWriter.w((Object)"<tr>");
        String string2 = "hx-AlarmConsole-row";
        htmlWriter.w((Object)("<td class=\"" + string2 + "\" align=\"center\" valign=\"middle\" style=\"padding:0;\">"));
        htmlWriter.w((Object)"<input type=checkbox ");
        htmlWriter.w((Object)("id=\"" + hxOp.scope(bAlarmRecord.getUuid().toString()) + "\" "));
        htmlWriter.w((Object)("name=\"" + hxOp.scope("_" + bAlarmRecord.getUuid().toString()) + "\" "));
        htmlWriter.w((Object)("value=\"" + SlotPath.escape((String)bAlarmRecord.getSource().encodeToString()) + "\">"));
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)("<td class=\"" + string2 + "\" align=\"right\">"));
        if (bAlarmRecord.getAlarmData().get("icon") != null) {
            bImage = BImage.make((BOrd)BOrd.make((BOrd)((BComponent)hxOp.get()).getNavOrd(), (String)bAlarmRecord.getAlarmData().get("icon").toString()));
            this.makeImage(bImage, hxOp);
        }
        if (bAlarmRecord.getAlarmData().get("hyperlinkOrd") != null) {
            this.makeAlarmHyperlink(bAlarmRecord.getAlarmData().get("hyperlinkOrd").toString(), hxOp);
        } else {
            this.makeImage(blankImg, hxOp);
        }
        bImage = this.getVideoImage(bAlarmRecord);
        if (bImage != null) {
            this.makeImage(bImage, hxOp);
        }
        this.makeImage(bImage2, hxOp);
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
        BasicContext basicContext = new BasicContext((Context)hxOp, HX_TIMESTAMP_FACETS);
        BHxAlarmConsole.safe(htmlWriter, bAlarmRecord.getTimestamp().toString((Context)basicContext));
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
        BHxAlarmConsole.safe(htmlWriter, bString2.toString());
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
        BHxAlarmConsole.safe(htmlWriter, bAlarmRecord.getSourceState().toString((Context)hxOp));
        htmlWriter.w((Object)"</td>");
        if (sourceAlarm != null) {
            if (sourceAlarm.pendingCount == 0) {
                htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
                BHxAlarmConsole.safe(htmlWriter, sourceAlarm.ackedCount + " Acked / " + sourceAlarm.unackedCount + " Unacked");
                htmlWriter.w((Object)"</td>");
            } else {
                htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
                BHxAlarmConsole.safe(htmlWriter, sourceAlarm.ackedCount + " Acked / " + sourceAlarm.unackedCount + " Unacked / " + sourceAlarm.pendingCount + " Ack Pending");
                htmlWriter.w((Object)"</td>");
            }
        } else {
            htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
            BHxAlarmConsole.safe(htmlWriter, bAlarmRecord.getAckState().toString((Context)hxOp));
            htmlWriter.w((Object)"</td>");
        }
        htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
        BHxAlarmConsole.safe(htmlWriter, "" + bAlarmRecord.getPriority());
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
        BHxAlarmConsole.safe(htmlWriter, SlotPath.unescape((String)this.getAlarmService().getAlarmClassDisplayName(BString.make((String)bAlarmRecord.getAlarmClass()), (Context)hxOp).toString()));
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)("<td class=\"" + string2 + "\">"));
        BHxAlarmConsole.safe(htmlWriter, string);
        htmlWriter.w((Object)"</td>");
        htmlWriter.w((Object)"</tr>");
    }

    public static void safe(HtmlWriter htmlWriter, Object object) {
        if (object == null) {
            htmlWriter.w((Object)"&nbsp;");
        } else {
            String string = object.toString();
            if (string == null) {
                htmlWriter.w((Object)"&nbsp;");
            }
            if (string.equals("") || string.equals(" ") || string.equals("&nbsp;")) {
                htmlWriter.w((Object)"&nbsp;");
                return;
            }
            htmlWriter.safe(string);
        }
    }

    public BImage getVideoImage(BAlarmRecord bAlarmRecord) {
        return null;
    }

    protected void makeAlarmHyperlink(String string, HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        htmlWriter.w((Object)("<a href=\"" + string + "\">"));
        this.makeImage(linkImg, "class=\"hx-AlarmConsole-sortImg\"", hxOp);
        htmlWriter.w((Object)"</a>");
    }

    public void makeImage(BImage bImage, HxOp hxOp) throws Exception {
        this.makeImage(bImage, null, hxOp);
    }

    public void makeImage(BImage bImage, String string, HxOp hxOp) throws Exception {
        String string2;
        boolean bl;
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        String string3 = bImage.getOrdList().get(0).toString();
        boolean bl2 = false;
        if (!hxOp.isUpdate() && hxOp.getUserAgent().isIE() && string3.endsWith(".png") && hxOp.getRequest().getMethod().toLowerCase().equals("get")) {
            bl2 = bl = true;
        }
        if (disablePngFixing) {
            bl = false;
        }
        if (bl) {
            try {
                bImage.sync();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (bl) {
            string2 = Integer.toString((int)bImage.getWidth());
            String string4 = Integer.toString((int)bImage.getHeight());
            htmlWriter.w((Object)"<span style=\"width:").w((Object)string2).w((Object)"px; height:").w((Object)string4).w((Object)"px; ");
            htmlWriter.w((Object)"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\"");
            htmlWriter.w((Object)string3);
            htmlWriter.w((Object)"\");\">");
        }
        htmlWriter.w((Object)("<img src=\"" + string3 + '\"'));
        if (bl) {
            string2 = "filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);";
            if (string != null && string.indexOf("style=") != -1) {
                int n = string.indexOf("style=");
                int n2 = n + "style=".length() + 1;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n2));
                stringBuffer.append(string2).append(" ");
                stringBuffer.append(string.substring(n2));
                string = stringBuffer.toString();
            } else {
                htmlWriter.w((Object)(" style=\"" + string2 + '\"'));
            }
        }
        if (string != null && string.length() > 0) {
            htmlWriter.w((Object)" ").w((Object)string);
        }
        htmlWriter.w((Object)"/>");
        if (bl) {
            htmlWriter.w((Object)"</span>");
        }
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public AlarmCommand[] getCommands(boolean bl, HxOp hxOp) {
        Class clazz = class$com$tridium$alarm$hx$BHxAlarmConsole$AlarmCommand;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$hx$BHxAlarmConsole$AlarmCommand = BHxAlarmConsole.class("[Lcom.tridium.alarm.hx.BHxAlarmConsole$AlarmCommand;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)this.acknowledge);
        if (!bl) {
            array.add((Object)this.showRecurring);
        } else {
            array.add((Object)this.showAll);
        }
        BPermissions bPermissions = hxOp.getPermissionsForTarget();
        if (bPermissions.hasOperatorWrite()) {
            array.add((Object)this.addNotes);
        }
        array.add((Object)this.showDetails);
        if (bPermissions.hasAdminWrite() || bPermissions.hasAdminInvoke()) {
            array.add((Object)this.forceClear);
        }
        return (AlarmCommand[])array.trim();
    }

    public Array sortSourceAlarms(Array array, String string, Comparator comparator) {
        int n = array.size();
        int n2 = n / 2;
        while (n2 >= 1) {
            int n3 = n2;
            while (n3 < n) {
                SourceAlarm sourceAlarm = (SourceAlarm)array.get(n3);
                Object object = sourceAlarm.get(string);
                int n4 = n3;
                while (n4 >= n2 && comparator.compare(object, ((SourceAlarm)array.get(n4 - n2)).get(string)) <= 0) {
                    if (comparator.compare(object, ((SourceAlarm)array.get(n4 - n2)).get(string)) == 0) {
                        BAbsTime bAbsTime = (BAbsTime)sourceAlarm.get(BAlarmRecord.timestamp.getName());
                        BAbsTime bAbsTime2 = (BAbsTime)((SourceAlarm)array.get(n4 - n2)).get(BAlarmRecord.timestamp.getName());
                        if (!bAbsTime2.isBefore(bAbsTime)) break;
                        array.set(n4, array.get(n4 - n2));
                    } else {
                        array.set(n4, array.get(n4 - n2));
                    }
                    n4 -= n2;
                }
                array.set(n4, (Object)sourceAlarm);
                ++n3;
            }
            n2 /= 2;
        }
        return array;
    }

    public Array sortAlarms(Array array, String string, Comparator comparator) {
        int n = array.size();
        int n2 = n / 2;
        while (n2 >= 1) {
            int n3 = n2;
            while (n3 < n) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n3));
                BValue bValue = bAlarmRecord.get(string);
                int n4 = n3;
                while (n4 >= n2 && comparator.compare(bValue, ((BAlarmRecord)((Object)array.get(n4 - n2))).get(string)) <= 0) {
                    if (comparator.compare(bValue, ((BAlarmRecord)((Object)array.get(n4 - n2))).get(string)) == 0) {
                        BAbsTime bAbsTime = bAlarmRecord.getTimestamp();
                        BAbsTime bAbsTime2 = ((BAlarmRecord)((Object)array.get(n4 - n2))).getTimestamp();
                        if (!bAbsTime2.isBefore(bAbsTime)) break;
                        array.set(n4, array.get(n4 - n2));
                    } else {
                        array.set(n4, array.get(n4 - n2));
                    }
                    n4 -= n2;
                }
                array.set(n4, (Object)bAlarmRecord);
                ++n3;
            }
            n2 /= 2;
        }
        return array;
    }

    public String[] getSelection(HxOp hxOp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = hxOp.getFormKeys();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("_")) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string;
            stringArray2[n2] = string = ((String)arrayList.get(n2)).substring(1);
            ++n2;
        }
        return stringArray2;
    }

    private final String sessionScope(String string, HxOp hxOp) {
        String string2 = hxOp.getOrd().relativizeToSession().toString();
        int n = string2.indexOf("|view:");
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        return string2 + '|' + hxOp.getPath() + '|' + string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sheetClass = "window-bg hx-AlarmConsole";
        this.headClass = "window-bg control-border font hx-AlarmConsole-header";
        this.rowClass = "window-bg control-border hx-AlarmConsole-row";
    }

    protected BHxAlarmConsole() {
        this.this();
        this.acknowledge = new Acknowledge(this);
        this.registerEvent((Event)this.acknowledge);
        this.showRecurring = new ShowRecurring(this);
        this.registerEvent((Event)this.showRecurring);
        this.showAll = new ShowAll(this);
        this.registerEvent((Event)this.showAll);
        this.showDetails = new ShowDetails(this);
        this.registerEvent((Event)this.showDetails);
        this.forceClear = new ForceClear(this);
        this.registerEvent((Event)this.forceClear);
        this.sort = new SortCommand(this);
        this.registerEvent((Event)this.sort);
        this.addNotes = new AddNotes(this);
        this.registerEvent((Event)this.addNotes);
    }

    static {
        Class clazz = class$com$tridium$alarm$hx$BHxAlarmConsole;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$hx$BHxAlarmConsole = BHxAlarmConsole.class("[Lcom.tridium.alarm.hx.BHxAlarmConsole;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$alarm$hx$BHxAlarmConsole;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$alarm$hx$BHxAlarmConsole = BHxAlarmConsole.class("[Lcom.tridium.alarm.hx.BHxAlarmConsole;", false);
        }
        lexicon = Lexicon.make((Class)clazz2);
        HX_TIMESTAMP_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.FALSE);
        yellowAlarmImg = BImage.make((String)"module://icons/x16/alarm.png");
        redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
        greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
        orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
        sortAsc = BImage.make((BIcon)BIcon.std((String)"moveUp.png"));
        sortDesc = BImage.make((BIcon)BIcon.std((String)"moveDown.png"));
        arrow = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
        linkImg = BImage.make((BIcon)BIcon.std((String)"link.png"));
        blankImg = BImage.make((BIcon)BIcon.std((String)"blank.png"));
        disablePngFixing = false;
        try {
            disablePngFixing = new Boolean(System.getProperty("hx.disablePngFixing", "false"));
        }
        catch (Exception exception) {}
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SourceAlarm {
        public BAlarmRecord alarm;
        public int ackedCount;
        public int unackedCount;
        public int pendingCount;

        public Object get(String string) {
            if (string.equals(BAlarmRecord.ackState.getName())) {
                return "" + this.ackedCount + '/' + this.unackedCount + '/' + this.pendingCount;
            }
            return this.alarm.get(string);
        }

        public void update(BAlarmRecord bAlarmRecord) {
            if (this.alarm.getTimestamp().isBefore(bAlarmRecord.getTimestamp())) {
                this.alarm = bAlarmRecord;
            }
            if (bAlarmRecord.isAcknowledged()) {
                ++this.ackedCount;
            } else if (bAlarmRecord.isAckPending()) {
                ++this.pendingCount;
            } else {
                ++this.unackedCount;
            }
        }

        private final /* synthetic */ void this() {
            this.alarm = new BAlarmRecord();
            this.ackedCount = 0;
            this.unackedCount = 0;
            this.pendingCount = 0;
        }

        public SourceAlarm() {
            this.this();
            this.alarm.setTimestamp(BAbsTime.NULL);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AlarmCommand
    extends Command {
        public BImage getIcon(HxOp hxOp) {
            return null;
        }

        public AlarmCommand(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Acknowledge
    extends AlarmCommand {
        public String getDisplayName(HxOp hxOp) {
            return lexicon.getText("hx.acknowledge.label");
        }

        public BImage getIcon(HxOp hxOp) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.acknowledge.icon")));
        }

        public void handle(HxOp hxOp) throws Exception {
            HtmlWriter htmlWriter;
            if (hxOp.getPostBody() == null || hxOp.getFormValue("recurringAlarms") == null) {
                htmlWriter = BHxAlarmConsole.this.getSelection(hxOp);
                int n = 0;
                while (n < ((String[])htmlWriter).length) {
                    BHxAlarmConsole.this.ackAlarmBySource(hxOp.getFormValue("_" + (String)htmlWriter[n]), null, hxOp);
                    ++n;
                }
            } else {
                htmlWriter = BHxAlarmConsole.this.getSelection(hxOp);
                int n = 0;
                while (n < ((String[])htmlWriter).length) {
                    BHxAlarmConsole.this.ackAlarmByUuid((String)htmlWriter[n], null, hxOp);
                    ++n;
                }
            }
            htmlWriter = hxOp.getHtmlWriter();
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
            htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
            if (hxOp.getFormValue("recurringAlarms") == null) {
                BHxAlarmConsole.this.showAll(hxOp);
            } else {
                BHxAlarmConsole.this.showRecurringAlarms(hxOp.getFormValue("source"), hxOp);
            }
            htmlWriter.w((Object)"';");
        }

        public Acknowledge(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ShowRecurring
    extends AlarmCommand {
        public String getDisplayName(HxOp hxOp) {
            return lexicon.getText("hx.showRecurring.label");
        }

        public BImage getIcon(HxOp hxOp) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.showRecurring.icon")));
        }

        public void handle(HxOp hxOp) throws Exception {
            if (BHxAlarmConsole.this.getSelection(hxOp).length == 0) {
                return;
            }
            hxOp.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("recurring", hxOp), (Object)"true");
            hxOp.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("source", hxOp), (Object)hxOp.getFormValue("_" + BHxAlarmConsole.this.getSelection(hxOp)[0]));
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableTitle") + "').innerHTML='"));
            BHxAlarmConsole.this.writeTableTitle(true, hxOp);
            htmlWriter.w((Object)"';");
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
            htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
            BHxAlarmConsole.this.showRecurringAlarms(hxOp.getFormValue("_" + BHxAlarmConsole.this.getSelection(hxOp)[0]), hxOp);
            htmlWriter.w((Object)"';");
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("commands") + "').innerHTML='"));
            BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(true, hxOp), hxOp);
            htmlWriter.w((Object)"';");
        }

        public ShowRecurring(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ShowAll
    extends AlarmCommand {
        public String getDisplayName(HxOp hxOp) {
            return lexicon.getText("hx.showAll.label");
        }

        public BImage getIcon(HxOp hxOp) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.showAll.icon")));
        }

        public void handle(HxOp hxOp) throws Exception {
            hxOp.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("recurring", hxOp), null);
            hxOp.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("source", hxOp), null);
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableTitle") + "').innerHTML='"));
            BHxAlarmConsole.this.writeTableTitle(false, hxOp);
            htmlWriter.w((Object)"';");
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
            htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
            BHxAlarmConsole.this.showAll(hxOp);
            htmlWriter.w((Object)"';");
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("commands") + "').innerHTML='"));
            BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(false, hxOp), hxOp);
            htmlWriter.w((Object)"';");
        }

        public ShowAll(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ShowDetails
    extends AlarmCommand {
        DetailsDialog dlg;

        public String getDisplayName(HxOp hxOp) {
            return lexicon.getText("hx.showDetails.label");
        }

        public BImage getIcon(HxOp hxOp) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.showDetails.icon")));
        }

        public void handle(HxOp hxOp) throws Exception {
            String[] stringArray = BHxAlarmConsole.this.getSelection(hxOp);
            if (stringArray.length < 1) {
                return;
            }
            if (!this.dlg.isSubmit(hxOp)) {
                this.dlg.open(hxOp);
                return;
            }
        }

        public ShowDetails(BHxView bHxView) {
            super(bHxView);
            this.dlg = new DetailsDialog(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ForceClear
    extends AlarmCommand {
        public String getDisplayName(HxOp hxOp) {
            return lexicon.getText("hx.forceClear.label");
        }

        public BImage getIcon(HxOp hxOp) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.forceClear.icon")));
        }

        public void handle(HxOp hxOp) throws Exception {
            if (hxOp.getPermissionsForTarget().hasAdminInvoke() || hxOp.getPermissionsForTarget().hasAdminWrite()) {
                HtmlWriter htmlWriter;
                if (hxOp.getPostBody() == null || hxOp.getFormValue("recurringAlarms") == null) {
                    htmlWriter = BHxAlarmConsole.this.getSelection(hxOp);
                    int n = 0;
                    while (n < ((String[])htmlWriter).length) {
                        BHxAlarmConsole.this.forceClearBySource(hxOp.getFormValue("_" + (String)htmlWriter[n]), hxOp);
                        ++n;
                    }
                } else {
                    htmlWriter = BHxAlarmConsole.this.getSelection(hxOp);
                    int n = 0;
                    while (n < ((String[])htmlWriter).length) {
                        BHxAlarmConsole.this.forceClearByUuid((String)htmlWriter[n], hxOp);
                        ++n;
                    }
                }
                htmlWriter = hxOp.getHtmlWriter();
                htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
                htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
                if (hxOp.getFormValue("recurringAlarms") == null) {
                    BHxAlarmConsole.this.showAll(hxOp);
                } else {
                    BHxAlarmConsole.this.showRecurringAlarms(hxOp.getFormValue("source"), hxOp);
                }
                htmlWriter.w((Object)"';");
            }
        }

        public ForceClear(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SortCommand
    extends Command {
        public String getDisplayName(HxOp hxOp) {
            return "sortCommand";
        }

        public void handle(HxOp hxOp) throws Exception {
            String string;
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            boolean bl = true;
            Object object = hxOp.getRequest().getSession().getAttribute(BHxAlarmConsole.this.sessionScope("recurring", hxOp));
            Object object2 = hxOp.getRequest().getSession().getAttribute(BHxAlarmConsole.this.sessionScope("source", hxOp));
            if (object != null) {
                bl = false;
            }
            if ((string = hxOp.getFormValue("recurringAlarms")) != null) {
                bl = false;
            }
            if (bl) {
                htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
                htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
                BHxAlarmConsole.this.showAll(hxOp);
                htmlWriter.w((Object)"';");
                htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("commands") + "').innerHTML='"));
                BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(false, hxOp), hxOp);
                htmlWriter.w((Object)"';");
            } else {
                htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
                htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
                String string2 = "";
                string2 = object2 != null ? object2.toString() : hxOp.getFormValue("source");
                BHxAlarmConsole.this.showRecurringAlarms(string2, hxOp);
                htmlWriter.w((Object)"';");
                htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("commands") + "').innerHTML='"));
                BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(true, hxOp), hxOp);
                htmlWriter.w((Object)"';");
            }
        }

        public SortCommand(BHxView bHxView) {
            super(bHxView);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AddNotes
    extends AlarmCommand {
        Dialog dlg;

        public String getDisplayName(HxOp hxOp) {
            return lexicon.getText("hx.addNotes.label");
        }

        public BImage getIcon(HxOp hxOp) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.notes.icon")));
        }

        public void handle(HxOp hxOp) throws Exception {
            int n;
            if (!this.dlg.isSubmit(hxOp)) {
                this.dlg.open(hxOp);
                return;
            }
            String string = hxOp.getFormValue("notes");
            String[] stringArray = BHxAlarmConsole.this.getSelection(hxOp);
            if (hxOp.getPostBody() == null || hxOp.getFormValue("recurringAlarms") == null) {
                n = 0;
                while (n < stringArray.length) {
                    String string2 = hxOp.getFormValue("_" + stringArray[n]);
                    BHxAlarmConsole.this.addAlarmNoteBySource(string2, string, hxOp);
                    ++n;
                }
            } else {
                n = 0;
                while (n < stringArray.length) {
                    BHxAlarmConsole.this.addAlarmNoteByUuid(stringArray[n], string, hxOp);
                    ++n;
                }
            }
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            htmlWriter.w((Object)("document.getElementById('" + hxOp.scope("tableRecords") + "').innerHTML='"));
            htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + hxOp.scope("records") + "\">"));
            if (hxOp.getFormValue("recurringAlarms") == null) {
                BHxAlarmConsole.this.showAll(hxOp);
            } else {
                BHxAlarmConsole.this.showRecurringAlarms(hxOp.getFormValue("source"), hxOp);
            }
            htmlWriter.w((Object)"';");
        }

        public AddNotes(BHxView bHxView) {
            super(bHxView);
            this.dlg = new AlarmNotesDialog(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DetailsDialog
    extends Dialog {
        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this)};
        }

        public void writeContent(HxOp hxOp) throws Exception {
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            String[] stringArray = BHxAlarmConsole.this.getSelection(hxOp);
            String string = stringArray[0];
            String string2 = "alarm:|bql:SELECT * FROM openAlarms WHERE uuid='" + string + '\'';
            BOrd bOrd = BOrd.make((String)string2);
            BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
            Cursor cursor = bICollection.cursor();
            if (cursor.next()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                Property[] propertyArray = bAlarmRecord.loadSlots().getPropertiesArray();
                htmlWriter.w((Object)"<div ");
                htmlWriter.w((Object)" class='hx-AlarmConsole-detailsRow' style='overflow:auto; width:100%;'");
                htmlWriter.w((Object)">");
                String string3 = "hx-AlarmConsole-detailsRow window-bg control-border hx-PropertySheet-row";
                htmlWriter.w((Object)"<table width='100%' cellpadding='3' cellspacing='0' style='padding:5px'>");
                int n = 0;
                while (n < propertyArray.length) {
                    if (!Flags.isHidden((BComplex)bAlarmRecord, (Slot)propertyArray[n])) {
                        htmlWriter.w((Object)"<tr>");
                        htmlWriter.w((Object)("<td nowrap width='1%' class='" + string3 + "'><b>"));
                        BHxAlarmConsole.safe(htmlWriter, propertyArray[n].getDefaultDisplayName((Context)hxOp));
                        htmlWriter.w((Object)"</b></td>");
                        if (propertyArray[n].equals((Object)BAlarmRecord.alarmData)) {
                            BFacets bFacets = bAlarmRecord.getAlarmData();
                            Object[] objectArray = bFacets.list();
                            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)new Comparator(){

                                public final int compare(Object object, Object object2) {
                                    return ((String)object).compareToIgnoreCase((String)object2);
                                }
                            });
                            htmlWriter.w((Object)("<td class='" + string3 + "'>"));
                            htmlWriter.w((Object)"<table cellpadding='3' cellspacing='0'>");
                            int n2 = 0;
                            while (n2 < objectArray.length) {
                                String string4;
                                if (((String)objectArray[n2]).equals("notes") || ((String)objectArray[n2]).equals("instructions")) {
                                    string4 = SlotPath.unescape((String)bFacets.get((String)objectArray[n2]).toString((Context)hxOp));
                                    String[] stringArray2 = TextUtil.split((String)string4, (char)'\n');
                                    int n3 = 0;
                                    while (n3 < stringArray2.length) {
                                        stringArray2[n3] = XWriter.safeToString((String)stringArray2[n3], (boolean)true);
                                        ++n3;
                                    }
                                    string4 = TextUtil.join((String[])stringArray2, (char)'\n');
                                    string4 = TextUtil.replace((String)string4, (String)"\n", (String)"<br/>");
                                    htmlWriter.w((Object)"<tr>");
                                    htmlWriter.w((Object)"<td nowrap><b>");
                                    BHxAlarmConsole.safe(htmlWriter, objectArray[n2]);
                                    htmlWriter.w((Object)"</b></td>");
                                    htmlWriter.w((Object)"<td>");
                                    htmlWriter.w((Object)string4);
                                    htmlWriter.w((Object)"</td>");
                                    htmlWriter.w((Object)"</tr>");
                                } else if (propertyArray[n].getName().equals("alarmClass")) {
                                    string4 = bAlarmRecord.get(propertyArray[n]).toString((Context)hxOp);
                                    string4 = BHxAlarmConsole.this.getAlarmService().getAlarmClassDisplayName(BString.make((String)string4), (Context)hxOp).toString();
                                    htmlWriter.w((Object)("<td class='" + string3 + "'>"));
                                    BHxAlarmConsole.safe(htmlWriter, string4);
                                    htmlWriter.w((Object)"</td>");
                                } else {
                                    htmlWriter.w((Object)"<tr>");
                                    htmlWriter.w((Object)("<td nowrap><b>" + (String)objectArray[n2] + "</b></td>"));
                                    htmlWriter.w((Object)"<td>");
                                    BHxAlarmConsole.safe(htmlWriter, BFormat.format((String)SlotPath.unescape((String)bFacets.get((String)objectArray[n2]).toString((Context)hxOp)), (Object)((Object)bAlarmRecord)));
                                    htmlWriter.w((Object)"</td>");
                                    htmlWriter.w((Object)"</tr>");
                                }
                                ++n2;
                            }
                            htmlWriter.w((Object)"</table></div>");
                            htmlWriter.w((Object)"</td>");
                        } else if (propertyArray[n].getType().equals(BAbsTime.TYPE)) {
                            htmlWriter.w((Object)("<td class='" + string3 + "'>"));
                            BHxAlarmConsole.safe(htmlWriter, SlotPath.unescape((String)bAlarmRecord.get(propertyArray[n]).toString((Context)BFacets.make((BFacets)hxOp.getFacets(), (BFacets)HX_TIMESTAMP_FACETS))));
                            htmlWriter.w((Object)"</td>");
                        } else {
                            htmlWriter.w((Object)("<td class='" + string3 + "'>"));
                            BHxAlarmConsole.safe(htmlWriter, SlotPath.unescape((String)bAlarmRecord.get(propertyArray[n]).toString((Context)hxOp)));
                            htmlWriter.w((Object)"</td>");
                        }
                        htmlWriter.w((Object)"</tr>");
                    }
                    ++n;
                }
                htmlWriter.w((Object)"</table>");
                htmlWriter.w((Object)"</div>");
            }
        }

        public DetailsDialog(Command command) {
            super("Alarm Details", command);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AlarmNotesDialog
    extends Dialog {
        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this), new Dialog.Cancel((Dialog)this)};
        }

        public void writeContent(HxOp hxOp) throws Exception {
            String string = this.getAlarmNotes(hxOp);
            HtmlWriter htmlWriter = hxOp.getHtmlWriter();
            htmlWriter.w((Object)"<div style='display:block;' >");
            htmlWriter.w((Object)"<textarea rows='4' cols='40' readonly='yes' wrap='hard'>");
            htmlWriter.safe(string);
            htmlWriter.w((Object)"</textarea><br />");
            htmlWriter.w((Object)"</div>");
            htmlWriter.w((Object)("<textarea rows='4' cols='40' name='" + hxOp.scope("notes") + "' >"));
            htmlWriter.w((Object)"</textarea>");
        }

        private final String getAlarmNotes(HxOp hxOp) {
            String[] stringArray = BHxAlarmConsole.this.getSelection(hxOp);
            String string = "";
            if (hxOp.getPostBody() == null || hxOp.getFormValue("recurringAlarms") == null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = hxOp.getFormValue("_" + stringArray[n]);
                    string = string + this.getAlarmNotesBySource(hxOp, string2);
                    ++n;
                }
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    string = string + this.getAlarmNotesByUUID(hxOp, stringArray[n]);
                    ++n;
                }
            }
            return string;
        }

        private final String getAlarmNotesBySource(HxOp hxOp, String string) {
            Object object;
            if (string == null) {
                return "";
            }
            BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + string + '\''));
            BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
            Cursor cursor = bICollection.cursor();
            Class clazz = class$javax$baja$alarm$BAlarmRecord;
            if (clazz == null) {
                clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            Array array = new Array(clazz);
            while (cursor.next()) {
                object = (BAlarmRecord)cursor.get();
                array.add((Object)object.newCopy());
            }
            object = new StringBuffer();
            if (array.size() > 1) {
                ((StringBuffer)object).append(lexicon.getText("hx.notes.multiple") + '\n');
            }
            int n = 0;
            while (n < array.size()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
                BObject bObject = bAlarmRecord.getAlarmData().get("notes");
                if (bObject != null) {
                    ((StringBuffer)object).append(bObject.toString());
                }
                ++n;
            }
            return ((StringBuffer)object).toString();
        }

        private final String getAlarmNotesByUUID(HxOp hxOp, String string) {
            if (string == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            BOrd bOrd = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + string + '\''));
            BICollection bICollection = (BICollection)bOrd.resolve(hxOp.get()).get();
            Cursor cursor = bICollection.cursor();
            Class clazz = class$javax$baja$alarm$BAlarmRecord;
            if (clazz == null) {
                clazz = class$javax$baja$alarm$BAlarmRecord = BHxAlarmConsole.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            Array array = new Array(clazz);
            while (cursor.next()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
                array.add((Object)bAlarmRecord.newCopy());
            }
            if (array.size() > 1) {
                stringBuffer.append(lexicon.getText("hx.notes.multiple") + '\n');
            }
            int n = 0;
            while (n < array.size()) {
                BAlarmRecord bAlarmRecord = (BAlarmRecord)((Object)array.get(n));
                BObject bObject = bAlarmRecord.getAlarmData().get("notes");
                if (bObject != null) {
                    stringBuffer.append(bObject.toString());
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        public AlarmNotesDialog(Command command) {
            super("Alarm Notes", command);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class LoadThread
    extends Thread {
        public HxOp op;

        public void run() {
            try {
                HtmlWriter htmlWriter = this.op.getHtmlWriter();
                htmlWriter.w((Object)("document.getElementById('" + this.op.scope("tableRecords") + "').innerHTML='"));
                htmlWriter.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"table\" id=\"" + this.op.scope("records") + "\">"));
                BHxAlarmConsole.this.showAll(this.op);
                htmlWriter.w((Object)"\";");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public LoadThread(HxOp hxOp) {
            this.op = hxOp;
        }
    }
}

