/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.util.BUuid;

public class FoxAlarmCodec {
    public static FoxMessage encodeAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("timestamp", bAlarmRecord.getTimestamp().getMillis());
        foxMessage.add("uuid", bAlarmRecord.getUuid().encodeToString());
        foxMessage.add("sourceState", bAlarmRecord.getSourceState().encodeToString());
        foxMessage.add("ackState", bAlarmRecord.getAckState().encodeToString());
        foxMessage.add("ackRequired", bAlarmRecord.getAckRequired());
        foxMessage.add("source", bAlarmRecord.getSource().encodeToString());
        foxMessage.add("alarmClass", bAlarmRecord.getAlarmClass());
        foxMessage.add("priority", bAlarmRecord.getPriority());
        foxMessage.add("normalTime", bAlarmRecord.getNormalTime().getMillis());
        foxMessage.add("ackTime", bAlarmRecord.getAckTime().getMillis());
        foxMessage.add("user", bAlarmRecord.getUser());
        foxMessage.add("alarmData", bAlarmRecord.getAlarmData().encodeToString());
        foxMessage.add("alarmTransition", bAlarmRecord.getAlarmTransition().encodeToString());
        foxMessage.add("lastUpdate", bAlarmRecord.getLastUpdate().getMillis());
        return foxMessage;
    }

    public static BAlarmRecord decodeAlarm(FoxMessage foxMessage) throws Exception {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        try {
            bAlarmRecord.setTimestamp(BAbsTime.make((long)foxMessage.getTime("timestamp")));
            bAlarmRecord.setUuid((BUuid)BUuid.DEFAULT.decodeFromString(foxMessage.getString("uuid")));
            bAlarmRecord.setSourceState((BSourceState)BSourceState.normal.decodeFromString(foxMessage.getString("sourceState")));
            bAlarmRecord.setAckState((BAckState)BAckState.acked.decodeFromString(foxMessage.getString("ackState")));
            bAlarmRecord.setAckRequired(foxMessage.getBoolean("ackRequired"));
            bAlarmRecord.setSource((BOrdList)BOrdList.DEFAULT.decodeFromString(foxMessage.getString("source")));
            bAlarmRecord.setAlarmClass(foxMessage.getString("alarmClass"));
            bAlarmRecord.setPriority(foxMessage.getInt("priority"));
            bAlarmRecord.setNormalTime(BAbsTime.make((long)foxMessage.getTime("normalTime")));
            bAlarmRecord.setAckTime(BAbsTime.make((long)foxMessage.getTime("ackTime")));
            bAlarmRecord.setUser(foxMessage.getString("user"));
            bAlarmRecord.setAlarmData((BFacets)BFacets.DEFAULT.decodeFromString(foxMessage.getString("alarmData")));
            bAlarmRecord.setAlarmTransition((BSourceState)BSourceState.normal.decodeFromString(foxMessage.getString("alarmTransition")));
            bAlarmRecord.setLastUpdate(BAbsTime.make((long)foxMessage.getTime("lastUpdate")));
        }
        catch (Exception exception) {
            bAlarmRecord.setTimestamp(BAbsTime.make((long)foxMessage.getTime("timestamp")));
            bAlarmRecord.setUuid((BUuid)DecoderFactory.decode((FoxMessage)foxMessage, (String)"uuid", null));
            bAlarmRecord.setSourceState((BSourceState)((Object)DecoderFactory.decode((FoxMessage)foxMessage, (String)"sourceState", null)));
            bAlarmRecord.setAckState((BAckState)((Object)DecoderFactory.decode((FoxMessage)foxMessage, (String)"ackState", null)));
            bAlarmRecord.setAckRequired(foxMessage.getBoolean("ackRequired"));
            bAlarmRecord.setSource((BOrdList)DecoderFactory.decode((FoxMessage)foxMessage, (String)"source", null));
            bAlarmRecord.setAlarmClass(foxMessage.getString("alarmClass"));
            bAlarmRecord.setPriority(foxMessage.getInt("priority"));
            bAlarmRecord.setNormalTime(BAbsTime.make((long)foxMessage.getTime("normalTime")));
            bAlarmRecord.setAckTime(BAbsTime.make((long)foxMessage.getTime("ackTime")));
            bAlarmRecord.setUser(foxMessage.getString("user"));
            bAlarmRecord.setAlarmData((BFacets)DecoderFactory.decode((FoxMessage)foxMessage, (String)"alarmData", null));
            bAlarmRecord.setAlarmTransition((BSourceState)((Object)DecoderFactory.decode((FoxMessage)foxMessage, (String)"alarmTransition", null)));
            bAlarmRecord.setLastUpdate(BAbsTime.make((long)foxMessage.getTime("lastUpdate")));
        }
        return bAlarmRecord;
    }
}

