/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.AlarmColumnSpec;
import com.tridium.alarm.AlarmInput;
import com.tridium.alarm.AlarmInputCursor;
import com.tridium.alarm.AlarmOutput;
import com.tridium.alarm.BAlarmInputTable;
import com.tridium.alarm.db.BAlarmDbQueryResult;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.HashMap;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataTable;
import javax.baja.naming.BOrd;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmDbChannel
extends BFoxChannel {
    public static final Type TYPE;
    private Version serverVersion;
    static /* synthetic */ Class class$com$tridium$alarm$fox$BAlarmDbChannel;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "append") {
            return this.append(foxRequest);
        }
        if (string == "update") {
            return this.update(foxRequest);
        }
        if (string == "getRecordCount") {
            return this.getRecordCount(foxRequest);
        }
        if (string == "getRecord") {
            return this.getRecord(foxRequest);
        }
        if (string == "clearAll") {
            return this.clearAllRecords(foxRequest);
        }
        if (string == "clearOld") {
            return this.clearOldRecords(foxRequest);
        }
        if (string == "getVersion") {
            return this.getVersion(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "resolve") {
            this.resolve(foxCircuit);
            return;
        }
        if (string == "resolve34") {
            this.resolve34(foxCircuit);
            return;
        }
        if (string == "scan") {
            this.scan(foxCircuit);
            return;
        }
        if (string == "timeQuery") {
            this.timeQuery(foxCircuit);
            return;
        }
        if (string == "bqlQuery") {
            this.bqlQuery(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public Version checkVersion() {
        if (this.serverVersion == null) {
            try {
                this.serverVersion = this.getVersion();
            }
            catch (Exception exception) {
                this.serverVersion = Version.ZERO;
            }
        }
        return this.serverVersion;
    }

    public Version getVersion() throws Exception {
        FoxRequest foxRequest = this.makeRequest("getVersion");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return new Version(foxResponse.getString("version", ""));
    }

    public FoxResponse getVersion(FoxRequest foxRequest) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("version", TYPE.getModule().getVendorVersion().toString());
        return foxResponse;
    }

    public void append(BAlarmRecord bAlarmRecord) throws Exception {
        FoxRequest foxRequest = this.makeRequest("append");
        foxRequest.add("rec", FoxAlarmCodec.encodeAlarm(bAlarmRecord));
        this.sendSync(foxRequest);
    }

    private final FoxResponse append(FoxRequest foxRequest) throws Exception {
        BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm(foxRequest.getMessage("rec"));
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BUser bUser = this.getSessionContext().getUser();
        BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass == null) {
            bAlarmClass = bAlarmService.getDefaultAlarmClass();
        }
        bUser.check((BIProtected)bAlarmClass, BPermissions.operatorWrite);
        bAlarmService.getAlarmDb().append(bAlarmRecord);
        return null;
    }

    public void update(BAlarmRecord bAlarmRecord) throws Exception {
        FoxRequest foxRequest = this.makeRequest("update");
        foxRequest.add("rec", FoxAlarmCodec.encodeAlarm(bAlarmRecord));
        this.sendSync(foxRequest);
    }

    private final FoxResponse update(FoxRequest foxRequest) throws Exception {
        BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm(foxRequest.getMessage("rec"));
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BUser bUser = this.getSessionContext().getUser();
        BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass == null) {
            bAlarmClass = bAlarmService.getDefaultAlarmClass();
        }
        bUser.check((BIProtected)bAlarmClass, BPermissions.operatorWrite);
        bAlarmService.getAlarmDb().update(bAlarmRecord);
        return null;
    }

    public int getRecordCount() throws Exception {
        FoxRequest foxRequest = this.makeRequest("getRecordCount");
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return foxResponse.getInt("count");
    }

    private final FoxResponse getRecordCount(FoxRequest foxRequest) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("count", bAlarmService.getAlarmDb().getRecordCount());
        return foxResponse;
    }

    public BAlarmRecord getRecord(BUuid bUuid) throws Exception {
        FoxRequest foxRequest = this.makeRequest("getRecord");
        foxRequest.add("uuid", bUuid.encodeToString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        return FoxAlarmCodec.decodeAlarm(foxResponse.getMessage("rec"));
    }

    private final FoxResponse getRecord(FoxRequest foxRequest) throws Exception {
        BUuid bUuid = (BUuid)BUuid.DEFAULT.decodeFromString(foxRequest.getString("uuid"));
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmRecord bAlarmRecord = bAlarmService.getAlarmDb().getRecord(bUuid);
        BUser bUser = this.getSessionContext().getUser();
        BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass == null) {
            bAlarmClass = bAlarmService.getDefaultAlarmClass();
        }
        bUser.check((BIProtected)bAlarmClass, BPermissions.operatorRead);
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        foxResponse.add("rec", FoxAlarmCodec.encodeAlarm(bAlarmRecord));
        return foxResponse;
    }

    public void clearAllRecords() throws Exception {
        this.sendAsync(this.makeRequest("clearAll"));
    }

    private final FoxResponse clearAllRecords(FoxRequest foxRequest) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (bAlarmService != null) {
            bAlarmService.getAlarmDb().clearAllRecords(this.getSessionContext());
        }
        return null;
    }

    public void clearOldRecords(BAbsTime bAbsTime) throws Exception {
        FoxRequest foxRequest = this.makeRequest("clearOld");
        foxRequest.add("before", bAbsTime.getMillis());
        this.sendAsync(foxRequest);
    }

    private final FoxResponse clearOldRecords(FoxRequest foxRequest) throws Exception {
        BAbsTime bAbsTime = BAbsTime.make((long)foxRequest.getTime("before"));
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (bAlarmService != null) {
            bAlarmService.getAlarmDb().clearOldRecords(bAbsTime, this.getSessionContext());
        }
        return null;
    }

    public void clearRecord(BUuid bUuid) throws Exception {
        FoxRequest foxRequest = this.makeRequest("clear");
        foxRequest.add("uuid", bUuid.encodeToString());
        this.sendAsync(foxRequest);
    }

    private final FoxResponse clearRecord(FoxRequest foxRequest) throws Exception {
        BUuid bUuid = (BUuid)BUuid.DEFAULT.decodeFromString(foxRequest.getString("uuid"));
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (bAlarmService != null) {
            bAlarmService.getAlarmDb().clearRecord(bUuid, this.getSessionContext());
        }
        return null;
    }

    public Cursor scan() throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("scan");
        AlarmInput alarmInput = new AlarmInput(new DataInputStream(foxCircuit.getInputStream()));
        return new AlarmInputCursor(alarmInput, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void scan(FoxCircuit foxCircuit) throws Exception {
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
            AlarmSecurityCursor alarmSecurityCursor = new AlarmSecurityCursor(bAlarmDatabase.scan(), bAlarmService, BPermissions.operatorRead, this.getSessionContext());
            DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
            AlarmOutput alarmOutput = new AlarmOutput(null, dataOutputStream);
            while (true) {
                block4: {
                    if (alarmSecurityCursor.next()) break block4;
                    alarmOutput.flush();
                    alarmOutput.close();
                    break;
                }
                alarmOutput.write((BAlarmRecord)alarmSecurityCursor.get());
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var3_9 = null;
        }
        foxCircuit.close();
    }

    public Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2) throws Exception {
        FoxCircuit foxCircuit = this.openCircuit("timeQuery");
        FoxMessage foxMessage = new FoxMessage();
        if (bAbsTime != null && !bAbsTime.isNull()) {
            foxMessage.add("startTime", bAbsTime.getMillis());
        }
        if (bAbsTime2 != null && !bAbsTime2.isNull()) {
            foxMessage.add("endTime", bAbsTime2.getMillis());
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        AlarmInput alarmInput = new AlarmInput(new DataInputStream(foxCircuit.getInputStream()));
        return new AlarmInputCursor(alarmInput, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void timeQuery(FoxCircuit foxCircuit) throws Exception {
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
            FoxMessage foxMessage = foxCircuit.readMessage();
            BAbsTime bAbsTime = null;
            BAbsTime bAbsTime2 = null;
            long l = foxMessage.getTime("startTime", (long)-1);
            if (l != (long)-1) {
                bAbsTime = BAbsTime.make((long)l);
            }
            if ((l = foxMessage.getTime("endTime", (long)-1)) != (long)-1) {
                bAbsTime2 = BAbsTime.make((long)l);
            }
            Cursor cursor = bAlarmDatabase.timeQuery(bAbsTime, bAbsTime2);
            cursor = new AlarmSecurityCursor(cursor, bAlarmService, BPermissions.operatorRead, this.getSessionContext());
            DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
            AlarmOutput alarmOutput = new AlarmOutput(null, dataOutputStream);
            while (true) {
                block6: {
                    if (cursor.next()) break block6;
                    alarmOutput.flush();
                    alarmOutput.close();
                    break;
                }
                alarmOutput.write((BAlarmRecord)cursor.get());
            }
        }
        catch (Throwable throwable) {
            Object var3_12 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var3_13 = null;
        }
        foxCircuit.close();
    }

    public Cursor bqlQuery(BqlQuery bqlQuery) throws Exception {
        Version version = this.getVersion();
        if (version.compareTo((Object)new Version("3.4.23")) < 0) {
            throw new AlarmException("Incompatible Version: " + version + " < 3.4.23");
        }
        FoxCircuit foxCircuit = this.openCircuit("bqlQuery");
        FoxMessage foxMessage = new FoxMessage();
        if (bqlQuery != null) {
            foxMessage.add("bql", bqlQuery.getBody());
        }
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        AlarmInput alarmInput = new AlarmInput(new DataInputStream(foxCircuit.getInputStream()));
        return new AlarmInputCursor(alarmInput, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void bqlQuery(FoxCircuit foxCircuit) throws Exception {
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
            FoxMessage foxMessage = foxCircuit.readMessage();
            BqlQuery bqlQuery = BqlQuery.make((String)foxMessage.getString("bql", ""));
            AlarmSecurityCursor alarmSecurityCursor = new AlarmSecurityCursor(((BAlarmDbQueryResult)bAlarmDatabase.bqlQuery(null, bqlQuery)).cursor(), bAlarmService, BPermissions.operatorRead, this.getSessionContext());
            DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
            AlarmOutput alarmOutput = new AlarmOutput(null, dataOutputStream);
            while (true) {
                block4: {
                    if (alarmSecurityCursor.next()) break block4;
                    alarmOutput.flush();
                    alarmOutput.close();
                    break;
                }
                alarmOutput.write((BAlarmRecord)alarmSecurityCursor.get());
            }
        }
        catch (Throwable throwable) {
            Object var3_10 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var3_11 = null;
        }
        foxCircuit.close();
    }

    public BObject resolve(BOrd bOrd) throws Exception {
        Version version = this.checkVersion();
        boolean bl = false;
        if (version.major() == 3) {
            boolean bl2 = false;
            if (version.minor() >= 4) {
                bl2 = true;
            }
            bl = bl2;
        } else {
            bl = version.major() >= 4;
        }
        if (bl) {
            bOrd = bOrd.relativizeToSession();
            FoxCircuit foxCircuit = this.openCircuit("resolve34");
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("ord", bOrd.toString());
            foxCircuit.writeMessage(foxMessage);
            foxCircuit.flush();
            FoxMessage foxMessage2 = foxCircuit.readMessage();
            String string = foxMessage2.getString("resultType", null);
            if (string.equals("records")) {
                DataInputStream dataInputStream = new DataInputStream(foxCircuit.getInputStream());
                AlarmColumnSpec[] alarmColumnSpecArray = this.readColumns(dataInputStream);
                AlarmInput alarmInput = new AlarmInput(dataInputStream);
                return new BAlarmInputTable(alarmColumnSpecArray, alarmInput);
            }
            if (string.equals("table")) {
                BIDataTable bIDataTable = DataTableDecoder.decode((DataInput)new DataInputStream(foxCircuit.getInputStream()));
                foxCircuit.close();
                return (BObject)bIDataTable;
            }
            throw new UnsupportedOperationException("Unsupported result type: " + string);
        }
        bOrd = bOrd.relativizeToSession();
        FoxCircuit foxCircuit = this.openCircuit("resolve");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("ord", bOrd.toString());
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.flush();
        DataInputStream dataInputStream = new DataInputStream(foxCircuit.getInputStream());
        AlarmInput alarmInput = new AlarmInput(dataInputStream);
        return new BAlarmInputTable(null, alarmInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void resolve(FoxCircuit foxCircuit) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try {
            FoxMessage foxMessage = foxCircuit.readMessage();
            BOrd bOrd = BOrd.make((String)foxMessage.getString("ord"));
            BObject bObject = bOrd.resolve((BObject)this).get();
            DataOutputStream dataOutputStream = new DataOutputStream(foxCircuit.getOutputStream());
            if (!(bObject instanceof BICollection)) throw new IllegalStateException("Unsupported result type: " + bObject.getClass().getName());
            BITable bITable = ((BICollection)bObject).toTable();
            AlarmOutput alarmOutput = new AlarmOutput(bITable, dataOutputStream);
            AlarmSecurityCursor alarmSecurityCursor = new AlarmSecurityCursor(((BICollection)bObject).cursor(), bAlarmService, BPermissions.operatorRead, this.getSessionContext());
            while (true) {
                block4: {
                    if (alarmSecurityCursor.next()) break block4;
                    alarmOutput.flush();
                    alarmOutput.close();
                    break;
                }
                alarmOutput.write((BAlarmRecord)alarmSecurityCursor.get());
            }
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            foxCircuit.close();
            throw throwable;
        }
        {
            Object var4_12 = null;
        }
        foxCircuit.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void resolve34(FoxCircuit var1_1) throws Exception {
        var2_2 = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try {
            block6: {
                var5_3 = var1_1.readMessage();
                var6_4 = new FoxMessage("resp");
                var7_5 = BOrd.make((String)var5_3.getString("ord"));
                var8_6 = var7_5.resolve((BObject)this).get();
                var6_4.add("resolved", true);
                var9_7 = new DataOutputStream(var1_1.getOutputStream());
                if (var8_6 instanceof BICollection == false) throw new IllegalStateException("Unsupported result type: " + var8_6.getClass().getName());
                var10_8 = ((BICollection)var8_6).toTable();
                var11_9 = var10_8.getColumns();
                var12_10 = true;
                var13_11 = new BAlarmRecord();
                var14_12 = 0;
                while (var14_12 < var11_9.size()) {
                    var15_15 /* !! */  = var11_9.get(var14_12);
                    if (var13_11.getProperty(var15_15 /* !! */ .getName()) == null) {
                        var12_10 = false;
                        break;
                    }
                    ++var14_12;
                }
                if (!var12_10) break block6;
                var6_4.add("resultType", "records");
                var1_1.writeMessage(var6_4);
                var1_1.flush();
                this.writeColumns(var10_8, var9_7, this.getSessionContext());
                var14_13 = new AlarmOutput(var10_8, var9_7);
                var15_15 /* !! */  = new AlarmSecurityCursor(((BICollection)var8_6).cursor(), var2_2, BPermissions.operatorRead, this.getSessionContext());
                while (true) {
                    block7: {
                        if (var15_15 /* !! */ .next()) break block7;
                        var14_13.flush();
                        var14_13.close();
                        ** GOTO lbl-1000
                    }
                    var14_13.write((BAlarmRecord)var15_15 /* !! */ .get());
                }
            }
            var6_4.add("resultType", "table");
            var1_1.writeMessage(var6_4);
            var1_1.flush();
            var14_14 = new DataOutputStream(var1_1.getOutputStream());
            DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable((BITable)var10_8), (DataOutput)var14_14, (Context)this.getSessionContext());
            var14_14.flush();
            var14_14.close();
        }
        catch (Throwable var3_16) {
            var4_17 = null;
            var1_1.close();
            throw var3_16;
        }
lbl-1000:
        // 2 sources

        {
            var4_18 = null;
        }
        var1_1.close();
    }

    private final AlarmColumnSpec[] readColumns(DataInput dataInput) throws Exception {
        int n = dataInput.readInt();
        AlarmColumnSpec[] alarmColumnSpecArray = new AlarmColumnSpec[n];
        int n2 = 0;
        while (n2 < alarmColumnSpecArray.length) {
            alarmColumnSpecArray[n2] = AlarmColumnSpec.read(dataInput);
            ++n2;
        }
        return alarmColumnSpecArray;
    }

    private final void writeColumns(BITable bITable, DataOutput dataOutput, Context context) throws Exception {
        ColumnList columnList = bITable.getColumns();
        dataOutput.writeInt(columnList.size());
        int n = 0;
        while (n < columnList.size()) {
            Column column = columnList.get(n);
            new AlarmColumnSpec(column.getName(), column.getDisplayName(context), column.getFacets()).write(dataOutput);
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAlarmDbChannel() {
        super("alarmdb");
    }

    static {
        Class clazz = class$com$tridium$alarm$fox$BAlarmDbChannel;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$fox$BAlarmDbChannel = BAlarmDbChannel.class("[Lcom.tridium.alarm.fox.BAlarmDbChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlarmSecurityCursor
    implements Cursor {
        private BAlarmService service;
        private BUser user;
        private Context context;
        private BPermissions required;
        private Cursor inner;
        private BAlarmRecord rec;
        private HashMap classPermissions;

        public Context getContext() {
            return this.context;
        }

        public BObject get() {
            return this.rec;
        }

        public boolean next() {
            while (this.inner.next()) {
                this.rec = (BAlarmRecord)this.inner.get();
                if (this.user != null) {
                    BPermissions bPermissions = this.getClassPermissions(this.user, this.service.lookupAlarmClass(this.rec.getAlarmClass()));
                    if (!bPermissions.has(this.required)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean nextComponent() {
            while (this.inner.next()) {
            }
            return false;
        }

        public boolean next(Class clazz) {
            Class clazz2 = class$javax$baja$alarm$BAlarmRecord;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$alarm$BAlarmRecord = BAlarmDbChannel.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return this.next();
            }
            while (this.inner.next()) {
            }
            return false;
        }

        private final BPermissions getClassPermissions(BUser bUser, BAlarmClass bAlarmClass) {
            BPermissions bPermissions = (BPermissions)this.classPermissions.get(bAlarmClass.getHandle());
            if (bPermissions == null) {
                bPermissions = BAlarmDbChannel.this.getPermissionsFor((Object)bAlarmClass);
                this.classPermissions.put(bAlarmClass.getHandle(), bPermissions);
            }
            return bPermissions;
        }

        private final /* synthetic */ void this() {
            this.classPermissions = new HashMap();
        }

        public AlarmSecurityCursor(Cursor cursor, BAlarmService bAlarmService, BPermissions bPermissions, Context context) {
            this.this();
            this.inner = cursor;
            this.service = bAlarmService;
            this.required = bPermissions;
            this.context = context;
            this.user = context != null ? context.getUser() : null;
        }
    }
}

