/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.IndexEntry;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Random;
import javax.baja.alarm.BAlarmRecord;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SkipList {
    public static final int EQUAL_OR_AFTER = 0;
    public static final int EQUAL_OR_BEFORE = 1;
    public static final int EQUAL = 2;
    private int maxLevel;
    private IndexEntry header;
    private double probability;
    private int level;
    private int size;
    private Random rand;
    private IndexEntry[] addAt;
    private IndexEntry[] removeAt;
    private IndexEntry[] findAt;

    public synchronized int getSize() {
        return this.size;
    }

    public IndexEntry getHeader() {
        return this.header;
    }

    public IndexEntry getFirstEntry() {
        return this.getNext(this.header, 0);
    }

    public synchronized void add(IndexEntry indexEntry) {
        int n = this.generateNewLevel();
        this.setLevel(indexEntry, n);
        if (n > this.level) {
            this.level = n;
        }
        this.pathTo(indexEntry, this.addAt);
        int n2 = 0;
        while (n2 < n) {
            if (n2 == 0) {
                this.setPrev(indexEntry, this.addAt[0]);
                IndexEntry indexEntry2 = this.getNext(this.addAt[0], 0);
                if (indexEntry2 != null) {
                    this.setPrev(indexEntry2, indexEntry);
                }
            }
            this.setNext(indexEntry, n2, this.getNext(this.addAt[n2], n2));
            this.setNext(this.addAt[n2], n2, indexEntry);
            ++n2;
        }
        ++this.size;
    }

    public synchronized void remove(IndexEntry indexEntry) {
        if (this.size == 0) {
            return;
        }
        this.pathTo(indexEntry, this.removeAt);
        IndexEntry indexEntry2 = this.getNext(this.removeAt[0], 0);
        if (!indexEntry2.equals(indexEntry)) {
            throw new IllegalArgumentException("Entry not found: " + this.entryToString(indexEntry2));
        }
        int n = 0;
        while (n < this.level) {
            IndexEntry indexEntry3;
            if (this.getNext(this.removeAt[n], n) != indexEntry2) break;
            if (n == 0 && (indexEntry3 = this.getNext(indexEntry2, 0)) != null) {
                this.setPrev(indexEntry3, this.removeAt[0]);
            }
            this.setNext(this.removeAt[n], n, this.getNext(indexEntry2, n));
            ++n;
        }
        while (this.level > 1 && this.getNext(this.header, this.level - 1) == null) {
            --this.level;
        }
        n = this.level;
        while (n < this.maxLevel) {
            this.addAt[n] = null;
            this.removeAt[n] = null;
            this.findAt[n] = null;
            ++n;
        }
        --this.size;
    }

    public IndexEntry find(Object object) {
        this.pathTo(object, this.findAt);
        return this.findAt[0];
    }

    protected void pathTo(Object object, IndexEntry[] indexEntryArray) {
        IndexEntry indexEntry = this.header;
        IndexEntry indexEntry2 = null;
        int n = this.level - 1;
        while (n >= 0) {
            indexEntry2 = this.getNext(indexEntry, n);
            while (indexEntry2 != null && this.compareToKey(indexEntry2, object) < 0) {
                indexEntry = indexEntry2;
                indexEntry2 = this.getNext(indexEntry2, n);
            }
            indexEntryArray[n] = indexEntry;
            --n;
        }
    }

    protected void pathTo(IndexEntry indexEntry, IndexEntry[] indexEntryArray) {
        IndexEntry indexEntry2 = this.header;
        IndexEntry indexEntry3 = null;
        int n = this.level - 1;
        while (n >= 0) {
            indexEntry3 = this.getNext(indexEntry2, n);
            while (indexEntry3 != null && this.isBefore(indexEntry3, indexEntry)) {
                indexEntry2 = indexEntry3;
                indexEntry3 = this.getNext(indexEntry3, n);
            }
            indexEntryArray[n] = indexEntry2;
            --n;
        }
    }

    private final int generateNewLevel() {
        if (this.size == 0) {
            return 1;
        }
        int n = 1;
        while (this.rand.nextDouble() < this.probability && n < this.maxLevel) {
            if (++n != this.level + 1) continue;
            return n;
        }
        return n;
    }

    protected abstract int compare(IndexEntry var1, IndexEntry var2);

    protected abstract int compareToKey(IndexEntry var1, Object var2);

    protected boolean equals(IndexEntry indexEntry, IndexEntry indexEntry2) {
        boolean bl = false;
        if (this.compare(indexEntry, indexEntry2) == 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean isBefore(IndexEntry indexEntry, IndexEntry indexEntry2) {
        boolean bl = false;
        if (this.compare(indexEntry, indexEntry2) < 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean isAfter(IndexEntry indexEntry, IndexEntry indexEntry2) {
        boolean bl = false;
        if (this.compare(indexEntry, indexEntry2) > 0) {
            bl = true;
        }
        return bl;
    }

    protected abstract int getLevel(IndexEntry var1);

    protected abstract void setLevel(IndexEntry var1, int var2);

    protected abstract IndexEntry getNext(IndexEntry var1, int var2);

    protected abstract void setNext(IndexEntry var1, int var2, IndexEntry var3);

    protected abstract IndexEntry getPrev(IndexEntry var1);

    protected abstract void setPrev(IndexEntry var1, IndexEntry var2);

    public void dump() throws IOException {
        this.dump(null);
    }

    public void dump(AlarmStore alarmStore) throws IOException {
        int n = 0;
        IndexEntry indexEntry = this.getNext(this.header, 0);
        BAlarmRecord bAlarmRecord = null;
        if (alarmStore != null) {
            bAlarmRecord = new BAlarmRecord();
        }
        while (indexEntry != null) {
            System.out.println(n++ + ": (" + this.getLevel(indexEntry) + ") " + this.entryToString(indexEntry));
            if (alarmStore != null) {
                bAlarmRecord = alarmStore.readRecord(indexEntry.pageIndex, bAlarmRecord, null);
                System.out.println("  " + bAlarmRecord.toSummaryString());
            }
            indexEntry = this.getNext(indexEntry, 0);
        }
    }

    public void analyze(String string, PrintStream printStream) {
        printStream.println(string);
        printStream.println("  probability: " + this.probability);
        printStream.println("  maxLevel   : " + this.maxLevel);
        printStream.println("  level      : " + this.level);
        int[] nArray = new int[this.level];
        int n = 0;
        while (n < this.level) {
            IndexEntry indexEntry = this.getNext(this.header, n);
            while (indexEntry != null) {
                nArray[n] = nArray[n] + 1;
                indexEntry = this.getNext(indexEntry, n);
            }
            ++n;
        }
        n = 0;
        while (n < this.level) {
            System.out.println("    level " + (n + 1) + ": " + nArray[n]);
            ++n;
        }
        n = this.size * 4;
        int n2 = 0;
        while (n2 < this.level) {
            n += nArray[n2] * 4;
            ++n2;
        }
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###.##");
        printStream.println("  ptr ram    : " + decimalFormat.format((double)n / 1024.0 / 1024.0) + " MB");
    }

    public void verify() {
        int n = 0;
        IndexEntry indexEntry = null;
        IndexEntry indexEntry2 = this.getNext(this.header, 0);
        while (indexEntry2 != null) {
            ++n;
            if (indexEntry != null && this.isAfter(indexEntry, indexEntry2)) {
                throw new IllegalStateException("Invalid ascending order.  " + this.entryToString(indexEntry2) + " is before " + this.entryToString(indexEntry));
            }
            indexEntry = indexEntry2;
            indexEntry2 = this.getNext(indexEntry2, 0);
        }
        if (this.size != n) {
            throw new IllegalStateException("Invalid ascending count. size=" + this.size + ", count=" + n);
        }
        indexEntry2 = indexEntry;
        n = 0;
        indexEntry = null;
        while (indexEntry2 != this.header) {
            ++n;
            if (indexEntry != null && this.isBefore(indexEntry, indexEntry2)) {
                throw new IllegalStateException("Invalid descending order.  " + this.entryToString(indexEntry2) + " is after " + this.entryToString(indexEntry));
            }
            indexEntry = indexEntry2;
            indexEntry2 = this.getPrev(indexEntry2);
        }
        if (this.size != n) {
            throw new IllegalStateException("Invalid descending count. size=" + this.size + ", count=" + n);
        }
    }

    public abstract String entryToString(IndexEntry var1);

    private final /* synthetic */ void this() {
        this.rand = new Random();
    }

    public SkipList(double d, int n) {
        this.this();
        this.maxLevel = (int)(Math.log(n) / Math.log(1.0 / d)) + 1;
        this.probability = d;
        this.header = new IndexEntry();
        this.setLevel(this.header, this.maxLevel);
        this.level = 1;
        this.size = 0;
        this.addAt = new IndexEntry[this.maxLevel];
        this.removeAt = new IndexEntry[this.maxLevel];
        this.findAt = new IndexEntry[this.maxLevel];
    }
}

