/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.Page;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PageReader
implements DataInput {
    private AlarmStore store;
    private int pageIndex;
    private Page page;
    private int pos;
    private int pageLen;
    private int[] pages;
    private int pageCount;

    public void init(int n) throws IOException {
        this.pageIndex = n;
        if (this.pageIndex != -1) {
            this.page = this.store.readPage(this.pageIndex);
        }
        this.pos = 0;
        this.pageLen = this.store.getHeader().getPageSize() - 12;
        this.pageCount = 1;
        if (this.pages == null) {
            this.pages = new int[3];
        }
        this.pages[0] = n;
    }

    private final void nextPage() throws IOException {
        if (this.page == null) {
            throw new IllegalStateException("PageReader has not been initialized.");
        }
        int n = this.page.getNextPage();
        if (n == -1) {
            throw new EOFException();
        }
        this.pageIndex = n;
        this.page = this.store.readPage(this.pageIndex);
        this.pos = 0;
        if (this.pageCount == this.pages.length) {
            int[] nArray = new int[this.pageCount + 1];
            System.arraycopy(this.pages, 0, nArray, 0, this.pageCount);
            this.pages = nArray;
        }
        this.pages[this.pageCount++] = this.pageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageIndex(int n) {
        return this.pages[n];
    }

    public int read() throws IOException {
        if (this.pos >= this.pageLen) {
            this.nextPage();
        }
        return this.page.readData(this.pos++);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos >= this.pageLen) {
            this.nextPage();
        }
        int n3 = this.page.readData(this.pos, byArray, n, n2);
        this.pos += n3;
        return n3;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.read(byArray, n + n4, n3 - n4);
            if (n5 == -1) {
                throw new EOFException();
            }
            n4 += n5;
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2 = n;
        while (n > 0) {
            int n3 = this.pageLen - this.pos;
            if (n3 > n) {
                this.pos += n;
                return n2;
            }
            n -= n3;
            this.nextPage();
        }
        return n2;
    }

    public boolean readBoolean() throws IOException {
        boolean bl = false;
        if (this.read() != 0) {
            bl = true;
        }
        return bl;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public short readShort() throws IOException {
        return (short)((this.read() << 8) + this.read());
    }

    public int readUnsignedShort() throws IOException {
        return (this.read() << 8) + this.read();
    }

    public char readChar() throws IOException {
        return (char)((this.read() << 8) + this.read());
    }

    public int readInt() throws IOException {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + this.read();
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.read();
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n4 = this.read();
                    if ((n4 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | n4 & 0x3F));
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    int n4 = this.read();
                    int n5 = this.read();
                    if ((n4 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (n4 & 0x3F) << 6 | n5 & 0x3F));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    private final /* synthetic */ void this() {
        this.pageIndex = -1;
    }

    public PageReader(AlarmStore alarmStore) throws IOException {
        this(alarmStore, -1);
    }

    public PageReader(AlarmStore alarmStore, int n) throws IOException {
        this.this();
        this.store = alarmStore;
        this.init(n);
    }
}

