/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class OpenIndex {
    private static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private IndexEntry first = null;
    private IndexEntry last = null;
    private int size = 0;

    public int getSize() {
        return this.size;
    }

    public IndexEntry getFirstEntry() {
        return this.first;
    }

    public void add(IndexEntry indexEntry) {
        if (indexEntry.isOpen()) {
            return;
        }
        indexEntry.setOpen(true);
        indexEntry.nextOpen = null;
        indexEntry.prevOpen = null;
        if (this.size == 0) {
            this.first = this.last = indexEntry;
        } else {
            IndexEntry indexEntry2 = indexEntry.prevTimestamp;
            while (indexEntry2 != null && !indexEntry2.isOpen()) {
                indexEntry2 = indexEntry2.prevTimestamp;
            }
            if (indexEntry2 == null) {
                if (this.first == null) {
                    this.first = this.last = indexEntry;
                } else {
                    indexEntry.nextOpen = this.first;
                    this.first.prevOpen = indexEntry;
                    this.first = indexEntry;
                }
            } else {
                indexEntry.nextOpen = indexEntry2.nextOpen;
                indexEntry.prevOpen = indexEntry2;
                if (indexEntry2.nextOpen != null) {
                    indexEntry2.nextOpen.prevOpen = indexEntry;
                }
                indexEntry2.nextOpen = indexEntry;
                if (indexEntry.prevOpen == this.last) {
                    this.last = indexEntry;
                }
            }
        }
        ++this.size;
    }

    public void remove(IndexEntry indexEntry) {
        if (this.size == 0 || indexEntry == null) {
            return;
        }
        if (!indexEntry.isOpen()) {
            return;
        }
        indexEntry.setOpen(false);
        if (indexEntry.prevOpen != null) {
            indexEntry.prevOpen.nextOpen = indexEntry.nextOpen;
        }
        if (indexEntry.nextOpen != null) {
            indexEntry.nextOpen.prevOpen = indexEntry.prevOpen;
        }
        if (indexEntry == this.first) {
            this.first = indexEntry.nextOpen;
        }
        if (indexEntry == this.last) {
            this.last = indexEntry.prevOpen;
        }
        indexEntry.nextOpen = null;
        indexEntry.prevOpen = null;
        --this.size;
    }

    public void dump() {
        IndexEntry indexEntry = this.first;
        int n = 0;
        while (indexEntry != null) {
            System.out.println(n++ + ") " + indexEntry.timestamp.toString((Context)showSecs) + " open=" + indexEntry.isOpen());
            indexEntry = indexEntry.nextOpen;
        }
    }

    public void verify() {
        IndexEntry indexEntry = null;
        IndexEntry indexEntry2 = this.first;
        int n = 0;
        while (indexEntry2 != null) {
            ++n;
            if (indexEntry != null && indexEntry.timestamp.isAfter(indexEntry2.timestamp)) {
                throw new IllegalStateException("Invalid ascending order.  " + indexEntry2.timestamp.toString((Context)showSecs) + " is before " + indexEntry.timestamp.toString((Context)showSecs));
            }
            if (!indexEntry2.isOpen()) {
                throw new IllegalStateException("Cleared alarm in open index, ascending. " + indexEntry2.timestamp.toString((Context)showSecs));
            }
            indexEntry = indexEntry2;
            indexEntry2 = indexEntry2.nextOpen;
        }
        if (this.size != n) {
            throw new IllegalStateException("Invalid ascending count. size=" + this.size + ", count=" + n);
        }
        indexEntry = null;
        indexEntry2 = this.last;
        n = 0;
        while (indexEntry2 != null) {
            ++n;
            if (indexEntry != null && indexEntry.timestamp.isBefore(indexEntry2.timestamp)) {
                throw new IllegalStateException("Invalid descending order.  " + indexEntry2.timestamp.toString((Context)showSecs) + " is after " + indexEntry.timestamp.toString((Context)showSecs));
            }
            if (!indexEntry2.isOpen()) {
                throw new IllegalStateException("Cleared alarm in open index, descending. " + indexEntry2.timestamp.toString((Context)showSecs));
            }
            indexEntry = indexEntry2;
            indexEntry2 = indexEntry2.prevOpen;
        }
        if (this.size != n) {
            throw new IllegalStateException("Invalid descending count. size=" + this.size + ", count=" + n);
        }
    }
}

