/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AckPendingIndex;
import com.tridium.alarm.db.file.AlarmSourceIndex;
import com.tridium.alarm.db.file.AlarmStoreHeader;
import com.tridium.alarm.db.file.Block;
import com.tridium.alarm.db.file.BlockCache;
import com.tridium.alarm.db.file.FreePageMap;
import com.tridium.alarm.db.file.IndexEntry;
import com.tridium.alarm.db.file.OpenIndex;
import com.tridium.alarm.db.file.Page;
import com.tridium.alarm.db.file.PageReader;
import com.tridium.alarm.db.file.TimestampIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.io.ByteBuffer;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlarmStore {
    private static final int BLOCK_CACHE_SIZE = 10;
    private static final int MAX_SIZE = 250000;
    private static final int MAX_SIZE_PER_SOURCE = 10000;
    private File alarmFile;
    private RandomAccessFile io;
    private int capacity;
    private AlarmStoreHeader header;
    private FreePageMap freeMap;
    private BlockCache blockCache;
    private ByteBuffer writeBuf;
    private PageReader reader;
    private int[] recPages;
    private HashMap byUuid;
    private TimestampIndex timestampIndex;
    private AlarmSourceIndex sourceIndex;
    private OpenIndex openIndex;
    private AckPendingIndex ackPendingIndex;
    private BAlarmRecord trimRec;
    private BAlarmService alarmService;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmClass;

    public AlarmStoreHeader getHeader() {
        return this.header;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public synchronized void open() throws IOException {
        this.byUuid = new HashMap();
        this.timestampIndex = new TimestampIndex(0.5, 250000);
        this.sourceIndex = new AlarmSourceIndex(0.5, 10000);
        this.openIndex = new OpenIndex();
        this.ackPendingIndex = new AckPendingIndex();
        this.blockCache = new BlockCache(this, 10);
        this.io = new RandomAccessFile(this.alarmFile, "rw");
        try {
            if (this.io.length() == 0L) {
                this.create();
            } else {
                this.init();
            }
        }
        catch (IOException iOException) {
            this.io.close();
            this.io = null;
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.io.close();
            this.io = null;
            throw runtimeException;
        }
        this.writeBuf = new ByteBuffer(this.header.getPageSize());
    }

    private final void create() throws IOException {
        this.header = new AlarmStoreHeader(new BAlarmRecord().getSerialVersionId());
        this.io.seek(0L);
        this.header.write(this.io);
        this.freeMap = new FreePageMap();
        BAlarmDatabase.log.message("Created");
    }

    private final void init() throws IOException {
        BAlarmDatabase.log.message("Loading...");
        this.header = new AlarmStoreHeader();
        this.io.seek(0L);
        this.header.read(this.io);
        int n = new BAlarmRecord().getSerialVersionId();
        if (this.header.getRecordVersion() != n) {
            throw new IOException("Incompatible record versions.  (expected=" + n + ", actual=" + this.header.getRecordVersion() + ')');
        }
        this.freeMap = new FreePageMap();
        int n2 = (int)((this.io.length() - this.header.getDataOffset()) / (long)this.header.getPageSize());
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        BAlarmRecord bAlarmRecord2 = new BAlarmRecord();
        long l = Clock.ticks();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            block11: {
                block13: {
                    block12: {
                        Page page = this.readPage(n4);
                        if (page.getPageOfRecord() != 0) break block11;
                        if ((bAlarmRecord = this.readRecord(n4, bAlarmRecord, this.freeMap)) != null) break block12;
                        if (++n3 == 20) {
                            throw new IOException("Alarm database is invalid.  Too many invalid records read during init.");
                        }
                        break block11;
                    }
                    IndexEntry indexEntry = (IndexEntry)this.byUuid.get(bAlarmRecord.getUuid());
                    if (indexEntry == null) break block13;
                    if ((bAlarmRecord2 = this.readRecord(indexEntry.pageIndex, bAlarmRecord2, null)).getLastUpdate().isAfter(bAlarmRecord.getLastUpdate())) break block11;
                    this.freePageRun(indexEntry.pageIndex);
                }
                this.addToIndices(bAlarmRecord, n4);
                BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
                if (bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) {
                    bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() + 1);
                    if (!bAlarmRecord.isAcknowledged()) {
                        bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() + 1);
                    }
                    if (bAlarmRecord.isOpen()) {
                        bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() + 1);
                    }
                    if (!bAlarmRecord.isNormal()) {
                        bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() + 1);
                    }
                }
            }
            ++n4;
        }
        long l2 = Clock.ticks();
        BAlarmDatabase.log.message("Loaded [" + (l2 - l) + "ms, " + this.getRecordCount() + " alarms, " + n2 + " pages]");
    }

    public synchronized void close() {
        if (this.io != null) {
            try {
                this.io.close();
            }
            catch (Exception exception) {}
            this.io = null;
        }
    }

    public synchronized void append(BAlarmRecord bAlarmRecord) throws IOException {
        if (!this.byUuid.containsKey(bAlarmRecord.getUuid())) {
            this.append(bAlarmRecord, false);
            this.trimToCapacity();
        } else {
            this.update(bAlarmRecord);
        }
    }

    private final synchronized void append(BAlarmRecord bAlarmRecord, boolean bl) throws IOException {
        Object object;
        this.writeBuf.reset();
        bAlarmRecord.write((DataOutput)this.writeBuf);
        bAlarmRecord.getUuid().encode((DataOutput)this.writeBuf);
        byte[] byArray = this.writeBuf.getBytes();
        int n = this.writeBuf.getLength();
        int n2 = 0;
        int n3 = this.header.getPageSize() - 12;
        int n4 = n / n3;
        if (n % n3 != 0) {
            ++n4;
        }
        int[] nArray = this.takePages(n4);
        if (!bl) {
            object = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (object.getName().equals(bAlarmRecord.getAlarmClass())) {
                object.setTotalAlarmCount(object.getTotalAlarmCount() + 1);
                if (!bAlarmRecord.isAcknowledged()) {
                    object.setUnackedAlarmCount(object.getUnackedAlarmCount() + 1);
                }
                if (bAlarmRecord.isOpen()) {
                    object.setOpenAlarmCount(object.getOpenAlarmCount() + 1);
                }
                if (!bAlarmRecord.isNormal()) {
                    object.setInAlarmCount(object.getInAlarmCount() + 1);
                }
            }
            this.addToIndices(bAlarmRecord, nArray[0]);
        } else {
            object = (IndexEntry)this.byUuid.get(bAlarmRecord.getUuid());
            BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            BAlarmRecord bAlarmRecord2 = this.readRecord(((IndexEntry)object).pageIndex, null);
            if (bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) {
                if (!((IndexEntry)object).isAcked() && bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
                } else if (((IndexEntry)object).isAcked() && !bAlarmRecord.isAcknowledged()) {
                    bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() + 1);
                }
                if (!((IndexEntry)object).isOpen() && bAlarmRecord.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() + 1);
                }
                if (((IndexEntry)object).isOpen() && !bAlarmRecord.isOpen()) {
                    bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
                }
                if (((IndexEntry)object).isNormal() && !bAlarmRecord.isNormal()) {
                    bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() + 1);
                }
                if (!((IndexEntry)object).isNormal() && bAlarmRecord.isNormal()) {
                    bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
                }
            }
            this.updateIndices(bAlarmRecord, bAlarmRecord2, nArray[0]);
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[n5];
            int n7 = n5 == n4 - 1 ? -1 : nArray[n5 + 1];
            Page page = this.readPage(n6);
            int n8 = Math.min(n - n2, n3);
            page.write(n5, n4, n7, byArray, n2, n8);
            n2 += n8;
            ++n5;
        }
        if (n2 != n) {
            throw new IOException("Write error: " + n2 + " of " + n + " bytes written.");
        }
    }

    public synchronized void update(BAlarmRecord bAlarmRecord) throws IOException {
        IndexEntry indexEntry = (IndexEntry)this.byUuid.get(bAlarmRecord.getUuid());
        int n = -1;
        if (indexEntry != null) {
            n = indexEntry.pageIndex;
        }
        boolean bl = false;
        if (indexEntry != null) {
            bl = true;
        }
        this.append(bAlarmRecord, bl);
        if (n != -1) {
            this.freePageRun(n);
        }
    }

    private final synchronized void remove(IndexEntry indexEntry, BAlarmRecord bAlarmRecord) throws IOException {
        if (indexEntry == null && bAlarmRecord == null) {
            return;
        }
        if (indexEntry == null && (indexEntry = (IndexEntry)this.byUuid.get(bAlarmRecord.getUuid())) == null) {
            return;
        }
        bAlarmRecord = this.readRecord(indexEntry.pageIndex, bAlarmRecord, null);
        this.byUuid.remove(bAlarmRecord.getUuid());
        this.timestampIndex.remove(indexEntry);
        this.sourceIndex.remove(bAlarmRecord.getSource(), indexEntry);
        if (indexEntry.isOpen()) {
            this.openIndex.remove(indexEntry);
        }
        if (indexEntry.isAckPending()) {
            this.ackPendingIndex.remove(indexEntry);
        }
        this.freePageRun(indexEntry.pageIndex);
        BAlarmClass bAlarmClass = this.alarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass.getName().equals(bAlarmRecord.getAlarmClass())) {
            bAlarmClass.setTotalAlarmCount(bAlarmClass.getTotalAlarmCount() - 1);
            if (!bAlarmRecord.isAcknowledged()) {
                bAlarmClass.setUnackedAlarmCount(bAlarmClass.getUnackedAlarmCount() - 1);
            }
            if (bAlarmRecord.isOpen()) {
                bAlarmClass.setOpenAlarmCount(bAlarmClass.getOpenAlarmCount() - 1);
            }
            if (!bAlarmRecord.isNormal()) {
                bAlarmClass.setInAlarmCount(bAlarmClass.getInAlarmCount() - 1);
            }
        }
        indexEntry.nextTimestamp = null;
        indexEntry.prevTimestamp = null;
        indexEntry.nextSource = null;
        indexEntry.prevSource = null;
        indexEntry = null;
    }

    private final synchronized void addToIndices(BAlarmRecord bAlarmRecord, int n) {
        IndexEntry indexEntry = new IndexEntry(bAlarmRecord, n);
        this.byUuid.put(bAlarmRecord.getUuid(), indexEntry);
        this.timestampIndex.add(indexEntry);
        this.sourceIndex.add(bAlarmRecord.getSource(), indexEntry);
        if (bAlarmRecord.isOpen()) {
            this.openIndex.add(indexEntry);
        }
        if (bAlarmRecord.isAckPending()) {
            this.ackPendingIndex.add(indexEntry);
        }
        indexEntry.setAcked(bAlarmRecord.isAcknowledged());
        indexEntry.setNormal(bAlarmRecord.isNormal());
        indexEntry.setAckPending(bAlarmRecord.isAckPending());
    }

    private final synchronized void updateIndices(BAlarmRecord bAlarmRecord, BAlarmRecord bAlarmRecord2, int n) {
        IndexEntry indexEntry = (IndexEntry)this.byUuid.get(bAlarmRecord.getUuid());
        if (indexEntry != null) {
            this.byUuid.remove(bAlarmRecord.getUuid());
            this.timestampIndex.remove(indexEntry);
            this.sourceIndex.remove(bAlarmRecord2.getSource(), indexEntry);
            if (indexEntry.isOpen()) {
                this.openIndex.remove(indexEntry);
            }
            if (indexEntry.isAckPending()) {
                this.ackPendingIndex.remove(indexEntry);
            }
        }
        this.addToIndices(bAlarmRecord, n);
    }

    public synchronized void flush() throws IOException {
        this.blockCache.flush();
    }

    public synchronized int getRecordCount() {
        return this.timestampIndex.getSize();
    }

    public synchronized BAlarmRecord getRecord(BUuid bUuid) throws IOException {
        IndexEntry indexEntry = (IndexEntry)this.byUuid.get(bUuid);
        if (indexEntry != null) {
            return this.readRecord(indexEntry.pageIndex, null);
        }
        return null;
    }

    public synchronized Cursor scan() {
        return new TimestampCursor(this, this.timestampIndex.getFirstEntry(), null);
    }

    public synchronized Cursor timeQuery(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        IndexEntry indexEntry = null;
        if (bAbsTime == null || bAbsTime.isNull()) {
            indexEntry = this.timestampIndex.getFirstEntry();
        } else {
            indexEntry = this.timestampIndex.find(bAbsTime);
            if (indexEntry != null) {
                indexEntry = indexEntry.nextTimestamp[0];
            }
        }
        return new TimestampCursor(this, indexEntry, bAbsTime2);
    }

    public synchronized Cursor getAlarmsForSource(BOrdList bOrdList) throws IOException {
        IndexEntry indexEntry = this.sourceIndex.getListForSource(bOrdList);
        return new SourceCursor(this, indexEntry, null);
    }

    public synchronized Cursor getOpenAlarms() throws IOException {
        IndexEntry indexEntry = this.openIndex.getFirstEntry();
        return new OpenCursor(this, indexEntry, null);
    }

    public synchronized Cursor getAckPendingAlarms() throws IOException {
        IndexEntry indexEntry = this.ackPendingIndex.getFirstEntry();
        return new AckPendingCursor(this, indexEntry, null);
    }

    private final synchronized int[] takePages(int n) throws IOException {
        if (this.recPages == null || this.recPages.length < n) {
            this.recPages = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.recPages[n2] = this.nextFreePage();
            this.freeMap.setFree(this.recPages[n2], false);
            ++n2;
        }
        return this.recPages;
    }

    private final synchronized void freePageRun(int n) throws IOException {
        int n2 = n;
        do {
            Page page;
            if ((page = this.readPage(n2)) == null) {
                return;
            }
            this.freeMap.setFree(n2, true);
            n2 = page.getNextPage();
            page.clear();
        } while (n2 != -1);
    }

    private final synchronized int nextFreePage() throws IOException {
        int n = this.freeMap.getFreePage();
        if (n == -1) {
            this.grow();
        }
        if ((n = this.freeMap.getFreePage()) == -1) {
            throw new IOException("Cannot allocate a new page.");
        }
        return n;
    }

    public synchronized Page readPage(int n) throws IOException {
        int n2 = this.header.getPagesPerBlock();
        int n3 = n / n2;
        int n4 = n - n3 * n2;
        return this.getBlock(n3).getPage(n4);
    }

    private final synchronized void grow() throws IOException {
        int n = this.header.getPageSize();
        int n2 = this.header.getPagesPerBlock();
        int n3 = n * n2;
        int n4 = (int)((this.io.length() - this.header.getDataOffset()) / (long)n3);
        Block block = new Block(this, n4);
        block.clear();
        this.io.seek(this.io.length());
        block.write(this.io);
        this.freeMap.addFreePages(this.header.getPagesPerBlock());
    }

    synchronized Block getBlock(int n) throws IOException {
        Block block = this.blockCache.getBlock(n);
        if (block == null) {
            block = this.readBlock(n);
            this.blockCache.add(block);
        }
        return block;
    }

    synchronized Block readBlock(int n) throws IOException {
        Block block = new Block(this, n);
        long l = this.header.getDataOffset() + (long)(n * block.getSize());
        this.io.seek(l);
        block.read(this.io);
        return block;
    }

    synchronized void writeBlock(Block block) throws IOException {
        if (!block.isDirty()) {
            return;
        }
        int n = block.getIndex();
        long l = this.header.getDataOffset() + (long)(n * block.getSize());
        this.io.seek(l);
        block.write(this.io);
    }

    public BAlarmRecord readRecord(int n, BAlarmRecord bAlarmRecord) throws IOException {
        return this.readRecord(n, bAlarmRecord, null);
    }

    public synchronized BAlarmRecord readRecord(int n, BAlarmRecord bAlarmRecord, FreePageMap freePageMap) throws IOException {
        if (bAlarmRecord == null) {
            bAlarmRecord = new BAlarmRecord();
        }
        if (this.reader == null) {
            this.reader = new PageReader(this, n);
        } else {
            this.reader.init(n);
        }
        try {
            bAlarmRecord.read(this.reader);
        }
        catch (Exception exception) {
            BAlarmDatabase.log.error("Unable to read record", (Throwable)exception);
            return null;
        }
        BUuid bUuid = (BUuid)BUuid.DEFAULT.decode((DataInput)this.reader);
        if (!bAlarmRecord.getUuid().equals((Object)bUuid)) {
            return null;
        }
        if (freePageMap != null) {
            int n2 = this.reader.getPageCount();
            int n3 = 0;
            while (n3 < n2) {
                freePageMap.setFree(this.reader.getPageIndex(n3), false);
                ++n3;
            }
        }
        return bAlarmRecord;
    }

    public synchronized void trimToCapacity() throws IOException {
        if (this.timestampIndex.getSize() > this.capacity) {
            if (this.trimRec == null) {
                this.trimRec = new BAlarmRecord();
            }
            while (this.timestampIndex.getSize() > this.capacity) {
                this.remove(this.timestampIndex.getFirstEntry(), this.trimRec);
            }
        }
    }

    public synchronized void clearAllRecords(Context context) throws IOException {
        this.close();
        Class clazz = class$javax$baja$alarm$BAlarmClass;
        if (clazz == null) {
            clazz = class$javax$baja$alarm$BAlarmClass = AlarmStore.class("[Ljavax.baja.alarm.BAlarmClass;", false);
        }
        BAlarmClass[] bAlarmClassArray = (BAlarmClass[])this.alarmService.getChildren(clazz);
        int n = 0;
        while (n < bAlarmClassArray.length) {
            bAlarmClassArray[n].setTotalAlarmCount(0);
            bAlarmClassArray[n].setUnackedAlarmCount(0);
            bAlarmClassArray[n].setOpenAlarmCount(0);
            bAlarmClassArray[n].setInAlarmCount(0);
            ++n;
        }
        if (!this.alarmFile.delete()) {
            this.open();
            throw new IOException("Cannot delete alarm history file: " + this.alarmFile.getAbsolutePath());
        }
        this.open();
    }

    public synchronized void clearOldRecords(BAbsTime bAbsTime, Context context) throws IOException {
        if (this.timestampIndex.getSize() == 0) {
            return;
        }
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        while (this.timestampIndex.getSize() > 0) {
            IndexEntry indexEntry = this.timestampIndex.getFirstEntry();
            if (!indexEntry.timestamp.isBefore(bAbsTime)) break;
            this.remove(indexEntry, bAlarmRecord);
        }
    }

    public synchronized void clearRecord(BUuid bUuid, Context context) throws IOException {
        if (this.byUuid.size() == 0) {
            return;
        }
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        IndexEntry indexEntry = (IndexEntry)this.byUuid.get(bUuid);
        if (indexEntry != null) {
            this.remove(indexEntry, bAlarmRecord);
        }
    }

    public void analyze(PrintStream printStream) {
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###");
        DecimalFormat decimalFormat2 = new DecimalFormat("###,###,###.##");
        DecimalFormat decimalFormat3 = new DecimalFormat("###,###,###");
        printStream.println("db file     : " + this.alarmFile.getAbsolutePath());
        printStream.println("file size   : " + decimalFormat.format(this.alarmFile.length()));
        printStream.println("capacity    : " + this.capacity);
        printStream.println("record count: " + this.timestampIndex.getSize());
        printStream.println("free map    : " + decimalFormat3.format(this.freeMap.getSizeInBytes()) + " bytes");
        this.timestampIndex.analyze("timestamp index", printStream);
        printStream.println();
        int n = this.timestampIndex.getSize() * 21;
        printStream.println("non-list entry ram: " + decimalFormat2.format((double)n / 1024.0 / 1024.0) + " MB");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AlarmStore(File file, int n) {
        this.alarmFile = file;
        this.capacity = n;
        this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    private static class TimestampCursor
    extends AlarmStoreCursor {
        public IndexEntry nextEntry(IndexEntry indexEntry) {
            if (indexEntry.nextTimestamp == null) {
                return null;
            }
            return indexEntry.nextTimestamp[0];
        }

        public TimestampCursor(AlarmStore alarmStore, IndexEntry indexEntry, BAbsTime bAbsTime) {
            super(alarmStore, indexEntry, bAbsTime);
        }
    }

    private static class SourceCursor
    extends AlarmStoreCursor {
        public IndexEntry nextEntry(IndexEntry indexEntry) {
            if (indexEntry.nextSource == null) {
                return null;
            }
            return indexEntry.nextSource[0];
        }

        public SourceCursor(AlarmStore alarmStore, IndexEntry indexEntry, BAbsTime bAbsTime) {
            super(alarmStore, indexEntry, bAbsTime);
        }
    }

    private static class OpenCursor
    extends AlarmStoreCursor {
        public IndexEntry nextEntry(IndexEntry indexEntry) {
            return indexEntry.nextOpen;
        }

        public OpenCursor(AlarmStore alarmStore, IndexEntry indexEntry, BAbsTime bAbsTime) {
            super(alarmStore, indexEntry, bAbsTime);
        }
    }

    private static class AckPendingCursor
    extends AlarmStoreCursor {
        public IndexEntry nextEntry(IndexEntry indexEntry) {
            return indexEntry.nextAckPending;
        }

        public AckPendingCursor(AlarmStore alarmStore, IndexEntry indexEntry, BAbsTime bAbsTime) {
            super(alarmStore, indexEntry, bAbsTime);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static abstract class AlarmStoreCursor
    implements Cursor {
        boolean init = true;
        AlarmStore store;
        IndexEntry entry;
        BAlarmRecord rec;
        BAbsTime endTime;
        static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

        public Context getContext() {
            return null;
        }

        public BObject get() {
            if (this.init) {
                throw new IllegalStateException("get() before next()");
            }
            if (this.entry != null) {
                return this.rec;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public boolean next() {
            if (this.entry == null) {
                return false;
            }
            if (this.init) {
                this.init = false;
                try {
                    AlarmStore alarmStore = this.store;
                    // MONITORENTER : alarmStore
                    if (this.store.io == null) {
                        throw new IllegalStateException("Alarm database is closed.");
                    }
                    if (-1 == this.store.readPage(this.entry.pageIndex).getPageOfRecord()) {
                        // MONITOREXIT : alarmStore
                        return false;
                    }
                    if (!this.store.readRecord(this.entry.pageIndex, this.rec).getTimestamp().equals((Object)this.entry.timestamp)) {
                        // MONITOREXIT : alarmStore
                        return false;
                    }
                    // MONITOREXIT : alarmStore
                }
                catch (Exception exception) {
                    BAlarmDatabase.log.error("Unable to read record", (Throwable)exception);
                    return false;
                }
                if (this.endTime == null) return true;
                if (!this.rec.getTimestamp().isAfter(this.endTime)) return true;
                this.entry = null;
                return false;
            }
            this.entry = this.nextEntry(this.entry);
            if (this.entry == null) {
                this.rec = null;
                return false;
            }
            try {
                AlarmStore alarmStore = this.store;
                // MONITORENTER : alarmStore
                if (this.store.io == null) {
                    throw new IllegalStateException("Alarm database is closed.");
                }
                if (-1 == this.store.readPage(this.entry.pageIndex).getPageOfRecord()) {
                    // MONITOREXIT : alarmStore
                    return false;
                }
                if (!this.store.readRecord(this.entry.pageIndex, this.rec).getTimestamp().equals((Object)this.entry.timestamp)) {
                    // MONITOREXIT : alarmStore
                    return false;
                }
                // MONITOREXIT : alarmStore
            }
            catch (Exception exception) {
                BAlarmDatabase.log.error("Unable to read record", (Throwable)exception);
                return false;
            }
            if (this.endTime == null) return true;
            if (!this.rec.getTimestamp().isAfter(this.endTime)) return true;
            this.entry = null;
            return false;
        }

        public boolean next(Class clazz) {
            Class clazz2 = class$javax$baja$alarm$BAlarmRecord;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$alarm$BAlarmRecord = AlarmStoreCursor.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
            }
            if (clazz2.equals(clazz)) {
                return this.next();
            }
            this.entry = null;
            return false;
        }

        public boolean nextComponent() {
            this.entry = null;
            return false;
        }

        protected abstract IndexEntry nextEntry(IndexEntry var1);

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public AlarmStoreCursor(AlarmStore alarmStore, IndexEntry indexEntry, BAbsTime bAbsTime) {
            this.store = alarmStore;
            this.entry = indexEntry;
            this.rec = new BAlarmRecord();
            this.endTime = bAbsTime;
            if (this.endTime != null && this.endTime.isNull()) {
                this.endTime = null;
            }
        }
    }
}

