/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ack;

import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BAlarmAcknowledger
extends BComponent
implements BIStatus {
    public static final Property status = BAlarmAcknowledger.newProperty((int)2051, (BValue)BStatus.ok, null);
    public static final Property enabled = BAlarmAcknowledger.newProperty((int)0, (boolean)true, null);
    public static final Property ackAlarmsFromSameSource = BAlarmAcknowledger.newProperty((int)0, (boolean)true, null);
    public static final Property lastAlarmAcked = BAlarmAcknowledger.newProperty((int)2115, (String)"", null);
    public static final Property lastAlarmAckedTime = BAlarmAcknowledger.newProperty((int)2115, (BValue)BAbsTime.NULL, null);
    public static final Property lastAlarmAckedFailureTime = BAlarmAcknowledger.newProperty((int)2115, (BValue)BAbsTime.NULL, null);
    public static final Property lastAlarmAckedFailureCause = BAlarmAcknowledger.newProperty((int)2115, (String)"", null);
    public static final Property totalAlarmsAckedToday = BAlarmAcknowledger.newProperty((int)2115, (int)0, null);
    public static final Property totalAlarmAckedFailures = BAlarmAcknowledger.newProperty((int)2115, (int)0, null);
    public static final Property totalMessagesReceivedToday = BAlarmAcknowledger.newProperty((int)2115, (int)0, null);
    public static final Action resetTotals = BAlarmAcknowledger.newAction((int)20, null);
    public static final Topic alarmAcked = BAlarmAcknowledger.newTopic((int)0, null);
    public static final Type TYPE;
    protected static final String UUID_TEXT = "UUID:";
    protected static final int UUID_LENGTH = 36;
    protected static final Log log;
    private static Worker worker;
    private static final Object compRefCountMonitor;
    private static int compRefCount;
    private Clock.Ticket resetTicket;
    static /* synthetic */ Class class$com$tridium$alarm$ack$BAlarmAcknowledger;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public boolean getAckAlarmsFromSameSource() {
        return this.getBoolean(ackAlarmsFromSameSource);
    }

    public void setAckAlarmsFromSameSource(boolean bl) {
        this.setBoolean(ackAlarmsFromSameSource, bl, null);
    }

    public String getLastAlarmAcked() {
        return this.getString(lastAlarmAcked);
    }

    public void setLastAlarmAcked(String string) {
        this.setString(lastAlarmAcked, string, null);
    }

    public BAbsTime getLastAlarmAckedTime() {
        return (BAbsTime)this.get(lastAlarmAckedTime);
    }

    public void setLastAlarmAckedTime(BAbsTime bAbsTime) {
        this.set(lastAlarmAckedTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastAlarmAckedFailureTime() {
        return (BAbsTime)this.get(lastAlarmAckedFailureTime);
    }

    public void setLastAlarmAckedFailureTime(BAbsTime bAbsTime) {
        this.set(lastAlarmAckedFailureTime, (BValue)bAbsTime, null);
    }

    public String getLastAlarmAckedFailureCause() {
        return this.getString(lastAlarmAckedFailureCause);
    }

    public void setLastAlarmAckedFailureCause(String string) {
        this.setString(lastAlarmAckedFailureCause, string, null);
    }

    public int getTotalAlarmsAckedToday() {
        return this.getInt(totalAlarmsAckedToday);
    }

    public void setTotalAlarmsAckedToday(int n) {
        this.setInt(totalAlarmsAckedToday, n, null);
    }

    public int getTotalAlarmAckedFailures() {
        return this.getInt(totalAlarmAckedFailures);
    }

    public void setTotalAlarmAckedFailures(int n) {
        this.setInt(totalAlarmAckedFailures, n, null);
    }

    public int getTotalMessagesReceivedToday() {
        return this.getInt(totalMessagesReceivedToday);
    }

    public void setTotalMessagesReceivedToday(int n) {
        this.setInt(totalMessagesReceivedToday, n, null);
    }

    public void resetTotals() {
        this.invoke(resetTotals, null, null);
    }

    public void fireAlarmAcked(BAlarmRecord bAlarmRecord) {
        this.fire(alarmAcked, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fwStarted() {
        block4: {
            this.setStatus(this.getEnabled() ? BStatus.ok : BStatus.disabled);
            Object object = compRefCountMonitor;
            synchronized (object) {
                int n = ++compRefCount;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_1
                if (n != 1) break block4;
            }
            if (log.isTraceOn()) {
                log.trace("Starting Alarm Acknowledger Worker");
            }
            worker = new Worker((Worker.ITodo)new Queue(512));
            worker.start("alarmAcknowledger");
        }
        this.startMidnightReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fwStopped() {
        block5: {
            if (this.resetTicket != null) {
                this.resetTicket.cancel();
                this.resetTicket = null;
            }
            Object object = compRefCountMonitor;
            synchronized (object) {
                int n = --compRefCount;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var2_1
                if (n > 0) break block5;
            }
            if (log.isTraceOn()) {
                log.trace("Stopping Alarm Acknowledger Worker");
            }
            worker.stop();
            worker = null;
        }
    }

    private final void fwChanged(Property property) {
        if (this.isRunning() && property == enabled) {
            this.setStatus(this.getEnabled() ? BStatus.ok : BStatus.disabled);
        }
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == resetTotals) {
            this.post((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    private final void incTotalAlarmsAckedToday() {
        int n = this.getTotalAlarmsAckedToday();
        if (++n >= Integer.MAX_VALUE) {
            n = 0;
        }
        this.setTotalAlarmsAckedToday(n);
    }

    protected final void incTotalAlarmAckedFailures() {
        int n = this.getTotalAlarmAckedFailures();
        if (++n >= Integer.MAX_VALUE) {
            n = 0;
        }
        this.setTotalAlarmAckedFailures(n);
    }

    protected final void incTotalMessagesReceivedToday() {
        int n = this.getTotalMessagesReceivedToday();
        if (++n >= Integer.MAX_VALUE) {
            n = 0;
        }
        this.setTotalMessagesReceivedToday(n);
    }

    public final void doResetTotals() {
        this.setTotalAlarmsAckedToday(0);
        this.setTotalAlarmAckedFailures(0);
        this.setTotalMessagesReceivedToday(0);
        this.startMidnightReset();
    }

    protected final void doFail(String string) {
        this.setLastAlarmAckedFailureCause(string);
        this.setLastAlarmAckedFailureTime(BAbsTime.now());
        this.incTotalAlarmAckedFailures();
    }

    protected final void ackAlarm(BUuid bUuid, String string) {
        try {
            BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BAlarmRecord bAlarmRecord = (BAlarmRecord)bAlarmService.getAlarmDb().getRecord(bUuid).newCopy(true);
            if (bAlarmRecord == null) {
                this.doFail("Could not find alarm record to ack (" + this.getType() + ')');
                return;
            }
            if (!bAlarmRecord.isAcknowledged()) {
                bAlarmRecord.ackAlarm(string);
                bAlarmRecord.setAckState(BAckState.ackPending);
                bAlarmService.getAlarmDb().update(bAlarmRecord);
                this.setLastAlarmAcked(bAlarmRecord.getUuid().encodeToString());
                bAlarmService.ackAlarm(bAlarmRecord);
                this.fireAlarmAcked(bAlarmRecord);
                this.incTotalAlarmsAckedToday();
                this.setLastAlarmAckedTime(BAbsTime.now());
                if (log.isTraceOn()) {
                    log.trace(this.getType() + " acknowledged " + bAlarmRecord.getUuid());
                }
            } else if (log.isTraceOn()) {
                log.trace(this.getType() + " already acknowledged " + bAlarmRecord.getUuid());
            }
            if (this.getAckAlarmsFromSameSource()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("alarm:|bql:select from openAlarms where ackState != 'acked' and source='");
                stringBuffer.append(SlotPath.escape((String)bAlarmRecord.getSource().encodeToString()));
                stringBuffer.append("'");
                BITable bITable = (BITable)BOrd.make((String)stringBuffer.toString()).get((BObject)this);
                Cursor cursor = bITable.cursor();
                Class clazz = class$javax$baja$alarm$BAlarmRecord;
                if (clazz == null) {
                    clazz = class$javax$baja$alarm$BAlarmRecord = BAlarmAcknowledger.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
                }
                Array array = new Array(clazz);
                while (cursor.next()) {
                    array.add((Object)cursor.get().asValue().newCopy(true));
                }
                boolean bl = false;
                BAlarmRecord[] bAlarmRecordArray = (BAlarmRecord[])array.trim();
                int n = 0;
                while (n < bAlarmRecordArray.length) {
                    BAlarmRecord bAlarmRecord2 = (BAlarmRecord)bAlarmRecordArray[n].newCopy(true);
                    bAlarmRecord2.ackAlarm(string);
                    bAlarmRecord2.setAckState(BAckState.ackPending);
                    bAlarmService.getAlarmDb().update(bAlarmRecord2);
                    bAlarmService.ackAlarm(bAlarmRecord2);
                    this.fireAlarmAcked(bAlarmRecord2);
                    this.setLastAlarmAcked(bAlarmRecordArray[n].getUuid().encodeToString());
                    this.incTotalAlarmsAckedToday();
                    bl = true;
                    if (log.isTraceOn()) {
                        log.trace(this.getType() + " also acknowledged " + bAlarmRecordArray[n].getUuid());
                    }
                    ++n;
                }
                if (bl) {
                    this.setLastAlarmAckedTime(BAbsTime.now());
                }
            }
        }
        catch (Exception exception) {
            String string2 = "Failure to acknowledge alarm (" + this.getType() + ')';
            log.error(string2, (Throwable)exception);
            this.doFail(string2);
        }
    }

    protected final void post(Runnable runnable) {
        ((Queue)worker.getTodo()).enqueue((Object)runnable);
    }

    private final void startMidnightReset() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
        }
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = bAbsTime.nextDay();
        BAbsTime bAbsTime3 = bAbsTime2.timeOfDay(0, 0, 0, 0);
        this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime3, (Action)resetTotals, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.resetTicket = null;
    }

    public BAlarmAcknowledger() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$alarm$ack$BAlarmAcknowledger;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$ack$BAlarmAcknowledger = BAlarmAcknowledger.class("[Lcom.tridium.alarm.ack.BAlarmAcknowledger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"alarm.acknowledger");
        worker = null;
        compRefCountMonitor = new Object();
        compRefCount = 0;
    }
}

