/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIRemoteAlarmRecipient;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BStationRecipient
extends BAlarmRecipient {
    public static final Property transitions = BStationRecipient.newProperty((int)0, (BValue)BAlarmTransitionBits.ALL, (BFacets)BFacets.make((String[])new String[]{"showNormal"}, (BIDataValue[])new BBoolean[]{BBoolean.FALSE}));
    public static final Property routeAcks = BStationRecipient.newProperty((int)1, (boolean)true, null);
    public static final Property remoteStation = BStationRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:RemoteStationFE")));
    public static final Type TYPE;
    public static final Lexicon lex;
    private static final BIcon icon;
    private static final Log log;
    static /* synthetic */ Class class$com$tridium$alarm$BStationRecipient;

    public BAlarmTransitionBits getTransitions() {
        return (BAlarmTransitionBits)this.get(transitions);
    }

    public void setTransitions(BAlarmTransitionBits bAlarmTransitionBits) {
        this.set(transitions, (BValue)bAlarmTransitionBits, null);
    }

    public boolean getRouteAcks() {
        return this.getBoolean(routeAcks);
    }

    public void setRouteAcks(boolean bl) {
        this.setBoolean(routeAcks, bl, null);
    }

    public String getRemoteStation() {
        return this.getString(remoteStation);
    }

    public void setRemoteStation(String string) {
        this.setString(remoteStation, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        try {
            BIRemoteAlarmRecipient bIRemoteAlarmRecipient = this.getAlarmDeviceExt();
            if (bIRemoteAlarmRecipient == null) {
                return;
            }
            bIRemoteAlarmRecipient.routeAlarm(bAlarmRecord);
        }
        catch (Exception exception) {}
    }

    private final NiagaraStation getStation() throws Exception {
        Type type = Sys.getType((String)"niagaraDriver:NiagaraNetwork");
        NiagaraNetwork niagaraNetwork = (NiagaraNetwork)Sys.getService((Type)type);
        BComponent bComponent = (BComponent)niagaraNetwork.getStation(this.getRemoteStation());
        if (bComponent == null) {
            log.error(this.getName() + ": Station '" + this.getRemoteStation() + "' not Configured in the Database");
            throw new Exception("Station '" + this.getRemoteStation() + "' not Configured in the Database");
        }
        return (NiagaraStation)bComponent;
    }

    private final BIRemoteAlarmRecipient getAlarmDeviceExt() throws Exception {
        BComponent bComponent = (BComponent)this.getStation();
        if (!((BBoolean)bComponent.get("enabled")).getBoolean()) {
            return null;
        }
        return (BIRemoteAlarmRecipient)bComponent.get("alarms");
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$alarm$BStationRecipient;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$BStationRecipient = BStationRecipient.class("[Lcom.tridium.alarm.BStationRecipient;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"baja");
        icon = BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
        log = Log.getLog((String)"alarm");
    }
}

