/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmConsoleChannel
extends BFoxChannel {
    public static final Action routeAlarmAcks = BAlarmConsoleChannel.newAction((int)4, null);
    public static final Type TYPE;
    public static final Object channelMutex;
    Array newList;
    Array ackList;
    Worker worker;
    static /* synthetic */ Class class$com$tridium$alarm$BAlarmConsoleChannel;
    static /* synthetic */ Class class$com$tridium$fox$message$FoxMessage;
    static /* synthetic */ Class class$javax$baja$alarm$BAlarmRecord;
    static /* synthetic */ Class class$java$lang$String;

    public void routeAlarmAcks() {
        this.invoke(routeAlarmAcks, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void startWorker() throws Exception {
        try {
            if (this.getConnection() != null && this.getConnection().getParentStation() == null && this.worker == null) {
                this.worker = new Worker();
                this.worker.start();
            }
        }
        catch (Exception exception) {}
    }

    public void stopWorker() throws Exception {
        if (this.worker != null) {
            this.worker.kill();
        }
        this.worker = null;
    }

    public void stopped() throws Exception {
        this.stopWorker();
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (this.isTraceOn()) {
            this.trace("AlarmConsoleChannel: command = " + string);
        }
        if (string == "ack") {
            return this.ackAlarms(foxRequest);
        }
        if (string == "updateAlarm") {
            return this.updateAlarm(foxRequest);
        }
        if (string == "getInitialAlarmQuery") {
            return this.getInitialAlarmQuery(foxRequest);
        }
        if (string == "unregister") {
            return this.unregister(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public void newAlarm(BConsoleRecipient bConsoleRecipient, BAlarmRecord bAlarmRecord) throws Exception {
        BAlarmService bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
        if (bAlarmClass == null) {
            bAlarmClass = bAlarmService.getDefaultAlarmClass();
        }
        BUser bUser = this.getSessionContext().getUser();
        bUser.check((BIProtected)bAlarmClass, BPermissions.operatorRead);
        FoxMessage foxMessage = new FoxMessage("alarmRec");
        foxMessage.add("alarm", FoxAlarmCodec.encodeAlarm(bAlarmRecord));
        String string = bConsoleRecipient.getOrdInSession().encodeToString();
        foxMessage.add("ord", string);
        this.newList.add((Object)foxMessage);
    }

    private final FoxResponse ackAlarms(FoxRequest foxRequest) throws Exception {
        BAlarmService bAlarmService;
        if (this.isTraceOn()) {
            this.trace("received: ack");
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BUser bUser = this.getSessionContext().getUser();
        try {
            bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
        FoxTuple[] foxTupleArray = foxRequest.list("alarm");
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BAlarmConsoleChannel.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < foxTupleArray.length) {
            BAlarmRecord bAlarmRecord = null;
            try {
                bAlarmRecord = FoxAlarmCodec.decodeAlarm((FoxMessage)foxTupleArray[n]);
                BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
                if (bAlarmClass == null) {
                    bAlarmClass = bAlarmService.getDefaultAlarmClass();
                }
                bUser.check((BIProtected)bAlarmClass, BPermissions.operatorWrite);
                this.ackList.add((Object)bAlarmRecord);
            }
            catch (PermissionException permissionException) {
                bAlarmRecord.setAckState(BAckState.unacked);
                FoxMessage foxMessage = new FoxMessage("alarmRec");
                foxMessage.add("alarm", FoxAlarmCodec.encodeAlarm(bAlarmRecord));
                foxMessage.add("ord", foxRequest.getString("ord"));
                this.newList.add((Object)foxMessage);
                if (!array.contains((Object)bAlarmRecord.getAlarmClass())) {
                    array.add((Object)bAlarmRecord.getAlarmClass());
                    this.error(foxRequest.getString("ord"), "Cannot ack alarms from Alarm Class: " + bAlarmRecord.getAlarmClass(), (Throwable)permissionException);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        this.routeAlarmAcks();
        return null;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == routeAlarmAcks) {
            Queue queue = (Queue)((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).fw(601);
            queue.enqueue((Object)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRouteAlarmAcks() {
        var1_1 = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        var2_2 = new BAlarmRecord[]{};
        var3_3 = this.ackList;
        synchronized (var3_3) {
            var2_2 = (BAlarmRecord[])this.ackList.trim();
            this.ackList.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
            var5_4 = 0;
            if (true) ** GOTO lbl34
        }
        do {
            var6_5 = var2_2[var5_4];
            try {
                if (this.isTraceOn()) {
                    this.trace("BAlarmChannel: ack -> routeAlarm: " + var6_5.getTimestamp() + ' ');
                }
                if ((var7_6 = var1_1.getAlarmDb().getRecord(var6_5.getUuid())) == null || var7_6.getAckState() != BAckState.acked) {
                    var6_5.setLastUpdate(BAbsTime.now());
                    var8_8 = var6_5.getAlarmData();
                    if (var7_6 != null) {
                        var8_8 = BFacets.make((BFacets)var6_5.getAlarmData(), (BFacets)var7_6.getAlarmData());
                    }
                    if ((var9_9 = var6_5.getAlarmData().gets("notes", null)) != null) {
                        var8_8 = BFacets.make((BFacets)var8_8, (BFacets)BFacets.make((String)"notes", (String)var9_9));
                    }
                    var6_5.setAlarmData(var8_8);
                    if (var7_6 != null && var6_5.getNormalTime().isBefore(var7_6.getNormalTime())) {
                        var6_5.setNormalTime(var7_6.getNormalTime());
                    }
                    var1_1.getAlarmDb().update(var6_5);
                }
                var1_1.doAckAlarm(var6_5);
            }
            catch (Exception var7_7) {
                var7_7.printStackTrace();
            }
            ++var5_4;
lbl34:
            // 2 sources

        } while (var5_4 < var2_2.length);
    }

    private final FoxResponse getInitialAlarmQuery(FoxRequest foxRequest) throws Exception {
        BConsoleRecipient bConsoleRecipient;
        Object object;
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            object = (BOrd)BOrd.DEFAULT.decodeFromString(foxRequest.getString("ord"));
            bConsoleRecipient = (BConsoleRecipient)object.resolve().get();
            bConsoleRecipient.registerAlarmChannel(this);
        }
        catch (Exception exception) {
            foxResponse.add("error", exception.toString());
            return foxResponse;
        }
        object = bConsoleRecipient.getInitialAlarmQuery(this.getSessionContext().getUser());
        foxResponse.add("query", ((String)object).toString());
        return foxResponse;
    }

    public void error(BConsoleRecipient bConsoleRecipient, String string, Throwable throwable) throws Exception {
        String string2 = bConsoleRecipient.getOrdInSession().encodeToString();
        this.error(string2, string, throwable);
    }

    private final void error(String string, String string2, Throwable throwable) throws Exception {
        FoxRequest foxRequest = this.makeRequest("error");
        foxRequest.add("msg", string2);
        foxRequest.add("error", throwable.toString());
        foxRequest.add("ord", string);
        this.sendAsync(foxRequest);
    }

    private final FoxResponse unregister(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            BOrd bOrd = (BOrd)BOrd.DEFAULT.decodeFromString(foxRequest.getString("ord"));
            BConsoleRecipient bConsoleRecipient = (BConsoleRecipient)bOrd.resolve().get();
            bConsoleRecipient.unregisterAlarmChannel(this);
        }
        catch (Exception exception) {
            foxResponse.add("error", exception.toString());
        }
        return foxResponse;
    }

    private final FoxResponse updateAlarm(FoxRequest foxRequest) throws Exception {
        BAlarmService bAlarmService;
        if (this.isTraceOn()) {
            this.trace("received: updateAlarm");
        }
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        try {
            bAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            foxResponse.add("error", "Could not find AlarmService");
            return foxResponse;
        }
        String string = "";
        try {
            BAlarmRecord bAlarmRecord = FoxAlarmCodec.decodeAlarm(foxRequest.getMessage("alarm"));
            BAlarmClass bAlarmClass = bAlarmService.lookupAlarmClass(bAlarmRecord.getAlarmClass());
            if (bAlarmClass == null) {
                bAlarmClass = bAlarmService.getDefaultAlarmClass();
            }
            BUser bUser = this.getSessionContext().getUser();
            bUser.check((BIProtected)bAlarmClass, BPermissions.operatorWrite);
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: ack -> updateAlarm: " + bAlarmRecord.getTimestamp() + ' ' + (Object)((Object)bAlarmRecord.getSourceState()) + ' ' + bAlarmRecord.getAlarmClass());
            }
            bAlarmRecord.setLastUpdate(BAbsTime.now());
            bAlarmService.routeAlarm(bAlarmRecord);
            bAlarmService.doRouteToSource((BAlarmRecord)bAlarmRecord.newCopy());
        }
        catch (PermissionException permissionException) {
            foxResponse.add("error", "Invalid Permissions: " + (Object)((Object)permissionException));
            this.error(foxRequest.getString("ord"), "Cannot update alarms from Alarm Class: " + string, (Throwable)permissionException);
        }
        catch (Exception exception) {
            foxResponse.add("error", "Could Not Route Alarm Update Request");
        }
        return foxResponse;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BAlarmConsoleChannel() {
        this("alarmui");
    }

    protected BAlarmConsoleChannel(String string) {
        super(string);
        Class clazz = class$com$tridium$fox$message$FoxMessage;
        if (clazz == null) {
            clazz = class$com$tridium$fox$message$FoxMessage = BAlarmConsoleChannel.class("[Lcom.tridium.fox.message.FoxMessage;", false);
        }
        this.newList = new Array(clazz);
        Class clazz2 = class$javax$baja$alarm$BAlarmRecord;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$alarm$BAlarmRecord = BAlarmConsoleChannel.class("[Ljavax.baja.alarm.BAlarmRecord;", false);
        }
        this.ackList = new Array(clazz2);
    }

    static {
        Class clazz = class$com$tridium$alarm$BAlarmConsoleChannel;
        if (clazz == null) {
            clazz = class$com$tridium$alarm$BAlarmConsoleChannel = BAlarmConsoleChannel.class("[Lcom.tridium.alarm.BAlarmConsoleChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        channelMutex = new Object();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Worker
    implements Runnable {
        public static final int WORKER_SLEEP = 1000;
        private boolean isAlive;
        private Thread thread;

        public void start() {
            this.isAlive = true;
            this.thread = new Thread((Runnable)this, "AlarmConsoleChannel:Worker");
            this.thread.start();
        }

        public void kill() {
            this.isAlive = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        public void run() {
            while (this.isAlive) {
                try {
                    int n;
                    Thread.sleep(1000L);
                    FoxMessage[] foxMessageArray = this.getNewAlarms();
                    int n2 = 100;
                    int n3 = 0;
                    int n4 = n = n2 < foxMessageArray.length ? n2 : foxMessageArray.length;
                    if (foxMessageArray.length <= 0) continue;
                    while (n3 < foxMessageArray.length) {
                        FoxRequest foxRequest = BAlarmConsoleChannel.this.makeRequest("new");
                        int n5 = n3;
                        while (n5 < n) {
                            foxRequest.add("alarmRec", foxMessageArray[n5]);
                            ++n5;
                        }
                        BAlarmConsoleChannel.this.sendAsync(foxRequest);
                        n3 = n;
                        int n6 = n = (n += n2) < foxMessageArray.length ? n : foxMessageArray.length;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final synchronized FoxMessage[] getNewAlarms() {
            FoxMessage[] foxMessageArray = new FoxMessage[]{};
            Array array = BAlarmConsoleChannel.this.newList;
            synchronized (array) {
                foxMessageArray = (FoxMessage[])BAlarmConsoleChannel.this.newList.trim();
                BAlarmConsoleChannel.this.newList.clear();
                return foxMessageArray;
            }
        }

        private final /* synthetic */ void this() {
            this.isAlive = true;
        }

        Worker() {
            this.this();
        }
    }
}

