/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import java.util.Comparator;
import java.util.HashMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BObjectArrayCursor;

public class AlarmsToSourcesCursor
implements Cursor {
    private Cursor alarms;
    private Cursor sources;

    public BObject get() {
        return this.sources.get();
    }

    public Context getContext() {
        return this.alarms.getContext();
    }

    public boolean next() {
        if (this.sources == null) {
            this.sources = this.load();
        }
        return this.sources.next();
    }

    private final Cursor load() {
        BObject[] bObjectArray;
        HashMap<BOrdList, BAlarmSource> hashMap = new HashMap<BOrdList, BAlarmSource>();
        while (this.alarms.next()) {
            bObjectArray = (BObject[])this.alarms.get();
            BOrdList bOrdList = bObjectArray.getSource();
            BAlarmSource bAlarmSource = (BAlarmSource)((Object)hashMap.get(bOrdList));
            if (bAlarmSource == null) {
                bAlarmSource = new BAlarmSource(bOrdList, (BAlarmRecord)bObjectArray.newCopy(true));
                hashMap.put(bOrdList, bAlarmSource);
                continue;
            }
            if (!bObjectArray.getTimestamp().isAfter(bAlarmSource.getCurrentAlarm().getTimestamp())) continue;
            bAlarmSource.setCurrentAlarm((BAlarmRecord)bObjectArray.newCopy(true));
        }
        bObjectArray = hashMap.values().toArray(new BAlarmSource[hashMap.size()]);
        SortUtil.sort((Object[])bObjectArray, (Object[])bObjectArray, (Comparator)new BAlarmSource.SourceComparator());
        return new BObjectArrayCursor(bObjectArray, this.alarms.getContext());
    }

    public boolean next(Class clazz) {
        while (this.next()) {
            BObject bObject = this.get();
            if (!clazz.isInstance(bObject)) continue;
            return true;
        }
        return false;
    }

    public boolean nextComponent() {
        while (this.next()) {
            BObject bObject = this.get();
            if (!bObject.isComponent()) continue;
            return true;
        }
        return false;
    }

    public AlarmsToSourcesCursor(Cursor cursor) {
        this.alarms = cursor;
    }
}

