/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.rdb.BAbstractConnectionPool;
import com.tridium.rdb.sqlserver.BSqlServerDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.commons.dbcp.BasicDataSource;

public class BConnectionPool
extends BAbstractConnectionPool {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$sqlserver$BConnectionPool == null ? (class$com$tridium$rdb$sqlserver$BConnectionPool = BConnectionPool.class$("com.tridium.rdb.sqlserver.BConnectionPool")) : class$com$tridium$rdb$sqlserver$BConnectionPool));
    private BasicDataSource ds;
    static /* synthetic */ Class class$com$tridium$rdb$sqlserver$BConnectionPool;

    public Type getType() {
        return TYPE;
    }

    public void doUpdateConnectionStats() {
        if (this.ds != null) {
            this.setNumActive(this.ds.getNumActive());
            if (this.getNumActive() > this.getPeakNumActive()) {
                this.setPeakNumActive(this.getNumActive());
            }
            this.setNumIdle(this.ds.getNumIdle());
        }
    }

    protected Connection obtainConnection(String string, String string2) throws SQLException {
        BSqlServerDatabase bSqlServerDatabase = (BSqlServerDatabase)this.getParent();
        String string3 = BConnectionPool.makeUrl(bSqlServerDatabase);
        if (this.ds == null) {
            Log.getLog((String)"rdb").trace("initializing connection pool for " + string3);
            this.ds = this.makeDataSource(string3, string, string2);
        } else if (!(this.ds.getUrl().equals(string3) && this.ds.getUsername().equals(string) && this.ds.getPassword().equals(string2))) {
            Log.getLog((String)"rdb").trace("re-initializing connection pool for " + string3);
            this.ds.close();
            this.ds = this.makeDataSource(string3, string, string2);
        }
        return this.ds.getConnection();
    }

    private BasicDataSource makeDataSource(String string, String string2, String string3) {
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName("net.sourceforge.jtds.jdbc.Driver");
        basicDataSource.setUrl(string);
        basicDataSource.setUsername(string2);
        basicDataSource.setPassword(string3);
        basicDataSource.setMaxActive(this.getMaxActive());
        basicDataSource.setMaxIdle(this.getMaxIdle());
        basicDataSource.setMaxWait(this.getMaxWait());
        return basicDataSource;
    }

    private static String makeUrl(BSqlServerDatabase bSqlServerDatabase) {
        String string;
        StringBuffer stringBuffer = new StringBuffer("jdbc:jtds:sqlserver:");
        stringBuffer.append("//").append(bSqlServerDatabase.getHostname());
        stringBuffer.append(":").append(bSqlServerDatabase.getPort());
        String string2 = bSqlServerDatabase.getInstanceName();
        if (string2.length() != 0) {
            stringBuffer.append("/").append(string2);
        }
        if ((string = bSqlServerDatabase.getExtraConnectionProperties()) != "") {
            stringBuffer.append(";").append(string);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

