/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.util;

import com.tridium.nx584.BNx6Network;
import com.tridium.nx584.messages.InterfaceConfiguration;
import com.tridium.nx584.messages.Nx6Acknowledge;
import com.tridium.nx584.messages.Nx6MessageConst;
import com.tridium.nx584.messages.Nx6Request;
import com.tridium.nx584.messages.Nx6Response;
import com.tridium.nx584.messages.PartitionStatus;
import com.tridium.nx584.messages.PartitionsSnapshot;
import com.tridium.nx584.messages.SystemStatus;
import com.tridium.nx584.messages.ZoneStatus;
import com.tridium.nx584.messages.ZonesSnapshot;

public class Nx6Util
implements Nx6MessageConst {
    public static int calCksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        while (n5 < n2) {
            int n6;
            int n7 = n6 = n5 == -1 ? n2 : byArray[n5 + n] & 0xFF;
            if (255 - n3 < n6) {
                ++n3;
            }
            if ((n3 = n3 + n6 & 0xFF) == 255) {
                n3 = 0;
            }
            if (255 - n4 < n3) {
                ++n4;
            }
            if ((n4 = n4 + n3 & 0xFF) == 255) {
                n4 = 0;
            }
            ++n5;
        }
        return ((n3 & 0xFF) << 8) + (n4 & 0xFF);
    }

    public static byte[] intToPin(int n) {
        int n2 = 4;
        byte[] byArray = new byte[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            byArray[n3] = (byte)(n % 10);
            n /= 10;
            --n3;
        }
        return byArray;
    }

    public static boolean isCksumOk(byte[] byArray, int n, int n2) {
        int n3 = Nx6Util.calCksum(byArray, n, n2);
        int n4 = ((byArray[n2 - 2] & 0xFF) << 8) + (byArray[n2 - 1] & 0xFF);
        boolean bl = false;
        if (n3 == n4) {
            bl = true;
        }
        return bl;
    }

    public static void sendAck(BNx6Network bNx6Network, int n) {
        Nx6Acknowledge nx6Acknowledge = new Nx6Acknowledge(n);
        bNx6Network.sendSync(nx6Acknowledge);
    }

    public static InterfaceConfiguration getInterfaceConfiguration(BNx6Network bNx6Network) {
        Nx6Request nx6Request = new Nx6Request(33){

            public final Nx6Response getResponseInstance() {
                return new InterfaceConfiguration(this);
            }
        };
        return (InterfaceConfiguration)bNx6Network.sendSync(nx6Request);
    }

    public static SystemStatus getSystemStatus(BNx6Network bNx6Network) {
        Nx6Request nx6Request = new Nx6Request(40){

            public final Nx6Response getResponseInstance() {
                return new SystemStatus(this);
            }
        };
        return (SystemStatus)bNx6Network.sendSync(nx6Request);
    }

    public static PartitionStatus getPartitionsStatus(BNx6Network bNx6Network, int n) {
        Nx6Request nx6Request = new Nx6Request(38, n - 1){

            public final Nx6Response getResponseInstance() {
                return new PartitionStatus(this);
            }
        };
        return (PartitionStatus)bNx6Network.sendSync(nx6Request);
    }

    public static PartitionsSnapshot getPartitionsSnapshop(BNx6Network bNx6Network) {
        Nx6Request nx6Request = new Nx6Request(39){

            public final Nx6Response getResponseInstance() {
                return new PartitionsSnapshot(this);
            }
        };
        return (PartitionsSnapshot)bNx6Network.sendSync(nx6Request);
    }

    public static ZoneStatus getZoneStatus(BNx6Network bNx6Network, int n) {
        Nx6Request nx6Request = new Nx6Request(36, n - 1){

            public final Nx6Response getResponseInstance() {
                return new ZoneStatus(this);
            }
        };
        return (ZoneStatus)bNx6Network.sendSync(nx6Request);
    }

    public static ZonesSnapshot getZonesSnapshot(BNx6Network bNx6Network, int n) {
        Nx6Request nx6Request = new Nx6Request(37, n){

            public final Nx6Response getResponseInstance() {
                return new ZonesSnapshot(this);
            }
        };
        return (ZonesSnapshot)bNx6Network.sendSync(nx6Request);
    }

    public static void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
    }
}

