/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.messages;

import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6MessageConst;
import com.tridium.nx584.messages.Nx6Request;
import com.tridium.nx584.messages.Nx6Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZonesSnapshot
extends Nx6Response
implements Nx6MessageConst {
    Nx6Request request;
    int zoneOffset;
    byte[] zoneStatusFlags;

    public void fromInputStream(Nx6InputStream nx6InputStream) {
        int n = nx6InputStream.readByte();
        this.msgType = nx6InputStream.readByte();
        this.zoneOffset = nx6InputStream.readByte();
        int n2 = 0;
        while (n2 < this.zoneStatusFlags.length) {
            this.zoneStatusFlags[n2] = (byte)nx6InputStream.readByte();
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.zoneOffset + 1;
        while (n < this.zoneStatusFlags.length) {
            stringBuffer.append("Zone ").append(n2++).append(":\n");
            this.appendStatus(this.zoneStatusFlags[n] & 0xF, stringBuffer);
            stringBuffer.append("Zone ").append(n2++).append(":\n");
            this.appendStatus(this.zoneStatusFlags[n] >> 4 & 0xF, stringBuffer);
            ++n;
        }
        return stringBuffer.toString();
    }

    private final void appendStatus(int n, StringBuffer stringBuffer) {
        if (this.isBitActive(n, 0)) {
            stringBuffer.append("  faulted (or delayed trip)\n");
        }
        if (this.isBitActive(n, 1)) {
            stringBuffer.append("  bypass (or inhibited)\n");
        }
        if (this.isBitActive(n, 2)) {
            stringBuffer.append("  trouble (tamper, low battery, or lost)\n");
        }
        if (this.isBitActive(n, 3)) {
            stringBuffer.append("  alarm memory\n");
        }
    }

    private final boolean isBitActive(int n, int n2) {
        boolean bl = false;
        if ((n & 1 << n2) != 0) {
            bl = true;
        }
        return bl;
    }

    public String toDebugString() {
        return this.toString();
    }

    public boolean isZoneFaulted(int n) {
        int n2 = n / 2;
        int n3 = 1;
        if (n % 2 == 0) {
            n3 = 16;
        }
        boolean bl = false;
        if ((this.zoneStatusFlags[n2] & n3) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isZoneBypassed(int n) {
        int n2 = n / 2;
        int n3 = 2;
        if (n % 2 == 0) {
            n3 = 32;
        }
        boolean bl = false;
        if ((this.zoneStatusFlags[n2] & n3) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isZoneTrouble(int n) {
        int n2 = n / 2;
        int n3 = 4;
        if (n % 2 == 0) {
            n3 = 64;
        }
        boolean bl = false;
        if ((this.zoneStatusFlags[n2] & n3) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isZoneAlarmMemory(int n) {
        int n2 = n / 2;
        int n3 = 8;
        if (n % 2 == 0) {
            n3 = 128;
        }
        boolean bl = false;
        if ((this.zoneStatusFlags[n2] & n3) != 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.zoneStatusFlags = new byte[8];
    }

    public ZonesSnapshot() {
        this.this();
    }

    public ZonesSnapshot(Nx6Request nx6Request) {
        this.this();
        this.request = nx6Request;
    }
}

