/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.messages;

import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6Request;
import com.tridium.nx584.messages.Nx6Response;
import com.tridium.nx584.util.Nx6ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SystemStatus
extends Nx6Response {
    Nx6Request request;
    int panelId;
    byte[] data;

    public void fromInputStream(Nx6InputStream nx6InputStream) {
        int n = nx6InputStream.readByte();
        this.msgType = nx6InputStream.readByte();
        this.panelId = nx6InputStream.readByte();
        int n2 = 0;
        while (n2 < this.data.length) {
            this.data[n2] = (byte)nx6InputStream.read();
            ++n2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("System status for panel ").append(this.panelId).append("\n");
        if (this.isBitActive(0, 0)) {
            stringBuffer.append(" Line seizure").append("\n");
        }
        if (this.isBitActive(0, 1)) {
            stringBuffer.append(" Off hook").append("\n");
        }
        if (this.isBitActive(0, 2)) {
            stringBuffer.append(" Initial handshake received").append("\n");
        }
        if (this.isBitActive(0, 3)) {
            stringBuffer.append(" Download in progress").append("\n");
        }
        if (this.isBitActive(0, 4)) {
            stringBuffer.append(" Dialer delay in progress").append("\n");
        }
        if (this.isBitActive(0, 5)) {
            stringBuffer.append(" Using backup phone").append("\n");
        }
        if (this.isBitActive(0, 6)) {
            stringBuffer.append(" Listen in active").append("\n");
        }
        if (this.isBitActive(0, 7)) {
            stringBuffer.append(" Two way lockout").append("\n");
        }
        if (this.isBitActive(1, 0)) {
            stringBuffer.append(" Ground fault").append("\n");
        }
        if (this.isBitActive(1, 1)) {
            stringBuffer.append(" Phone fault").append("\n");
        }
        if (this.isBitActive(1, 2)) {
            stringBuffer.append(" Fail to communicate").append("\n");
        }
        if (this.isBitActive(1, 3)) {
            stringBuffer.append(" Fuse fault").append("\n");
        }
        if (this.isBitActive(1, 4)) {
            stringBuffer.append(" Box tamper").append("\n");
        }
        if (this.isBitActive(1, 5)) {
            stringBuffer.append(" Siren tamper / trouble").append("\n");
        }
        if (this.isBitActive(1, 6)) {
            stringBuffer.append(" Low Battery").append("\n");
        }
        if (this.isBitActive(1, 7)) {
            stringBuffer.append(" AC fail").append("\n");
        }
        if (this.isBitActive(2, 0)) {
            stringBuffer.append(" Expander box tamper").append("\n");
        }
        if (this.isBitActive(2, 1)) {
            stringBuffer.append(" Expander AC failure").append("\n");
        }
        if (this.isBitActive(2, 2)) {
            stringBuffer.append(" Expander low battery").append("\n");
        }
        if (this.isBitActive(2, 3)) {
            stringBuffer.append(" Expander loss of supervision").append("\n");
        }
        if (this.isBitActive(2, 4)) {
            stringBuffer.append(" Expander auxiliary output over current").append("\n");
        }
        if (this.isBitActive(2, 5)) {
            stringBuffer.append(" Auxiliary communication channel failure").append("\n");
        }
        if (this.isBitActive(2, 6)) {
            stringBuffer.append(" Expander bell fault").append("\n");
        }
        if (this.isBitActive(3, 0)) {
            stringBuffer.append(" 6 digit PIN enabled").append("\n");
        }
        if (this.isBitActive(3, 1)) {
            stringBuffer.append(" Programming token in use").append("\n");
        }
        if (this.isBitActive(3, 2)) {
            stringBuffer.append(" PIN required for local download").append("\n");
        }
        if (this.isBitActive(3, 3)) {
            stringBuffer.append(" Global pulsing buzzer").append("\n");
        }
        if (this.isBitActive(3, 4)) {
            stringBuffer.append(" Global Siren on").append("\n");
        }
        if (this.isBitActive(3, 5)) {
            stringBuffer.append(" Global steady siren").append("\n");
        }
        if (this.isBitActive(3, 6)) {
            stringBuffer.append(" Bus device has line seized").append("\n");
        }
        if (this.isBitActive(3, 7)) {
            stringBuffer.append(" Bus device has requested sniff mode").append("\n");
        }
        if (this.isBitActive(4, 0)) {
            stringBuffer.append(" Dynamic battery test").append("\n");
        }
        if (this.isBitActive(4, 1)) {
            stringBuffer.append(" AC power on").append("\n");
        }
        if (this.isBitActive(4, 2)) {
            stringBuffer.append(" Low battery memory").append("\n");
        }
        if (this.isBitActive(4, 3)) {
            stringBuffer.append(" Ground fault memory").append("\n");
        }
        if (this.isBitActive(4, 4)) {
            stringBuffer.append(" Fire alarm verification being timed").append("\n");
        }
        if (this.isBitActive(4, 5)) {
            stringBuffer.append(" Smoke power reset").append("\n");
        }
        if (this.isBitActive(4, 6)) {
            stringBuffer.append(" 50 Hz line power detected").append("\n");
        }
        if (this.isBitActive(4, 7)) {
            stringBuffer.append(" Timing a high voltage battery charge").append("\n");
        }
        if (this.isBitActive(5, 0)) {
            stringBuffer.append(" Communication since last autotest").append("\n");
        }
        if (this.isBitActive(5, 1)) {
            stringBuffer.append(" Power up delay in progress").append("\n");
        }
        if (this.isBitActive(5, 2)) {
            stringBuffer.append(" Walk test mode").append("\n");
        }
        if (this.isBitActive(5, 3)) {
            stringBuffer.append(" Loss of system time").append("\n");
        }
        if (this.isBitActive(5, 4)) {
            stringBuffer.append(" Enroll requested").append("\n");
        }
        if (this.isBitActive(5, 5)) {
            stringBuffer.append(" Test fixture mode").append("\n");
        }
        if (this.isBitActive(5, 6)) {
            stringBuffer.append(" Control shutdown mode").append("\n");
        }
        if (this.isBitActive(5, 7)) {
            stringBuffer.append(" Timing a cancel window").append("\n");
        }
        if (this.isBitActive(6, 7)) {
            stringBuffer.append(" Call back in progress").append("\n");
        }
        if (this.isBitActive(7, 0)) {
            stringBuffer.append(" Phone line faulted").append("\n");
        }
        if (this.isBitActive(7, 1)) {
            stringBuffer.append(" Voltage present interrupt active").append("\n");
        }
        if (this.isBitActive(7, 2)) {
            stringBuffer.append(" House phone off hook").append("\n");
        }
        if (this.isBitActive(7, 3)) {
            stringBuffer.append(" Phone line monitor enabled").append("\n");
        }
        if (this.isBitActive(7, 4)) {
            stringBuffer.append(" Sniffing").append("\n");
        }
        if (this.isBitActive(7, 5)) {
            stringBuffer.append(" Last read was off hook").append("\n");
        }
        if (this.isBitActive(7, 6)) {
            stringBuffer.append(" Listen in requested").append("\n");
        }
        if (this.isBitActive(7, 7)) {
            stringBuffer.append(" Listen in trigger").append("\n");
        }
        if (this.isBitActive(8, 0)) {
            stringBuffer.append(" Valid partition 1").append("\n");
        }
        if (this.isBitActive(8, 1)) {
            stringBuffer.append(" Valid partition 2").append("\n");
        }
        if (this.isBitActive(8, 2)) {
            stringBuffer.append(" Valid partition 3").append("\n");
        }
        if (this.isBitActive(8, 3)) {
            stringBuffer.append(" Valid partition 4").append("\n");
        }
        if (this.isBitActive(8, 4)) {
            stringBuffer.append(" Valid partition 5").append("\n");
        }
        if (this.isBitActive(8, 5)) {
            stringBuffer.append(" Valid partition 6").append("\n");
        }
        if (this.isBitActive(8, 6)) {
            stringBuffer.append(" Valid partition 7").append("\n");
        }
        if (this.isBitActive(8, 7)) {
            stringBuffer.append(" Valid partition 8").append("\n");
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("panelId=").append(this.panelId);
        stringBuffer.append(" status=").append(Nx6ByteArrayUtil.toString(this.data));
        return stringBuffer.toString();
    }

    public boolean isBitActive(int n, int n2) {
        boolean bl = false;
        if ((this.data[n] & 1 << n2) != 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.data = new byte[10];
    }

    public SystemStatus() {
        this.this();
    }

    public SystemStatus(Nx6Request nx6Request) {
        this.this();
        this.request = nx6Request;
    }
}

