/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nx584.messages;

import com.tridium.nx584.messages.Nx6InputStream;
import com.tridium.nx584.messages.Nx6Request;
import com.tridium.nx584.messages.Nx6Response;
import com.tridium.nx584.util.Nx6ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PartitionStatus
extends Nx6Response {
    Nx6Request request;
    public int partitionNumber;
    public int lastUser;
    byte[] data;

    public void fromInputStream(Nx6InputStream nx6InputStream) {
        int n = nx6InputStream.readByte();
        this.msgType = nx6InputStream.readByte();
        this.partitionNumber = nx6InputStream.readByte() + 1;
        this.data[0] = (byte)nx6InputStream.readByte();
        this.data[1] = (byte)nx6InputStream.readByte();
        this.data[2] = (byte)nx6InputStream.readByte();
        this.data[3] = (byte)nx6InputStream.readByte();
        this.lastUser = (byte)nx6InputStream.readByte();
        this.data[4] = (byte)nx6InputStream.readByte();
        this.data[5] = (byte)nx6InputStream.readByte();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PartitionStatus for partition ").append(this.partitionNumber).append("\n");
        stringBuffer.append(" last user=").append(this.lastUser).append("\n");
        if (this.isBitActive(0, 1)) {
            stringBuffer.append(" Fire trouble                   ").append("\n");
        }
        if (this.isBitActive(0, 2)) {
            stringBuffer.append(" Fire                           ").append("\n");
        }
        if (this.isBitActive(0, 3)) {
            stringBuffer.append(" Pulsing Buzzer                 ").append("\n");
        }
        if (this.isBitActive(0, 4)) {
            stringBuffer.append(" TLM fault memory               ").append("\n");
        }
        if (this.isBitActive(0, 6)) {
            stringBuffer.append(" Armed                          ").append("\n");
        }
        if (this.isBitActive(0, 7)) {
            stringBuffer.append(" Instant                        ").append("\n");
        }
        if (this.isBitActive(1, 0)) {
            stringBuffer.append(" Previous Alarm                 ").append("\n");
        }
        if (this.isBitActive(1, 1)) {
            stringBuffer.append(" Siren on                       ").append("\n");
        }
        if (this.isBitActive(1, 2)) {
            stringBuffer.append(" Steady siren on                ").append("\n");
        }
        if (this.isBitActive(1, 3)) {
            stringBuffer.append(" Alarm memory                   ").append("\n");
        }
        if (this.isBitActive(1, 4)) {
            stringBuffer.append(" Tamper                         ").append("\n");
        }
        if (this.isBitActive(1, 5)) {
            stringBuffer.append(" Cancel command entered         ").append("\n");
        }
        if (this.isBitActive(1, 6)) {
            stringBuffer.append(" Code entered                   ").append("\n");
        }
        if (this.isBitActive(1, 7)) {
            stringBuffer.append(" Cancel pending                 ").append("\n");
        }
        if (this.isBitActive(2, 1)) {
            stringBuffer.append(" Silent exit enabled            ").append("\n");
        }
        if (this.isBitActive(2, 2)) {
            stringBuffer.append(" Entryguard (stay mode)         ").append("\n");
        }
        if (this.isBitActive(2, 3)) {
            stringBuffer.append(" Chime mode on                  ").append("\n");
        }
        if (this.isBitActive(2, 4)) {
            stringBuffer.append(" Entry                          ").append("\n");
        }
        if (this.isBitActive(2, 5)) {
            stringBuffer.append(" Delay expiration warning       ").append("\n");
        }
        if (this.isBitActive(2, 6)) {
            stringBuffer.append(" Exit1                          ").append("\n");
        }
        if (this.isBitActive(2, 7)) {
            stringBuffer.append(" Exit2                          ").append("\n");
        }
        if (this.isBitActive(3, 0)) {
            stringBuffer.append(" LED extinguish                 ").append("\n");
        }
        if (this.isBitActive(3, 1)) {
            stringBuffer.append(" Cross timing                   ").append("\n");
        }
        if (this.isBitActive(3, 2)) {
            stringBuffer.append(" Recent closing being timed     ").append("\n");
        }
        if (this.isBitActive(3, 4)) {
            stringBuffer.append(" Exit error triggered           ").append("\n");
        }
        if (this.isBitActive(3, 5)) {
            stringBuffer.append(" Auto home inhibited            ").append("\n");
        }
        if (this.isBitActive(3, 6)) {
            stringBuffer.append(" Sensor low battery             ").append("\n");
        }
        if (this.isBitActive(3, 7)) {
            stringBuffer.append(" Sensor lost supervision        ").append("\n");
        }
        if (this.isBitActive(4, 0)) {
            stringBuffer.append(" Zone bypassed                  ").append("\n");
        }
        if (this.isBitActive(4, 1)) {
            stringBuffer.append(" Force arm triggered by auto arm").append("\n");
        }
        if (this.isBitActive(4, 2)) {
            stringBuffer.append(" Ready to arm                   ").append("\n");
        }
        if (this.isBitActive(4, 3)) {
            stringBuffer.append(" Ready to force arm             ").append("\n");
        }
        if (this.isBitActive(4, 4)) {
            stringBuffer.append(" Valid PIN accepted             ").append("\n");
        }
        if (this.isBitActive(4, 5)) {
            stringBuffer.append(" Chime on (sounding)            ").append("\n");
        }
        if (this.isBitActive(4, 6)) {
            stringBuffer.append(" Error beep (triple beep)       ").append("\n");
        }
        if (this.isBitActive(4, 7)) {
            stringBuffer.append(" Tone on (activation tone)      ").append("\n");
        }
        if (this.isBitActive(5, 0)) {
            stringBuffer.append(" Entry 1                        ").append("\n");
        }
        if (this.isBitActive(5, 1)) {
            stringBuffer.append(" Open period                    ").append("\n");
        }
        if (this.isBitActive(5, 2)) {
            stringBuffer.append(" Alarm sent using phone number 1").append("\n");
        }
        if (this.isBitActive(5, 3)) {
            stringBuffer.append(" Alarm sent using phone number 2").append("\n");
        }
        if (this.isBitActive(5, 4)) {
            stringBuffer.append(" Alarm sent using phone number 3").append("\n");
        }
        if (this.isBitActive(5, 5)) {
            stringBuffer.append(" Cancel report is in the stack  ").append("\n");
        }
        if (this.isBitActive(5, 6)) {
            stringBuffer.append(" Keyswitch armed                ").append("\n");
        }
        if (this.isBitActive(5, 7)) {
            stringBuffer.append(" Delay Trip in progress").append("\n");
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("partitionNumber=").append(this.partitionNumber);
        stringBuffer.append("lastUser=").append(this.lastUser);
        stringBuffer.append(" partitionConditionFlags=").append(Nx6ByteArrayUtil.toString(this.data));
        return stringBuffer.toString();
    }

    public boolean isBitActive(int n, int n2) {
        boolean bl = false;
        if ((this.data[n] & 1 << n2) != 0) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.data = new byte[6];
    }

    public PartitionStatus() {
        this.this();
    }

    public PartitionStatus(Nx6Request nx6Request) {
        this.this();
        this.request = nx6Request;
    }
}

